/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.breadcrumb;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbPanel;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbTable;
import ch.icit.pegasus.client.gui.utils.ClipingProvider;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LinkListener;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.ArrowButton;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.skins.AlignedSizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.HorizontalTextureSkin;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.BackgroundFadeSkin;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;

public abstract class BreadCrumbNavigator
extends JPanelFadable
implements LinkListener {
    private static final long serialVersionUID = 1L;
    private List<BreadCrumbTable> tableStack;
    private List<TextLabel> labelStack = new ArrayList<TextLabel>();
    private List<ArrowButton> arrowButtons = new ArrayList<ArrowButton>();
    private BreadCrumbPanel master;
    private HorizontalTextureSkin titleSkin;
    private int titleHeight;

    public BreadCrumbNavigator(List<BreadCrumbTable> tableStack, BreadCrumbPanel master) {
        this.tableStack = tableStack;
        this.master = master;
        this.getFader().setProgress(1.0f);
        this.titleSkin = SkinRegistry.getSkin(BackgroundFadeSkin.class);
        this.titleHeight = this.titleSkin.getImage(11).getHeight();
        this.setLayout(new Layouter());
    }

    public void rebuildNavigation() {
        this.doRebuild();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        for (TextLabel l : this.labelStack) {
            l.setEnabled(isEnabled);
        }
    }

    public abstract Converter getViewConverter();

    private void doRebuild() {
        ArrowButton b;
        TextLabel l;
        int overhead = this.labelStack.size() - this.tableStack.size();
        if (overhead > 0) {
            while (overhead > 0) {
                l = this.labelStack.get(0);
                l.removeLinkListener(this);
                l.kill();
                this.labelStack.remove(l);
                if (this.arrowButtons.size() > 0) {
                    b = this.arrowButtons.get(0);
                    this.arrowButtons.remove(b);
                    b.kill();
                }
                overhead = this.labelStack.size() - this.tableStack.size();
            }
        } else {
            while (overhead < 0) {
                l = new TextLabel();
                l.setViewConverter(this.getViewConverter());
                l.setLink(true);
                l.addLinkListener(this);
                l.setProgress(1.0f);
                this.add(l);
                this.labelStack.add(l);
                ArrowButton a = new ArrowButton(AlignedSizedSkin1Field.AlignedDirection.Right, SizedSkin1Field.SkinSize.MEDIUM);
                this.arrowButtons.add(a);
                this.add(a);
                overhead = this.labelStack.size() - this.tableStack.size();
            }
        }
        if (this.labelStack.size() == 1 && this.arrowButtons.size() > 0) {
            ArrowButton b2 = this.arrowButtons.remove(0);
            b2.kill();
        }
        int count = 0;
        for (BreadCrumbTable t : this.tableStack) {
            TextLabel text = this.labelStack.get(count);
            text.setNode(t.getTableNode());
            ++count;
        }
        if (this.labelStack.size() > 0) {
            while (this.labelStack.size() <= this.arrowButtons.size() && this.arrowButtons.size() > 0) {
                b = this.arrowButtons.remove(0);
                this.remove(b);
            }
        }
        this.validate();
    }

    @Override
    public void paint(Graphics g) {
        Shape s;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        if (this.getParent() instanceof ClipingProvider && (s = ((ClipingProvider)((Object)this.getParent())).getClipingArea()) != null) {
            g2.clip(s);
        }
        this.titleSkin.paint(g2, 0, 0, this.getWidth(), 11);
        this.paintChildren(g2);
    }

    @Override
    public void linkClicked(TextLabel label) {
        int index = this.labelStack.indexOf(label);
        if (index != this.labelStack.size() - 1) {
            int offset = this.labelStack.size() - 1 - index;
            this.master.moveBack(offset);
            this.master.getScrollPane().revalidate();
        }
    }

    private class Layouter
    extends DefaultLayout {
        private Layouter() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int pw = 10;
            int count = 0;
            for (TextLabel l : BreadCrumbNavigator.this.labelStack) {
                pw = (int)((double)pw + (l.getPreferredSize().getWidth() + 5.0));
                if (count < BreadCrumbNavigator.this.labelStack.size() - 1) {
                    ArrowButton b = (ArrowButton)BreadCrumbNavigator.this.arrowButtons.get(count);
                    pw = (int)((double)pw + (b.getPreferredSize().getHeight() + 5.0));
                }
                ++count;
            }
            if (pw <= parent.getWidth()) {
                int currentX = 10;
                count = 0;
                for (TextLabel l : BreadCrumbNavigator.this.labelStack) {
                    l.setLocation(currentX, (int)(((double)parent.getHeight() - l.getPreferredSize().getHeight()) / 2.0));
                    l.setSize(l.getPreferredSize());
                    currentX += l.getWidth() + 5;
                    if (count < BreadCrumbNavigator.this.labelStack.size() - 1) {
                        ArrowButton b = (ArrowButton)BreadCrumbNavigator.this.arrowButtons.get(count);
                        b.setLocation(currentX, (int)(((double)parent.getHeight() - b.getPreferredSize().getHeight()) / 2.0));
                        b.setSize(b.getPreferredSize());
                        currentX += b.getWidth() + 5;
                    }
                    ++count;
                }
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, BreadCrumbNavigator.this.titleHeight);
        }
    }
}

