/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.hud;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.ScreenViewProvider;
import ch.icit.pegasus.client.gui.hud.DragAndDropController;
import ch.icit.pegasus.client.gui.hud.model.HUDModel;
import ch.icit.pegasus.client.gui.hud.model.HUDModelCategory;
import ch.icit.pegasus.client.gui.hud.model.HUDModelModule;
import ch.icit.pegasus.client.gui.hud.view.FavoriteButton;
import ch.icit.pegasus.client.gui.hud.view.FavoriteButtonContainer;
import ch.icit.pegasus.client.gui.hud.view.HUDActionButton;
import ch.icit.pegasus.client.gui.hud.view.HUDButton;
import ch.icit.pegasus.client.gui.hud.view.HUDCategoryButton;
import ch.icit.pegasus.client.gui.hud.view.HUDCloseButton;
import ch.icit.pegasus.client.gui.hud.view.HudButtonBarLayout;
import ch.icit.pegasus.client.gui.hud.view.HudCenterLayout;
import ch.icit.pegasus.client.gui.hud.view.PhantomButton;
import ch.icit.pegasus.client.gui.modules.AppModulesUtils;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Screen;
import ch.icit.pegasus.client.gui.utils.ScreenInsert;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextField;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextFieldListener;
import ch.icit.pegasus.client.gui.utils.skins.Skin9Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.FavoriteModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.ModuleDefinitionToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.Timer;

public class HUDPanel
extends DragAndDropController
implements ButtonListener,
SearchTextFieldListener {
    private static final long serialVersionUID = 1L;
    private MainFrame mainFrame;
    private DefaultPanel panelCenter;
    private DefaultPanel panelWest;
    private Map<HUDModelModule, HUDButton> centerButtons;
    private int buttonsPerRound;
    private Timer addButtonTimer;
    private Stack<List<Button>> animationStack = new Stack();
    private Stack<Button> centerButtonList = new Stack();
    private Stack<HUDButton> navigationButtonList = new Stack();
    private Stack<FavoriteButton> favoritesButtonList = new Stack();
    private ScrollPane west;
    private ScrollPane center;
    private TextLabel searchText;
    private SearchTextField searchField;
    private Skin9Field borderSkin;
    private List<FavoriteButtonContainer> favorites;
    private int buttonBarWidth = 200;
    private int searchBarHeight = 30;
    private int favoriteBarHeight = 60;
    private int verticalBorder = 10;
    private int horizontalBorder = 10;
    private int centerOffsetVertical = 15;
    private int centerOffsetHorizontal = 15;
    private int maxHudWidth = 1024;
    private int maxHudHeight = 768;
    private UserComplete user;
    private final ScreenInsert<?> currentScreen;
    private HUDModel model;
    private HUDCloseButton closeButton;
    private Button focusButton;
    private List<Button> focusableButtons = new ArrayList<Button>();
    HudCenterLayout hudCenterLayouter = new HudCenterLayout();

    public HUDPanel(MainFrame mainFrame, ScreenInsert<?> currentScreen, UserComplete user) {
        this.currentScreen = currentScreen;
        this.model = new HUDModel(user);
        this.mainFrame = mainFrame;
        this.user = user;
        this.setOpaque(false);
        this.setBackground(Color.black);
        this.favorites = new ArrayList<FavoriteButtonContainer>();
        for (int i = 0; i < 5; ++i) {
            this.favorites.add(new FavoriteButtonContainer(false, true, i));
            this.favorites.get(i).setVisible(true);
            this.favorites.get(i).setOpaque(false);
            this.favorites.get(i).setBorder(BorderFactory.createLineBorder(Color.orange));
            this.add(this.favorites.get(i));
        }
        this.borderSkin = (Skin9Field)DefaultSkins.HudBorder.createDynamicSkin();
        this.searchText = new TextLabel(Words.SEARCH);
        this.searchText.setForeground(Color.white);
        Font font = new Font("Verdana", 1, 16);
        this.searchText.setFont(font);
        this.searchField = new SearchTextField(DefaultSkins.HUDSearchFieldTexture);
        this.searchField.addSearchTextFieldListener(this);
        this.searchField.setForeground(Color.WHITE);
        this.add(this.searchText);
        this.add(this.searchField);
        this.west = new ScrollPane();
        this.panelWest = new DefaultPanel(){

            @Override
            public List<Component> getFocusComponents() {
                return null;
            }

            @Override
            public void setVisibleContainer(VisibleContainer pane) {
            }

            @Override
            public void requestFocusInWindowNow() {
            }
        };
        this.panelWest.setLayout(new HudButtonBarLayout());
        this.west.setViewportView(this.panelWest);
        this.west.getViewport().setOpaque(false);
        this.west.setOpaque(false);
        this.center = new ScrollPane();
        this.panelCenter = new DefaultPanel(){

            @Override
            public List<Component> getFocusComponents() {
                return null;
            }

            @Override
            public void setVisibleContainer(VisibleContainer pane) {
            }

            @Override
            public void requestFocusInWindowNow() {
            }
        };
        this.panelCenter.setLayout(this.hudCenterLayouter);
        this.center.setHorizontalScrollBarPolicy(31);
        this.center.getHorizontalScrollBar().setOpaque(true);
        this.center.setVerticalScrollBarPolicy(20);
        this.center.getVerticalScrollBar().setOpaque(true);
        this.center.setViewportView(this.panelCenter);
        this.center.getViewport().setOpaque(false);
        this.center.setOpaque(false);
        this.center.getVerticalScrollBar().setBackground(new Color(100, 100, 100));
        this.west.setVisible(true);
        this.center.setVisible(true);
        this.add(this.west);
        this.add(this.center);
        this.setLayout(new HudTopLevelLayout());
    }

    public void showHUD() {
        this.addButtons();
        this.requestFocusInWindow();
        this.fadeIn();
        this.fadeInButtons();
        this.searchField.getTextField().requestFocusInWindow();
        this.center.getActionMap().put("unitScrollUp", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.center.getActionMap().put("unitScrollDown", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.center.getActionMap().put("unitScrollLeft", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.center.getActionMap().put("unitScrollRight", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
    }

    private void fadeInButtons() {
        int rounds = (int)(this.getFader().getAnimationDuration() / 4L);
        ArrayList<HUDButton> roundNav = new ArrayList<HUDButton>();
        roundNav.addAll(this.navigationButtonList);
        ArrayList roundOne = new ArrayList();
        for (int i = 0; i < this.centerButtonList.size(); i += 3) {
            roundOne.add(this.centerButtonList.get(i));
        }
        ArrayList roundTwo = new ArrayList();
        for (int i = 1; i < this.centerButtonList.size(); i += 3) {
            roundTwo.add(this.centerButtonList.get(i));
        }
        ArrayList roundThree = new ArrayList();
        for (int i = 2; i < this.centerButtonList.size(); i += 3) {
            roundThree.add(this.centerButtonList.get(i));
        }
        this.animationStack.add(roundThree);
        this.animationStack.add(roundTwo);
        this.animationStack.add(roundOne);
        this.animationStack.add(roundNav);
        this.addButtonTimer = new Timer(rounds, e -> this.doRound());
        this.addButtonTimer.setRepeats(true);
        this.addButtonTimer.start();
    }

    private void doRound() {
        if (this.animationStack != null) {
            if (!this.animationStack.isEmpty()) {
                List<Button> b = this.animationStack.pop();
                for (Button bu : b) {
                    bu.fadeIn();
                }
            }
            if (this.animationStack.isEmpty()) {
                this.addButtonTimer.stop();
                this.addButtonTimer = null;
            }
        }
    }

    private void addButtons() {
        this.centerButtons = new HashMap<HUDModelModule, HUDButton>();
        List<HUDModelCategory> categories = this.model.getCategories();
        for (HUDModelCategory category : categories) {
            HUDCategoryButton btn = new HUDCategoryButton(category.getName(), this, category);
            this.panelWest.add(btn);
            btn.setVisible(true);
            btn.setProgress(0.0f);
            btn.addButtonListener(this);
            if (category.getName().equals(ModuleDefinitionToolkit.CATEGORY_ALL.getIdentifier())) {
                btn.setState(Button.ButtonState.STATE_SELECTED);
            }
            this.navigationButtonList.add(btn);
        }
        AppModulesUtils utils = new AppModulesUtils();
        List<HUDModelModule> modules = this.model.getAllModules();
        Collections.sort(modules, (o1, o2) -> {
            String modName1 = utils.getModuleDisplayName(o1.getAccessright().getModule().getAccessDefinition());
            String modName2 = utils.getModuleDisplayName(o2.getAccessright().getModule().getAccessDefinition());
            return modName1.compareTo(modName2);
        });
        for (HUDModelModule module : modules) {
            HUDActionButton btn = new HUDActionButton(module.getName(), this, module);
            this.panelCenter.add(btn);
            btn.setVisible(true);
            btn.setProgress(0.0f);
            btn.addButtonListener(this);
            btn.addMouseListener(this);
            btn.addMouseMotionListener(this);
            this.centerButtons.put(module, btn);
            this.centerButtonList.add(btn);
            this.focusableButtons.add(btn);
        }
        int i = 0;
        for (FavoriteModuleAccessRightComplete favoriteModule : this.user.getFavorites()) {
            for (HUDModelModule hudModelModule : modules) {
                if (!hudModelModule.getModuleID().equals(favoriteModule.getAccessRight().getModule().getInvokingName())) continue;
                FavoriteButton fav = new FavoriteButton(hudModelModule);
                fav.addButtonListener(this);
                fav.addMouseListener(this);
                fav.addMouseMotionListener(this);
                this.favorites.get(favoriteModule.getIndex()).setFavorite(fav);
                this.favoritesButtonList.add(fav);
            }
            ++i;
        }
        this.closeButton = new HUDCloseButton();
        this.closeButton.addButtonListener(this);
        this.closeButton.setVisible(true);
        this.closeButton.addButtonListener(this);
        this.add(this.closeButton);
    }

    private void setCentralButtonsPerCategory(HUDModelCategory category) {
        List<HUDModelModule> modules = this.model.getModulesForCategory(category);
        Collections.sort(modules);
        this.setCentralButtonsByList(modules);
    }

    private void setCentralButtonsBySearchString(String search) {
        String moduleDisplayName;
        List<HUDModelModule> modules = this.model.getAllModules();
        Collections.sort(modules);
        ArrayList<HUDModelModule> searchedModules = new ArrayList<HUDModelModule>();
        AppModulesUtils utils = new AppModulesUtils();
        for (HUDModelModule module : modules) {
            moduleDisplayName = utils.getModuleDisplayName(module.getAccessright().getModule().getAccessDefinition());
            if (!moduleDisplayName.toLowerCase().startsWith(search.toLowerCase())) continue;
            searchedModules.add(module);
        }
        for (HUDModelModule module : modules) {
            String[] subStrings;
            if (searchedModules.contains(module)) continue;
            moduleDisplayName = utils.getModuleDisplayName(module.getAccessright().getModule().getAccessDefinition());
            for (String subString : subStrings = moduleDisplayName.toLowerCase().split(" ")) {
                if (!subString.startsWith(search.toLowerCase())) continue;
                searchedModules.add(module);
            }
        }
        for (HUDModelModule module : modules) {
            if (searchedModules.contains(module) || !(moduleDisplayName = utils.getModuleDisplayName(module.getAccessright().getModule().getAccessDefinition())).toLowerCase().contains(search.toLowerCase())) continue;
            searchedModules.add(module);
        }
        this.setCentralButtonsByList(searchedModules);
    }

    private void setCentralButtonsByList(List<HUDModelModule> modules) {
        this.panelCenter.removeAll();
        this.panelCenter.getLayout().layoutContainer(this.panelCenter);
        this.center.getLayout().layoutContainer(this.center);
        this.panelCenter.repaint(23L);
        this.focusableButtons.clear();
        for (HUDModelModule hudModelModule : modules) {
            HUDButton hudButton = this.centerButtons.get(hudModelModule);
            this.panelCenter.add(hudButton);
            this.focusableButtons.add(hudButton);
        }
        this.panelCenter.getLayout().layoutContainer(this.panelCenter);
        this.center.getLayout().layoutContainer(this.center);
        this.panelCenter.repaint(23L);
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader(), 0.75f);
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        int nullx = 0;
        int newWidth = this.getWidth();
        int nully = 0;
        int newHeight = this.getHeight();
        if (this.getHeight() > this.maxHudHeight) {
            nully = (this.getHeight() - this.maxHudHeight) / 2;
            newHeight = this.maxHudHeight;
        }
        if (this.getWidth() > this.maxHudWidth) {
            nullx = (this.getWidth() - this.maxHudWidth) / 2;
            newWidth = this.maxHudWidth;
        }
        if (this.borderSkin != null) {
            this.borderSkin.paint(g2, nullx + this.buttonBarWidth + 2 * this.horizontalBorder + 8, nully + this.searchBarHeight + this.verticalBorder, newWidth - this.buttonBarWidth - 3 * this.horizontalBorder - 8, newHeight - this.searchBarHeight - 2 * this.verticalBorder - this.favoriteBarHeight, Button.ButtonState.UP);
            this.borderSkin.paint(g2, nullx, nully, newWidth - 1, newHeight - 1, Button.ButtonState.UP);
        }
        this.paintChildren(g2);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        Container p = this.getParent();
        for (HUDModelModule hUDModelModule : this.centerButtons.keySet()) {
            this.centerButtons.get(hUDModelModule).kill();
            hUDModelModule.kill();
        }
        this.centerButtons.clear();
        this.centerButtons = null;
        this.addButtonTimer = null;
        this.panelWest.kill();
        this.panelCenter.kill();
        this.west.kill();
        this.center.kill();
        this.searchText.kill();
        this.searchField.kill();
        for (BorderedInletPanel borderedInletPanel : this.favorites) {
            borderedInletPanel.kill();
        }
        this.favorites.clear();
        this.favorites = null;
        this.panelWest = null;
        this.panelCenter = null;
        this.west = null;
        this.center = null;
        this.searchText = null;
        this.searchField = null;
        this.mainFrame = null;
        this.animationStack.clear();
        this.animationStack = null;
        this.centerButtonList.clear();
        this.centerButtonList = null;
        this.navigationButtonList.clear();
        this.navigationButtonList = null;
        this.favoritesButtonList.clear();
        this.favoritesButtonList = null;
        this.west = null;
        this.center = null;
        this.borderSkin = null;
        this.user = null;
        this.model.kill();
        this.model = null;
        this.closeButton.kill();
        this.closeButton = null;
        super.kill();
        if (p != null) {
            p.repaint(32L);
        }
    }

    public List<FavoriteButtonContainer> getFavorites() {
        return this.favorites;
    }

    public void setFavorites(List<FavoriteButtonContainer> favorites) {
        this.favorites = favorites;
    }

    @Override
    public void textChanged(String nText, SearchTextField source) {
        this.setCentralButtonsBySearchString(nText);
    }

    private void showScreen(String viewClass, String text) {
        ThreadSafeLoader.clearLoadingList();
        Object screen = ScreenViewProvider.forName(viewClass, this.mainFrame, text, this.mainFrame.getCurrenScreen());
        if (screen == null) {
            return;
        }
        this.mainFrame.showScreen((Screen)screen, viewClass);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (!this.isDragStarted()) {
            if (source instanceof HUDCategoryButton) {
                this.setCentralButtonsPerCategory(((HUDCategoryButton)source).getCategory());
            } else if (source instanceof FavoriteButton) {
                this.showScreen(((FavoriteButton)source).getModule().getScreenClass(), ((FavoriteButton)source).getModule().getName());
            } else if (source instanceof HUDActionButton) {
                this.showScreen(((HUDActionButton)source).getScreenClass(), ((HUDActionButton)source).getText());
            } else if (source instanceof HUDCloseButton) {
                if (this.currentScreen != null) {
                    this.currentScreen.showHud(false);
                }
                this.mainFrame.showHud(false);
            }
        }
    }

    @Override
    protected List<JComponent> getTargetObjects() {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        for (FavoriteButtonContainer favorite : this.favorites) {
            list.add(favorite);
        }
        return list;
    }

    @Override
    protected void draggedOverTarget(JComponent target, JComponent source) {
        if (source instanceof HUDActionButton) {
            ((FavoriteButtonContainer)target).hideFavorite();
            ((FavoriteButtonContainer)target).setTemporalFavorite(new FavoriteButton(((HUDActionButton)source).getModule()));
        } else if (source instanceof FavoriteButton) {
            ((FavoriteButtonContainer)target).hideFavorite();
            ((FavoriteButtonContainer)target).setTemporalFavorite(new FavoriteButton(((FavoriteButton)source).getModule()));
        }
    }

    @Override
    protected void draggedOutOfTarget(JComponent target, JComponent source) {
        if (source instanceof HUDActionButton) {
            ((FavoriteButtonContainer)target).removeTemporalFavorite();
            ((FavoriteButtonContainer)target).showFavorite();
        } else if (source instanceof FavoriteButton) {
            ((FavoriteButtonContainer)target).removeTemporalFavorite();
            if (target == source.getParent()) {
                ((FavoriteButtonContainer)target).hideFavorite();
            } else {
                ((FavoriteButtonContainer)target).showFavorite();
            }
        }
    }

    @Override
    protected PhantomButton getPhantomButton(JComponent source) {
        if (source instanceof FavoriteButton) {
            for (HUDModelModule module : this.centerButtons.keySet()) {
                if (!module.equals(((FavoriteButton)source).getModule())) continue;
                BufferedImage image = new BufferedImage(this.centerButtons.get(module).getWidth(), this.centerButtons.get(module).getHeight(), 1);
                this.centerButtons.get(module).paint(image.getGraphics());
                PhantomButton phantomButton = new PhantomButton(image);
                phantomButton.setSize(this.centerButtons.get(module).getWidth(), this.centerButtons.get(module).getHeight());
                phantomButton.setOpaque(true);
                return phantomButton;
            }
            return null;
        }
        BufferedImage image = new BufferedImage(source.getWidth(), source.getHeight(), 1);
        source.paint(image.getGraphics());
        PhantomButton phantomButton = new PhantomButton(image);
        phantomButton.setSize(source.getWidth(), source.getHeight());
        phantomButton.setOpaque(true);
        return phantomButton;
    }

    @Override
    protected void mouseReleasedOverTarget(JComponent target, JComponent source) {
        ((FavoriteButtonContainer)target).changeTemporalToReal();
        ((FavoriteButtonContainer)target).getFavorite().addMouseListener(this);
        ((FavoriteButtonContainer)target).getFavorite().addMouseMotionListener(this);
        ((FavoriteButtonContainer)target).getFavorite().addButtonListener(this);
        if (source instanceof FavoriteButton && source.getParent() != target) {
            ((FavoriteButtonContainer)source.getParent()).removeFavorite();
        }
    }

    @Override
    protected void mouseReleasedNotOverTarget(JComponent source) {
        if (source instanceof FavoriteButton) {
            ((FavoriteButtonContainer)source.getParent()).removeFavorite();
        }
    }

    public void moveFocusLeft() {
        if (this.focusButton instanceof HUDActionButton) {
            int z;
            int i = this.focusableButtons.indexOf(this.focusButton);
            if (i % (z = this.hudCenterLayouter.getColumnCount()) == 0) {
                int scrolledY = this.center.getVerticalScrollBar().getValue();
                int yCategory = this.focusButton.getY();
                int difBefore = 100;
                int difAfter = 100;
                Button newfocusButton = null;
                boolean cameCloser = false;
                for (Button button : this.navigationButtonList) {
                    difAfter = yCategory - button.getY() - scrolledY;
                    difAfter = Math.abs(difAfter);
                    if (cameCloser && difAfter > difBefore) break;
                    if (difAfter < difBefore) {
                        cameCloser = true;
                        difBefore = difAfter;
                    }
                    newfocusButton = button;
                }
                int j = this.navigationButtonList.indexOf(newfocusButton);
                ((HUDButton)this.navigationButtonList.get(j)).requestFocusInWindowNow();
            } else {
                int t = i - 1;
                if (t >= 0 && t <= this.focusableButtons.size()) {
                    Button newFocusButton = this.focusableButtons.get(t);
                    newFocusButton.requestFocusInWindowNow();
                    Rectangle bounds = newFocusButton.getBounds();
                    Rectangle target = new Rectangle((int)bounds.getX(), (int)bounds.getY() - bounds.height * 5, bounds.width, bounds.height);
                    ((JComponent)newFocusButton.getParent()).scrollRectToVisible(target);
                }
            }
        } else if (this.focusButton instanceof HUDButton) {
            this.searchField.getTextField().requestFocusInWindow();
            this.setFocusButton(null);
        }
    }

    public void moveFocusRight() {
        int z = this.hudCenterLayouter.getColumnCount();
        if (this.focusButton instanceof HUDCategoryButton) {
            int scrolledY = this.center.getVerticalScrollBar().getValue();
            int yCategory = this.focusButton.getY();
            int difBefore = 100;
            int difAfter = 100;
            Button newfocusButton = null;
            boolean cameCloser = false;
            for (Button button : this.focusableButtons) {
                difAfter = yCategory - button.getY() + scrolledY;
                difAfter = Math.abs(difAfter);
                if (cameCloser && difAfter > difBefore) break;
                if (difAfter < difBefore) {
                    cameCloser = true;
                    difBefore = difAfter;
                }
                newfocusButton = button;
            }
            int i = this.focusableButtons.indexOf(newfocusButton);
            if (z != 0) {
                while (i % z != 0) {
                    --i;
                }
                this.focusableButtons.get(i).requestFocusInWindowNow();
            }
        } else {
            int t;
            int i = this.focusableButtons.indexOf(this.focusButton);
            if (i != this.focusableButtons.size() - 1 && (i + 1) % z != 0 && (t = i + 1) >= 0 && t <= this.focusableButtons.size()) {
                Button newFocusButton = this.focusableButtons.get(t);
                newFocusButton.requestFocusInWindowNow();
                Rectangle bounds = newFocusButton.getBounds();
                Rectangle target = new Rectangle((int)bounds.getX(), (int)bounds.getY() + bounds.height * 5, bounds.width, bounds.height);
                ((JComponent)newFocusButton.getParent()).scrollRectToVisible(target);
            }
        }
    }

    public void moveFocusUp() {
        if (this.focusButton instanceof HUDCategoryButton) {
            int i = this.navigationButtonList.indexOf(this.focusButton);
            if (i == 0) {
                i = this.navigationButtonList.size();
            }
            ((HUDButton)this.navigationButtonList.get(i - 1)).requestFocusInWindowNow();
        } else {
            int z = this.hudCenterLayouter.getColumnCount();
            int i = this.focusableButtons.indexOf(this.focusButton);
            int t = i - z;
            if (t >= 0 && t <= this.focusableButtons.size()) {
                Button newFocusButton = this.focusableButtons.get(t);
                newFocusButton.requestFocusInWindowNow();
                Rectangle bounds = newFocusButton.getBounds();
                Rectangle target = new Rectangle((int)bounds.getX(), (int)bounds.getY() - bounds.height * 5, bounds.width, bounds.height);
                ((JComponent)newFocusButton.getParent()).scrollRectToVisible(target);
            }
        }
    }

    public void moveFocusDown() {
        if (this.focusButton instanceof HUDCategoryButton) {
            int i = this.navigationButtonList.indexOf(this.focusButton);
            if (i == this.navigationButtonList.size() - 1) {
                i = -1;
            }
            ((HUDButton)this.navigationButtonList.get(i + 1)).requestFocusInWindowNow();
        } else if (this.focusButton instanceof HUDButton) {
            int z = this.hudCenterLayouter.getColumnCount();
            int i = this.focusableButtons.indexOf(this.focusButton);
            if (i == -1) {
                ((HUDButton)this.navigationButtonList.get(0)).requestFocusInWindowNow();
                return;
            }
            int t = i + z;
            if (t >= 0 && t < this.focusableButtons.size()) {
                Button newFocusButton = this.focusableButtons.get(t);
                newFocusButton.requestFocusInWindowNow();
                Rectangle bounds = newFocusButton.getBounds();
                Rectangle target = new Rectangle((int)bounds.getX(), (int)bounds.getY() + bounds.height * 5, bounds.width, bounds.height);
                ((JComponent)newFocusButton.getParent()).scrollRectToVisible(target);
            }
        } else {
            ((HUDButton)this.navigationButtonList.get(0)).requestFocusInWindowNow();
        }
    }

    public void escapeKeyPressed() {
        this.searchField.getTextField().requestFocusInWindow();
        this.setFocusButton(null);
    }

    public Button getFocusButton() {
        return this.focusButton;
    }

    public void setFocusButton(Button focusButton) {
        this.focusButton = focusButton;
    }

    private class HudTopLevelLayout
    extends DefaultLayout {
        private HudTopLevelLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            List<FavoriteButtonContainer> favories;
            int nullx = 0;
            int newWidth = parent.getWidth();
            int nully = 0;
            int newHeight = parent.getHeight();
            if (parent.getHeight() > HUDPanel.this.maxHudHeight) {
                nully = (parent.getHeight() - HUDPanel.this.maxHudHeight) / 2;
                newHeight = HUDPanel.this.maxHudHeight;
            }
            if (parent.getWidth() > HUDPanel.this.maxHudWidth) {
                nullx = (parent.getWidth() - HUDPanel.this.maxHudWidth) / 2;
                newWidth = HUDPanel.this.maxHudWidth;
            }
            if ((favories = HUDPanel.this.getFavorites()) != null) {
                for (int i = 0; i < 5; ++i) {
                    favories.get(i).setSize(52, 52);
                    favories.get(i).setLocation(newWidth + nullx - (HUDPanel.this.horizontalBorder + (i + 1) * 52 + i * 4), newHeight + nully - HUDPanel.this.favoriteBarHeight - 2);
                }
            }
            HUDPanel.this.searchField.setSize(300, 50);
            HUDPanel.this.searchField.setLocation(nullx + HUDPanel.this.horizontalBorder + 75, nully + 10);
            HUDPanel.this.searchText.setSize(75, 15);
            HUDPanel.this.searchText.setLocation(nullx + HUDPanel.this.horizontalBorder, nully + 12);
            HUDPanel.this.west.setLocation(nullx + HUDPanel.this.horizontalBorder, nully + HUDPanel.this.verticalBorder + HUDPanel.this.searchBarHeight);
            HUDPanel.this.west.setSize(HUDPanel.this.buttonBarWidth, nully + newHeight - 2 * HUDPanel.this.verticalBorder - HUDPanel.this.searchBarHeight);
            HUDPanel.this.center.setLocation(nullx + HUDPanel.this.buttonBarWidth + HUDPanel.this.centerOffsetHorizontal + 2 * HUDPanel.this.horizontalBorder, nully + HUDPanel.this.verticalBorder + HUDPanel.this.centerOffsetVertical + HUDPanel.this.searchBarHeight);
            HUDPanel.this.center.setSize(newWidth - HUDPanel.this.buttonBarWidth - 3 * HUDPanel.this.horizontalBorder - 2 * HUDPanel.this.centerOffsetHorizontal, newHeight - 2 * HUDPanel.this.verticalBorder - HUDPanel.this.searchBarHeight - 2 * HUDPanel.this.centerOffsetVertical - HUDPanel.this.favoriteBarHeight);
            HUDPanel.this.panelCenter.setSize(HUDPanel.this.center.getSize());
            if (HUDPanel.this.closeButton != null) {
                HUDPanel.this.closeButton.setLocation(nullx + newWidth - HUDPanel.this.horizontalBorder - 150, nully + HUDPanel.this.verticalBorder);
                HUDPanel.this.closeButton.setSize(150, (int)HUDPanel.this.closeButton.getPreferredSize().getHeight());
            }
        }
    }
}

