/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.hud.model;

import ch.icit.pegasus.client.gui.hud.model.HUDModelCategory;
import ch.icit.pegasus.client.gui.hud.model.HUDModelModule;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.ModuleDefinitionToolkit;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;

public class HUDModel
implements Killable {
    private TreeMap<HUDModelCategory, List<HUDModelModule>> categories = new TreeMap();
    private ArrayList<HUDModelModule> modules = new ArrayList();
    private LinkedList<HUDModelCategory> categoriesList = new LinkedList();
    private boolean isKilled = false;

    public HUDModel(UserComplete user) {
        ArrayList<String> categoryStrings = new ArrayList<String>();
        ArrayList<String> moduleStrings = new ArrayList<String>();
        for (ModuleAccessRightComplete r : user.getModules()) {
            String name;
            if (!r.getModule().getToplevel().booleanValue() || (name = r.getModule().getDisplayName()) == null) continue;
            if (r.getModule().getAccessDefinition() == null) {
                r.getModule().setAccessDefinition(HUDToolkit.getAccessDefinition(r.getModule().getInvokingName()));
            }
            String classname = HUDToolkit.getScreenClassForInvoker(r.getModule().getAccessDefinition());
            AccessDefinitionComplete category = HUDToolkit.getCategory4Invoker(r.getModule().getAccessDefinition());
            if (category != null && !categoryStrings.contains(category.getIdentifier())) {
                HUDModelCategory hmc = new HUDModelCategory(category.getIdentifier(), category.getDisplayName());
                this.categories.put(hmc, new ArrayList());
                this.categoriesList.add(hmc);
                categoryStrings.add(category.getIdentifier());
            }
            if (name == null || classname == null || category == null || moduleStrings.contains(name)) continue;
            HUDModelModule hmm = new HUDModelModule(r.getModule().getInvokingName(), name, classname, category.getIdentifier(), r);
            this.modules.add(hmm);
            for (HUDModelCategory hmc : this.categories.keySet()) {
                if (!hmc.getCategoryID().equals(category.getIdentifier())) continue;
                this.categories.get(hmc).add(hmm);
            }
            moduleStrings.add(name);
        }
        HUDModelCategory all = new HUDModelCategory(ModuleDefinitionToolkit.CATEGORY_ALL.getIdentifier(), ModuleDefinitionToolkit.CATEGORY_ALL.getDisplayName());
        this.categories.put(all, this.modules);
        this.categoriesList.addFirst(all);
    }

    public List<HUDModelCategory> getCategories() {
        return this.categoriesList;
    }

    public List<HUDModelModule> getAllModules() {
        return this.modules;
    }

    public List<HUDModelModule> getModulesForCategory(HUDModelCategory category) {
        return this.categories.get(category);
    }

    @Override
    public void kill() {
        if (this.isKilled) {
            return;
        }
        this.isKilled = true;
        this.categories.clear();
        this.categories = null;
        this.modules.clear();
        this.modules = null;
        this.categoriesList.clear();
        this.categoriesList = null;
    }

    @Override
    public boolean isKilled() {
        return this.isKilled;
    }
}

