/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.hud.view;

import ch.icit.pegasus.client.gui.hud.model.HUDModelModule;
import ch.icit.pegasus.client.gui.hud.view.HUDButtonIconSkin;
import ch.icit.pegasus.client.gui.modules.AppModules;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.prototypes.SkinButton;
import ch.icit.pegasus.client.util.HUDToolkit;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;

public class FavoriteButton
extends SkinButton<HUDButtonIconSkin> {
    private static final long serialVersionUID = 1L;
    private HUDModelModule module;

    public FavoriteButton(HUDModelModule module) {
        super(HUDButtonIconSkin.class);
        this.module = module;
        this.border = 3;
    }

    @Override
    public void paintSkin(HUDButtonIconSkin skin, Graphics2D g2, int border) {
        skin.paint(g2, border, border, this.getState(), HUDToolkit.getScreenType4Invoker(this.module.getModuleID()));
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.module.kill();
        this.module = null;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getSkin() == null || this.module == null) {
            return new Dimension(0, 0);
        }
        AppModules id = HUDToolkit.getScreenType4Invoker(this.module.getModuleID());
        return new Dimension(((HUDButtonIconSkin)this.getSkin()).getImage(Button.ButtonState.UP, id).getWidth() + 2 * this.border, ((HUDButtonIconSkin)this.getSkin()).getImage(Button.ButtonState.UP, id).getHeight() + 2 * this.border);
    }

    public HUDModelModule getModule() {
        return this.module;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.getState() == Button.ButtonState.DISABLED) {
            this.changeState(Button.ButtonState.DOWN);
        }
        if (this.getState() == Button.ButtonState.FOCUS) {
            this.changeState(Button.ButtonState.UP);
        }
        this.repaint(32L);
    }

    @Override
    public void setState(Button.ButtonState newState) {
        super.setState(newState);
        if (this.getState() == Button.ButtonState.DISABLED) {
            this.state = Button.ButtonState.DOWN;
        }
        if (this.getState() == Button.ButtonState.FOCUS) {
            this.state = Button.ButtonState.UP;
        }
        this.repaint(32L);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.state = Button.ButtonState.OVER;
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.state = Button.ButtonState.UP;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.hasFocus()) {
            super.mouseExited(e);
        }
    }
}

