/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.accountdistribution.details;

import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.acountdistribution.AccountDistributionComplete_;
import ch.icit.pegasus.server.core.dtos.acountdistribution.AccountDistributionLight;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class HandlingCostsDetailsPanel
extends TableDetailsPanel<AccountDistributionLight> {
    private static final long serialVersionUID = 1L;
    private boolean isHandlingDeletable;
    private boolean isHandlingWritable;

    public HandlingCostsDetailsPanel(RowEditor<AccountDistributionLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.HANDLING_COSTS);
        this.isHandlingDeletable = provider.isDeletable(AccountDistributionComplete_.handlingcosts);
        this.isHandlingWritable = provider.isWritable(AccountDistributionComplete_.handlingcosts);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.HANDLING_COST, null, null, null, "", 30, 30, 30));
        int dw2 = this.table.getCellPadding() * 2 + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", dw2, dw2, dw2));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setComparator((d1, d2) -> {
            HandlingCostTableRowImpl o1 = (HandlingCostTableRowImpl)d1;
            HandlingCostTableRowImpl o2 = (HandlingCostTableRowImpl)d2;
            if (o1 == null || o1.getHandlingCost() == null) {
                return 1;
            }
            if (o2 == null || o2.getHandlingCost() == null) {
                return -1;
            }
            return o1.getHandlingCost().getNumber().compareTo(o2.getHandlingCost().getNumber());
        });
        table.setOverrideName(AccountDistributionComplete_.handlingcosts);
        table.setProvider(this.provider);
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        this.table.getModel().getNode().addChild((Node)new DTOProxyNode(), System.currentTimeMillis());
        this.table.enableAddButton(true);
        this.editor.revalidate();
    }

    @Override
    public void childRemoved() {
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        HandlingCostTableRowImpl p = new HandlingCostTableRowImpl(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return p;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        HashSet<HandlingCostComplete> products = new HashSet<HandlingCostComplete>();
        for (Table2RowPanel tr : this.table.getRows()) {
            HandlingCostComplete p = (HandlingCostComplete)tr.getModel().getNode().getValue();
            if (products.contains(p)) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.HANDLING_IS_INSERTED_TWICE, (Object[])new Object[]{p.getNumber()})));
                continue;
            }
            products.add(p);
        }
        return validationObjects;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.table.getModel().setNode(node.getChildNamed(AccountDistributionComplete_.handlingcosts));
    }

    private class HandlingCostTableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private SearchTextField2<HandlingCostComplete> handling;
        private DeleteButton deleteButton;

        HandlingCostTableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new InnerLayout());
            this.handling = SearchTextField2Factory.getHandlingCostSearchField(true, m.getNode());
            if (HandlingCostsDetailsPanel.this.isHandlingDeletable) {
                this.deleteButton = new DeleteButton();
                this.deleteButton.addButtonListener(this);
                this.deleteButton.setProgress(1.0f);
                this.add(this.deleteButton);
            }
            this.add(this.handling);
            this.handling.setProgress(1.0f);
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.handling.getName();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.handling.setEnabled(isEnabled && HandlingCostsDetailsPanel.this.isHandlingWritable);
            if (this.deleteButton != null) {
                this.deleteButton.setEnabled(isEnabled);
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            a.addAll(this.handling.getFocusComponents());
            CheckedListAdder.addToList(a, this.deleteButton);
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.handling.requestFocusInWindowNow();
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.model.getNode().removeNodeListener((NodeListener)this);
            this.handling.kill();
            this.handling = null;
            if (this.deleteButton != null) {
                this.deleteButton.kill();
            }
            this.deleteButton = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.deleteButton) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public void valueChanged(Node<?> node) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        public HandlingCostComplete getHandlingCost() {
            return (HandlingCostComplete)this.handling.getNode().getValue();
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = HandlingCostTableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                HandlingCostTableRowImpl.this.handling.setLocation(currentX + HandlingCostTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - HandlingCostTableRowImpl.this.handling.getPreferredSize().getHeight()) / 2.0));
                HandlingCostTableRowImpl.this.handling.setSize(w - 2 * HandlingCostTableRowImpl.this.getCellPadding(), (int)HandlingCostTableRowImpl.this.handling.getPreferredSize().getHeight());
                currentX += w;
                if (HandlingCostTableRowImpl.this.deleteButton != null) {
                    HandlingCostTableRowImpl.this.deleteButton.setLocation(currentX + HandlingCostTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - HandlingCostTableRowImpl.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                    HandlingCostTableRowImpl.this.deleteButton.setSize(HandlingCostTableRowImpl.this.deleteButton.getPreferredSize());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, HandlingCostTableRowImpl.this.getDefaultRowHeight());
            }
        }
    }
}

