/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.accountdistribution.details;

import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.acountdistribution.AccountDistributionComplete_;
import ch.icit.pegasus.server.core.dtos.acountdistribution.AccountDistributionLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SpecificationDetailsPanel
extends DefaultDetailsPanel<AccountDistributionLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDTextField> name;
    private TitledItem<RDSearchTextField2<CustomerLight>> customer;

    public SpecificationDetailsPanel(RowEditor<AccountDistributionLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.SPECIFICATION);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.customer = new TitledItem(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.CUSTOMER), WordsToolkit.toCapitalLetter((String)Words.CUSTOMER), TitledItem.TitledItemOrientation.NORTH);
        this.setCustomLayouter(new Layout());
        this.addToView(this.name);
        this.addToView(this.customer);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.name.requestFocusInWindowNow();
    }

    @Override
    public void validateRemote(List<ScreenValidationObject> callBack) throws ClientServerCallException {
    }

    @Override
    public void setNode(Node<?> node) {
        this.name.getElement().setNode(node.getChildNamed(AccountDistributionComplete_.name));
        this.customer.getElement().setNode(node.getChildNamed(AccountDistributionComplete_.customer));
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.name);
        CheckedListAdder.addToList(a, this.customer);
        return a;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        String n = (String)this.editor.getModel().getNode().getChildNamed(AccountDistributionComplete_.name).getValue();
        if (n == null || n.isEmpty()) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_NAME_IS_SET));
        }
        if (this.editor.getModel().getNode().getChildNamed(AccountDistributionComplete_.customer).getValue() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_CUSTOMER));
        }
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.name.setEnabled(isEnabled);
        this.customer.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.name.kill();
        this.name = null;
        this.customer.kill();
        this.customer = null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            SpecificationDetailsPanel.this.name.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.name.setSize(280, (int)SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.customer.setLocation(SpecificationDetailsPanel.this.name.getX() + SpecificationDetailsPanel.this.name.getWidth() + SpecificationDetailsPanel.this.inner_horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.customer.setSize(180, (int)SpecificationDetailsPanel.this.customer.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            int h = SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            return new Dimension(0, h += SpecificationDetailsPanel.this.verticalBorder);
        }
    }
}

