/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.admin;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.admin.inserts.ActiveSessions;
import ch.icit.pegasus.client.gui.modules.admin.inserts.AdminConfig;
import ch.icit.pegasus.client.gui.modules.admin.inserts.CustomSequenceInsert;
import ch.icit.pegasus.client.gui.modules.admin.inserts.EmailInsert;
import ch.icit.pegasus.client.gui.modules.admin.inserts.LocationsInsert;
import ch.icit.pegasus.client.gui.modules.admin.inserts.ModuleInsert;
import ch.icit.pegasus.client.gui.modules.admin.inserts.PasswordResetInsert;
import ch.icit.pegasus.client.gui.modules.admin.inserts.ReportConfigurationInsert;
import ch.icit.pegasus.client.gui.modules.admin.inserts.ReportSheetsInsert;
import ch.icit.pegasus.client.gui.modules.admin.inserts.SlaveServerInsert;
import ch.icit.pegasus.client.gui.modules.masterdata.AbstractDataInsertModule;
import ch.icit.pegasus.client.gui.screentemplates.ComboBoxScreenInsert;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.AdministrationAccess;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;

public class AdminModule
extends ComboBoxScreenInsert
implements AbstractDataInsertModule,
ItemListener,
ButtonListener,
InnerPopUpListener2,
Module {
    private static final long serialVersionUID = 1L;
    private boolean isChaning = false;
    private boolean isAdmin = false;

    public AdminModule() {
        super(Words.CHOOSE_SECTION);
    }

    private void checkIsAdmin() {
        UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        if (currentUser.getUserName().equals("admin")) {
            this.isAdmin = true;
        }
    }

    @Override
    public void setMainFrame(MainFrame frame) {
        super.setMainFrame(frame);
        this.checkIsAdmin();
        this.fillGUI();
    }

    private void fillGUI() {
        this.getMasterDataSelection().getElement().addItem("");
        this.getMasterDataSelection().getElement().addItem(MASTERDATA.MODULES);
        this.getMasterDataSelection().getElement().addItem(MASTERDATA.REPORT);
        this.getMasterDataSelection().getElement().addItem(MASTERDATA.LOCATIONS);
        this.getMasterDataSelection().getElement().addItem(MASTERDATA.SEQUENCE);
        this.getMasterDataSelection().getElement().addItem(MASTERDATA.SCRIPT);
        this.getMasterDataSelection().getElement().addItem(MASTERDATA.EMAIL);
        this.getMasterDataSelection().getElement().addItem(MASTERDATA.ACTIVE_SESSIONS);
        this.getMasterDataSelection().getElement().addItem(MASTERDATA.REPORT_CONFIGURATION);
        this.getMasterDataSelection().getElement().addItem(MASTERDATA.PASSWORD_RESET);
        if (this.isAdmin) {
            this.getMasterDataSelection().getElement().addItem(MASTERDATA.SLAVE_SERVER);
        }
    }

    @Override
    public void escapeKeyPressed() {
    }

    @Override
    public void saveKeyPressed() {
    }

    @Override
    public void stopAnimationsImmediately() {
    }

    public void redo() {
    }

    public void undo() {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.getMainFrame() != null) {
            this.getMainFrame().showHUDButtons(105);
        }
        if (e.getStateChange() == 1) {
            this.isChaning = true;
            InnerPopupFactory.showDesicionPopup(Words.CHANGE_ADMIN_DATA, Words.SAVE_BEFORE_CHANGING, this.getMasterDataSelection(), this, -1, -1);
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (this.getInsert() != null) {
            List<ScreenValidationObject> a = this.getInsert().validateInsert();
            if (a == null || a.isEmpty()) {
                this.setEnabled(false);
                this.getInsert().saveIt();
            } else {
                InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
            }
        }
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (this.isChaning) {
            if (xargs == null) {
                return;
            }
            if (this.getMasterDataSelection().getElement().getSelectedItem() == MASTERDATA.MODULES) {
                this.setInsert(new ModuleInsert());
                this.setEnabled(true);
            } else if (this.getMasterDataSelection().getElement().getSelectedItem() == MASTERDATA.REPORT) {
                this.setInsert(new ReportSheetsInsert());
                this.setEnabled(true);
            } else if (this.getMasterDataSelection().getElement().getSelectedItem() == MASTERDATA.LOCATIONS) {
                this.setInsert(new LocationsInsert());
                this.setEnabled(true);
            } else if (this.getMasterDataSelection().getElement().getSelectedItem() == MASTERDATA.SEQUENCE) {
                this.setInsert(new CustomSequenceInsert());
                this.setEnabled(true);
            } else if (this.getMasterDataSelection().getElement().getSelectedItem() == MASTERDATA.SCRIPT) {
                this.setInsert(new AdminConfig(this));
                this.setEnabled(true);
            } else if (this.getMasterDataSelection().getElement().getSelectedItem() == MASTERDATA.EMAIL) {
                this.setInsert(new EmailInsert(this));
                this.setEnabled(true);
            } else if (this.getMasterDataSelection().getElement().getSelectedItem() == MASTERDATA.ACTIVE_SESSIONS) {
                this.setInsert(new ActiveSessions(this));
                this.setEnabled(true);
            } else if (this.getMasterDataSelection().getElement().getSelectedItem() == MASTERDATA.REPORT_CONFIGURATION) {
                this.setInsert(new ReportConfigurationInsert());
                this.setEnabled(true);
            } else if (this.getMasterDataSelection().getElement().getSelectedItem() == MASTERDATA.PASSWORD_RESET) {
                this.setInsert(new PasswordResetInsert(this));
                this.setEnabled(true);
            } else if (this.isAdmin && this.getMasterDataSelection().getElement().getSelectedItem() == MASTERDATA.SLAVE_SERVER) {
                this.setInsert(new SlaveServerInsert(this));
                this.setEnabled(true);
            }
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void setSelectionEnabled(boolean isEnabled) {
        this.getMasterDataSelection().setEnabled(isEnabled);
    }

    @Override
    public String getScreenTitle() {
        return AdministrationAccess.MODULE_ADMIN.getDisplayName();
    }

    @Override
    public void dataSaved() {
    }

    @Override
    public void setLoading(boolean b) {
        this.setEnabled(b);
    }

    private static enum MASTERDATA {
        MODULES,
        REPORT,
        LOCATIONS,
        SEQUENCE,
        SCRIPT,
        EMAIL,
        ACTIVE_SESSIONS,
        REPORT_CONFIGURATION,
        PASSWORD_RESET,
        SLAVE_SERVER;


        public String toString() {
            switch (this) {
                case MODULES: {
                    return Words.MODULES;
                }
                case REPORT: {
                    return Words.REPORTS;
                }
                case LOCATIONS: {
                    return Words.LOCATIONS;
                }
                case SEQUENCE: {
                    return Words.SEQUENCE;
                }
                case SCRIPT: {
                    return Words.SCRIPTS;
                }
                case EMAIL: {
                    return Words.E_MAIL;
                }
                case ACTIVE_SESSIONS: {
                    return Words.ACTIVE_SESSIONS;
                }
                case REPORT_CONFIGURATION: {
                    return Words.REPORT_CONFIGURATION;
                }
                case PASSWORD_RESET: {
                    return Words.PASSWORD_RESET;
                }
                case SLAVE_SERVER: {
                    return Words.SLAVE_SERVER;
                }
            }
            return super.toString();
        }
    }
}

