/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.admin.inserts;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.ReportTypeConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DTODataInsert;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferState;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.file.FileServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.file.FileCategoryE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete_;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.file.SubReportFileComplete;
import ch.icit.pegasus.server.core.dtos.system.ADeletableDTO_;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ReportSheetsInsert
extends DTODataInsert<ReportFileComplete>
implements FileTransferListener {
    private static final long serialVersionUID = 1L;

    public ReportSheetsInsert() {
        super((MasterDataModule)null);
    }

    @Override
    public void insertElements() {
    }

    @Override
    public ReportFileComplete getNewObject() {
        return new ReportFileComplete();
    }

    @Override
    public Class<? extends ReportFileComplete> getMasterDataClass() {
        return ReportFileComplete.class;
    }

    @Override
    public DetailsPanel getDetails() {
        return new ReportSheetInsertPanelConfig();
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node r1 = NodeToolkit.getAffixList(ReportTypeE.class);
                if (r1 == null) {
                    StaticEnumServiceManager.getAllReportTypes();
                }
                ArrayList ret = new ArrayList();
                Collections.sort(ret, (o1, o2) -> o1.getReportType().name().compareTo(o2.getReportType().name()));
                for (ReportTypeE en : ReportTypeE.values()) {
                    SearchResult r = ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getReportStyleSheet(en);
                    if (r == null || !(r.getResults() instanceof List)) continue;
                    ret.addAll(r.getResults());
                }
                List r5 = ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getSubReportStylesheets().getList();
                if (r5 != null && r5 instanceof List) {
                    ret.addAll(r5);
                }
                Node n = INodeCreator.getDefaultImpl().createNodes(ret, false);
                Iterator it = n.getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node nn = (Node)it.next();
                    if (nn.getChildNamed(ADeletableDTO_.isDeleted) == null) {
                        Node nc = new Node();
                        nc.setName(ADeletableDTO_.isDeleted);
                        nc.setValue((Object)false, 0L);
                        nn.addChild(nc, 0L);
                    }
                    if (nn.getChildNamed(ADeletableDTO_.isDeleted).getValue() != null) continue;
                    nn.getChildNamed(ADeletableDTO_.isDeleted).setValue((Object)false, 0L);
                }
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ReportSheetsInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void saveIt() {
        super.saveIt();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Iterator it = ReportSheetsInsert.this.masterDataTable.getModel().getNode().getChilds();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    try {
                        ReportFileComplete file;
                        n.commit(ReportFileComplete.class);
                        ReportFileComplete d = (ReportFileComplete)n.getValue(ReportFileComplete.class);
                        if (n.getChildNamed(DtoFieldConstants.selectedFile) != null) {
                            if (n.getChildNamed(DtoFieldConstants.isSub) != null && n.getChildNamed(DtoFieldConstants.isSub).getValue() != null && ((Boolean)n.getChildNamed(DtoFieldConstants.isSub).getValue()).booleanValue() && !(d instanceof SubReportFileComplete)) {
                                SubReportFileComplete r = new SubReportFileComplete();
                                r.setCategory(d.getCategory());
                                r.setDescription(d.getDescription());
                                r.setFileName(d.getFileName());
                                r.setFileSuffix(d.getFileSuffix());
                                r.setLocalFile(d.getLocalFile());
                                r.setReportType(d.getReportType());
                                r.setUri(d.getUri());
                                d = r;
                            }
                            File f = (File)n.getChildNamed(DtoFieldConstants.selectedFile).getValue();
                            d.setCategory(FileCategoryE.STYLESHEET);
                            d.setLocalFile(f);
                            String fname = f.getName();
                            String sname = "";
                            int i = fname.lastIndexOf(".");
                            if (i != -1) {
                                sname = fname.substring(i + 1, fname.length());
                                fname = fname.substring(0, i);
                            }
                            d.setFileSuffix(sname);
                            d.setFileName(fname);
                            if (d.getId() != null) {
                                FileTransferUtil.replace((PegasusFileComplete)d, (File)f, (FileTransferListener[])new FileTransferListener[]{ReportSheetsInsert.this});
                            } else {
                                d = (ReportFileComplete)FileTransferUtil.upload((PegasusFileComplete)d, (FileTransferListener[])new FileTransferListener[]{ReportSheetsInsert.this});
                            }
                            n.removeChild(n.getChildNamed(DtoFieldConstants.selectedFile), 0L);
                        } else if (n.getChildNamed(ADeletableDTO_.isDeleted) != null && Boolean.TRUE.equals(n.getChildNamed(ADeletableDTO_.isDeleted).getValue()) && (file = (ReportFileComplete)n.getValue()).getId() != null) {
                            FileTransferUtil.delete((PegasusFileComplete)file);
                        }
                        if (d.getId() != null) {
                            ((FileServiceManager)ServiceManagerRegistry.getService(FileServiceManager.class)).update((PegasusFileComplete)d);
                        }
                        n.removeExistingValues();
                        n.setValue((Object)d, 0L);
                        n.updateNode();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ReportSheetsInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void statusChanged(File file, FileTransferState state) {
    }

    public void exceptionOccurred(Exception exception) {
    }

    @Override
    public String getInsertName() {
        return Words.REPORT_STYLE_SHEETS;
    }

    private class ReportSheetInsertPanelConfig
    extends DetailsPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextButton styleSheet;
        private final MultiLineTextLabel file;
        private Node<?> node;
        private File selectedFile;
        private TitledItem<TextField> description;
        private TitledItem<ComboBox> reportType;
        private TitledItem<CheckBox> isSubreport;
        private TextLabel resourceInfo;

        public ReportSheetInsertPanelConfig() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.styleSheet = new TextButton();
            this.styleSheet.addButtonListener(this);
            this.isSubreport = new TitledItem<CheckBox>(new CheckBox(), Words.IS_SUBREPORT, TitledItem.TitledItemOrientation.WEST);
            this.reportType = new TitledItem<ComboBox>(new ComboBox(null, NodeToolkit.getAffixList(ReportTypeE.class), ConverterRegistry.getConverter(ReportTypeConverter.class)), Words.REPORT_TYPE, TitledItem.TitledItemOrientation.NORTH);
            this.description = new TitledItem<TextField>(new TextField(), WordsToolkit.toCapitalLetter((String)Words.DESCRIPTION), TitledItem.TitledItemOrientation.NORTH);
            this.resourceInfo = new TextLabel();
            this.file = new MultiLineTextLabel();
            this.setLayout(new AALayout());
            this.add(this.styleSheet);
            this.add(this.resourceInfo);
            this.add(this.file);
            this.add(this.description);
            this.add(this.reportType);
            this.add(this.isSubreport);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            a.addAll(this.description.getFocusComponents());
            a.addAll(this.reportType.getFocusComponents());
            a.addAll(this.isSubreport.getFocusComponents());
            if (this.styleSheet != null) {
                a.addAll(this.styleSheet.getFocusComponents());
            }
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.description.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.description.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (this.isSubreport != null) {
                this.isSubreport.kill();
            }
            if (this.styleSheet != null) {
                this.styleSheet.kill();
            }
            if (this.resourceInfo != null) {
                this.resourceInfo.kill();
            }
            if (this.description != null) {
                this.description.kill();
            }
            if (this.reportType != null) {
                this.reportType.kill();
            }
            this.isSubreport = null;
            this.styleSheet = null;
            this.description = null;
            this.reportType = null;
            this.resourceInfo = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.isSubreport.setEnabled(b);
            this.description.setEnabled(b);
            if (this.styleSheet != null) {
                this.styleSheet.setEnabled(b);
            }
            if (this.resourceInfo != null) {
                this.resourceInfo.setEnabled(b);
            }
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        private void setUserUploaded(Node<?> node) {
            String t = Words.USER_UPLOAD;
            ReportFileComplete d = (ReportFileComplete)node.getValue();
            if (d.getUploadUser() != null) {
                t = t + ", " + Words.BY + " " + d.getUploadUser().getContact().getFirstName() + " " + d.getUploadUser().getContact().getLastName();
            }
            if (d.getUploadTime() != null) {
                Converter c = ConverterRegistry.getConverter(DateTimeConverter.class);
                t = t + ", " + Words.AT + " ";
                t = t + c.convert((Object)d.getUploadTime(), null, new Object[0]);
            }
            this.resourceInfo.setText(t);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.node = node;
            if (node.getChildNamed(ADTO.ID_).getValue() != null) {
                this.styleSheet.setText(Words.REPLACE_STYLESHEET);
                this.setUserUploaded(node);
            } else {
                this.styleSheet.setText(Words.SELECT_STYLESHEET);
                if (node.getChildNamed(ADTO.CLIENT_ID).getValue() == null) {
                    this.resourceInfo.setText(Words.SYSTEM_TYPE);
                } else {
                    this.setUserUploaded(node);
                }
            }
            this.description.getElement().setNode(node.getChildNamed(ReportFileComplete_.description));
            this.reportType.getElement().setNode(node.getChildNamed(ReportFileComplete_.reportType));
            this.reportType.getElement().refreshPossibleValues(NodeToolkit.getAffixList(ReportTypeE.class));
            Node isSub = node.getChildNamed(DtoFieldConstants.isSub);
            if (isSub == null) {
                isSub = new Node();
            }
            if (node.getValue() instanceof SubReportFileComplete) {
                isSub.setValue((Object)true, 0L);
            } else {
                isSub.setValue((Object)false, 0L);
            }
            this.isSubreport.getElement().setNode(isSub);
            if (node.getChildNamed(ReportFileComplete_.fileName).getValue() != null) {
                this.file.setText(((ReportFileComplete)node.getValue()).getFileName());
            } else {
                this.file.setText(Words.NO_STYLESHEET_SELECTED);
            }
            this.revalidate();
            ReportSheetsInsert.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return ReportFileComplete_.description;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            File fileName;
            if (source != this.isSubreport.getElement() && (fileName = FileChooserUtil.loadFile()) != null) {
                this.selectedFile = fileName;
                Node n = this.node.getChildNamed(DtoFieldConstants.selectedFile);
                if (n == null) {
                    n = new Node();
                    n.setName(DtoFieldConstants.selectedFile);
                    this.node.addChild(n, 0L);
                }
                n.setValue((Object)this.selectedFile, 0L);
                this.file.setText(this.selectedFile.getPath());
            }
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                ReportSheetInsertPanelConfig.this.description.setLocation(ReportSheetsInsert.this.masterDataTable.getCellPadding(), ReportSheetsInsert.this.masterDataTable.getCellPadding());
                ReportSheetInsertPanelConfig.this.description.setSize(200, (int)ReportSheetInsertPanelConfig.this.description.getPreferredSize().getHeight());
                ReportSheetInsertPanelConfig.this.resourceInfo.setLocation(ReportSheetInsertPanelConfig.this.description.getX() + ReportSheetInsertPanelConfig.this.description.getWidth() + ReportSheetsInsert.this.masterDataTable.getCellPadding(), (int)((double)(ReportSheetInsertPanelConfig.this.description.getY() + ReportSheetInsertPanelConfig.this.description.getHeight()) - ReportSheetInsertPanelConfig.this.resourceInfo.getPreferredSize().getHeight()));
                ReportSheetInsertPanelConfig.this.resourceInfo.setSize(ReportSheetInsertPanelConfig.this.resourceInfo.getPreferredSize());
                ReportSheetInsertPanelConfig.this.reportType.setLocation(ReportSheetsInsert.this.masterDataTable.getCellPadding(), ReportSheetInsertPanelConfig.this.description.getY() + ReportSheetInsertPanelConfig.this.description.getHeight() + ReportSheetsInsert.this.masterDataTable.getCellPadding());
                ReportSheetInsertPanelConfig.this.reportType.setSize(400, (int)ReportSheetInsertPanelConfig.this.reportType.getPreferredSize().getHeight());
                int cy = ReportSheetInsertPanelConfig.this.reportType.getY() + ReportSheetInsertPanelConfig.this.reportType.getHeight() + ReportSheetsInsert.this.masterDataTable.getCellPadding();
                ReportSheetInsertPanelConfig.this.isSubreport.setLocation(ReportSheetInsertPanelConfig.this.reportType.getX() + ReportSheetInsertPanelConfig.this.reportType.getWidth() + 5, (int)((double)cy - ReportSheetInsertPanelConfig.this.isSubreport.getPreferredSize().getHeight()) - 9);
                ReportSheetInsertPanelConfig.this.isSubreport.setSize(ReportSheetInsertPanelConfig.this.isSubreport.getPreferredSize());
                if (ReportSheetInsertPanelConfig.this.styleSheet != null) {
                    ReportSheetInsertPanelConfig.this.styleSheet.setLocation(ReportSheetsInsert.this.masterDataTable.getCellPadding(), ReportSheetInsertPanelConfig.this.reportType.getY() + ReportSheetInsertPanelConfig.this.reportType.getHeight() + ReportSheetsInsert.this.masterDataTable.getCellPadding());
                    ReportSheetInsertPanelConfig.this.styleSheet.setSize(200, (int)ReportSheetInsertPanelConfig.this.styleSheet.getPreferredSize().getHeight());
                    cy = ReportSheetInsertPanelConfig.this.styleSheet.getY() + ReportSheetInsertPanelConfig.this.styleSheet.getHeight() + ReportSheetsInsert.this.masterDataTable.getCellPadding();
                }
                ReportSheetInsertPanelConfig.this.file.setLocation(ReportSheetsInsert.this.masterDataTable.getCellPadding(), cy);
                ReportSheetInsertPanelConfig.this.file.setSize(ReportSheetInsertPanelConfig.this.file.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

