/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.article.details;

import ch.icit.pegasus.client.gui.modules.article.details.utils.InventoryTransitionCommentTable;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextArea;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class AdditionalInfoDetailsPanel
extends DefaultDetailsPanel<BasicArticleLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDTextArea> additionalInformation;
    private TitledItem<RDTextArea> usageComment;
    private InventoryTransitionCommentTable transitionTable;

    public AdditionalInfoDetailsPanel(RowEditor<BasicArticleLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.COMMENTS);
        this.additionalInformation = new TitledItem<RDTextArea>(new RDTextArea(provider), Words.ORDER_INFO, TitledItem.TitledItemOrientation.NORTH);
        this.additionalInformation.setIgnorePrefHeight(true);
        this.additionalInformation.setIgnorePrefWidth(true);
        this.usageComment = new TitledItem<RDTextArea>(new RDTextArea(provider), Words.USAGE_COMMENT, TitledItem.TitledItemOrientation.NORTH);
        this.usageComment.setIgnorePrefHeight(true);
        this.usageComment.setIgnorePrefWidth(true);
        RowEditor<BasicArticleLight> rowEditor = editor;
        this.transitionTable = new InventoryTransitionCommentTable(provider, rowEditor);
        this.setCustomLayouter(new Layout());
        this.addToView(this.additionalInformation);
        this.addToView(this.usageComment);
        this.addToView(this.transitionTable);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.additionalInformation.setEnabled(isEnabled);
        this.usageComment.setEnabled(isEnabled);
        this.transitionTable.setEnabled(isEnabled);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        return this.transitionTable.validateRow();
    }

    @Override
    public void setNode(Node<?> node) {
        this.additionalInformation.getElement().setNode(node.getChildNamed(BasicArticleComplete_.comment));
        this.usageComment.getElement().setNode(node.getChildNamed(BasicArticleComplete_.usageComment));
        this.transitionTable.getModel().setNode(node.getChildNamed(BasicArticleComplete_.inventoryComments));
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusComponents = new ArrayList<Component>();
        CheckedListAdder.addToList(focusComponents, this.additionalInformation);
        CheckedListAdder.addToList(focusComponents, this.usageComment);
        CheckedListAdder.addToList(focusComponents, this.transitionTable);
        return focusComponents;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int height = (parent.getHeight() - (2 * AdditionalInfoDetailsPanel.this.verticalBorder + 2 * AdditionalInfoDetailsPanel.this.inner_verticalBorder)) / 3;
            AdditionalInfoDetailsPanel.this.additionalInformation.setLocation(AdditionalInfoDetailsPanel.this.horizontalBorder, AdditionalInfoDetailsPanel.this.verticalBorder);
            AdditionalInfoDetailsPanel.this.additionalInformation.setSize(parent.getWidth() - 2 * AdditionalInfoDetailsPanel.this.horizontalBorder, height);
            AdditionalInfoDetailsPanel.this.usageComment.setLocation(AdditionalInfoDetailsPanel.this.horizontalBorder, AdditionalInfoDetailsPanel.this.additionalInformation.getY() + AdditionalInfoDetailsPanel.this.additionalInformation.getHeight() + AdditionalInfoDetailsPanel.this.inner_verticalBorder);
            AdditionalInfoDetailsPanel.this.usageComment.setSize(parent.getWidth() - 2 * AdditionalInfoDetailsPanel.this.horizontalBorder, height);
            AdditionalInfoDetailsPanel.this.transitionTable.setLocation(AdditionalInfoDetailsPanel.this.horizontalBorder, AdditionalInfoDetailsPanel.this.usageComment.getY() + AdditionalInfoDetailsPanel.this.usageComment.getHeight() + AdditionalInfoDetailsPanel.this.inner_verticalBorder);
            AdditionalInfoDetailsPanel.this.transitionTable.setSize(parent.getWidth() - 2 * AdditionalInfoDetailsPanel.this.horizontalBorder, height);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 400);
        }
    }
}

