/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.article.details;

import ch.icit.pegasus.client.converter.FormattedDoubleConverter3Decimals;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.article.details.utils.GroupedLoader;
import ch.icit.pegasus.client.gui.modules.article.details.utils.MaterialCostPanel;
import ch.icit.pegasus.client.gui.modules.article.details.utils.SupplierPriceConverter;
import ch.icit.pegasus.client.gui.modules.article.details.utils.TotalCostConverter;
import ch.icit.pegasus.client.gui.modules.article.details.utils.TotalCostSolarConverter;
import ch.icit.pegasus.client.gui.modules.article.details.utils.WeightedPriceConverter;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.panels.TabbedItem;
import ch.icit.pegasus.client.gui.utils.priceanimation.CalculationRunnable;
import ch.icit.pegasus.client.gui.utils.priceanimation.LoadingGroup;
import ch.icit.pegasus.client.gui.utils.priceanimation.ReloadablePriceView;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.HorizontalTextureSkin;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.BackgroundFadeSkin;
import ch.icit.pegasus.client.gui.utils.tabbed.TabButton;
import ch.icit.pegasus.client.gui.utils.tables.ArticlePriceTable;
import ch.icit.pegasus.client.gui.utils.tables.ArticleTenderPriceTable;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.ValueChangeListener;
import ch.icit.pegasus.client.util.variantaccessor.CurrencyVariantAccessorImpl;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticlePriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticlePriceComplete_;
import ch.icit.pegasus.server.core.dtos.supply.MaterialCostFactorComplete_;
import ch.icit.pegasus.server.core.dtos.supply.MaterialCostFactorVariantComplete;
import ch.icit.pegasus.server.core.dtos.supply.MaterialCostFactorVariantComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.ArticlePriceCalculationToolkit;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CurrencyVariantAccessor;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CostCalculationDetailsPanel
extends DefaultDetailsPanel<BasicArticleLight>
implements ValueChangeListener,
NodeListener {
    private static final long serialVersionUID = 1L;
    private final boolean isSolarCompany;
    private ReloadablePriceView cheapestPrice;
    private HorizontalSeparator sep1;
    private HorizontalSeparator sep2;
    private TextLabel priceTitle;
    private TextLabel matCostFactorTitle;
    private GroupedLoader loader;
    private TabbedItem<ArticlePriceTable> prices;
    private ReloadablePriceView totalPrice;
    private ArticlePriceTable articlePrice;
    private ArticlePriceTable tenderArticlePrice;
    private MaterialCostPanel table;
    private HorizontalTextureSkin backFade;
    private SupplierPriceConverter converter;
    private boolean isTemplate;
    private CurrencyVariantAccessor accessor = new CurrencyVariantAccessorImpl();

    public CostCalculationDetailsPanel(RowEditor<BasicArticleLight> editor, RDProvider provider, GroupedLoader loader) {
        super(editor, provider);
        this.isSolarCompany = Boolean.TRUE.equals(this.settings.getCompany().getSolarCompanyType());
        this.backFade = SkinRegistry.getSkin(BackgroundFadeSkin.class);
        this.setTitleText(Words.COST_CALCULATION);
        this.loader = loader;
        Object[] paras = new Object[]{FormattedDoubleConverter3Decimals.class};
        this.sep1 = new HorizontalSeparator();
        this.sep2 = new HorizontalSeparator();
        this.priceTitle = new TextLabel(Words.STANDARD_PRICE);
        if (!this.isSolarCompany) {
            this.matCostFactorTitle = new TextLabel(Words.MATERIAL_COST_FACTORS);
        }
        this.cheapestPrice = new ReloadablePriceView((LoadingGroup)loader, ConverterRegistry.getConverter(WeightedPriceConverter.class));
        this.cheapestPrice.setToolTipText(Words.PRICE_WEIGHTED_BY_THE_SUPPLIER_QUOTA);
        this.cheapestPrice.setConverterParametes(paras);
        this.totalPrice = this.isSolarCompany ? new ReloadablePriceView((LoadingGroup)loader, ConverterRegistry.getConverter(TotalCostSolarConverter.class)) : new ReloadablePriceView((LoadingGroup)loader, ConverterRegistry.getConverter(TotalCostConverter.class));
        this.totalPrice.setConverterParametes(paras);
        loader.setWeightedPrice(this.cheapestPrice);
        loader.setTotalView(this.totalPrice);
        this.prices = new TabbedItem<ArticlePriceTable>(){

            @Override
            public void updateFocusCycle() {
            }
        };
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        boolean showTenderPrice = Boolean.TRUE.equals(settings.getUseArticlePriceTender());
        if (showTenderPrice) {
            this.articlePrice = new ArticlePriceTable(false, provider, loader, false, false, Words.PRICES);
            this.articlePrice.setUseTenderRights(false, editor.getModel().isAddRow());
            this.tenderArticlePrice = new ArticleTenderPriceTable(false, provider, null, true, Words.TENDER_PRICES);
            this.tenderArticlePrice.setUseTenderRights(true, false);
            this.prices.addView(this.articlePrice, new TabButton(Words.PRODUCTIVE), true);
            this.prices.addView(this.tenderArticlePrice, new TabButton(Words.TENDER));
        } else {
            this.articlePrice = new ArticlePriceTable(false, provider, loader);
            this.articlePrice.setUseTenderRights(false, editor.getModel().isAddRow());
            this.prices.addView(this.articlePrice, new TabButton(Words.PRODUCTIVE), true);
            this.prices.removeHeaders();
        }
        if (!this.isSolarCompany) {
            this.table = new MaterialCostPanel(provider, this, editor);
        }
        this.setCustomLayouter(new Layout());
        this.totalPrice.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("productoverview_pricetext_font_type")));
        this.cheapestPrice.setFont(this.totalPrice.getFont());
        this.priceTitle.setFont(this.cheapestPrice.getFont());
        if (!this.isSolarCompany) {
            this.matCostFactorTitle.setFont(this.cheapestPrice.getFont());
        }
        if (!this.isSolarCompany) {
            this.addToView(this.table);
            this.addToView(this.matCostFactorTitle);
        }
        this.addToView(this.cheapestPrice);
        this.addToView(this.prices);
        this.addToView(this.totalPrice);
        this.addToView(this.sep1);
        this.addToView(this.sep2);
        this.addToView(this.priceTitle);
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public void setTemplate(boolean isTemplate) {
        this.isTemplate = isTemplate;
    }

    @Override
    public void setNode(Node<?> node) {
        SupplierPriceConverter c = (SupplierPriceConverter)ConverterRegistry.getConverter(SupplierPriceConverter.class);
        c.setSecondNode((Node<UnitComplete>)node.getChildNamed(BasicArticleLight_.priceUnit));
        this.converter = c;
        this.converter.convert(null, null, new Object[0]);
        node.getChildNamed(BasicArticleLight_.priceUnit).addNodeListener((NodeListener)this);
        this.articlePrice.setSecondUnitNode((Node<UnitComplete>)node.getChildNamed(BasicArticleLight_.priceUnit));
        node.getChildNamed(BasicArticleComplete_.prices).sortChilds((o1, o2) -> {
            BasicArticlePriceComplete a1 = (BasicArticlePriceComplete)o1.getValue();
            BasicArticlePriceComplete a2 = (BasicArticlePriceComplete)o2.getValue();
            return a1.compareTo(a2);
        });
        this.articlePrice.getModel().setNode(node.getChildNamed(BasicArticleComplete_.prices));
        if (this.tenderArticlePrice != null) {
            this.tenderArticlePrice.setSecondUnitNode((Node<UnitComplete>)node.getChildNamed(BasicArticleLight_.priceUnit));
            this.tenderArticlePrice.getModel().setNode(node.getChildNamed(BasicArticleComplete_.tenderPrices));
        }
        this.setCheapestPriceCalc();
        this.setCalc();
        this.loader.updateMe(this.cheapestPrice);
        this.loader.updateMe(this.totalPrice);
        if (!this.isSolarCompany) {
            this.table.setNode(node);
        }
    }

    private void updateWeightedPrice() {
        this.loader.updateMe(this.cheapestPrice);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.hasBackground) {
            g2.setColor(this.innerBackground);
            g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.arcW, this.arcH);
        }
        if (this.hasSkin) {
            this.skin.paint(g2, 0, 0, this.getWidth(), this.getHeight(), Button.ButtonState.UP);
        }
        if (this.useCliping) {
            g2.clip(this.getClipingArea());
        }
        int backHeight = this.backFade.getImage(11).getHeight();
        this.backFade.paint(g2, 0, this.getTitleHeight(), this.getWidth(), 11);
        g2.setColor(new Color(25, 25, 25));
        g2.drawLine(0, this.getTitleHeight(), this.getWidth() - 1, this.getTitleHeight());
        this.backFade.paint(g2, 0, this.getHeight() - backHeight, this.getWidth(), 11);
        this.paintChildren(g2);
    }

    private void setCheapestPriceCalc() {
        CalculationRunnable run = new CalculationRunnable(){

            @Override
            public void run() {
                if (CostCalculationDetailsPanel.this.isTemplate) {
                    return;
                }
                CostCalculationDetailsPanel.this.editor.getModel().getNode().commit(BasicArticleComplete.class);
                BasicArticleComplete article = (BasicArticleComplete)CostCalculationDetailsPanel.this.editor.getModel().getNode().getValue(BasicArticleComplete.class);
                PriceComplete price = ArticlePriceCalculationToolkit.getCheapestPurchasePrice((BasicArticleComplete)article, (CurrencyComplete)CostCalculationDetailsPanel.this.converter.getHomeBaseCurrency(), (CurrencyVariantAccessor)CostCalculationDetailsPanel.this.accessor, (Timestamp)new Timestamp(System.currentTimeMillis()));
                if (price != null && CostCalculationDetailsPanel.this.cheapestPrice != null) {
                    Node priceNode = CostCalculationDetailsPanel.this.cheapestPrice.getNode();
                    if (priceNode == null) {
                        priceNode = new EmbeddedDTONode();
                        if (CostCalculationDetailsPanel.this.cheapestPrice != null) {
                            CostCalculationDetailsPanel.this.cheapestPrice.setNode(priceNode);
                        }
                    }
                    priceNode.setValue((Object)price, 0L);
                }
            }

            @Override
            public boolean isAlive() {
                return CostCalculationDetailsPanel.this.cheapestPrice != null && !CostCalculationDetailsPanel.this.cheapestPrice.isKilled();
            }
        };
        this.cheapestPrice.setRunnable(run);
    }

    private Node<MaterialCostFactorVariantComplete> getCurrentMaterialCostFactor(Node<List<MaterialCostFactorVariantComplete>> variants, Timestamp validityDate) {
        Iterator it = variants.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node materialPriceFactorNode = (Node)it.next();
            Date startDate = (Date)materialPriceFactorNode.getChildNamed(new DtoField[]{MaterialCostFactorVariantComplete_.validityPeriod, PeriodComplete_.startDate}).getValue();
            Date endDate = (Date)materialPriceFactorNode.getChildNamed(new DtoField[]{MaterialCostFactorVariantComplete_.validityPeriod, PeriodComplete_.endDate}).getValue();
            if (startDate.getTime() > validityDate.getTime() || endDate.getTime() < validityDate.getTime()) continue;
            return materialPriceFactorNode;
        }
        return variants.getChildAt(variants.getChildCount() - 1);
    }

    private void setCalc() {
        CalculationRunnable run = new CalculationRunnable(){

            @Override
            public void run() {
                if (CostCalculationDetailsPanel.this.isTemplate) {
                    return;
                }
                CostCalculationDetailsPanel.this.editor.getModel().getNode().commit(BasicArticleComplete.class);
                double priceValue = CostCalculationDetailsPanel.this.getCurrentArticlePrice();
                double additional = 0.0;
                Node mats = CostCalculationDetailsPanel.this.getCurrentMaterialCostFactor((Node<List<MaterialCostFactorVariantComplete>>)CostCalculationDetailsPanel.this.editor.getModel().getNode().getChildNamed(BasicArticleComplete_.materialCostFactorVariants), new Timestamp(System.currentTimeMillis()));
                Iterator it = mats.getChildNamed(MaterialCostFactorVariantComplete_.materialCostFactors).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node factorNode = (Node)it.next();
                    Double factor = (Double)factorNode.getChildNamed(MaterialCostFactorComplete_.value).getValue();
                    if (factor == null) continue;
                    additional += priceValue * (factor / 100.0);
                }
                PriceComplete price = new PriceComplete(CostCalculationDetailsPanel.this.converter.getHomeBaseCurrency(), Double.valueOf(priceValue + additional));
                Node priceNode = CostCalculationDetailsPanel.this.totalPrice.getNode();
                if (priceNode == null) {
                    priceNode = new EmbeddedDTONode();
                    priceNode.setValue((Object)price, 0L);
                    CostCalculationDetailsPanel.this.totalPrice.setNode(priceNode);
                } else {
                    priceNode.setValue((Object)price, 0L);
                }
            }

            @Override
            public boolean isAlive() {
                return !CostCalculationDetailsPanel.this.totalPrice.isKilled();
            }
        };
        this.totalPrice.setRunnable(run);
    }

    private double getCurrentArticlePrice() {
        Iterator it = this.editor.getModel().getNode().getChildNamed(BasicArticleLight_.prices).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node priceNode = (Node)it.next();
            Date startDate = (Date)priceNode.getChildNamed(new DtoField[]{BasicArticlePriceComplete_.validity, PeriodComplete_.startDate}).getValue();
            Date endDate = (Date)priceNode.getChildNamed(new DtoField[]{BasicArticlePriceComplete_.validity, PeriodComplete_.endDate}).getValue();
            if (startDate.getTime() > System.currentTimeMillis() || endDate.getTime() < System.currentTimeMillis()) continue;
            return (Double)priceNode.getChildNamed(new DtoField[]{BasicArticlePriceComplete_.price, PriceComplete_.price}).getValue();
        }
        return 0.0;
    }

    @Override
    public void valueChanged(Object newValue) {
        this.invalidate();
        this.validate();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (!this.isSolarCompany) {
            this.table.kill();
        }
        this.cheapestPrice.kill();
        if (this.editor.getModel().getNode() != null && this.editor.getModel().getNode().getChildNamed(BasicArticleLight_.priceUnit) != null) {
            this.editor.getModel().getNode().getChildNamed(BasicArticleLight_.priceUnit).removeNodeListener((NodeListener)this);
        }
        this.sep1.kill();
        this.sep2.kill();
        this.priceTitle.kill();
        if (!this.isSolarCompany) {
            this.matCostFactorTitle.kill();
        }
        this.sep1 = null;
        this.priceTitle = null;
        this.matCostFactorTitle = null;
        this.articlePrice.kill();
        this.articlePrice = null;
        if (this.tenderArticlePrice != null) {
            this.tenderArticlePrice.kill();
            this.tenderArticlePrice = null;
        }
        this.table = null;
        this.cheapestPrice = null;
        this.prices.kill();
        this.prices = null;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (settings.getArticleStdPriceRestrictiv().booleanValue()) {
            Iterator it = this.editor.getModel().getNode().getChildNamed(BasicArticleComplete_.prices).getFailSafeChildIterator();
            boolean foundWrongPrice = false;
            while (it.hasNext()) {
                Node b = (Node)it.next();
                DtoField[] dtoFieldArray = new DtoField[]{BasicArticlePriceComplete_.price, PriceComplete_.price};
                if (!((Double)b.getChildNamed(dtoFieldArray).getValue() < 0.0)) continue;
                foundWrongPrice = true;
            }
            if (foundWrongPrice) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_STANDARD_PRICE_IS_GREATER_THAN_0));
            }
        }
        if (this.editor.getModel().getNode().getChildNamed(BasicArticleComplete_.prices).getChildCount() == 0) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ATLEAST_ONE_PRICE_VARIANT_EXISTS));
        }
        this.validateStdPriceVariants(validationObjects);
        this.validatePriceFactorVariants(validationObjects);
        return validationObjects;
    }

    private void validateStdPriceVariants(List<ScreenValidationObject> validationObjects) {
        this.articlePrice.updateOrder();
        long lastDate = -1L;
        boolean errorFound = false;
        for (Table2RowPanel p : this.articlePrice.getRows()) {
            Date startDate = (Date)p.getModel().getNode().getChildNamed(new DtoField[]{BasicArticlePriceComplete_.validity, PeriodComplete_.startDate}).getValue();
            Date endDate = (Date)p.getModel().getNode().getChildNamed(new DtoField[]{BasicArticlePriceComplete_.validity, PeriodComplete_.endDate}).getValue();
            PeriodComplete pc = new PeriodComplete(startDate, endDate);
            if (lastDate != -1L && lastDate + 1L != pc.getStartDate().getTime()) {
                errorFound = true;
            }
            lastDate = pc.getEndDate().getTime();
        }
        if (errorFound) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_THE_GIVEN_PRICE_VARIANTS_AREN_T_OVERLAPPING_AVOID_GABS));
        }
        if (this.articlePrice.getRowCount() == 0) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_AT_LEAST_ONE_PRICE_VARIANT));
        }
    }

    private void validatePriceFactorVariants(List<ScreenValidationObject> validationObjects) {
        if (!this.isSolarCompany) {
            this.table.getProductiveMaterialCostTable().updateOrder();
            long lastDate = -1L;
            boolean errorFound = false;
            for (Table2RowPanel p : this.table.getProductiveMaterialCostTable().getRows()) {
                Date startDate = (Date)p.getModel().getNode().getChildNamed(new DtoField[]{MaterialCostFactorVariantComplete_.validityPeriod, PeriodComplete_.startDate}).getValue();
                Date endDate = (Date)p.getModel().getNode().getChildNamed(new DtoField[]{MaterialCostFactorVariantComplete_.validityPeriod, PeriodComplete_.endDate}).getValue();
                PeriodComplete pc = new PeriodComplete(startDate, endDate);
                if (lastDate != -1L && lastDate + 1L != pc.getStartDate().getTime()) {
                    errorFound = true;
                }
                lastDate = pc.getEndDate().getTime();
            }
            if (errorFound) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_THE_GIVEN_MATERIAL_VARIANTS_AREN_T_OVERLAPPING_AVOID_GABS));
            }
        }
        if (this.articlePrice.getRowCount() == 0) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_AT_LEAST_ONE_MATERIAL_VARIANT));
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (!this.isSolarCompany) {
            this.table.setEnabled(isEnabled);
            this.matCostFactorTitle.setEnabled(isEnabled);
        }
        this.cheapestPrice.setEnabled(isEnabled);
        this.prices.setEnabled(isEnabled);
        this.totalPrice.setEnabled(isEnabled);
        this.sep1.setEnabled(isEnabled);
        this.sep2.setEnabled(isEnabled);
        this.priceTitle.setEnabled(isEnabled);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusComponents = new ArrayList<Component>();
        CheckedListAdder.addToList(focusComponents, this.prices);
        CheckedListAdder.addToList(focusComponents, this.table);
        return focusComponents;
    }

    public Double getUserPrice() {
        return this.getCurrentArticlePrice();
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void valueChanged(Node<?> node) {
        if (node.getName().equals(BasicArticleLight_.priceUnit.getFieldName())) {
            this.updateWeightedPrice();
            this.totalPrice.updateString();
            this.articlePrice.updateAdditional();
            if (this.tenderArticlePrice != null) {
                this.tenderArticlePrice.updateAdditional();
            }
        } else {
            this.loader.updateMe(this.totalPrice);
        }
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public void updatePrice() {
        this.loader.updateMe(this.cheapestPrice);
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
    }

    public GroupedLoader getLoader() {
        return this.loader;
    }

    public SupplierPriceConverter getConverter() {
        return this.converter;
    }

    public boolean isSwingOnly() {
        return true;
    }

    public ReloadablePriceView getTotalPrice() {
        return this.totalPrice;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int backHeight;
            int shapeHeight = backHeight = CostCalculationDetailsPanel.this.backFade.getImage(11).getHeight();
            CostCalculationDetailsPanel.this.cheapestPrice.setLocation(CostCalculationDetailsPanel.this.horizontalBorder, (int)(((double)backHeight - CostCalculationDetailsPanel.this.cheapestPrice.getPreferredSize().getHeight()) / 2.0));
            CostCalculationDetailsPanel.this.cheapestPrice.setSize(parent.getWidth() - 2 * CostCalculationDetailsPanel.this.horizontalBorder, (int)CostCalculationDetailsPanel.this.cheapestPrice.getPreferredSize().getHeight());
            CostCalculationDetailsPanel.this.sep1.setLocation(0, backHeight);
            CostCalculationDetailsPanel.this.sep1.setSize(parent.getWidth(), (int)CostCalculationDetailsPanel.this.sep1.getPreferredSize().getHeight());
            CostCalculationDetailsPanel.this.priceTitle.setLocation(CostCalculationDetailsPanel.this.horizontalBorder, CostCalculationDetailsPanel.this.sep1.getY() + CostCalculationDetailsPanel.this.sep1.getHeight());
            CostCalculationDetailsPanel.this.priceTitle.setSize(parent.getWidth() - 2 * CostCalculationDetailsPanel.this.horizontalBorder, (int)CostCalculationDetailsPanel.this.priceTitle.getPreferredSize().getHeight());
            CostCalculationDetailsPanel.this.prices.setLocation(0, CostCalculationDetailsPanel.this.priceTitle.getY() + CostCalculationDetailsPanel.this.priceTitle.getHeight());
            CostCalculationDetailsPanel.this.prices.setSize(parent.getWidth(), 200);
            CostCalculationDetailsPanel.this.sep2.setLocation(0, CostCalculationDetailsPanel.this.prices.getY() + CostCalculationDetailsPanel.this.prices.getHeight());
            CostCalculationDetailsPanel.this.sep2.setSize(parent.getWidth(), (int)CostCalculationDetailsPanel.this.sep2.getPreferredSize().getHeight());
            if (!CostCalculationDetailsPanel.this.isSolarCompany) {
                CostCalculationDetailsPanel.this.matCostFactorTitle.setLocation(CostCalculationDetailsPanel.this.horizontalBorder, CostCalculationDetailsPanel.this.sep2.getY() + CostCalculationDetailsPanel.this.sep2.getHeight());
                CostCalculationDetailsPanel.this.matCostFactorTitle.setSize(parent.getWidth() - 2 * CostCalculationDetailsPanel.this.horizontalBorder, (int)CostCalculationDetailsPanel.this.matCostFactorTitle.getPreferredSize().getHeight());
                CostCalculationDetailsPanel.this.table.setLocation(0, CostCalculationDetailsPanel.this.matCostFactorTitle.getY() + CostCalculationDetailsPanel.this.matCostFactorTitle.getHeight());
                CostCalculationDetailsPanel.this.table.setSize(parent.getWidth(), parent.getHeight() - (CostCalculationDetailsPanel.this.table.getY() + shapeHeight));
            }
            CostCalculationDetailsPanel.this.totalPrice.setLocation(CostCalculationDetailsPanel.this.horizontalBorder, (int)((double)(parent.getHeight() - backHeight) + ((double)backHeight - CostCalculationDetailsPanel.this.totalPrice.getPreferredSize().getHeight()) / 2.0));
            CostCalculationDetailsPanel.this.totalPrice.setSize(parent.getWidth() - CostCalculationDetailsPanel.this.horizontalBorder * 2, (int)CostCalculationDetailsPanel.this.totalPrice.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int backHeight = CostCalculationDetailsPanel.this.backFade.getImage(11).getHeight();
            int h = 0;
            h += 3 * backHeight;
            h += 200;
            if (!CostCalculationDetailsPanel.this.isSolarCompany) {
                h += 300;
            }
            return new Dimension(0, h);
        }
    }
}

