/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.article.details;

import ch.icit.pegasus.client.gui.modules.article.details.CostCalculationDetailsPanel;
import ch.icit.pegasus.client.gui.modules.article.details.SupplierConditionDetailsPanel;
import ch.icit.pegasus.client.gui.modules.article.details.utils.ISpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.commiter.FileCommitter;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.panels.SupplierConditionPanel;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionBaseComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionCategoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionCategoryComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionSpecificationComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionSpecificationComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import ch.icit.utils.NumberUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class SupplierDetailsPanel
extends DefaultDetailsPanel<BasicArticleLight>
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private SupplierConditionPanel table;

    public SupplierDetailsPanel(RowEditor<BasicArticleLight> editor, RDProvider provider, CostCalculationDetailsPanel costPanel, ISpecificationDetailsPanel spec) {
        super(editor, provider);
        this.setTitleText(Words.SUPPLIER_CONFIGURATION);
        this.table = new SupplierConditionPanel(editor, provider, costPanel, spec);
        this.setCustomLayouter(new Layout());
        this.addToView(this.table);
    }

    @Override
    public void setNode(Node<?> node) {
        node.getChildNamed(BasicArticleLight_.priceUnit).addNodeListener((NodeListener)this);
        this.table.setNode(node);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        Iterator it = this.getEditor().getModel().getNode().getChildNamed(BasicArticleComplete_.suppliers).getFailSafeChildIterator();
        boolean hasNoSupplier = false;
        while (it.hasNext()) {
            int year;
            java.util.Date endOfYear;
            boolean validityValidation = false;
            java.util.Date validityValidationReferenceDate = null;
            boolean fieldValidation = false;
            boolean categoryUniquenessValidation = false;
            ArrayList<TaxZoneComplete> categoryIndex = new ArrayList<TaxZoneComplete>();
            Node supplierLEVEL_1 = (Node)it.next();
            SupplierLight supplier = null;
            if (supplierLEVEL_1.getChildNamed(SupplierConditionBaseComplete_.supplier).getValue() == null) {
                hasNoSupplier = true;
            } else {
                supplier = (SupplierLight)supplierLEVEL_1.getChildNamed(SupplierConditionBaseComplete_.supplier).getValue();
            }
            Iterator it3 = supplierLEVEL_1.getChildNamed(SupplierConditionBaseComplete_.specifications).getFailSafeChildIterator();
            while (it3.hasNext()) {
                Node supplierSpecifications = (Node)it3.next();
                Node supplierSpecificationNode = supplierSpecifications.getChildNamed(SupplierConditionSpecificationComplete_.specFile);
                PegasusFileComplete supplierSpecification = (PegasusFileComplete)supplierSpecificationNode.getValue(PegasusFileComplete.class);
                if (supplierSpecification != null && (supplierSpecification.getLocalFile() != null || supplierSpecification.getId() != null)) continue;
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ALL_SPECIFICATIONS_HAVE_A_PDF));
            }
            Iterator it2 = supplierLEVEL_1.getChildNamed(SupplierConditionBaseComplete_.supplierConditionCategory).getFailSafeChildIterator();
            while (it2.hasNext()) {
                Node supplierLEVEL_2 = (Node)it2.next();
                TaxZoneComplete taxZone = (TaxZoneComplete)supplierLEVEL_2.getChildNamed(SupplierConditionCategoryComplete_.taxZone).getValue();
                if (categoryIndex.contains(taxZone)) {
                    categoryUniquenessValidation = true;
                } else {
                    categoryIndex.add(taxZone);
                }
                supplierLEVEL_2.getChildNamed(SupplierConditionCategoryComplete_.conditions).sortChilds(new Comparator<Node<?>>(){

                    @Override
                    public int compare(Node<?> o1, Node<?> o2) {
                        return ((SupplierConditionComplete)o1.getValue(SupplierConditionComplete.class)).getValidityPeriod().getStartDate().compareTo(((SupplierConditionComplete)o2.getValue(SupplierConditionComplete.class)).getValidityPeriod().getStartDate());
                    }
                });
                it3 = supplierLEVEL_2.getChildNamed(SupplierConditionCategoryComplete_.conditions).getFailSafeChildIterator();
                long latestEnd = -1L;
                while (it3.hasNext()) {
                    Node supplierLEVEL_3 = (Node)it3.next();
                    Double interval = NumberUtils.getDoubleValue((Object)supplierLEVEL_3.getChildNamed(SupplierConditionComplete_.minOrderAmount).getValue());
                    supplierLEVEL_3.getChildNamed(SupplierConditionComplete_.minOrderAmount).setValue((Object)interval, 0L);
                    supplierLEVEL_3.commitThis(SupplierConditionComplete.class);
                    Date startDate = (Date)supplierLEVEL_3.getChildNamed(new DtoField[]{SupplierConditionComplete_.validity, PeriodComplete_.startDate}).getValue();
                    Date endDate = (Date)supplierLEVEL_3.getChildNamed(new DtoField[]{SupplierConditionComplete_.validity, PeriodComplete_.endDate}).getValue();
                    PeriodComplete period = new PeriodComplete(startDate, endDate);
                    if (period.getStartDate().after(period.getEndDate())) {
                        String sup = supplier != null ? supplier.getName() : Words.NO_SUPPLIER;
                        validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ENSURE_SUPPLIER_CONDITION_VARIANCE_START_NOT_AFTER_END, (Object[])new Object[]{sup, period.toString()})));
                    }
                    if (latestEnd != -1L && ++latestEnd != period.getStartDate().getTime()) {
                        validityValidation = true;
                        validityValidationReferenceDate = new Date(period.getStartDate().getTime());
                    }
                    latestEnd = period.getEndDate().getTime();
                    String artNo = (String)supplierLEVEL_3.getChildNamed(SupplierConditionComplete_.articleNumber).getValue();
                    Integer deliveryTime = (Integer)supplierLEVEL_3.getChildNamed(SupplierConditionComplete_.deliveryTime).getValue();
                    if (artNo == null || artNo.equals("")) {
                        fieldValidation = true;
                    }
                    if (interval == null) {
                        fieldValidation = true;
                    }
                    if (deliveryTime != null) continue;
                    fieldValidation = true;
                }
                supplierLEVEL_2.commitThis(SupplierConditionCategoryComplete.class);
            }
            supplierLEVEL_1.commitThis(SupplierConditionBaseComplete.class);
            if (validityValidation && validityValidationReferenceDate.after(endOfYear = DateUtil.getDate((int)((year = DateUtil.getYear((java.util.Date)new java.util.Date(System.currentTimeMillis()))) - 2), (int)12, (int)31))) {
                String sup = supplier != null ? supplier.getName() : Words.NO_SUPPLIER;
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ENSURE_SUPPLIER_CONDITION_VARIANCE, (Object[])new Object[]{sup, validityValidationReferenceDate})));
            }
            if (fieldValidation) {
                String sup = supplier != null ? supplier.getName() : Words.NO_SUPPLIER;
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ENSURE_SUPPLIER_CONDITION_ALL_FIELDS_ARE_SET, (Object[])new Object[]{sup})));
            }
            if (!categoryUniquenessValidation) continue;
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_SUPPLIER_CATEGORY_UNIQUENESS_OF_NAME_AND_TAX_ZONE));
        }
        if (hasNoSupplier) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Words.ENSURE_SUPPLIER_CONDITION_SUPPLIER_IS_SET, (Object[])new Object[0])));
        }
        return validationObjects;
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void valueChanged(Node<?> node) {
        if (node.getName().equals(BasicArticleComplete_.priceUnit.getFieldName())) {
            long currentId = System.currentTimeMillis();
            Iterator it = this.editor.getModel().getNode().getChildNamed(BasicArticleComplete_.suppliers).getChilds();
            while (it.hasNext()) {
                Node s = (Node)it.next();
                Iterator it2 = s.getChildNamed(SupplierConditionBaseComplete_.supplierConditionCategory).getFailSafeChildIterator();
                while (it2.hasNext()) {
                    Node c = (Node)it2.next();
                    Iterator it3 = c.getChildNamed(SupplierConditionCategoryComplete_.conditions).getFailSafeChildIterator();
                    while (it3.hasNext()) {
                        Node conditionNode = (Node)it3.next();
                        Node n = conditionNode.getChildNamed(SupplierConditionComplete_.orderUnit);
                        if (!(n instanceof Node)) continue;
                        n.setValue(node.getValue(), currentId);
                    }
                }
            }
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.table.kill();
        this.table = null;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.table.setEnabled(isEnabled);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.table);
        return focusList;
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    public boolean isSwingOnly() {
        return true;
    }

    public SupplierConditionDetailsPanel getConditionPanel() {
        return this.table.getConditionPanel();
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        ArrayList<RemoteCommitter> commitList = new ArrayList<RemoteCommitter>();
        Iterator it = this.editor.getModel().getNode().getChildNamed(BasicArticleComplete_.suppliers).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node supplierConditionBase = (Node)it.next();
            Iterator it2 = supplierConditionBase.getChildNamed(SupplierConditionBaseComplete_.specifications).getFailSafeChildIterator();
            while (it2.hasNext()) {
                Node supplierConditionSpecification = (Node)it2.next();
                Node imageNode = supplierConditionSpecification.getChildNamed(SupplierConditionSpecificationComplete_.specFile);
                PegasusFileComplete imageFile = (PegasusFileComplete)imageNode.getValue(PegasusFileComplete.class);
                if (imageFile == null || imageFile.getLocalFile() == null) continue;
                FileCommitter committer = new FileCommitter(imageFile.getLocalFile());
                committer.setWriteBackAlgorithm(reference -> {
                    imageNode.setValue((Object)reference, 0L);
                    ((SupplierConditionSpecificationComplete)supplierConditionSpecification.getValue()).setSpecFile(reference);
                });
                commitList.add(committer);
            }
        }
        return commitList;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            SupplierDetailsPanel.this.table.setLocation(0, 0);
            SupplierDetailsPanel.this.table.setSize(parent.getWidth(), parent.getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = (int)SupplierDetailsPanel.this.table.getPreferredSize().getHeight();
            if (h < 250) {
                h = 250;
            }
            return new Dimension(0, h);
        }
    }
}

