/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.article.details.rows;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.IntegerPlusPlusConverter;
import ch.icit.pegasus.client.converter.StoreConditionTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.article.details.StoresDetailsPanel;
import ch.icit.pegasus.client.gui.table2.SortableTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBox;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.supply.StoreConditionComplete_;
import ch.icit.pegasus.server.core.dtos.supply.StoreConditionTypeE;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class StoresDetailsTableRowImpl
extends SortableTable2RowPanel {
    private static final long serialVersionUID = 1L;
    private TextLabel sequenceLabel;
    private StorePositionSearchBox storeCB;
    private InfoButton infoButton;
    private ComboBox typeCombo;
    private ComboBox department;

    public StoresDetailsTableRowImpl(Table2RowModel model, StoresDetailsPanel panel, RDProvider provider, boolean isOrder, boolean isDelete) {
        super(model, isOrder, isDelete);
        this.setSortAttributeName(StoreConditionComplete_.preference);
        this.setStartEndOffset(0, 1);
        this.setSelectable(false);
        Converter intConverter = ConverterRegistry.getConverter(IntegerPlusPlusConverter.class);
        this.sequenceLabel = new TextLabel(model.getNode().getChildNamed(StoreConditionComplete_.preference), intConverter);
        this.typeCombo = new ComboBox(model.getNode().getChildNamed(StoreConditionComplete_.type), NodeToolkit.getAffixList(StoreConditionTypeE.class), ConverterRegistry.getConverter(StoreConditionTypeConverter.class), false);
        this.storeCB = new StorePositionSearchBox();
        this.storeCB.setNode((Node<StorePositionLight>)model.getNode().getChildNamed(StoreConditionComplete_.position));
        this.department = new ComboBox(model.getNode().getChildNamed(StoreConditionComplete_.department), ComboBoxFactory.filterDepartments((Node<List<InternalCostCenterComplete>>)NodeToolkit.getAffixList(InternalCostCenterComplete.class), null, ComboBoxFactory.DepartmentType.ALL), ConverterRegistry.getConverter(CostCenterConverter.class), true);
        this.department.addItemListener(e -> this.updateInfoButton());
        this.infoButton = new InfoButton();
        this.sequenceLabel.setProgress(1.0f);
        this.storeCB.setProgress(1.0f);
        this.department.setProgress(1.0f);
        this.setLayout(new Layout());
        this.updateInfoButton();
        this.add(this.sequenceLabel);
        this.add(this.typeCombo);
        this.add(this.storeCB);
        this.add(this.department);
        this.add(this.infoButton);
    }

    private void updateInfoButton() {
        StoreConditionTypeE storeConditionType = (StoreConditionTypeE)this.model.getNode().getChildNamed(StoreConditionComplete_.type).getValue();
        StringBuffer buffer = new StringBuffer();
        buffer.append("<b>");
        switch (storeConditionType) {
            case PURCHASE_CHECKIN: {
                buffer.append("Purchase Checkin Store</b><br/>");
                buffer.append("Store is used as default target store in Purchase Order Receive Module");
                break;
            }
            case REQUISITION_CHECKIN: {
                buffer.append("Requisition Checkin Store</b><br/>");
                buffer.append("Store is used as default target store in Requisition Order Module");
                break;
            }
            case FLIGHT_AUTOSTOCK: {
                buffer.append("Flight Auto Checkout Store</b><br/>");
                buffer.append("Store is used as default checkout store in for Flight Checkouts");
                break;
            }
            case RETURNS_COUNT_CHECKIN: {
                buffer.append("Flight Returns Count</b><br/>");
                buffer.append("Store is used as default checkin store in for Flight Checkins");
                break;
            }
            case WASTE_CHECKIN: {
                buffer.append("Flight Waste Store</b><br/>");
                buffer.append("Store is used as waste store for Flight");
                break;
            }
            case REQUISITION_DELIVER: {
                buffer.append("Requisition Deliver Store</b><br/>");
                buffer.append("Store is used as default store in Requisition Order Deliver");
                break;
            }
            case PURCHASE_CHECKIN_REDIRECT: {
                buffer.append("Purchase Order Redirect Store</b><br/>");
                buffer.append("Default Redirect Store for Purchase Order <br/><br/>");
                buffer.append("<b>Example</b><br/>");
                buffer.append("Redirect Store is L30, Purchase Order Receive to L11 => CATIT creates Purchase Receive Transaction to L30 and the a internal Movement Transaction to L11");
            }
        }
        this.infoButton.installStringViewer(buffer.toString());
    }

    public boolean isStoreSelected() {
        boolean validity;
        boolean bl = validity = this.storeCB.getNode().getValue() != null;
        if (!validity) {
            this.storeCB.setInValid();
        }
        return validity;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.storeCB.requestFocusInWindowNow();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.sequenceLabel.kill();
        this.storeCB.kill();
        this.department.kill();
        this.infoButton.kill();
        this.sequenceLabel = null;
        this.storeCB = null;
        this.department = null;
        this.infoButton = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.sequenceLabel.setEnabled(isEnabled);
        this.storeCB.setEnabled(isEnabled);
        this.department.setEnabled(isEnabled);
        this.infoButton.setEnabled(isEnabled);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.storeCB);
        CheckedListAdder.addToList(focusList, this.infoButton);
        CheckedListAdder.addToList(focusList, this.department);
        focusList.addAll(super.getFocusComponents());
        return focusList;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int currentX = 0;
            int w = StoresDetailsTableRowImpl.this.model.getParentModel().getColumnWidth(0);
            StoresDetailsTableRowImpl.this.sequenceLabel.setLocation(StoresDetailsTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - StoresDetailsTableRowImpl.this.sequenceLabel.getPreferredSize().getHeight()) / 2.0));
            StoresDetailsTableRowImpl.this.sequenceLabel.setSize(w - 2 * StoresDetailsTableRowImpl.this.getCellPadding(), (int)StoresDetailsTableRowImpl.this.sequenceLabel.getPreferredSize().getHeight());
            currentX += w;
            w = StoresDetailsTableRowImpl.this.model.getParentModel().getColumnWidth(1);
            StoresDetailsTableRowImpl.this.storeCB.setLocation(currentX + StoresDetailsTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - StoresDetailsTableRowImpl.this.storeCB.getPreferredSize().getHeight()) / 2.0));
            StoresDetailsTableRowImpl.this.storeCB.setSize((int)((double)w - ((double)(2 * StoresDetailsTableRowImpl.this.getCellPadding() + StoresDetailsTableRowImpl.this.getInnerCellPadding()) + StoresDetailsTableRowImpl.this.infoButton.getPreferredSize().getWidth())), (int)StoresDetailsTableRowImpl.this.storeCB.getPreferredSize().getHeight());
            StoresDetailsTableRowImpl.this.infoButton.setLocation(StoresDetailsTableRowImpl.this.storeCB.getX() + StoresDetailsTableRowImpl.this.storeCB.getWidth() + StoresDetailsTableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - StoresDetailsTableRowImpl.this.infoButton.getPreferredSize().getHeight()) / 2.0));
            StoresDetailsTableRowImpl.this.infoButton.setSize(StoresDetailsTableRowImpl.this.infoButton.getPreferredSize());
            currentX += w;
            w = StoresDetailsTableRowImpl.this.model.getParentModel().getColumnWidth(2);
            StoresDetailsTableRowImpl.this.typeCombo.setLocation(currentX + StoresDetailsTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - StoresDetailsTableRowImpl.this.typeCombo.getPreferredSize().getHeight()) / 2.0));
            StoresDetailsTableRowImpl.this.typeCombo.setSize(w - 2 * StoresDetailsTableRowImpl.this.getCellPadding(), (int)StoresDetailsTableRowImpl.this.typeCombo.getPreferredSize().getHeight());
            currentX += w;
            w = StoresDetailsTableRowImpl.this.model.getParentModel().getColumnWidth(3);
            StoresDetailsTableRowImpl.this.department.setLocation(currentX + StoresDetailsTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - StoresDetailsTableRowImpl.this.department.getPreferredSize().getHeight()) / 2.0));
            StoresDetailsTableRowImpl.this.department.setSize(w - 2 * StoresDetailsTableRowImpl.this.getCellPadding(), (int)StoresDetailsTableRowImpl.this.department.getPreferredSize().getHeight());
            StoresDetailsTableRowImpl.this.setControlsX(currentX += w);
            w = StoresDetailsTableRowImpl.this.model.getParentModel().getColumnWidth(4);
            StoresDetailsTableRowImpl.this.layoutSortButtons(currentX, parent.getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            StoresDetailsTableRowImpl p = (StoresDetailsTableRowImpl)parent;
            return new Dimension(0, p.getDefaultRowHeight());
        }
    }
}

