/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.article.details.utils;

import ch.icit.pegasus.client.converter.ArticleHalalStateConverter;
import ch.icit.pegasus.client.converter.HalalCertificationTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.HalalCertificationTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.supply.ArticleHalalCertificationComplete;
import ch.icit.pegasus.server.core.dtos.supply.ArticleHalalCertificationComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ArticleHalalCertificationTable
extends Table2 {
    private static final long serialVersionUID = 1L;
    private RowEditor<BasicArticleComplete> article;

    public ArticleHalalCertificationTable(RDProvider provider, RowEditor<BasicArticleComplete> article) {
        super(true, Words.ADD, false, false);
        this.article = article;
        ArticleHalalCertificationTable table = this;
        table.setProvider(provider);
        table.setUseWriteAccessRight(true);
        table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                ArticleHalalCertificationTable.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                ArticleHalalCertificationComplete w = new ArticleHalalCertificationComplete();
                w.setValidity(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
                w.setClientOId(Long.valueOf(ADTO.getNextId()));
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)w, true, false);
                ArticleHalalCertificationTable.this.getModel().getNode().addChild(n, 0L);
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int dw = DateChooser.getPreferredWidth(this, false);
        columns.add(new TableColumnInfo(Words.FROM, dw += 2 * this.getCellPadding()));
        dw = DateChooser.getPreferredWidth(this, true);
        columns.add(new TableColumnInfo(Words.TO, dw += 2 * this.getCellPadding()));
        columns.add(new TableColumnInfo(Words.TYPE, 160, 160, 160));
        columns.add(new TableColumnInfo(Words.COMMENT, 60, 60, 60));
        columns.add(new TableColumnInfo(Words.STATE, 100, 100, 100));
        int tw = this.getCellPadding() * 2 + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.2);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.8);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        table.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    public List<ScreenValidationObject> validateRow() {
        ArrayList<ScreenValidationObject> validate = new ArrayList<ScreenValidationObject>();
        HashSet its = new HashSet();
        for (Table2RowPanel r : this.getRows()) {
            r.getModel().getNode().commitThis();
            ArticleHalalCertificationComplete articleHalalCertificationComplete = (ArticleHalalCertificationComplete)r.getModel().getNode().getValue();
        }
        return validate;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private RDDateChooser startDate;
        private RDDateChooser endDate;
        private RDComboBox halalCertificationTypeSearch;
        private RDTextField comment;
        private DeleteButton deleteButton;
        private RDComboBox state;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new RowLayout());
            this.halalCertificationTypeSearch = new RDComboBox(ArticleHalalCertificationTable.this.getProvider(), ConverterRegistry.getConverter(HalalCertificationTypeConverter.class));
            this.halalCertificationTypeSearch.setOverrideName(BasicArticleComplete_.halalCertifications);
            this.halalCertificationTypeSearch.refreshPossibleValues(NodeToolkit.getAffixList(HalalCertificationTypeComplete.class));
            this.halalCertificationTypeSearch.setNode(m.getNode().getChildNamed(ArticleHalalCertificationComplete_.halalCertificationType));
            this.state = new RDComboBox(ArticleHalalCertificationTable.this.getProvider(), ConverterRegistry.getConverter(ArticleHalalStateConverter.class));
            this.state.setOverrideName(BasicArticleComplete_.halalCertifications);
            this.state.refreshPossibleValues(StaticEnumServiceManager.getArticleHalalStates());
            this.state.setNode(m.getNode().getChildNamed(ArticleHalalCertificationComplete_.halalState));
            this.startDate = new RDDateChooser(ArticleHalalCertificationTable.this.getProvider());
            this.endDate = new RDDateChooser(ArticleHalalCertificationTable.this.getProvider());
            this.endDate.setCheckBoxEnabled();
            this.startDate.setOverrideName(BasicArticleComplete_.halalCertifications);
            this.endDate.setOverrideName(BasicArticleComplete_.halalCertifications);
            this.startDate.setNode(m.getNode().getChildNamed(new DtoField[]{ArticleHalalCertificationComplete_.validity, PeriodComplete_.startDate}));
            this.endDate.setNode(m.getNode().getChildNamed(new DtoField[]{ArticleHalalCertificationComplete_.validity, PeriodComplete_.endDate}));
            this.comment = new RDTextField(ArticleHalalCertificationTable.this.getProvider());
            this.comment.setOverrideName(BasicArticleComplete_.halalCertifications);
            this.comment.setNode(m.getNode().getChildNamed(ArticleHalalCertificationComplete_.comment));
            this.deleteButton = new DeleteButton();
            this.deleteButton.addButtonListener(this);
            this.add(this.halalCertificationTypeSearch);
            this.add(this.startDate);
            this.add(this.endDate);
            this.add(this.comment);
            this.add(this.state);
            this.add(this.deleteButton);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.startDate);
            CheckedListAdder.addToList(focusList, this.endDate);
            CheckedListAdder.addToList(focusList, this.halalCertificationTypeSearch);
            CheckedListAdder.addToList(focusList, this.comment);
            CheckedListAdder.addToList(focusList, this.state);
            CheckedListAdder.addToList(focusList, this.deleteButton);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            boolean editable = ArticleHalalCertificationTable.this.getProvider().isWritable(BasicArticleComplete_.halalCertifications);
            this.comment.setEnabled(isEnabled);
            this.halalCertificationTypeSearch.setEnabled(isEnabled);
            this.startDate.setEnabled(isEnabled);
            this.endDate.setEnabled(isEnabled);
            this.state.setEnabled(isEnabled);
            this.deleteButton.setEnabled(editable && isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.comment.kill();
            this.halalCertificationTypeSearch.kill();
            this.startDate.kill();
            this.endDate.kill();
            this.deleteButton.kill();
            this.state.kill();
            this.comment = null;
            this.halalCertificationTypeSearch = null;
            this.startDate = null;
            this.endDate = null;
            this.deleteButton = null;
            this.state = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.deleteButton) {
                this.getModel().getNode().getParent().removeChild(this.getModel().getNode(), 0L);
            }
        }

        private class RowLayout
        extends DefaultLayout {
            private RowLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.startDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.startDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.startDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.startDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.endDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.endDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.endDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.endDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.halalCertificationTypeSearch.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.halalCertificationTypeSearch.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.halalCertificationTypeSearch.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.halalCertificationTypeSearch.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.comment.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.comment.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.comment.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.comment.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.state.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.state.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.state.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.state.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.deleteButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.deleteButton.setSize(TableRowImpl.this.deleteButton.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container arg0) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }
}

