/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.article.details.utils;

import ch.icit.pegasus.client.converter.IntegerPlusPlusConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.article.details.utils.ArticleStepPriceConverter;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceCalculationComplete_;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceFunctionComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceFunctionComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityBaseComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ArticleStepPriceEditor
extends PopUpInsert {
    private static final long serialVersionUID = 1L;
    private Table2 table;
    private Node currentArticle;
    private Node currentSupplier;

    public ArticleStepPriceEditor(Node<StepPriceCalculationComplete> node, Node currentArticle, Node currentSupplier) {
        this.currentArticle = currentArticle;
        this.currentSupplier = currentSupplier.getChildNamed(SupplierConditionComplete_.supplier);
        this.table = new Table2(true, Words.TABLE_ADD, false, false);
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                if (ArticleStepPriceEditor.this.currentSupplier == null) {
                    return;
                }
                StepPriceFunctionComplete f = new StepPriceFunctionComplete();
                f.setClientOId(Long.valueOf(ADTO.getNextId()));
                if (ArticleStepPriceEditor.this.table != null) {
                    f.setSequenceNumber(Integer.valueOf(ArticleStepPriceEditor.this.table.getRowCount()));
                } else {
                    f.setSequenceNumber(Integer.valueOf(0));
                }
                f.setPrice(new PriceComplete((CurrencyComplete)ArticleStepPriceEditor.this.currentSupplier.getChildNamed(SupplierLight_.paymentCurrency).getValue(), Double.valueOf(0.0)));
                f.setUpperLimit(new QuantityComplete(Double.valueOf(0.0), (UnitComplete)ArticleStepPriceEditor.this.currentArticle.getChildNamed(BasicArticleLight_.priceUnit).getValue()));
                ArticleStepPriceEditor.this.table.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)f, true, false), 0L);
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int tw1 = 2 * this.table.getCellPadding() + InputComboBox2.getPreferredWidth(this, 11);
        columns.add(new TableColumnInfo(Words.NO_NUMBER, null, null, null, "", TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth));
        columns.add(new TableColumnInfo(Words.FROM, null, null, null, "", tw1, tw1, tw1));
        columns.add(new TableColumnInfo(Words.TO, null, null, null, "", tw1, tw1, tw1));
        columns.add(new TableColumnInfo(Words.PRICE, null, null, null, "", tw1, tw1, tw1));
        int tw = 2 * this.table.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.table.getModel().setNode(node.getChildNamed(StepPriceCalculationComplete_.steps));
        this.setLayout(new Layout());
        this.add(this.table);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.table.kill();
        this.table = null;
    }

    @Override
    public boolean validateContent() {
        return true;
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.table.getFocusComponents();
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return this.table.isInnerComponent(c);
    }

    private Node createUnits() {
        ArrayList<Node<UnitComplete>> prodList = new ArrayList<Node<UnitComplete>>();
        Node article = this.currentArticle;
        if (article.getValue() != null) {
            Iterator it = article.getChildNamed(BasicArticleComplete_.packingQuantitiesVariants).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node pax = (Node)it.next();
                Iterator it2 = pax.getChildNamed(PackagingQuantityBaseComplete_.packingQuantities).getFailSafeChildIterator();
                while (it2.hasNext()) {
                    Node pak = (Node)it2.next();
                    Node unit = pak.getChildNamed(PackagingQuantityComplete_.unit);
                    List<Node<UnitComplete>> list = UnitToolkit.generateUnitView((Node<UnitComplete>)unit, null, null, true);
                    prodList.addAll(list);
                }
            }
        }
        ViewNode n = new ViewNode("ProdUnits");
        n.addChildren(prodList);
        return n;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel no;
        private TextLabel from;
        private InputComboBox to;
        private InputComboBox price;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.no = new TextLabel(m.getNode().getChildNamed(StepPriceFunctionComplete_.sequenceNumber), ConverterRegistry.getConverter(IntegerPlusPlusConverter.class));
            this.from = new TextLabel(this.getLastNode(), ConverterRegistry.getConverter(ArticleStepPriceConverter.class));
            this.to = new InputComboBox(m.getNode().getChildNamed(new DtoField[]{StepPriceFunctionComplete_.upperLimit, QuantityComplete_.quantity}), m.getNode().getChildNamed(new DtoField[]{StepPriceFunctionComplete_.upperLimit, QuantityComplete_.unit}), InputComboBox.InputComboBoxType.PRICE_DOUBLE);
            this.price = new InputComboBox(m.getNode().getChildNamed(new DtoField[]{StepPriceFunctionComplete_.price, PriceComplete_.price}), m.getNode().getChildNamed(new DtoField[]{StepPriceFunctionComplete_.price, PriceComplete_.currency}), InputComboBox.InputComboBoxType.PRICE_DOUBLE);
            this.to.setPossibleUnits(ArticleStepPriceEditor.this.createUnits());
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.no);
            this.add(this.from);
            this.add(this.to);
            this.add(this.price);
            this.add(this.delete);
        }

        private Node getLastNode() {
            int i = (Integer)this.model.getNode().getChildNamed(StepPriceFunctionComplete_.sequenceNumber).getValue();
            if (i > 0) {
                Iterator it = this.model.getNode().getParent().getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    if ((Integer)n.getChildNamed(StepPriceFunctionComplete_.sequenceNumber).getValue() != i - 1) continue;
                    return n.getChildNamed(StepPriceFunctionComplete_.upperLimit);
                }
            } else {
                return null;
            }
            return null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            a.addAll(this.to.getFocusComponents());
            a.addAll(this.price.getFocusComponents());
            a.addAll(this.delete.getFocusComponents());
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.no.setEnabled(isEnabled);
            this.from.setEnabled(isEnabled);
            this.to.setEnabled(isEnabled);
            this.price.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.no.kill();
            this.from.kill();
            this.to.kill();
            this.price.kill();
            this.delete.kill();
            this.no = null;
            this.from = null;
            this.to = null;
            this.price = null;
            this.delete = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.no.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.no.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.no.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.no.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.from.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.from.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.from.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.from.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.to.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.to.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.to.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.to.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.price.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.price.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.price.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.price.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(350, 300);
        }

        @Override
        public void layoutContainer(Container parent) {
            ArticleStepPriceEditor.this.table.setLocation(0, 0);
            ArticleStepPriceEditor.this.table.setSize(parent.getSize());
        }
    }
}

