/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.article.details.utils;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReturnsRateComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class CustomerReturnsRateTable
extends Table2 {
    private static final long serialVersionUID = 1L;
    private Node<BasicArticleComplete> articleNode;

    public CustomerReturnsRateTable(RDProvider provider, ListNode<List<BasicArticleReturnsRateComplete>, BasicArticleReturnsRateComplete> node, Node<BasicArticleComplete> articleNode) {
        super(true, Words.TABLE_ADD);
        this.articleNode = articleNode;
        this.setProvider(provider);
        this.setOverrideName(BasicArticleComplete_.useArticleReturnsRate);
        this.setUseWriteAccessRight(true);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                CustomerReturnsRateTable.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                BasicArticleReturnsRateComplete w = new BasicArticleReturnsRateComplete();
                w.setClientOId(Long.valueOf(ADTO.getNextId()));
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)w, true, false);
                CustomerReturnsRateTable.this.getModel().getNode().addChild(n, 0L);
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.CUSTOMER, 120, 120, 120));
        columns.add(new TableColumnInfo(Words.RETURNS_PERCENT + " [%]", 80, 80, 80));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
        this.model.setNode((Node)node);
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    SearchTextField2Listener {
        private static final long serialVersionUID = 1L;
        private RDSearchComboBox customer;
        private RDTextField returnsRate;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.setLayout(new RowLayout());
            this.customer = new RDSearchComboBox(CustomerReturnsRateTable.this.getProvider(), RDSearchComboBox.BoxSearchTypes.CUSTOMER);
            this.customer.addSearchTextFieldListener(this);
            this.returnsRate = new RDTextField(CustomerReturnsRateTable.this.getProvider(), TextFieldType.DOUBLE);
            this.delete = new DeleteButton();
            this.customer.setOverrideName(BasicArticleComplete_.useArticleReturnsRate);
            this.returnsRate.setOverrideName(BasicArticleComplete_.useArticleReturnsRate);
            this.customer.setNode(m.getNode().getChildNamed(BasicArticleComplete_.customer));
            this.returnsRate.setNode(m.getNode().getChildNamed(BasicArticleComplete_.returnsRate));
            this.delete.addButtonListener(this);
            this.add(this.customer);
            this.add(this.returnsRate);
            this.add(this.delete);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.customer);
            CheckedListAdder.addToList(a, this.returnsRate);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    if (this.customer.getNode().getValue() != null) {
                        return ((CustomerLight)this.customer.getNode().getValue()).getNumber();
                    }
                    return 0;
                }
                case 1: {
                    return this.returnsRate.getText();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.customer.setEnabled(isEnabled);
            boolean selected = this.customer.isItemSelected();
            this.returnsRate.setEnabled(isEnabled && selected);
            this.delete.setEnabled(isEnabled && CustomerReturnsRateTable.this.isWritable());
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.customer.kill();
            this.customer = null;
            this.returnsRate.kill();
            this.returnsRate = null;
            this.delete.kill();
            this.delete = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            }
        }

        @Override
        public void newValueSelected(SearchTextField2 source, Node<?> n) throws ClientServerCallException {
            this.setEnabled(this.isEnabled());
        }

        private class RowLayout
        extends DefaultLayout {
            private RowLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                TableRowImpl.this.customer.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.customer.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.customer.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.customer.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                TableRowImpl.this.returnsRate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.returnsRate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.returnsRate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.returnsRate.getPreferredSize().getHeight());
                TableRowImpl.this.setControlsX(currentX += w);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

