/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.article.details.utils;

import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDInputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionLight;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.InventoryTransitionCommentComplete;
import ch.icit.pegasus.server.core.dtos.supply.InventoryTransitionCommentComplete_;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class InventoryTransitionCommentTable
extends Table2 {
    private static final long serialVersionUID = 1L;
    private UnitComplete defaultUnit;
    private RowEditor<BasicArticleComplete> article;

    public InventoryTransitionCommentTable(RDProvider provider, RowEditor<BasicArticleComplete> article) {
        super(true, Words.ADD, true, true, Words.INVENTORY_TRANSITION_COMMENTS);
        this.article = article;
        this.defaultUnit = ((BasicArticleLight)this.article.getModel().getNode().getValue()).getFloatStoreUnit();
        InventoryTransitionCommentTable table = this;
        table.setProvider(provider);
        table.setUseWriteAccessRight(true);
        table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                InventoryTransitionCommentTable.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                InventoryTransitionCommentComplete comment = new InventoryTransitionCommentComplete();
                comment.setComment("");
                comment.setClientOId(Long.valueOf(ADTO.getNextId()));
                comment.setRemainingDifference(new QuantityComplete(Double.valueOf(0.0), InventoryTransitionCommentTable.this.defaultUnit));
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)comment, true, false);
                InventoryTransitionCommentTable.this.getModel().getNode().addChild(n, 0L);
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.COMMENT, 120, Integer.MAX_VALUE, 120));
        columns.add(new TableColumnInfo(Words.INVENTORY_TRANSITION, 120, 120, 120));
        int tw = this.getCellPadding() * 2 + InputComboBox.getPreferredWidth(this, InputComboBox.InputComboBoxType.PRICE_DOUBLE);
        columns.add(new TableColumnInfo(Words.REMAINING_DIFFERENCE, tw, tw, tw));
        tw = this.getCellPadding() * 2 + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        table.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    public List<ScreenValidationObject> validateRow() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        HashSet<InventoryTransitionLight> its = new HashSet<InventoryTransitionLight>();
        for (Table2RowPanel r : this.getRows()) {
            r.getModel().getNode().commitThis();
            InventoryTransitionCommentComplete c = (InventoryTransitionCommentComplete)r.getModel().getNode().getValue();
            if (c.getInventoryTransition() == null) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_A_INVENTORY_TRANSITION_IS_SET));
                continue;
            }
            if (its.add(c.getInventoryTransition())) continue;
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ONLY_ONE_COMMENT_FOR_A_TRANSITION_IS_ALLOWED, (Object[])new Object[]{c.getInventoryTransition().getNumber()})));
        }
        return a;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private RDTextField comment;
        private RDSearchTextField2<InventoryTransitionLight> inventorySearch;
        private RDInputComboBox quantity;
        private DeleteButton deleteButton;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new RowLayout());
            this.comment = new RDTextField(InventoryTransitionCommentTable.this.getProvider());
            this.comment.setOverrideName(BasicArticleComplete_.inventoryComments);
            this.comment.setNode(m.getNode().getChildNamed(InventoryTransitionCommentComplete_.comment));
            this.inventorySearch = new RDSearchTextField2(InventoryTransitionCommentTable.this.getProvider(), RDSearchTextField2.SearchTypes.INVENTORY_TRANSITION);
            this.inventorySearch.setOverrideName(BasicArticleComplete_.inventoryComments);
            this.inventorySearch.setNode(m.getNode().getChildNamed(InventoryTransitionCommentComplete_.inventoryTransition));
            this.quantity = new RDInputComboBox(InventoryTransitionCommentTable.this.getProvider(), InputComboBox.InputComboBoxType.PRICE_DOUBLE);
            this.quantity.setOverrideName(BasicArticleComplete_.inventoryComments);
            this.quantity.setNode(m.getNode().getChildNamed(InventoryTransitionCommentComplete_.remainingDifference));
            this.deleteButton = new DeleteButton();
            this.deleteButton.addButtonListener(this);
            this.add(this.comment);
            this.add(this.inventorySearch);
            this.add(this.quantity);
            this.add(this.deleteButton);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.comment);
            CheckedListAdder.addToList(a, this.inventorySearch);
            CheckedListAdder.addToList(a, this.quantity);
            CheckedListAdder.addToList(a, this.deleteButton);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.comment.setEnabled(isEnabled);
            this.inventorySearch.setEnabled(isEnabled);
            this.quantity.setEnabled(isEnabled);
            this.deleteButton.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.comment.kill();
            this.inventorySearch.kill();
            this.quantity.kill();
            this.deleteButton.kill();
            this.comment = null;
            this.inventorySearch = null;
            this.quantity = null;
            this.deleteButton = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.deleteButton) {
                this.getModel().getNode().getParent().removeChild(this.getModel().getNode(), 0L);
            }
        }

        private class RowLayout
        extends DefaultLayout {
            private RowLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.comment.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.comment.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.comment.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.comment.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.inventorySearch.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.inventorySearch.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.inventorySearch.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.inventorySearch.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.quantity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.quantity.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.quantity.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.quantity.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.deleteButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.deleteButton.setSize(TableRowImpl.this.deleteButton.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container arg0) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }
}

