/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.article.details.utils;

import ch.icit.pegasus.client.gui.modules.article.details.CostCalculationDetailsPanel;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowSelectionListener;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.VerticalSeparator;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.tables.MaterialCostPeriodTable;
import ch.icit.pegasus.client.gui.utils.tables.MaterialCostPeriodTenderTable;
import ch.icit.pegasus.client.gui.utils.tables.MaterialCostTable;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.MaterialCostFactorVariantComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class MaterialCostVariantPanel
extends DefaultPanel
implements Nodable,
Table2RowSelectionListener {
    private static final long serialVersionUID = 1L;
    private MaterialCostPeriodTable variantTable;
    private MaterialCostTable matCostTable;
    private VerticalSeparator sep;
    private Node<BasicArticleComplete> articleNode;
    private boolean tender;
    private RDProvider provider;
    private boolean canAddVariant;
    private boolean canAddFactor;

    public MaterialCostVariantPanel(JComponent parentComponent, RDProvider provider, CostCalculationDetailsPanel costPanel, boolean isTender) {
        this.provider = provider;
        this.variantTable = isTender ? new MaterialCostPeriodTenderTable(parentComponent, provider) : new MaterialCostPeriodTable(parentComponent, provider);
        this.matCostTable = new MaterialCostTable(parentComponent, provider, costPanel, isTender);
        this.variantTable.getModel().addTableSelectionListener(this);
        this.sep = new VerticalSeparator();
        this.setTender(isTender, costPanel != null && costPanel.getEditor().getModel().isAddRow());
        this.setLayout(new Layout());
        this.setProgress(1.0f);
        this.getFader().setPermanent(true);
        this.add(this.variantTable);
        this.add(this.sep);
        this.add(this.matCostTable);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.variantTable != null) {
            this.variantTable.setEnabled(isEnabled);
        }
        if (this.matCostTable != null) {
            this.matCostTable.setEnabled(isEnabled);
        }
    }

    public void setTender(boolean tender, boolean isNewArticle) {
        this.tender = tender;
        if (!this.tender) {
            this.canAddVariant = this.provider.isWritable(BasicArticleLight_.materialCostFactorVariants.getFieldName() + "-addvariant") || isNewArticle;
            this.canAddFactor = this.provider.isWritable(BasicArticleLight_.materialCostFactorVariants.getFieldName() + "-addfactor") || isNewArticle;
        } else {
            this.canAddVariant = this.provider.isWritable(BasicArticleLight_.materialCostFactorTenderVariants.getFieldName() + "-addvariant") || isNewArticle;
            this.canAddFactor = this.provider.isWritable(BasicArticleLight_.materialCostFactorTenderVariants.getFieldName() + "-addfactor") || isNewArticle;
        }
        this.variantTable.setHasAddButton(this.canAddVariant || isNewArticle);
        this.matCostTable.setHasAddButton(this.canAddFactor || isNewArticle);
        this.variantTable.setTender(tender, isNewArticle);
        this.matCostTable.setTender(tender, isNewArticle);
        this.variantTable.ensureAddButton(Words.ADD, true);
        this.matCostTable.ensureAddButton(Words.ADD, true);
    }

    public MaterialCostPeriodTable getTable() {
        return this.variantTable;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.variantTable);
        CheckedListAdder.addToList(a, this.matCostTable);
        return a;
    }

    public MaterialCostPeriodTable getVariantTable() {
        return this.variantTable;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.variantTable.setVisibleContainer(pane);
        this.matCostTable.setVisibleContainer(pane);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.variantTable.kill();
        this.matCostTable.kill();
        this.sep.kill();
        this.variantTable = null;
        this.matCostTable = null;
        this.sep = null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.variantTable.requestFocusInWindowNow();
    }

    @Override
    public Node<?> getNode() {
        return this.articleNode;
    }

    @Override
    public void setNode(Node<?> node) {
        this.articleNode = node;
        this.matCostTable.getModel().setNode(null);
        this.variantTable.getModel().setNode(node);
    }

    @Override
    public void tableRowSelected(Table2 sourceTable, Table2RowPanel panel) {
        if (panel == null) {
            this.matCostTable.getModel().setNode(null);
        } else if (panel.getModel().getParentModel().getTable() == this.variantTable) {
            this.matCostTable.getModel().setNode(panel.getModel().getNode().getChildNamed(MaterialCostFactorVariantComplete_.materialCostFactors));
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 200);
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = TitledPeriodEditor.getPreferredWidth(parent);
            w += MaterialCostVariantPanel.this.variantTable.getCellPadding() * 2;
            w += DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
            w += MaterialCostVariantPanel.this.variantTable.getCellPadding() * 2;
            MaterialCostVariantPanel.this.variantTable.setLocation(0, 0);
            MaterialCostVariantPanel.this.variantTable.setSize(w += CheckBox.getPreferredWidth() + 2 * MaterialCostVariantPanel.this.variantTable.getCellPadding(), parent.getHeight());
            MaterialCostVariantPanel.this.sep.setLocation(MaterialCostVariantPanel.this.variantTable.getWidth(), 0);
            MaterialCostVariantPanel.this.sep.setSize((int)MaterialCostVariantPanel.this.sep.getPreferredSize().getWidth(), parent.getHeight());
            MaterialCostVariantPanel.this.matCostTable.setLocation(MaterialCostVariantPanel.this.sep.getX() + MaterialCostVariantPanel.this.sep.getWidth(), 0);
            MaterialCostVariantPanel.this.matCostTable.setSize(parent.getWidth() - MaterialCostVariantPanel.this.matCostTable.getX(), parent.getHeight());
        }
    }
}

