/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.article.solar;

import ch.icit.pegasus.client.gui.modules.article.details.SupplierConditionDetailsPanel;
import ch.icit.pegasus.client.gui.modules.article.details.SupplierDetailsPanel;
import ch.icit.pegasus.client.gui.modules.article.details.utils.ISpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.combobox.TitledCategoryChooser;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.panels.ArticlePackagingTable;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDImageChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTitledCategoryChooser;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitSystemComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityBaseComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolarSpecificationDetailsPanel
extends DefaultDetailsPanel<BasicArticleLight>
implements ItemListener,
ArticlePackagingTable.ArticlePackagingTableListener,
ISpecificationDetailsPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(SolarSpecificationDetailsPanel.class);
    private TitledItem<TextLabel> number;
    private TitledItem<RDTextField> name;
    private TitledItem<RDTextField> orderName;
    private TitledItem<RDTextField> eanCode;
    private TitledItem<RDCheckBox> inUse;
    private RDTitledCategoryChooser catChooser;
    private final Node storeUnitSelectionNode = new ViewNode("");
    private SupplierConditionDetailsPanel supplierConditionPanel;
    private TitledItem<RDImageChooser> mainStoreUnitImageChooser;
    private TitledItem<RDImageChooser> floatStoreUnitImageChooser;
    private TitledItem<RDImageChooser> productionUnitImageChooser;
    private Node<BasicArticleComplete> node;

    public SolarSpecificationDetailsPanel(RowEditor<BasicArticleLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.BASIC_DATA);
        this.number = new TitledItem<TextLabel>(new TextLabel(), WordsToolkit.toCapitalLetter((String)Words.NUMBER), TitledItem.TitledItemOrientation.NORTH);
        this.number.getElement().setReadOnlyTextField(true);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.NORMAL), WordsToolkit.toCapitalLetter((String)Words.NAME), TitledItem.TitledItemOrientation.NORTH);
        this.orderName = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.NORMAL), Words.ORDER_NAME, TitledItem.TitledItemOrientation.NORTH);
        this.eanCode = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.NORMAL), Words.EAN_CODE, TitledItem.TitledItemOrientation.NORTH);
        this.inUse = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.IN_USE, TitledItem.TitledItemOrientation.EAST);
        this.catChooser = new RDTitledCategoryChooser(provider, null, TitledCategoryChooser.getTypeForSettings(TitledCategoryChooser.CATEGORY_TYPE.ARTICLE));
        this.mainStoreUnitImageChooser = new TitledItem<RDImageChooser>(new RDImageChooser(provider), Words.MAIN_STORE_UNIT_IMAGE, TitledItem.TitledItemOrientation.NORTH);
        this.mainStoreUnitImageChooser.getFader().setProgress(1.0f);
        this.floatStoreUnitImageChooser = new TitledItem<RDImageChooser>(new RDImageChooser(provider), Words.FLOAT_STORE_UNIT_IMAGE, TitledItem.TitledItemOrientation.NORTH);
        this.floatStoreUnitImageChooser.getFader().setProgress(1.0f);
        this.productionUnitImageChooser = new TitledItem<RDImageChooser>(new RDImageChooser(provider), Words.PRODUCTION_UNIT_IMAGE, TitledItem.TitledItemOrientation.NORTH);
        this.productionUnitImageChooser.getFader().setProgress(1.0f);
        this.inUse.getElement().addButtonListener(this);
        this.setCustomLayouter(new Layout());
        this.addToView(this.number);
        this.addToView(this.name);
        this.addToView(this.orderName);
        this.addToView(this.eanCode);
        this.addToView(this.inUse);
        this.addToView(this.catChooser);
        this.addToView(this.mainStoreUnitImageChooser);
        this.addToView(this.floatStoreUnitImageChooser);
        this.addToView(this.productionUnitImageChooser);
    }

    @Override
    public void setNode(Node<?> node) {
        if (this.editor.getModel().isAddRow()) {
            BasicArticleLight dto = (BasicArticleLight)node.getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        this.node = node;
        this.number.getElement().setNode(node.getChildNamed(BasicArticleLight_.number));
        this.name.getElement().setNode(node.getChildNamed(BasicArticleLight_.name));
        this.orderName.getElement().setNode(node.getChildNamed(BasicArticleComplete_.orderName));
        this.eanCode.getElement().setNode(node.getChildNamed(BasicArticleComplete_.eanCode));
        Node category = this.node.getChildNamed(BasicArticleLight_.category);
        if (category.getChildNamed(ArticleCategoryComplete_.parent).getValue() == null) {
            while (category.getChildNamed(ArticleCategoryComplete_.subCategories) != null && !((List)category.getChildNamed(ArticleCategoryComplete_.subCategories).getValue()).isEmpty()) {
                category = category.getChildNamed(ArticleCategoryComplete_.subCategories).getChildAt(0);
            }
            this.node.getChildNamed(BasicArticleLight_.category).removeExistingValues();
            this.node.getChildNamed(BasicArticleLight_.category).setValue(category.getValue(), 0L);
        }
        this.inUse.getElement().setNode(node.getChildNamed(BasicArticleComplete_.isInUse));
        Node categoryNode = node.getChildNamed(BasicArticleLight_.category);
        this.catChooser.setPossibles(NodeToolkit.getAffixList(ArticleCategoryComplete.class));
        this.catChooser.setNode(categoryNode);
        this.mainStoreUnitImageChooser.getElement().setNode(node.getChildNamed(BasicArticleLight_.mainStoreUnitImage));
        this.floatStoreUnitImageChooser.getElement().setNode(node.getChildNamed(BasicArticleLight_.floatStoreUnitImage));
        this.productionUnitImageChooser.getElement().setNode(node.getChildNamed(BasicArticleLight_.productionUnitImage));
        this.invalidate();
        this.validate();
    }

    private ScreenValidationObject isStoreUnitSetAndInPackingTable() {
        UnitComplete storeUnit = (UnitComplete)this.editor.getModel().getNode().getChildNamed(BasicArticleLight_.priceUnit).getValue();
        if (storeUnit == null) {
            return new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_STORE_UNIT_IS_SET);
        }
        UnitSystemComplete storeUnitSystem = UnitToolkit.getUnitSystem4Unit(storeUnit);
        Iterator it = this.editor.getModel().getNode().getChildNamed(BasicArticleComplete_.packingQuantitiesVariants).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node pack = (Node)it.next();
            Iterator it2 = pack.getChildNamed(PackagingQuantityBaseComplete_.packingQuantities).getFailSafeChildIterator();
            while (it2.hasNext()) {
                Node conversion = (Node)it2.next();
                UnitComplete currentUnit = (UnitComplete)conversion.getChildNamed(PackagingQuantityComplete_.unit).getValue();
                UnitSystemComplete currentSystem = UnitToolkit.getUnitSystem4Unit(currentUnit);
                if (!currentSystem.equals((Object)storeUnitSystem)) continue;
                return null;
            }
        }
        return new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_STORE_UNIT_IS_IN_PACKAGING_TABLE);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        ScreenValidationObject storeUnitValidation = this.isStoreUnitSetAndInPackingTable();
        if (storeUnitValidation != null) {
            validationObjects.add(storeUnitValidation);
        }
        if (this.name.getElement().isWritable() && this.name.getElement().getText().equals("") || this.editor.getModel().getNode().getChildNamed(BasicArticleLight_.name).getValue().equals("")) {
            this.name.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_NAME_IS_SET));
        } else {
            this.name.getElement().setValid();
        }
        return validationObjects;
    }

    public void setSupplierPanel(SupplierDetailsPanel panel) {
        this.supplierConditionPanel = panel.getConditionPanel();
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        List<RemoteCommitter> c2;
        List<RemoteCommitter> c1;
        ArrayList<RemoteCommitter> committers = new ArrayList<RemoteCommitter>();
        List<RemoteCommitter> c = this.mainStoreUnitImageChooser.getElement().commitImage();
        if (c != null) {
            committers.addAll(c);
        }
        if ((c1 = this.floatStoreUnitImageChooser.getElement().commitImage()) != null) {
            committers.addAll(c1);
        }
        if ((c2 = this.productionUnitImageChooser.getElement().commitImage()) != null) {
            committers.addAll(c2);
        }
        if (committers.isEmpty()) {
            return null;
        }
        return committers;
    }

    private void propagateRelayout() {
        if (this.supplierConditionPanel != null) {
            this.supplierConditionPanel.invalidate();
            this.supplierConditionPanel.validate();
        }
    }

    @Override
    public boolean grabsFocus() {
        return !this.editor.getModel().isAddRow();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.number.setEnabled(isEnabled);
        this.name.setEnabled(isEnabled);
        this.orderName.setEnabled(isEnabled);
        this.eanCode.setEnabled(isEnabled);
        this.inUse.setEnabled(isEnabled);
        this.catChooser.setEnabled(isEnabled);
        this.mainStoreUnitImageChooser.setEnabled(isEnabled);
        this.floatStoreUnitImageChooser.setEnabled(isEnabled);
        this.productionUnitImageChooser.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.number.kill();
        this.name.kill();
        this.orderName.kill();
        this.eanCode.kill();
        this.inUse.kill();
        this.catChooser.kill();
        this.mainStoreUnitImageChooser.kill();
        this.floatStoreUnitImageChooser.kill();
        this.productionUnitImageChooser.kill();
        this.number = null;
        this.name = null;
        this.inUse = null;
        this.orderName = null;
        this.eanCode = null;
        this.catChooser = null;
        this.mainStoreUnitImageChooser = null;
        this.floatStoreUnitImageChooser = null;
        this.productionUnitImageChooser = null;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.orderName);
        CheckedListAdder.addToList(focusList, this.eanCode);
        CheckedListAdder.addToList(focusList, this.inUse);
        CheckedListAdder.addToList(focusList, this.catChooser);
        CheckedListAdder.addToList(focusList, this.mainStoreUnitImageChooser);
        CheckedListAdder.addToList(focusList, this.floatStoreUnitImageChooser);
        CheckedListAdder.addToList(focusList, this.productionUnitImageChooser);
        return focusList;
    }

    @Override
    public Node getUnitSelectionNode() {
        return this.storeUnitSelectionNode;
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
        this.mainStoreUnitImageChooser.getElement().addFocusCycleChangeListener(listener);
        this.floatStoreUnitImageChooser.getElement().addFocusCycleChangeListener(listener);
        this.productionUnitImageChooser.getElement().addFocusCycleChangeListener(listener);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.propagateRelayout();
    }

    @Override
    public void requestFocusInWindowNow() {
        this.name.requestFocusInWindowNow();
    }

    @Override
    public void tableChanged() {
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            SolarSpecificationDetailsPanel.this.number.setLocation(SolarSpecificationDetailsPanel.this.horizontalBorder, SolarSpecificationDetailsPanel.this.verticalBorder);
            int w = parent.getWidth() - (SolarSpecificationDetailsPanel.this.inner_horizontalBorder + 2 * SolarSpecificationDetailsPanel.this.horizontalBorder);
            SolarSpecificationDetailsPanel.this.number.setSize(w / 3, (int)SolarSpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            SolarSpecificationDetailsPanel.this.name.setLocation(SolarSpecificationDetailsPanel.this.horizontalBorder + w / 3 + SolarSpecificationDetailsPanel.this.horizontalBorder, SolarSpecificationDetailsPanel.this.verticalBorder);
            SolarSpecificationDetailsPanel.this.name.setSize(w / 3 * 2, (int)SolarSpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            SolarSpecificationDetailsPanel.this.orderName.setLocation(SolarSpecificationDetailsPanel.this.horizontalBorder, SolarSpecificationDetailsPanel.this.name.getY() + SolarSpecificationDetailsPanel.this.name.getHeight() + SolarSpecificationDetailsPanel.this.inner_verticalBorder);
            SolarSpecificationDetailsPanel.this.orderName.setSize(SolarSpecificationDetailsPanel.this.name.getWidth(), (int)SolarSpecificationDetailsPanel.this.orderName.getPreferredSize().getHeight());
            int cy = 0;
            cy = SolarSpecificationDetailsPanel.this.orderName.getY() + SolarSpecificationDetailsPanel.this.orderName.getHeight();
            SolarSpecificationDetailsPanel.this.eanCode.setLocation(SolarSpecificationDetailsPanel.this.horizontalBorder, cy + SolarSpecificationDetailsPanel.this.inner_verticalBorder);
            SolarSpecificationDetailsPanel.this.eanCode.setSize(SolarSpecificationDetailsPanel.this.name.getWidth(), (int)SolarSpecificationDetailsPanel.this.eanCode.getPreferredSize().getHeight());
            cy = SolarSpecificationDetailsPanel.this.eanCode.getY() + SolarSpecificationDetailsPanel.this.eanCode.getHeight();
            SolarSpecificationDetailsPanel.this.inUse.setLocation(SolarSpecificationDetailsPanel.this.horizontalBorder, cy + SolarSpecificationDetailsPanel.this.verticalBorder);
            SolarSpecificationDetailsPanel.this.inUse.setSize(SolarSpecificationDetailsPanel.this.inUse.getPreferredSize());
            cy = SolarSpecificationDetailsPanel.this.inUse.getY() + SolarSpecificationDetailsPanel.this.inUse.getHeight();
            SolarSpecificationDetailsPanel.this.catChooser.setLocation(SolarSpecificationDetailsPanel.this.horizontalBorder, cy + SolarSpecificationDetailsPanel.this.inner_verticalBorder);
            SolarSpecificationDetailsPanel.this.catChooser.setSize(w, (int)SolarSpecificationDetailsPanel.this.catChooser.getPreferredSize().getHeight());
            cy = SolarSpecificationDetailsPanel.this.catChooser.getY() + SolarSpecificationDetailsPanel.this.catChooser.getHeight();
            SolarSpecificationDetailsPanel.this.mainStoreUnitImageChooser.setLocation(SolarSpecificationDetailsPanel.this.horizontalBorder, cy + SolarSpecificationDetailsPanel.this.verticalBorder);
            SolarSpecificationDetailsPanel.this.mainStoreUnitImageChooser.setSize(w, (int)SolarSpecificationDetailsPanel.this.mainStoreUnitImageChooser.getPreferredSize().getHeight());
            SolarSpecificationDetailsPanel.this.floatStoreUnitImageChooser.setLocation(SolarSpecificationDetailsPanel.this.horizontalBorder, SolarSpecificationDetailsPanel.this.mainStoreUnitImageChooser.getY() + SolarSpecificationDetailsPanel.this.mainStoreUnitImageChooser.getHeight() + SolarSpecificationDetailsPanel.this.verticalBorder);
            SolarSpecificationDetailsPanel.this.floatStoreUnitImageChooser.setSize(w, (int)SolarSpecificationDetailsPanel.this.mainStoreUnitImageChooser.getPreferredSize().getHeight());
            SolarSpecificationDetailsPanel.this.productionUnitImageChooser.setLocation(SolarSpecificationDetailsPanel.this.horizontalBorder, SolarSpecificationDetailsPanel.this.floatStoreUnitImageChooser.getY() + SolarSpecificationDetailsPanel.this.floatStoreUnitImageChooser.getHeight() + SolarSpecificationDetailsPanel.this.verticalBorder);
            SolarSpecificationDetailsPanel.this.productionUnitImageChooser.setSize(w, (int)SolarSpecificationDetailsPanel.this.productionUnitImageChooser.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SolarSpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SolarSpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            h += SolarSpecificationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SolarSpecificationDetailsPanel.this.orderName.getPreferredSize().getHeight());
            h += SolarSpecificationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SolarSpecificationDetailsPanel.this.eanCode.getPreferredSize().getHeight());
            h += SolarSpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SolarSpecificationDetailsPanel.this.inUse.getPreferredSize().getHeight());
            h += SolarSpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SolarSpecificationDetailsPanel.this.catChooser.getPreferredSize().getHeight());
            h += SolarSpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SolarSpecificationDetailsPanel.this.mainStoreUnitImageChooser.getPreferredSize().getHeight());
            h += SolarSpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SolarSpecificationDetailsPanel.this.floatStoreUnitImageChooser.getPreferredSize().getHeight());
            h += SolarSpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SolarSpecificationDetailsPanel.this.productionUnitImageChooser.getPreferredSize().getHeight());
            return new Dimension(0, h += SolarSpecificationDetailsPanel.this.verticalBorder);
        }
    }
}

