/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.articlepricecalculator.details;

import ch.icit.pegasus.client.converter.ArticlePriceCalculationStrategyConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.articlepricecalculator.details.utils.CurrencyExchangeRatePopup;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.validator.ValidationUtil;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticlePriceModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceCalculationComplete_;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceCalculationLight;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceCalculationStrategyE;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class CalculationDetailsPanel
extends DefaultDetailsPanel<ArticlePriceCalculationLight> {
    private static final long serialVersionUID = 1L;
    private TitledPeriodEditor period;
    private TitledItem<RDComboBox> strategy;
    private TitledItem<EditButton> editCurrency;
    private TitledItem<RDTextField> factor;
    private boolean isDraft = true;

    public CalculationDetailsPanel(RowEditor<ArticlePriceCalculationLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.CALCULATION_PARAMETERS);
        this.period = new TitledPeriodEditor(null, null, false, provider, ArticlePriceCalculationComplete_.dataRange);
        this.strategy = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(ArticlePriceCalculationStrategyConverter.class)), Words.STRATEGY, TitledItem.TitledItemOrientation.NORTH);
        this.strategy.getElement().setOverrideName(ArticlePriceCalculationComplete_.strategy);
        this.editCurrency = new TitledItem<EditButton>(new EditButton(), Words.DEFINE_EXCHANGE_RATES, TitledItem.TitledItemOrientation.WEST);
        this.editCurrency.getElement().addButtonListener(this);
        this.factor = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.DOUBLE), Words.FACTOR, TitledItem.TitledItemOrientation.NORTH);
        this.setCustomLayouter(new Layout());
        this.addToView(this.period);
        this.addToView(this.strategy);
        this.addToView(this.editCurrency);
        this.addToView(this.factor);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.editCurrency.getElement()) {
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(source, false, false, Words.CURRENCIES);
            popUp.setView(new CurrencyExchangeRatePopup(this.editor.getModel().getNode().getChildNamed(ArticlePriceCalculationComplete_.exchangeRates), this.provider, this.isDraft));
            popUp.showPopUp(x, y, 450, 300, null, source, PopupType.FRAMELESS);
        }
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        List<ScreenValidationObject> a = ValidationUtil.validatePeriod((Node<Date>)this.editor.getModel().getNode().getChildNamed(new DtoField[]{ArticlePriceCalculationComplete_.dataRange, PeriodComplete_.startDate}), (Node<Date>)this.editor.getModel().getNode().getChildNamed(new DtoField[]{ArticlePriceCalculationComplete_.dataRange, PeriodComplete_.endDate}), this.period);
        return a;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean enable = isEnabled && this.isDraft;
        boolean useOrderDate = false;
        try {
            useOrderDate = Boolean.TRUE.equals(this.editor.getModel().getNode().getChildNamed(ArticlePriceCalculationComplete_.useOrderDate).getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.period.setEnabled(enable);
        this.strategy.setEnabled(enable);
        this.editCurrency.setEnabled(isEnabled && !useOrderDate);
        this.factor.setEnabled(enable);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.period.kill();
        this.period = null;
        this.strategy.kill();
        this.strategy = null;
        this.editCurrency.kill();
        this.editCurrency = null;
        this.factor.kill();
        this.factor = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.period);
        CheckedListAdder.addToList(focusList, this.strategy);
        CheckedListAdder.addToList(focusList, this.editCurrency);
        CheckedListAdder.addToList(focusList, this.factor);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.isDraft = node.getChildNamed(ArticlePriceCalculationComplete_.state).getValue() == ArticlePriceModificationStateE.DRAFT;
        this.period.setStartDateNode(node.getChildNamed(new DtoField[]{ArticlePriceCalculationComplete_.dataRange, PeriodComplete_.startDate}));
        this.period.setEndDateNode(node.getChildNamed(new DtoField[]{ArticlePriceCalculationComplete_.dataRange, PeriodComplete_.endDate}));
        this.strategy.getElement().setNode(node.getChildNamed(ArticlePriceCalculationComplete_.strategy));
        this.strategy.getElement().refreshPossibleValues(NodeToolkit.getAffixList(ArticlePriceCalculationStrategyE.class));
        this.factor.getElement().setNode(node.getChildNamed(ArticlePriceCalculationComplete_.factor));
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = CalculationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + CalculationDetailsPanel.this.period.getPreferredSize().getHeight());
            h += CalculationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + CalculationDetailsPanel.this.strategy.getPreferredSize().getHeight());
            h += CalculationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + CalculationDetailsPanel.this.editCurrency.getPreferredSize().getHeight());
            h += CalculationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + CalculationDetailsPanel.this.factor.getPreferredSize().getHeight());
            return new Dimension(0, h += CalculationDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            CalculationDetailsPanel.this.period.setLocation(CalculationDetailsPanel.this.horizontalBorder, CalculationDetailsPanel.this.verticalBorder);
            CalculationDetailsPanel.this.period.setSize(CalculationDetailsPanel.this.period.getPreferredSize());
            CalculationDetailsPanel.this.strategy.setLocation(CalculationDetailsPanel.this.horizontalBorder, CalculationDetailsPanel.this.period.getY() + CalculationDetailsPanel.this.period.getHeight() + CalculationDetailsPanel.this.verticalBorder);
            CalculationDetailsPanel.this.strategy.setSize(parent.getWidth() - 2 * CalculationDetailsPanel.this.horizontalBorder, (int)CalculationDetailsPanel.this.strategy.getPreferredSize().getHeight());
            CalculationDetailsPanel.this.editCurrency.setLocation(CalculationDetailsPanel.this.horizontalBorder, CalculationDetailsPanel.this.strategy.getY() + CalculationDetailsPanel.this.strategy.getHeight() + CalculationDetailsPanel.this.verticalBorder);
            CalculationDetailsPanel.this.editCurrency.setSize(CalculationDetailsPanel.this.editCurrency.getPreferredSize());
            CalculationDetailsPanel.this.factor.setLocation(CalculationDetailsPanel.this.horizontalBorder, CalculationDetailsPanel.this.editCurrency.getY() + CalculationDetailsPanel.this.editCurrency.getHeight() + CalculationDetailsPanel.this.verticalBorder);
            CalculationDetailsPanel.this.factor.setSize(120, (int)CalculationDetailsPanel.this.factor.getPreferredSize().getHeight());
        }
    }
}

