/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.articlepricecalculator.details;

import ch.icit.pegasus.client.converter.ArticlePriceCalculationModificationStateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiOwnerSelectionComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticlePriceModificationStateE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ArticlePriceCalculationAccess;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceCalculationComplete_;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceCalculationLight;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceCalculationLight_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class SpecificationDetailsPanel
extends DefaultDetailsPanel<ArticlePriceCalculationLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDTextField> name;
    private TitledItem<TextLabel> number;
    private TitledItem<RDDateChooser> date;
    private TitledItem<RDDateChooser> currencyDate;
    private TitledItem<RDCheckBox> useTransactionDate;
    private TitledItem<RDMultiOwnerSelectionComboBox> department;
    private TitledItem<RDComboBox> state;
    private TitledItem<RDCheckBox> tenderUpdate;
    private TitledItem<RDSearchComboBox> customer;
    private boolean isDraft = true;
    private boolean canRedraft = false;

    public SpecificationDetailsPanel(RowEditor<ArticlePriceCalculationLight> editor, RDProvider provider) {
        super(editor, provider);
        this.canRedraft = provider.isWritable(ArticlePriceCalculationAccess.REDRAFT_ACCEPTED);
        this.setTitleText(Words.SPECIFICATION);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.number = new TitledItem<TextLabel>(new TextLabel(), Words.NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.number.getElement().setReadOnlyTextField(true);
        this.date = new TitledItem<RDDateChooser>(new RDDateChooser(provider), Words.EFFECTIVE_FROM, TitledItem.TitledItemOrientation.NORTH);
        this.department = new TitledItem<RDMultiOwnerSelectionComboBox>(new RDMultiOwnerSelectionComboBox(provider), Words.DEPARTMENTS, TitledItem.TitledItemOrientation.NORTH);
        this.department.getElement().setOverrideName(ArticlePriceCalculationComplete_.departments);
        this.state = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(ArticlePriceCalculationModificationStateConverter.class)), Words.STATE, TitledItem.TitledItemOrientation.NORTH);
        this.tenderUpdate = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.TENDER, TitledItem.TitledItemOrientation.EAST);
        this.customer = new TitledItem<RDSearchComboBox>(new RDSearchComboBox(provider, RDSearchComboBox.BoxSearchTypes.CUSTOMER), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.tenderUpdate.getElement().addButtonListener(this);
        this.currencyDate = new TitledItem<RDDateChooser>(new RDDateChooser(provider), Words.CURRENCY_VALIDITY, TitledItem.TitledItemOrientation.NORTH);
        this.useTransactionDate = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.USE_ORDER_DATE, TitledItem.TitledItemOrientation.EAST);
        this.useTransactionDate.getElement().addButtonListener(this);
        this.setCustomLayouter(new Layout());
        this.addToView(this.name);
        this.addToView(this.number);
        this.addToView(this.date);
        this.addToView(this.department);
        this.addToView(this.state);
        this.addToView(this.tenderUpdate);
        this.addToView(this.customer);
        this.addToView(this.currencyDate);
        this.addToView(this.useTransactionDate);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.tenderUpdate.getElement().getEditor() || source == this.useTransactionDate.getElement().getEditor()) {
            this.editor.setEnabled(this.isEnabled());
        } else {
            super.buttonPressed(source, x, y);
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        this.name.requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArticlePriceModificationStateE state;
        Date date;
        String name;
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.name.getElement().isWritable() && this.editor.getModel().getNode() != null && ((name = (String)this.editor.getModel().getNode().getChildNamed(ArticlePriceCalculationComplete_.name).getValue()) == null || name.isEmpty())) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_NAME_IS_SET));
        }
        if (this.date.getElement().isWritable() && this.editor.getModel().getNode() != null && (date = (Date)this.editor.getModel().getNode().getChildNamed(ArticlePriceCalculationComplete_.date).getValue()) == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_DATE_IS_SET));
        }
        if (this.state.getElement().isWritable() && this.editor.getModel().getNode() != null && (state = (ArticlePriceModificationStateE)this.editor.getModel().getNode().getChildNamed(ArticlePriceCalculationComplete_.state).getValue()) == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_STATE_IS_SET));
        }
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean enable = isEnabled && this.isDraft;
        this.name.setEnabled(enable);
        this.number.setEnabled(enable);
        this.date.setEnabled(enable);
        this.department.setEnabled(enable);
        boolean tenderUpdateSelected = this.tenderUpdate.getElement().isChecked();
        this.tenderUpdate.setEnabled(enable);
        this.customer.setEnabled(enable && tenderUpdateSelected);
        tenderUpdateSelected = this.useTransactionDate.getElement().isChecked();
        this.useTransactionDate.setEnabled(enable);
        this.currencyDate.setEnabled(enable && !tenderUpdateSelected);
        boolean isUpdated = false;
        if (this.editor.getModel().getNode() != null && this.editor.getModel().getNode().getChildNamed(ArticlePriceCalculationComplete_.state) != null) {
            isUpdated = this.editor.getModel().getNode().getChildNamed(ArticlePriceCalculationComplete_.state).getValue() == ArticlePriceModificationStateE.UPDATED;
        }
        this.state.setEnabled(!isUpdated && isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.name.kill();
        this.name = null;
        this.number.kill();
        this.number = null;
        this.date.kill();
        this.date = null;
        this.department.kill();
        this.department = null;
        this.state.kill();
        this.state = null;
        this.tenderUpdate.kill();
        this.tenderUpdate = null;
        this.customer.kill();
        this.customer = null;
        this.currencyDate.kill();
        this.currencyDate = null;
        this.useTransactionDate.kill();
        this.useTransactionDate = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.date);
        CheckedListAdder.addToList(focusList, this.useTransactionDate);
        CheckedListAdder.addToList(focusList, this.currencyDate);
        CheckedListAdder.addToList(focusList, this.department);
        CheckedListAdder.addToList(focusList, this.state);
        CheckedListAdder.addToList(focusList, this.tenderUpdate);
        CheckedListAdder.addToList(focusList, this.customer);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.isDraft = node.getChildNamed(ArticlePriceCalculationLight_.state).getValue() == ArticlePriceModificationStateE.DRAFT;
        this.name.getElement().setNode(node.getChildNamed(ArticlePriceCalculationLight_.name));
        this.number.getElement().setNode(node.getChildNamed(ArticlePriceCalculationLight_.number));
        this.date.getElement().setNode(node.getChildNamed(ArticlePriceCalculationLight_.date));
        this.department.getElement().setNode(node.getChildNamed(ArticlePriceCalculationLight_.departments));
        if (node.getChildNamed(ArticlePriceCalculationLight_.state).getValue() == ArticlePriceModificationStateE.UPDATED) {
            this.state.getElement().setNode(node.getChildNamed(ArticlePriceCalculationLight_.state));
            this.state.getElement().addItem(ArticlePriceModificationStateE.UPDATED);
        } else {
            this.state.getElement().setNode(node.getChildNamed(ArticlePriceCalculationLight_.state));
            this.state.getElement().refreshPossibleValues(NodeToolkit.getAffixList(ArticlePriceModificationStateE.class));
        }
        this.tenderUpdate.getElement().setNode(node.getChildNamed(ArticlePriceCalculationComplete_.tenderPrice));
        this.customer.getElement().setNode(node.getChildNamed(ArticlePriceCalculationComplete_.tenderCustomer));
        this.useTransactionDate.getElement().setNode(node.getChildNamed(ArticlePriceCalculationComplete_.useOrderDate));
        this.currencyDate.getElement().setNode(node.getChildNamed(ArticlePriceCalculationComplete_.currencyValidityDate));
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.date.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder * 2;
            h = (int)((double)h + SpecificationDetailsPanel.this.useTransactionDate.getPreferredSize().getHeight());
            h = (int)((double)h + SpecificationDetailsPanel.this.currencyDate.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.department.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.state.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder * 2;
            h = (int)((double)h + SpecificationDetailsPanel.this.tenderUpdate.getPreferredSize().getHeight());
            h = (int)((double)h + SpecificationDetailsPanel.this.customer.getPreferredSize().getHeight());
            return new Dimension(0, h += SpecificationDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = (parent.getWidth() - 3 * SpecificationDetailsPanel.this.horizontalBorder) * 2 / 3;
            SpecificationDetailsPanel.this.name.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.name.setSize(w, (int)SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.number.setLocation(SpecificationDetailsPanel.this.name.getX() + SpecificationDetailsPanel.this.name.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.number.setSize(parent.getWidth() - (SpecificationDetailsPanel.this.number.getX() + SpecificationDetailsPanel.this.horizontalBorder), (int)SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.date.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.name.getY() + SpecificationDetailsPanel.this.name.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.date.setSize(SpecificationDetailsPanel.this.date.getPreferredSize());
            SpecificationDetailsPanel.this.useTransactionDate.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.date.getY() + SpecificationDetailsPanel.this.date.getHeight() + SpecificationDetailsPanel.this.verticalBorder * 2);
            SpecificationDetailsPanel.this.useTransactionDate.setSize(SpecificationDetailsPanel.this.useTransactionDate.getPreferredSize());
            SpecificationDetailsPanel.this.currencyDate.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.useTransactionDate.getY() + SpecificationDetailsPanel.this.useTransactionDate.getHeight());
            SpecificationDetailsPanel.this.currencyDate.setSize(SpecificationDetailsPanel.this.currencyDate.getPreferredSize());
            SpecificationDetailsPanel.this.department.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.currencyDate.getY() + SpecificationDetailsPanel.this.currencyDate.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.department.setSize(parent.getWidth() - 2 * SpecificationDetailsPanel.this.horizontalBorder, (int)SpecificationDetailsPanel.this.department.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.state.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.department.getY() + SpecificationDetailsPanel.this.department.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.state.setSize(parent.getWidth() - 2 * SpecificationDetailsPanel.this.horizontalBorder, (int)SpecificationDetailsPanel.this.state.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.tenderUpdate.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.state.getY() + SpecificationDetailsPanel.this.state.getHeight() + SpecificationDetailsPanel.this.verticalBorder * 2);
            SpecificationDetailsPanel.this.tenderUpdate.setSize(SpecificationDetailsPanel.this.tenderUpdate.getPreferredSize());
            SpecificationDetailsPanel.this.customer.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.tenderUpdate.getY() + SpecificationDetailsPanel.this.tenderUpdate.getHeight());
            SpecificationDetailsPanel.this.customer.setSize(parent.getWidth() - 2 * SpecificationDetailsPanel.this.horizontalBorder, (int)SpecificationDetailsPanel.this.customer.getPreferredSize().getHeight());
        }
    }
}

