/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.articlepricecontract.details.utils;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.modules.articlepricecontract.details.ActionDetailsPanel;
import ch.icit.pegasus.client.gui.submodules.print.dayprice.PrintArticleContractComponent;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButtonBox;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.Ask4ReportGenerationPopupInsert;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.ArticlePriceContractToolkit;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceContractComplete;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceContractComplete_;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceContractLight;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceContractStateE;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.utils.ExcelRow;
import ch.icit.utils.ExcelToolkit;
import ch.icit.utils.StyledWorkbook;
import java.awt.Component;
import java.io.File;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;

public class ArticleContractExportPopup
extends Ask4ReportGenerationPopupInsert {
    private static final long serialVersionUID = 1L;
    private final ActionDetailsPanel para;
    private final boolean isExport;
    protected RadioButtonBox reportTypeBox;
    private final Node node;
    private boolean isDayPrice;

    public ArticleContractExportPopup(boolean itSelf, String text, String progress, String finish, ActionDetailsPanel p, boolean isExport, Node node) {
        super(itSelf, text, progress, finish);
        this.node = node;
        this.para = p;
        this.isExport = isExport;
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        switch (this.currentState) {
            case 5: {
                MainFrame.isTempRelease = true;
                File file = null;
                file = this.isExport ? FileChooserUtil.saveFile(".xlsx") : FileChooserUtil.loadFile();
                if (file != null) {
                    this.setSelectedFile(file);
                    this.currentState = 3;
                    if (this.getSelectedFile() != null && this.getSelectedFile().exists() && this.isExport) {
                        this.errorMSG = Words.FILE_ALREADY_EXISTS;
                        this.removeInheritedComponents();
                        this.showMessage(this.errorMSG);
                    } else {
                        this.enterPressed(isOK);
                    }
                }
                MainFrame.isTempRelease = false;
                break;
            }
            case 3: {
                this.startPrinting();
                break;
            }
            case 7: {
                if (this.msg != null) {
                    this.msg.setVisible(false);
                }
                super.enterPressed(isOK);
            }
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.msg != null) {
            this.msg.setVisible(false);
        }
    }

    private static String getSheetName() {
        return Words.SCREEN_NAME_ARTICLE_CONTRACT;
    }

    @Override
    protected void startPrinting() {
        this.printed = true;
        this.popup.enableOKButton(false);
        this.popup.enableCancelButton(false);
        this.removeInheritedComponents();
        if (this.isExport) {
            this.ensureAnimation(Words.EXPORT);
        } else {
            this.ensureAnimation(Words.IMPORT);
        }
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ViewNode returnValue = null;
                try {
                    if (ArticleContractExportPopup.this.isExport) {
                        ArticleContractExportPopup.this.para.getEditor().getModel().getNode().commit(ArticlePriceContractComplete.class);
                        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                        List<ExcelRow> rows = ArticlePriceContractToolkit.createExportList((Node<ArticlePriceContractComplete>)ArticleContractExportPopup.this.para.getEditor().getModel().getNode(), (SupplierLight)ArticleContractExportPopup.this.para.getEditor().getModel().getNode().getChildNamed(ArticlePriceContractComplete_.supplier).getValue(), settings);
                        try {
                            String password = settings.getContractPassword();
                            if (password == null || password.isEmpty()) {
                                password = null;
                            }
                            int cr = 0;
                            StyledWorkbook wb = ExcelToolkit.createFastWorkbook();
                            Sheet sheet = ExcelToolkit.insertSheet((StyledWorkbook)wb, (String)ArticleContractExportPopup.getSheetName());
                            for (ExcelRow r : rows) {
                                cr = r.writeRow(wb, sheet, r.isHeader(), cr);
                            }
                            ExcelToolkit.writeWorkBook((File)ArticleContractExportPopup.this.getSelectedFile(), (StyledWorkbook)wb);
                            ArticleContractExportPopup.this.finishText = Words.SUCCESSFULLY_EXPORTED;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ArticleContractExportPopup.this.finishText = Words.UNABLE_TO_EXPORT;
                        }
                        ArticleContractExportPopup.this.para.getEditor().getModel().getNode().getChildNamed(ArticlePriceContractComplete_.exported).setValue((Object)true, System.currentTimeMillis());
                        ArticleContractExportPopup.this.para.getEditor().getModel().getNode().getChildNamed(ArticlePriceContractComplete_.state).setValue((Object)ArticlePriceContractStateE.EXPORTED, 0L);
                        ArticleContractExportPopup.this.para.getEditor().getModel().getNode().commit(ArticlePriceContractComplete.class);
                        ArticlePriceContractComplete contract = (ArticlePriceContractComplete)ArticleContractExportPopup.this.para.getEditor().getModel().getNode().getValue(ArticlePriceContractComplete.class);
                        contract = (ArticlePriceContractComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).updateArticlePriceContract(contract).getValue();
                        ArticleContractExportPopup.this.para.getEditor().getModel().getNode().removeExistingValues();
                        ArticleContractExportPopup.this.para.getEditor().getModel().getNode().setValue((Object)contract, 0L);
                        ArticleContractExportPopup.this.para.getEditor().getModel().getNode().updateNode();
                    } else {
                        List r = ExcelToolkit.readRows((File)ArticleContractExportPopup.this.getSelectedFile());
                        List<ScreenValidationObject> ret = ArticlePriceContractToolkit.importData(r, (Node<ArticlePriceContractComplete>)ArticleContractExportPopup.this.para.getEditor().getModel().getNode(), (SupplierLight)ArticleContractExportPopup.this.para.getEditor().getModel().getNode().getChildNamed(ArticlePriceContractComplete_.supplier).getValue());
                        ArticleContractExportPopup.this.para.getEditor().getModel().getNode().commit(ArticlePriceContractComplete.class);
                        ArticleContractExportPopup.this.para.getEditor().commitData(ArticleContractExportPopup.this.para.getEditor().getModel().getNode(), ArticleContractExportPopup.this.para.getEditor());
                        ArticleContractExportPopup.this.finishText = Words.SUCCESSFULLY_IMPORTED;
                        ArticleContractExportPopup.this.para.getEditor().getModel().getNode().getChildNamed(ArticlePriceContractComplete_.state).setValue((Object)ArticlePriceContractStateE.IMPORTED, 0L);
                        ArticleContractExportPopup.this.para.getEditor().getModel().getNode().commit(ArticlePriceContractComplete.class);
                        ArticlePriceContractComplete contract = (ArticlePriceContractComplete)ArticleContractExportPopup.this.para.getEditor().getModel().getNode().getValue(ArticlePriceContractComplete.class);
                        contract = (ArticlePriceContractComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).updateArticlePriceContract(contract).getValue();
                        ArticleContractExportPopup.this.para.getEditor().getModel().getNode().removeExistingValues();
                        ArticleContractExportPopup.this.para.getEditor().getModel().getNode().setValue((Object)contract, 0L);
                        ArticleContractExportPopup.this.para.getEditor().getModel().getNode().updateNode();
                        returnValue = new ViewNode("");
                        returnValue.setValue(ret, 0L);
                    }
                    ArticleContractExportPopup.this.currentState = 7;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return returnValue;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ArticleContractExportPopup.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        if (node != null && node.getValue() instanceof ClientServerCallException) {
            InnerPopupFactory.showErrorDialog((Exception)((Object)((ClientServerCallException)((Object)node.getValue()))), (Component)this);
            return;
        }
        if (node != null && node.getValue() instanceof List) {
            InnerPopupFactory.showScreenValidationPopup((List)node.getValue(), Words.CONTRACT_ISN_T_IMPORTED, this);
        }
        boolean useArticleContract = false;
        if (this.isExport && this.node.getChildNamed(ArticlePriceContractComplete_.isDayPriceContract) != null && ((Boolean)this.node.getChildNamed(ArticlePriceContractComplete_.isDayPriceContract).getValue()).booleanValue()) {
            useArticleContract = true;
        }
        if (useArticleContract) {
            InnerPopUp2 pop = InnerPopUp2.getInnerPopUp();
            pop.setAttributes(null, true, true, Words.PRINT);
            PrintArticleContractComponent widget = new PrintArticleContractComponent((Node<ArticlePriceContractLight>)this.node);
            int prefH = 450;
            pop.setView(widget);
            pop.showPopUpWithinScreenMiddle(320, prefH, null, this);
            ((PrintArticleContractComponent)pop.getView()).loadReportTypes();
        }
        super.remoteObjectLoaded(node);
    }
}

