/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.articleswap.detail;

import ch.icit.pegasus.client.gui.modules.importer.utils.ImporterItemView;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.commiter.FileCommitter;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.ViewButton;
import ch.icit.pegasus.client.gui.utils.file.FileChooserPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.utils.ImportType;
import ch.icit.pegasus.server.core.dtos.swap.ArticleSwapDataImportComplete;
import ch.icit.pegasus.server.core.dtos.swap.ArticleSwapDataImportComplete_;
import ch.icit.pegasus.server.core.dtos.swap.ArticleSwapDataImportLight;
import ch.icit.pegasus.server.core.dtos.swap.ArticleSwapDataImportLight_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.StringUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class ConfigurationDetailsPanel
extends DefaultDetailsPanel<ArticleSwapDataImportLight>
implements ButtonListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDTextField> name;
    private TitledItem<RDTextField> description;
    private TitledItem<FileChooserPanel> file;
    private ViewButton downloadTemplateButton;
    private ImportType importType = ImportType.ARTICLE_SWAP_IMPORT;
    private InfoButton infoButton;
    private TitledItem<RDCheckBox> ignoreOrders;

    public ConfigurationDetailsPanel(RowEditor<ArticleSwapDataImportLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.CONFIGURATION);
        this.setCustomLayouter(new Layout());
        this.file = new TitledItem<FileChooserPanel>(new FileChooserPanel(false), Words.FILE, TitledItem.TitledItemOrientation.NORTH);
        this.file.getElement().setFileType("xlsx");
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.description = new TitledItem<RDTextField>(new RDTextField(provider), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
        this.downloadTemplateButton = new ViewButton();
        this.infoButton = new InfoButton();
        this.downloadTemplateButton.addButtonListener(this);
        this.infoButton.installStringViewer(this.createInfoText());
        this.ignoreOrders = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.IGNORE_ORDERS, TitledItem.TitledItemOrientation.EAST);
        this.addToView(this.file);
        this.addToView(this.name);
        this.addToView(this.description);
        this.addToView(this.downloadTemplateButton);
        this.addToView(this.infoButton);
        this.addToView(this.ignoreOrders);
    }

    private String createInfoText() {
        return this.importType.getFormat();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.description);
        CheckedListAdder.addToList(focusList, this.file);
        CheckedListAdder.addToList(focusList, this.ignoreOrders);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        this.name.getElement().setNode(node.getChildNamed(ArticleSwapDataImportLight_.name));
        this.file.getElement().setNode(node.getChildNamed(ArticleSwapDataImportComplete_.sheet));
        this.ignoreOrders.getElement().setNode(node.getChildNamed(ArticleSwapDataImportLight_.ignoreOrders));
        this.description.getElement().setNode(node.getChildNamed(ArticleSwapDataImportComplete_.description));
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        ArrayList<RemoteCommitter> a = new ArrayList<RemoteCommitter>();
        PegasusFileComplete gr = (PegasusFileComplete)this.editor.getModel().getNode().getChildNamed(ArticleSwapDataImportComplete_.sheet).getValue();
        if (gr != null && gr.getLocalFile() != null) {
            FileCommitter c = new FileCommitter(gr.getLocalFile());
            c.setWriteBackAlgorithm(reference -> {
                this.editor.getModel().getNode().getChildNamed(ArticleSwapDataImportComplete_.sheet).setValue((Object)reference, 0L);
                ((ArticleSwapDataImportComplete)this.editor.getModel().getNode().getValue()).setSheet(reference);
            });
            a.add(c);
        }
        return a;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.downloadTemplateButton) {
            try {
                File f = this.downloadFile();
                if (f == null) {
                    InnerPopupFactory.showErrorDialog("No template ready. Please contact support.", (Component)this);
                }
                Desktop.getDesktop().open(f);
            }
            catch (IOException e) {
                InnerPopupFactory.showErrorDialog(e, (Component)this);
            }
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.file.kill();
        this.file = null;
        this.name.kill();
        this.name = null;
        this.description.kill();
        this.description = null;
        this.infoButton.kill();
        this.infoButton = null;
        this.ignoreOrders.kill();
        this.ignoreOrders = null;
        this.downloadTemplateButton.kill();
        this.downloadTemplateButton = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.file.setEnabled(isEnabled);
        this.name.setEnabled(isEnabled);
        this.description.setEnabled(isEnabled);
        this.infoButton.setEnabled(isEnabled);
        this.ignoreOrders.setEnabled(isEnabled);
        this.downloadTemplateButton.setEnabled(isEnabled);
    }

    @Override
    public boolean grabsFocus() {
        return true;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.file.getElement().getNode().getValue() == null || ((PegasusFileComplete)this.file.getElement().getNode().getValue()).getLocalFile() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Article Swap file is selected"));
        }
        if (StringUtil.isBlank((String)((String)this.name.getElement().getNode().getValue()))) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Name is set"));
        }
        return validationObjects;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    @Override
    public void requestFocusInWindowNow() {
        this.name.requestFocusInWindowNow();
    }

    private File downloadFile() throws IOException {
        File tempFile = File.createTempFile("ImporterFile_", ".xlsx");
        URL url = this.createURL();
        if (url == null) {
            return null;
        }
        FileUtils.copyURLToFile((URL)url, (File)tempFile);
        return tempFile;
    }

    private URL createURL() throws MalformedURLException {
        return ImporterItemView.class.getResource("/importtemplates/" + this.importType.getTemplateId());
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ConfigurationDetailsPanel.this.name.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.verticalBorder);
            ConfigurationDetailsPanel.this.name.setSize(400, (int)ConfigurationDetailsPanel.this.name.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.ignoreOrders.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.name.getX() + ConfigurationDetailsPanel.this.name.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.ignoreOrders.setSize(400, (int)ConfigurationDetailsPanel.this.ignoreOrders.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.description.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.ignoreOrders.getY() + ConfigurationDetailsPanel.this.ignoreOrders.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.description.setSize(400, (int)ConfigurationDetailsPanel.this.description.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.file.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.description.getY() + ConfigurationDetailsPanel.this.description.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.file.setSize(400, (int)ConfigurationDetailsPanel.this.file.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.infoButton.setLocation(ConfigurationDetailsPanel.this.horizontalBorder + 420, ConfigurationDetailsPanel.this.file.getY() + ConfigurationDetailsPanel.this.file.getHeight() - 20);
            ConfigurationDetailsPanel.this.infoButton.setSize(ConfigurationDetailsPanel.this.infoButton.getPreferredSize());
            ConfigurationDetailsPanel.this.downloadTemplateButton.setLocation(ConfigurationDetailsPanel.this.horizontalBorder + 440, ConfigurationDetailsPanel.this.file.getY() + ConfigurationDetailsPanel.this.file.getHeight() - 22);
            ConfigurationDetailsPanel.this.downloadTemplateButton.setSize(ConfigurationDetailsPanel.this.downloadTemplateButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int lh = ConfigurationDetailsPanel.this.verticalBorder;
            lh = (int)((double)lh + ConfigurationDetailsPanel.this.name.getPreferredSize().getHeight());
            lh += ConfigurationDetailsPanel.this.inner_verticalBorder;
            lh = (int)((double)lh + ConfigurationDetailsPanel.this.ignoreOrders.getPreferredSize().getHeight());
            lh += ConfigurationDetailsPanel.this.inner_verticalBorder;
            lh = (int)((double)lh + ConfigurationDetailsPanel.this.description.getPreferredSize().getHeight());
            lh += ConfigurationDetailsPanel.this.inner_verticalBorder;
            lh = (int)((double)lh + ConfigurationDetailsPanel.this.file.getPreferredSize().getHeight());
            return new Dimension(0, lh += ConfigurationDetailsPanel.this.verticalBorder);
        }
    }
}

