/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.changenotification.utils;

import ch.icit.pegasus.client.converter.DayTimeConverter;
import ch.icit.pegasus.client.converter.IntegerSignedConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.icons.DefaultIconComponent_NEW;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.notification.ChangeNotificationServiceManager;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationComplete_;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationLight;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationLight_;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationReference;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationStateE;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationTypeE;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;

@Deprecated
public class NotificationTable
extends Table2
implements MouseMotionListener {
    public NotificationTable(int rowSize) {
        super(false, "", false, false, "");
        this.setDefaultRowHeight(rowSize);
        this.setLayout(new Layout());
        double monitorWidth = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        int flightColumnWidth = (int)monitorWidth / 10 * 2;
        int iconColumnWidth = (int)monitorWidth / 10;
        int messageColumnWidth = (int)monitorWidth / 10 * 5;
        int countColumnWidth = (int)monitorWidth / 10 * 2;
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.FLIGHT, null, null, null, "", flightColumnWidth, flightColumnWidth, flightColumnWidth));
        columns.add(new TableColumnInfo(Words.TYPE, null, null, null, "", iconColumnWidth, iconColumnWidth, iconColumnWidth));
        columns.add(new TableColumnInfo(Words.MESSAGE, null, null, null, "", messageColumnWidth, Integer.MAX_VALUE, messageColumnWidth));
        columns.add(new TableColumnInfo(Words.COUNT, null, null, null, "", countColumnWidth, countColumnWidth, countColumnWidth));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
        this.getModel().setNode((Node)new ViewNode("changeNotifications"));
        this.getViewPort().setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_background_color")));
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private DefaultIconComponent_NEW getIconForType(ChangeNotificationTypeE type) {
        DefaultSkins icon = null;
        switch (type) {
            case PAX: {
                icon = DefaultSkins.ChangeNotificationPaxIcon;
                break;
            }
            case REGULAR: {
                icon = DefaultSkins.ChangeNotificationRegularIcon;
                break;
            }
            case SPML: {
                icon = DefaultSkins.ChangeNotificationSpmlIcon;
                break;
            }
            case ALACARTE: {
                icon = DefaultSkins.ChangeNotificationAlaCarteIcon;
                break;
            }
            case ADDITIONAL: {
                icon = DefaultSkins.ChangeNotificationAdditionalIcon;
                break;
            }
            case STOWING: {
                icon = DefaultSkins.ChangeNotificationStowingUpdateIcon;
                break;
            }
            case MANUAL: {
                icon = DefaultSkins.ChangeNotificationManualIcon;
            }
        }
        return new DefaultIconComponent_NEW(icon);
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements MouseListener {
        private TextLabel flightCode;
        private TextLabel flightTime;
        private DefaultIconComponent_NEW icon;
        private TextLabel message;
        private TextLabel count;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.icon = NotificationTable.this.getIconForType((ChangeNotificationTypeE)m.getNode().getChildNamed(ChangeNotificationLight_.type).getValue());
            NotificationTable.this.textFont = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
            float fontSize = (float)this.getDefaultRowHeight() / 4.0f;
            Font sizedFont = NotificationTable.this.textFont.deriveFont(NotificationTable.this.textFont.getStyle(), fontSize);
            String flightNo = (String)m.getNode().getChildNamed(ChangeNotificationLight_.outboundCode).getValue();
            this.flightCode = new TextLabel(flightNo);
            this.flightCode.setFont(sizedFont);
            this.flightTime = new TextLabel(m.getNode().getChildNamed(ChangeNotificationLight_.std), ConverterRegistry.getConverter(DayTimeConverter.class));
            this.flightTime.setFont(sizedFont);
            this.message = new TextLabel(m.getNode().getChildNamed(ChangeNotificationLight_.remark));
            this.message.setFont(sizedFont);
            this.count = new TextLabel(m.getNode().getChildNamed(ChangeNotificationLight_.difference), ConverterRegistry.getConverter(IntegerSignedConverter.class));
            this.count.setFont(sizedFont);
            m.getNode().getChildNamed(ChangeNotificationLight_.state).addNodeListener(new NodeListener(){

                public void valueChanged(Node<?> node) {
                    TableRowImpl.this.repaint(32L);
                }

                public void childAdded(Node<?> source, Node<?> child) {
                }

                public void childRemoved(Node<?> source, Node<?> child) {
                }

                public void childrenAdded(Node<?> source, Node<?>[] nodes) {
                }

                public boolean isSwingOnly() {
                    return false;
                }
            });
            this.setLayout(new Layout());
            this.add(this.flightCode);
            this.add(this.flightTime);
            this.add(this.icon);
            this.add(this.message);
            this.add(this.count);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    TableRowImpl.this.switchState();
                }
            });
        }

        private void switchState() {
            ChangeNotificationLight l = (ChangeNotificationLight)this.model.getNode().getValue(ChangeNotificationLight.class);
            try {
                l = (ChangeNotificationLight)((ChangeNotificationServiceManager)ServiceManagerRegistry.getService(ChangeNotificationServiceManager.class)).invertState(new ChangeNotificationReference(l.getId())).getValue();
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
            this.model.getNode().removeExistingValues();
            this.model.getNode().setValue((Object)l, 0L);
            this.model.getNode().updateNode();
            this.model.getParentModel().getTable().repaint();
        }

        @Override
        public void paint(Graphics g) {
            ChangeNotificationLight changeNotification = (ChangeNotificationLight)this.model.getNode().getValue();
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color backgroundColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_background_color"));
            Color foreGroundColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color"));
            Color color1 = new Color(124, 56, 0);
            Color color2 = new Color(197, 107, 18);
            GradientPaint orange = new GradientPaint(this.getDefaultRowHeight() / 2, 0.0f, color1, this.getDefaultRowHeight() / 2, this.getDefaultRowHeight(), color2, false);
            GradientPaint grey = new GradientPaint(this.getDefaultRowHeight() / 2, -20.0f, foreGroundColor, this.getDefaultRowHeight() / 2, this.getDefaultRowHeight() / 2, backgroundColor, true);
            if (changeNotification.getState() == ChangeNotificationStateE.OPEN) {
                g2.setPaint(orange);
            } else {
                g2.setPaint(grey);
            }
            int space = 10;
            int spaceX = 10;
            int arc = 20;
            g2.fillRoundRect(0, space, this.getWidth() - spaceX, this.getHeight() - space, arc, arc);
            this.paintChildren(g2);
        }

        @Override
        public void kill() {
            super.kill();
            if (this.flightCode != null) {
                this.flightCode.kill();
            }
            if (this.flightTime != null) {
                this.flightTime.kill();
            }
            if (this.message != null) {
                this.message.kill();
            }
            if (this.count != null) {
                this.count.kill();
            }
            this.flightCode = null;
            this.flightTime = null;
            this.message = null;
            this.count = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.flightCode.setEnabled(isEnabled);
            this.flightTime.setEnabled(isEnabled);
            this.icon.setEnabled(isEnabled);
            this.message.setEnabled(isEnabled);
            this.count.setEnabled(isEnabled);
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(ChangeNotificationComplete_.flight).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(ChangeNotificationComplete_.flight).getValue();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(ChangeNotificationComplete_.type).getValue();
                }
                case 3: {
                    return this.model.getNode().getChildNamed(ChangeNotificationComplete_.remark).getValue();
                }
                case 4: {
                    return this.model.getNode().getChildNamed(ChangeNotificationComplete_.difference).getValue();
                }
            }
            return null;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.switchState();
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.flightCode.setLocation(w / 2 - (int)(TableRowImpl.this.flightCode.getPreferredSize().getWidth() / 2.0), (int)(((double)parent.getHeight() - TableRowImpl.this.flightCode.getPreferredSize().getHeight()) / 5.0));
                TableRowImpl.this.flightCode.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.flightCode.getPreferredSize().getHeight());
                TableRowImpl.this.flightTime.setLocation(w / 2 - (int)(TableRowImpl.this.flightTime.getPreferredSize().getWidth() / 2.0), (int)(((double)parent.getHeight() - TableRowImpl.this.flightTime.getPreferredSize().getHeight()) / 5.0 * 4.0));
                TableRowImpl.this.flightTime.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.flightTime.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.icon.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.icon.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.icon.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.icon.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.message.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.message.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.message.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.message.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.count.setLocation(parent.getWidth() - 2 * TableRowImpl.this.getCellPadding() - (int)TableRowImpl.this.count.getPreferredSize().getWidth(), (int)(((double)parent.getHeight() - TableRowImpl.this.count.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.count.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.count.getPreferredSize().getHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            int h = parent.getParent().getHeight();
            int currentX = 0;
            int currentY = 0;
            int endAdded = 0;
            NotificationTable.this.layoutTitle(parent);
            if (NotificationTable.this.hasSkin) {
                if (NotificationTable.this.hasTitle) {
                    currentX = 1;
                    endAdded = 1;
                    currentY += NotificationTable.this.getTitleHeight();
                } else {
                    currentX = 2;
                    endAdded = 2;
                    currentY = 2;
                }
            }
            if (NotificationTable.this.headerRow != null) {
                NotificationTable.this.headerRow.setLocation(currentX, currentY);
                if (NotificationTable.this.headerRow.isPrefSizeSet()) {
                    NotificationTable.this.headerRow.setSize(w - 2 * currentX, (int)NotificationTable.this.headerRow.getPreferredSize().getHeight());
                } else {
                    NotificationTable.this.headerRow.setSize(w - 2 * currentX, NotificationTable.this.headerHeight);
                }
                currentY += NotificationTable.this.headerRow.getHeight();
            }
            if (NotificationTable.this.footerPanel != null) {
                NotificationTable.this.footerPanel.setLocation(0, (int)((double)parent.getHeight() - NotificationTable.this.footerPanel.getPreferredSize().getHeight()));
                NotificationTable.this.footerPanel.setSize(parent.getWidth(), (int)NotificationTable.this.footerPanel.getPreferredSize().getHeight());
                endAdded += NotificationTable.this.footerPanel.getHeight();
            }
            NotificationTable.this.scrollPane.setLocation(currentX, currentY);
            NotificationTable.this.scrollPane.setSize(w - 2 * currentX, h - (currentY + endAdded));
            if (NotificationTable.this.loadingAnimation != null) {
                NotificationTable.this.loadingAnimation.setLocation((int)((double)parent.getWidth() - NotificationTable.this.loadingAnimation.getPreferredSize().getWidth()) / 2, (int)(((double)parent.getHeight() - NotificationTable.this.loadingAnimation.getPreferredSize().getHeight()) / 2.0));
                NotificationTable.this.loadingAnimation.setSize(NotificationTable.this.loadingAnimation.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension d = null;
            int usedHeight = NotificationTable.this.getDefaultRowHeight();
            if (NotificationTable.this.maxRows != -1 && NotificationTable.this.fixHeight) {
                d = new Dimension(30, NotificationTable.this.maxRows * usedHeight);
            } else if (NotificationTable.this.rows != null) {
                int h = 0;
                for (Table2RowPanel p : NotificationTable.this.rows) {
                    h = (int)((double)h + p.getPreferredSize().getHeight());
                    if (!p.isExpanded() || !p.isLayoutInnerChildsSelf()) continue;
                    for (Table2RowPanel p1 : p.getChildren()) {
                        h = (int)((double)h + p1.getPreferredSize().getHeight());
                    }
                }
                d = new Dimension(30, h);
            }
            return d;
        }
    }
}

