/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.changenotificationmanager;

import ch.icit.pegasus.client.converter.ChangeNotificationTypeEConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.DefaultObject2ObjectConverter;
import ch.icit.pegasus.client.converter.IntegerSignedConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.gui.modules.changenotificationmanager.ChangeNotificationManagerModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.changenotificationmanager.details.ChangeNotificationDetailsPanel;
import ch.icit.pegasus.client.gui.modules.changenotificationmanager.details.ChangeNotificationLogPanel;
import ch.icit.pegasus.client.gui.modules.changenotificationmanager.details.ChangeNotificationManualAddPanel;
import ch.icit.pegasus.client.gui.modules.changenotificationmanager.details.ChangeNotificationSpecificationPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.CombinedDetailsParagraph;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.ChangeNotificationSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationComplete_;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationLight;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationLight_;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationStateE;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ChangeNotificationManagerAccess;
import ch.icit.pegasus.server.core.dtos.search.ChangeNotificationSearchConfiguration;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

public class ChangeNotificationManagerModule
extends ScreenTableView<ChangeNotificationLight, ChangeNotificationSearchConfiguration.CHANGE_NOTIFICATION_COLUMN> {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_STATE = "state_filter";
    private static final String FILTER_TYPE = "type_filter";
    private static final String FILTER_FLIGHT = "flight_filter";
    private static final String FILTER_PERIOD = "period_filter";
    private static final String FILTER_CREATED = "created_filter";
    private ChangeNotificationStateE stateSearch;
    private ChangeNotificationTypeE typeSearch;
    private String flightSearchString;
    private PeriodComplete periodSearch;
    private TimestampPeriodComplete createdSearch;
    private static String WITHIN_HOUR = "WITHIN 1 HOUR";
    private static String WITHIN_4_HOURS = "WITHIN 4 HOURS";
    private static String WITHIN_8_HOURS = "WITHIN 8 HOURS";
    private ComboBox createdCombo;

    public ChangeNotificationManagerModule() {
        super(ChangeNotificationLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public boolean isExpanded() {
        return false;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return ChangeNotificationManagerAccess.MODULE_CHANGE_NOTIFICATION_MANAGER;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.createdCombo = new ComboBox();
        this.createdCombo.addItem(Words.ALL);
        this.createdCombo.addItem(WITHIN_HOUR);
        this.createdCombo.addItem(WITHIN_4_HOURS);
        this.createdCombo.addItem(WITHIN_8_HOURS);
        this.createdCombo.setSelectedItem(Words.ALL);
        this.filterChain.setSearchTextField2Width(200);
        this.filterChain.addSelectionComboBox(ComboBoxFactory.getChangeNotificationStateComboBox(true), FILTER_STATE, Words.STATE, Words.ALL);
        this.filterChain.addSelectionComboBox(ComboBoxFactory.getChangeNotificationTypeComboBox(true), FILTER_TYPE, Words.TYPE, Words.ALL);
        this.filterChain.addSearchField(FILTER_FLIGHT, Words.FLIGHT, "");
        TitledPeriodEditor periodEditor = this.filterChain.addPeriodSelection(FILTER_PERIOD, new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()), "", true);
        periodEditor.setCheckBoxEnabled();
        this.filterChain.addSelectionComboBox(this.createdCombo, 200, FILTER_CREATED, Words.CREATED_WITHIN, Words.ALL);
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<ChangeNotificationLight, ChangeNotificationSearchConfiguration.CHANGE_NOTIFICATION_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean emptyConfig, Component source) {
        if (isReset) {
            this.stateSearch = null;
            this.typeSearch = null;
            this.flightSearchString = null;
            this.periodSearch = null;
            this.createdSearch = null;
        } else if (name == FILTER_STATE) {
            this.stateSearch = value instanceof ChangeNotificationStateE ? (ChangeNotificationStateE)value : null;
        } else if (name == FILTER_TYPE) {
            this.typeSearch = value instanceof ChangeNotificationTypeE ? (ChangeNotificationTypeE)value : null;
        } else if (name == FILTER_FLIGHT) {
            this.flightSearchString = (String)value;
        } else if (name == FILTER_PERIOD) {
            this.periodSearch = value instanceof Node ? (PeriodComplete)((Node)value).getValue() : (value instanceof PeriodComplete ? (PeriodComplete)value : (value instanceof TitledPeriodEditor ? ((TitledPeriodEditor)value).getPeriod() : null));
        } else if (name == FILTER_CREATED) {
            DateTime start;
            DateTime end = new DateTime();
            if (value == WITHIN_HOUR) {
                start = new DateTime().minusHours(1);
                this.createdSearch = new TimestampPeriodComplete(new Timestamp(start.getMillis()), new Timestamp(end.getMillis()));
            } else if (value == WITHIN_4_HOURS) {
                start = new DateTime().minusHours(4);
                this.createdSearch = new TimestampPeriodComplete(new Timestamp(start.getMillis()), new Timestamp(end.getMillis()));
            } else if (value == WITHIN_8_HOURS) {
                start = new DateTime().minusHours(8);
                this.createdSearch = new TimestampPeriodComplete(new Timestamp(start.getMillis()), new Timestamp(end.getMillis()));
            } else {
                this.createdSearch = null;
            }
        }
        ChangeNotificationSearchConfiguration c = new ChangeNotificationSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        c.setState(this.stateSearch);
        c.setType(this.typeSearch);
        if (this.flightSearchString != null) {
            c.setFlightNumber(this.flightSearchString);
        }
        if (this.periodSearch != null) {
            c.setPeriod(this.periodSearch);
        }
        c.setCreated(this.createdSearch);
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.createdCombo.kill();
        this.createdCombo = null;
    }

    @Override
    public boolean isDeletable(RowModel<ChangeNotificationLight> model) {
        if (model.getNode() != null && model.getNode().getValue() != null) {
            ChangeNotificationLight changeNotification = (ChangeNotificationLight)model.getNode().getValue();
            return changeNotification.getState() == ChangeNotificationStateE.OPEN;
        }
        return false;
    }

    @Override
    protected RowEditorFactory<ChangeNotificationLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<ChangeNotificationLight> rowEditor = new MessageProvidedRowEditor<ChangeNotificationLight>(model, "");
            boolean addRow = model.isAddRow();
            RDProvider p = this.createProvider(addRow);
            if (addRow) {
                ChangeNotificationManualAddPanel detailsPanel2 = new ChangeNotificationManualAddPanel((RowEditor<ChangeNotificationLight>)rowEditor, p);
                CombinedDetailsParagraph c1 = new CombinedDetailsParagraph();
                c1.add((Component)detailsPanel2, new TableLayoutConstraint(1, 1, 1.0, 1.0));
                rowEditor.add(c1, (Object)new TableLayoutConstraint(0, 1, 1.0, 1.0));
                rowEditor.addToFocusQueue(c1);
                rowEditor.addToFocusQueue(detailsPanel2);
            } else {
                ChangeNotificationSpecificationPanel detailsPanel1 = new ChangeNotificationSpecificationPanel((RowEditor<ChangeNotificationLight>)rowEditor, p);
                ChangeNotificationDetailsPanel detailsPanel2 = new ChangeNotificationDetailsPanel((RowEditor<ChangeNotificationLight>)rowEditor, p);
                ChangeNotificationLogPanel detailsPanel3 = new ChangeNotificationLogPanel((RowEditor<ChangeNotificationLight>)rowEditor, p);
                CombinedDetailsParagraph c1 = new CombinedDetailsParagraph();
                c1.add((Component)detailsPanel1, new TableLayoutConstraint(0, 1, 0.333, 1.0));
                c1.add((Component)detailsPanel2, new TableLayoutConstraint(1, 1, 0.333, 1.0));
                c1.add((Component)detailsPanel3, new TableLayoutConstraint(2, 1, 0.333, 1.0));
                rowEditor.add(c1, (Object)new TableLayoutConstraint(0, 1, 1.0, 1.0));
                rowEditor.addToFocusQueue(c1);
                rowEditor.addToFocusQueue(detailsPanel1);
                rowEditor.addToFocusQueue(detailsPanel2);
                rowEditor.addToFocusQueue(detailsPanel3);
            }
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new ChangeNotificationManagerModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.STATE, "", (Class)DefaultObject2ObjectConverter.class, (Enum<?>)ChangeNotificationSearchConfiguration.CHANGE_NOTIFICATION_COLUMN.STATE, ChangeNotificationComplete_.state, TableColumnInfo.state2WithExpandWidth, TableColumnInfo.state2WithExpandWidth, TableColumnInfo.state2WithExpandWidth));
        columns.add(new TableColumnInfo(Words.TYPE, "", (Class)ChangeNotificationTypeEConverter.class, (Enum<?>)ChangeNotificationSearchConfiguration.CHANGE_NOTIFICATION_COLUMN.TYPE, ChangeNotificationComplete_.type, 80, 80, 80));
        columns.add(new TableColumnInfo(Words.OUTBOUND, "", StringConverter.class, null, ChangeNotificationLight_.outboundCode, 80, 80, 80));
        columns.add(new TableColumnInfo(Words.STD, "", DateTimeConverter.class, null, ChangeNotificationLight_.std, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
        columns.add(new TableColumnInfo(Words.CONTENT, "", StringConverter.class, null, ChangeNotificationComplete_.remark, 100, Integer.MAX_VALUE, 100));
        columns.add(new TableColumnInfo(Words.UPDATE, "", IntegerSignedConverter.class, null, ChangeNotificationComplete_.difference, 65, 65, 65));
        columns.add(new TableColumnInfo(Words.CREATED_AT, "", (Class)DateTimeConverter.class, (Enum<?>)ChangeNotificationSearchConfiguration.CHANGE_NOTIFICATION_COLUMN.CREATED, ChangeNotificationComplete_.creationTimestamp, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
        columns.add(new TableColumnInfo(Words.PROCESSED_AT, "", DateTimeConverter.class, null, ChangeNotificationComplete_.processedAtTimestamp, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
        return columns;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<ChangeNotificationLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(ChangeNotificationSearchAlgorithm.class);
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<ChangeNotificationLight> model) {
        return model != null && model.getDTO(ChangeNotificationLight.class) != null && model.getDTO(ChangeNotificationLight.class).getState().equals((Object)ChangeNotificationStateE.OPEN);
    }
}

