/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.changenotificationmanager.details;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationComplete_;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class ChangeNotificationLogPanel
extends DefaultDetailsPanel<ChangeNotificationLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> createdAt;
    private TitledItem<TextLabel> createdBy;
    private TitledItem<TextLabel> processedAt;
    private TitledItem<TextLabel> processedBy;

    public ChangeNotificationLogPanel(RowEditor<ChangeNotificationLight> editor, RDProvider provider) {
        super(editor, provider);
        boolean isAddRow = editor.getModel().isAddRow();
        String title = Words.LOG;
        this.setTitleText(title);
        this.setCustomLayouter(new Layout());
        this.createdAt = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(DateTimeConverter.class)), Words.CREATED_AT, TitledItem.TitledItemOrientation.NORTH);
        this.createdAt.getElement().setReadOnlyTextField(true);
        this.createdBy = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(UserConverter.class)), Words.CREATED_BY, TitledItem.TitledItemOrientation.NORTH);
        this.createdBy.getElement().setReadOnlyTextField(true);
        this.processedAt = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(DateTimeConverter.class)), Words.PROCESSED_AT, TitledItem.TitledItemOrientation.NORTH);
        this.processedAt.getElement().setReadOnlyTextField(true);
        this.processedBy = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(UserConverter.class)), Words.PROCESSED_BY, TitledItem.TitledItemOrientation.NORTH);
        this.processedBy.getElement().setReadOnlyTextField(true);
        this.addToView(this.createdAt);
        this.addToView(this.createdBy);
        this.addToView(this.processedAt);
        this.addToView(this.processedBy);
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.createdAt.getElement().setNode(node.getChildNamed(ChangeNotificationComplete_.creationTimestamp));
        this.createdBy.getElement().setNode(node.getChildNamed(ChangeNotificationComplete_.creationUser));
        this.processedAt.getElement().setNode(node.getChildNamed(ChangeNotificationComplete_.processedAtTimestamp));
        this.processedBy.getElement().setNode(node.getChildNamed(ChangeNotificationComplete_.processedByUser));
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.createdAt.setEnabled(isEnabled);
        this.createdBy.setEnabled(isEnabled);
        this.processedAt.setEnabled(isEnabled);
        this.processedBy.setEnabled(isEnabled);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    @Override
    public boolean grabsFocus() {
        return !this.editor.getModel().isAddRow();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.createdAt);
        CheckedListAdder.addToList(focusList, this.createdBy);
        CheckedListAdder.addToList(focusList, this.processedBy);
        CheckedListAdder.addToList(focusList, this.processedBy);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.createdAt.kill();
        this.createdBy.kill();
        this.processedAt.kill();
        this.processedBy.kill();
        this.createdAt = null;
        this.createdBy = null;
        this.processedAt = null;
        this.processedBy = null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.createdAt.requestFocusInWindowNow();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth() - 2 * ChangeNotificationLogPanel.this.horizontalBorder;
            ChangeNotificationLogPanel.this.createdAt.setLocation(ChangeNotificationLogPanel.this.horizontalBorder, ChangeNotificationLogPanel.this.verticalBorder);
            ChangeNotificationLogPanel.this.createdAt.setSize((w -= ChangeNotificationLogPanel.this.inner_horizontalBorder / 2) + ChangeNotificationLogPanel.this.inner_horizontalBorder / 2, (int)ChangeNotificationLogPanel.this.createdAt.getPreferredSize().getHeight());
            ChangeNotificationLogPanel.this.createdBy.setLocation(ChangeNotificationLogPanel.this.horizontalBorder, ChangeNotificationLogPanel.this.createdAt.getY() + ChangeNotificationLogPanel.this.createdAt.getHeight() + ChangeNotificationLogPanel.this.inner_verticalBorder);
            ChangeNotificationLogPanel.this.createdBy.setSize(w + ChangeNotificationLogPanel.this.inner_horizontalBorder / 2, (int)ChangeNotificationLogPanel.this.createdBy.getPreferredSize().getHeight());
            ChangeNotificationLogPanel.this.processedAt.setLocation(ChangeNotificationLogPanel.this.horizontalBorder, ChangeNotificationLogPanel.this.createdBy.getY() + ChangeNotificationLogPanel.this.createdBy.getHeight() + ChangeNotificationLogPanel.this.inner_verticalBorder);
            ChangeNotificationLogPanel.this.processedAt.setSize(w + ChangeNotificationLogPanel.this.inner_horizontalBorder / 2, (int)ChangeNotificationLogPanel.this.processedAt.getPreferredSize().getHeight());
            ChangeNotificationLogPanel.this.processedBy.setLocation(ChangeNotificationLogPanel.this.horizontalBorder, ChangeNotificationLogPanel.this.processedAt.getY() + ChangeNotificationLogPanel.this.processedAt.getHeight() + ChangeNotificationLogPanel.this.inner_verticalBorder);
            ChangeNotificationLogPanel.this.processedBy.setSize(w + ChangeNotificationLogPanel.this.inner_horizontalBorder / 2, (int)ChangeNotificationLogPanel.this.processedBy.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int currentY = ChangeNotificationLogPanel.this.verticalBorder;
            currentY = (int)((double)currentY + (ChangeNotificationLogPanel.this.createdAt.getPreferredSize().getHeight() + (double)ChangeNotificationLogPanel.this.verticalBorder));
            currentY = (int)((double)currentY + (ChangeNotificationLogPanel.this.createdBy.getPreferredSize().getHeight() + (double)ChangeNotificationLogPanel.this.verticalBorder));
            currentY = (int)((double)currentY + (ChangeNotificationLogPanel.this.processedAt.getPreferredSize().getHeight() + (double)ChangeNotificationLogPanel.this.verticalBorder));
            currentY = (int)((double)currentY + (ChangeNotificationLogPanel.this.processedBy.getPreferredSize().getHeight() + (double)ChangeNotificationLogPanel.this.verticalBorder));
            return new Dimension(0, currentY);
        }
    }
}

