/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.chargetracking2.details;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.QuantityConverter2Decimal;
import ch.icit.pegasus.client.converter.StorePositionShortNameConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2HeaderPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.TableRowLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete_;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete_;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class BatchesDetailsPanel
extends TableDetailsPanel<ArticleChargeLight> {
    public BatchesDetailsPanel(RowEditor<ArticleChargeLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText("Stock");
    }

    @Override
    public void setNode(Node<?> node) {
        this.table.getModel().setNode(node.getChildNamed(ArticleChargeComplete_.batches));
        this.table.updateTable();
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.STORE_POSITION, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.QUANTITY, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.LAST_INVENTORY, null, null, null, "", TableColumnInfo.dateTimeColumnWidth));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.3);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.3);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.3);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setTitleText(Words.BATCHES);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void childRemoved() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        if (isHeader) {
            return new Table2HeaderPanel(model, 7);
        }
        return new BatchTableRowImpl(model);
    }

    private class BatchTableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel position;
        private TextLabel quantity;
        private TextLabel lastInventory;

        public BatchTableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new InnerLayout());
            this.position = new TextLabel(m.getNode().getChildNamed(ArticleChargeBatchComplete_.position), ConverterRegistry.getConverter(StorePositionShortNameConverter.class));
            this.quantity = new TextLabel(m.getNode().getChildNamed(ArticleChargeBatchComplete_.quantity), ConverterRegistry.getConverter(QuantityConverter2Decimal.class));
            this.lastInventory = new TextLabel(m.getNode().getChildNamed(ArticleChargeBatchComplete_.lastInventory), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.add(this.position);
            this.add(this.quantity);
            this.add(this.lastInventory);
        }

        @Override
        public void updateRow(Node<?> node) {
            this.lastInventory.updateString();
            this.quantity.updateString();
            this.position.updateString();
        }

        @Override
        public Object getObject4Column(int column) {
            return this.position.getText();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.position.setEnabled(isEnabled);
            this.quantity.setEnabled(isEnabled);
            this.lastInventory.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.position.kill();
            this.position = null;
            this.quantity.kill();
            this.quantity = null;
            this.lastInventory.kill();
            this.lastInventory = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            return new ArrayList<Component>();
        }

        private class InnerLayout
        extends TableRowLayout {
            private InnerLayout() {
            }

            @Override
            public List<JComponent> getComponentsOrder() {
                ArrayList<JComponent> list = new ArrayList<JComponent>();
                list.add(BatchTableRowImpl.this.position);
                list.add(BatchTableRowImpl.this.quantity);
                list.add(BatchTableRowImpl.this.lastInventory);
                return list;
            }

            @Override
            public Table2RowPanel getTableRowPanel() {
                return BatchTableRowImpl.this;
            }
        }
    }
}

