/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.chargetracking2.details;

import ch.icit.pegasus.client.converter.ArticleOriginConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.QuantityConverter2Decimal;
import ch.icit.pegasus.client.converter.UnitConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.HACCPButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.ViewButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.inserts.HACCPCheckPopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.OPRPCheckPopUpInsert;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDInputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleOriginComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitSystemComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.ordering.haccp.PurchaseOrderPositionHACCPLogComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ChargeAccess;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete_;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight_;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityBaseComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SpecificationDetailsPanel
extends DefaultDetailsPanel<ArticleChargeLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> number;
    private TitledItem<TextLabel> quantity;
    private TitledItem<TextLabel> creationDate;
    private TitledItem<RDDateChooser> expiryDate;
    private TitledItem<RDDateChooser> currencyDate;
    private TitledItem<RDComboBox> originCountry;
    private TitledItem<RDInputComboBox> priceAndUnit;
    private TitledItem<RDComboBox> priceUnit;
    private InfoButton infoButton;
    private TitledItem<HACCPButton> oprp;
    private TitledItem<ViewButton> downloadPoPDF;
    private TitledItem<RDCheckBox> customsDeadlineArticle;
    private Node<ArticleChargeComplete> node;

    public SpecificationDetailsPanel(RowEditor<ArticleChargeLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.CHARGES_DETAILS);
        this.number = new TitledItem<TextLabel>(new TextLabel(), Words.getAllFirstCapitalLetters((String)Words.NO_NUMBER), TitledItem.TitledItemOrientation.NORTH);
        this.creationDate = new TitledItem<TextLabel>(new TextLabel(), Words.getAllFirstCapitalLetters((String)Words.CREATION_DATE), TitledItem.TitledItemOrientation.NORTH);
        this.creationDate.getElement().setViewConverter(ConverterRegistry.getConverter(DateConverter.class));
        this.expiryDate = new TitledItem<RDDateChooser>(new RDDateChooser(provider), Words.getAllFirstCapitalLetters((String)Words.EXPIRY_DATE), TitledItem.TitledItemOrientation.NORTH);
        this.expiryDate.getElement().setCheckBoxEnabled();
        this.originCountry = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(ArticleOriginConverter.class), true), Words.ORIGIN, TitledItem.TitledItemOrientation.NORTH);
        if (Boolean.TRUE.equals(this.viewSettings.getShowCustomsDeadline())) {
            this.customsDeadlineArticle = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "Customs Deadline Article", TitledItem.TitledItemOrientation.EAST);
        }
        this.currencyDate = new TitledItem<RDDateChooser>(new RDDateChooser(provider), Words.CURRENCY_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.quantity = new TitledItem<TextLabel>(new TextLabel(), Words.getAllFirstCapitalLetters((String)Words.QUANTITY), TitledItem.TitledItemOrientation.NORTH);
        this.quantity.getElement().setViewConverter(ConverterRegistry.getConverter(QuantityConverter2Decimal.class));
        this.priceAndUnit = new TitledItem<RDInputComboBox>(new RDInputComboBox(provider, null, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE), Words.getAllFirstCapitalLetters((String)Words.PRICE), TitledItem.TitledItemOrientation.NORTH);
        this.priceAndUnit.getElement().setOverrideName(ChargeAccess.CHANGE_PRICE);
        this.priceAndUnit.getElement().setMaxKommaStellen(3);
        this.priceUnit = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(UnitConverter.class)), Words.UNIT, TitledItem.TitledItemOrientation.NORTH);
        this.priceUnit.getElement().setOverrideName(ChargeAccess.CHANGE_PRICE);
        this.infoButton = new InfoButton();
        this.oprp = new TitledItem<HACCPButton>(new HACCPButton(), "OPRP Data", TitledItem.TitledItemOrientation.EAST);
        this.oprp.getElement().addButtonListener((source, x, y) -> this.showOPRP(source, x, y));
        this.downloadPoPDF = new TitledItem<ViewButton>(new ViewButton(), "Purchase PDF", TitledItem.TitledItemOrientation.NORTH);
        this.downloadPoPDF.getElement().addButtonListener((source, x, y) -> this.downloadPDF());
        this.addToView(this.number);
        this.addToView(this.creationDate);
        this.addToView(this.expiryDate);
        this.addToView(this.quantity);
        this.addToView(this.priceAndUnit);
        this.addToView(this.currencyDate);
        this.addToView(this.originCountry);
        if (this.customsDeadlineArticle != null) {
            this.addToView(this.customsDeadlineArticle);
        }
        this.addToView(this.infoButton);
        this.addToView(this.priceUnit);
        this.addToView(this.oprp);
        this.addToView(this.downloadPoPDF);
        this.setCustomLayouter(new Layout());
    }

    private void downloadPDF() {
        this.setEnabled(false);
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                ArticleChargeComplete charge = (ArticleChargeComplete)SpecificationDetailsPanel.this.node.getValue(ArticleChargeComplete.class);
                DocumentScanComplete documentScan = (DocumentScanComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).findScanDocument(new ArticleChargeReference(charge.getId())).getValue();
                PegasusFileComplete file = documentScan.getFileData();
                File downloaded = null;
                if (file != null) {
                    downloaded = FileTransferUtil.download((PegasusFileComplete)file, (FileTransferListener[])new FileTransferListener[0]);
                }
                ViewNode fileNode = new ViewNode("");
                fileNode.setValue((Object)downloaded, 0L);
                return fileNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        File file = (File)node.getValue();
                        if (file != null) {
                            try {
                                Desktop.getDesktop().open(file);
                            }
                            catch (IOException e) {
                                InnerPopupFactory.showErrorDialog(e, (Component)SpecificationDetailsPanel.this);
                            }
                        } else {
                            InnerPopupFactory.showErrorDialog("Purchase PDF scan for charge not found", (Component)SpecificationDetailsPanel.this);
                        }
                        SpecificationDetailsPanel.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog("Unable to load Purchase PDF for charge", (Component)SpecificationDetailsPanel.this);
                        SpecificationDetailsPanel.this.setEnabled(true);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void showOPRP(Button source, int x, int y) {
        ArticleChargeComplete charge = (ArticleChargeComplete)this.node.getValue(ArticleChargeComplete.class);
        PurchaseOrderPositionHACCPLogComplete haccpLog = charge.getHaccpLog();
        if (haccpLog == null) {
            haccpLog = new PurchaseOrderPositionHACCPLogComplete();
            haccpLog.setTruckType("");
            haccpLog.setTruckOk(Boolean.valueOf(false));
            haccpLog.setTemperature(Double.valueOf(-1.0));
            haccpLog.setQualityCondition(Boolean.valueOf(false));
            haccpLog.setOkState(Boolean.valueOf(false));
            haccpLog.setHalalState(charge.getBasicArticle().getHalal());
            haccpLog.setFrozenState(Boolean.valueOf(ArticleToolkit.isFrozenArticle(charge.getBasicArticle())));
            haccpLog.setExpiryDate(charge.getExpiryDate());
            haccpLog.setComment("");
            haccpLog.setChilledState(Boolean.valueOf(ArticleToolkit.isChilledArticle(charge.getBasicArticle())));
            haccpLog.setChargeNo("");
            haccpLog.setPurchaseCharge(Boolean.valueOf(Boolean.TRUE.equals(charge.getBasicArticle().getPurchaseCharge())));
            haccpLog.setNoPurchaseChargeText("NC");
            haccpLog.setCheckDate(new Date(System.currentTimeMillis()));
            haccpLog.setUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
            haccpLog.setNoExpiryDate(charge.getBasicArticle().getNoExpiryDate());
            haccpLog.setPurchaseCharge(charge.getBasicArticle().getPurchaseCharge());
        }
        InnerPopupFactory.showHACCPLog(false, null, source, charge.getBasicArticle(), null, null, x, y, new HACCPCheckPopUpInsert.ParameterObject(haccpLog, (ArticleChargeLight)charge), new OPRPCheckPopUpInsert.ParameterObject(haccpLog, (ArticleChargeLight)charge), false, null, false, false);
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public void setNode(Node<?> node) {
        this.node = node;
        this.number.getElement().setNode(node.getChildNamed(ArticleChargeComplete_.number));
        this.creationDate.getElement().setNode(node.getChildNamed(ArticleChargeComplete_.creationDate));
        this.expiryDate.getElement().setNode(node.getChildNamed(ArticleChargeComplete_.expiryDate));
        this.quantity.getElement().setNode(node.getChildNamed(ArticleChargeComplete_.quantity));
        this.priceAndUnit.getElement().setNode(node.getChildNamed(new DtoField[]{ArticleChargeComplete_.price, PriceComplete_.price}), node.getChildNamed(new DtoField[]{ArticleChargeComplete_.price, PriceComplete_.currency}));
        Iterator it = node.getChildNamed(new DtoField[]{ArticleChargeComplete_.basicArticle, BasicArticleComplete_.packingQuantitiesVariants}).getFailSafeChildIterator();
        HashSet<UnitComplete> units = new HashSet<UnitComplete>();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            Iterator it2 = n.getChildNamed(PackagingQuantityBaseComplete_.packingQuantities).getFailSafeChildIterator();
            while (it2.hasNext()) {
                Node p = (Node)it2.next();
                UnitComplete unit = (UnitComplete)p.getChildNamed(PackagingQuantityComplete_.unit).getValue();
                units.addAll(this.getUnitsForUnitSystem(unit.getUnitSystem()));
            }
        }
        HashMap childIndex = new HashMap();
        Node unitsNode = new Node();
        for (UnitComplete unit : units) {
            if (childIndex.containsKey(unit)) continue;
            unitsNode.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)unit, true, true), 0L);
        }
        this.priceUnit.getElement().refreshPossibleValues(unitsNode);
        this.priceUnit.getElement().setNode(node.getChildNamed(ArticleChargeComplete_.priceUnit));
        this.originCountry.getElement().refreshPossibleValues(NodeToolkit.getAffixList(ArticleOriginComplete.class));
        this.originCountry.getElement().setNode(node.getChildNamed(ArticleChargeLight_.origin));
        if (this.customsDeadlineArticle != null) {
            this.customsDeadlineArticle.getElement().setNode(node.getChildNamed(ArticleChargeLight_.deadlineArticle));
        }
        this.currencyDate.getElement().setNode(node.getChildNamed(ArticleChargeComplete_.currencyDate));
        this.infoButton.installStringViewer(ArticleToolkit.getArticleInfoPopupString((BasicArticleComplete)node.getChildNamed(ArticleChargeLight_.basicArticle).getValue(BasicArticleComplete.class), (Timestamp)node.getChildNamed(ArticleChargeComplete_.creationDate).getValue(), 11));
    }

    private Set<UnitComplete> getUnitsForUnitSystem(UnitSystemComplete unitSystem) {
        UnitComplete unit;
        HashSet<UnitComplete> units = new HashSet<UnitComplete>();
        for (unit = unitSystem.getBaseUnit(); unit != null; unit = unit.getSubUnit()) {
            units.add(unit);
        }
        for (unit = unitSystem.getBaseUnit(); unit != null; unit = unit.getSuperUnit()) {
            units.add(unit);
        }
        return units;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.number.kill();
        this.quantity.kill();
        this.creationDate.kill();
        this.expiryDate.kill();
        this.currencyDate.kill();
        this.priceAndUnit.kill();
        this.priceUnit.kill();
        this.originCountry.kill();
        if (this.customsDeadlineArticle != null) {
            this.customsDeadlineArticle.kill();
        }
        this.infoButton.kill();
        this.oprp.kill();
        this.downloadPoPDF.kill();
        this.number = null;
        this.quantity = null;
        this.creationDate = null;
        this.expiryDate = null;
        this.currencyDate = null;
        this.priceAndUnit = null;
        this.priceUnit = null;
        this.customsDeadlineArticle = null;
        this.originCountry = null;
        this.infoButton = null;
        this.oprp = null;
        this.downloadPoPDF = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.quantity.setEnabled(isEnabled);
        this.creationDate.setEnabled(isEnabled);
        this.expiryDate.setEnabled(isEnabled);
        this.priceAndUnit.setEnabled(isEnabled);
        this.priceUnit.setEnabled(isEnabled);
        this.number.setEnabled(isEnabled);
        this.currencyDate.setEnabled(isEnabled);
        this.originCountry.setEnabled(isEnabled);
        if (this.customsDeadlineArticle != null) {
            this.customsDeadlineArticle.setEnabled(isEnabled);
        }
        this.infoButton.setEnabled(isEnabled);
        this.oprp.setEnabled(isEnabled);
        this.downloadPoPDF.setEnabled(isEnabled);
    }

    public void reset() {
        this.number.getElement().setText("");
        this.creationDate.getElement().setText("");
        this.quantity.getElement().setText("");
        this.priceAndUnit.getElement().getValueNode().setValue(null, 0L);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(350, 350);
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            SpecificationDetailsPanel.this.number.setLocation(border, border);
            SpecificationDetailsPanel.this.number.setSize((int)SpecificationDetailsPanel.this.number.getPreferredSize().getWidth(), (int)SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.creationDate.setLocation(SpecificationDetailsPanel.this.number.getX() + SpecificationDetailsPanel.this.number.getWidth() + border, border);
            SpecificationDetailsPanel.this.creationDate.setSize(TableColumnInfo.dateColumnWidth, (int)SpecificationDetailsPanel.this.creationDate.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.infoButton.setLocation(SpecificationDetailsPanel.this.creationDate.getX() + SpecificationDetailsPanel.this.creationDate.getWidth() + border / 2, SpecificationDetailsPanel.this.creationDate.getY() + 25);
            SpecificationDetailsPanel.this.infoButton.setSize(SpecificationDetailsPanel.this.infoButton.getPreferredSize());
            SpecificationDetailsPanel.this.oprp.setLocation(SpecificationDetailsPanel.this.infoButton.getX() + SpecificationDetailsPanel.this.infoButton.getWidth() + border, SpecificationDetailsPanel.this.infoButton.getY());
            SpecificationDetailsPanel.this.oprp.setSize(SpecificationDetailsPanel.this.oprp.getPreferredSize());
            SpecificationDetailsPanel.this.originCountry.setLocation(SpecificationDetailsPanel.this.number.getX(), SpecificationDetailsPanel.this.number.getY() + SpecificationDetailsPanel.this.number.getHeight() + border);
            SpecificationDetailsPanel.this.originCountry.setSize(200, (int)SpecificationDetailsPanel.this.originCountry.getPreferredSize().getHeight());
            int cy = SpecificationDetailsPanel.this.originCountry.getY() + SpecificationDetailsPanel.this.originCountry.getHeight() + border;
            if (SpecificationDetailsPanel.this.customsDeadlineArticle != null) {
                SpecificationDetailsPanel.this.customsDeadlineArticle.setLocation(SpecificationDetailsPanel.this.originCountry.getX(), cy);
                SpecificationDetailsPanel.this.customsDeadlineArticle.setSize(SpecificationDetailsPanel.this.customsDeadlineArticle.getPreferredSize());
                cy = SpecificationDetailsPanel.this.customsDeadlineArticle.getY() + SpecificationDetailsPanel.this.customsDeadlineArticle.getHeight() + border;
            }
            SpecificationDetailsPanel.this.currencyDate.setLocation(SpecificationDetailsPanel.this.originCountry.getX(), cy);
            SpecificationDetailsPanel.this.currencyDate.setSize(SpecificationDetailsPanel.this.currencyDate.getPreferredSize());
            SpecificationDetailsPanel.this.expiryDate.setLocation(SpecificationDetailsPanel.this.currencyDate.getX(), SpecificationDetailsPanel.this.currencyDate.getY() + SpecificationDetailsPanel.this.currencyDate.getHeight() + border);
            SpecificationDetailsPanel.this.expiryDate.setSize(SpecificationDetailsPanel.this.expiryDate.getPreferredSize());
            SpecificationDetailsPanel.this.quantity.setLocation(SpecificationDetailsPanel.this.expiryDate.getX(), SpecificationDetailsPanel.this.expiryDate.getY() + SpecificationDetailsPanel.this.expiryDate.getHeight() + border);
            SpecificationDetailsPanel.this.quantity.setSize(100, (int)SpecificationDetailsPanel.this.quantity.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.priceAndUnit.setLocation(SpecificationDetailsPanel.this.quantity.getX() + SpecificationDetailsPanel.this.quantity.getWidth() + border, SpecificationDetailsPanel.this.quantity.getY());
            SpecificationDetailsPanel.this.priceAndUnit.setSize(110, (int)SpecificationDetailsPanel.this.priceAndUnit.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.priceUnit.setLocation(SpecificationDetailsPanel.this.priceAndUnit.getX() + SpecificationDetailsPanel.this.priceAndUnit.getWidth() + border, SpecificationDetailsPanel.this.priceAndUnit.getY());
            SpecificationDetailsPanel.this.priceUnit.setSize(100, (int)SpecificationDetailsPanel.this.priceUnit.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.downloadPoPDF.setLocation(border, SpecificationDetailsPanel.this.quantity.getY() + SpecificationDetailsPanel.this.quantity.getHeight() + border);
            SpecificationDetailsPanel.this.downloadPoPDF.setSize(SpecificationDetailsPanel.this.downloadPoPDF.getPreferredSize());
        }
    }
}

