/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.checkin.article;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.CustomsDocumentListConverter;
import ch.icit.pegasus.client.converter.CustomsDocumentTypeConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.checkin.article.GroupStockCheckinModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.checkin.article.details.ArticleDetailsPanel;
import ch.icit.pegasus.client.gui.modules.checkin.article.details.CheckinTemplateDetailsPanel;
import ch.icit.pegasus.client.gui.modules.checkin.article.details.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.minicombobox.MiniComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.minicombobox.MiniComboBoxConfiguration;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.ConfigurableSearchTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.StoreCheckinSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CustomsDocumentTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.GroupCheckInAccess;
import ch.icit.pegasus.server.core.dtos.search.StockCheckInOutGroupSearchTypeE;
import ch.icit.pegasus.server.core.dtos.search.StockCheckinGroupSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupLight;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupLight_;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class GroupStockCheckinModule
extends ScreenTableView<StockCheckinGroupLight, StockCheckinGroupSearchConfiguration.STOCK_CHECK_IN_GROUP_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_NUMBER_NAME_CUSDOCID = "number_name_customsDocumentId_filters";
    private static final String FILTER_DATE = "date_filter";
    private static final String FILTER_COSTCENTER = "costcenter";
    private static final String FILTER_CUSTOMS_DOC_TYPE = "customs_document_type";
    private String searchCriteria1 = null;
    private StockCheckInOutGroupSearchTypeE filterCriteria1;
    private PeriodComplete searchCriteria2 = null;
    private CostCenterComplete searchCriteria4;
    private CustomsDocumentTypeComplete searchCriteria5;
    private ComboBox costCenters;
    private ComboBox customsDocumentTypes;
    private TitledPeriodEditor period;

    public GroupStockCheckinModule() {
        super(StockCheckinGroupLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.period.kill();
        this.period = null;
        this.costCenters.kill();
        this.costCenters = null;
        this.customsDocumentTypes.kill();
        this.customsDocumentTypes = null;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return GroupCheckInAccess.MODULE_CHECK_IN_GROUPED;
    }

    public GroupStockCheckinModuleDataHandler getDataHandler() {
        return (GroupStockCheckinModuleDataHandler)this.getTable().getModel().getDataHandler();
    }

    public boolean isChargeBased() {
        return true;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", StockCheckinGroupSearchConfiguration.STOCK_CHECK_IN_GROUP_COLUMN.NUMBER + "<>" + true);
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        MiniComboBoxConfiguration mcbc = new MiniComboBoxConfiguration(StockCheckInOutGroupSearchTypeE.ALL);
        MiniComboBox mcomboBox = new MiniComboBox();
        mcomboBox.setVisible(true);
        mcomboBox.addItem(StockCheckInOutGroupSearchTypeE.ALL, mcbc.getPicture(StockCheckInOutGroupSearchTypeE.ALL));
        mcomboBox.addItem(StockCheckInOutGroupSearchTypeE.NAME, mcbc.getPicture(StockCheckInOutGroupSearchTypeE.NAME));
        mcomboBox.addItem(StockCheckInOutGroupSearchTypeE.NUMBER, mcbc.getPicture(StockCheckInOutGroupSearchTypeE.NUMBER));
        mcomboBox.addItem(StockCheckInOutGroupSearchTypeE.CUSTOMS_DOCUMENT_ID, mcbc.getPicture(StockCheckInOutGroupSearchTypeE.CUSTOMS_DOCUMENT_ID));
        mcomboBox.setSelectedItem(StockCheckInOutGroupSearchTypeE.ALL);
        this.filterChain.addConfigurableSearchField(FILTER_NUMBER_NAME_CUSDOCID, Words.NAME_OR_NUMBER, "", mcomboBox);
        this.costCenters = new ComboBox(null, null, ConverterRegistry.getConverter(CostCenterConverter.class));
        this.filterChain.addSelectionComboBox(this.costCenters, FILTER_COSTCENTER, Words.DEPARTMENT, Words.ALL);
        PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
        this.period = this.filterChain.addPeriodSelection(FILTER_DATE, p.getStartDate(), p.getEndDate(), null, true);
        this.period.setCheckBoxEnabled();
        this.customsDocumentTypes = new ComboBox(null, null, ConverterRegistry.getConverter(CustomsDocumentTypeConverter.class));
        this.filterChain.addSelectionComboBox(this.customsDocumentTypes, FILTER_CUSTOMS_DOC_TYPE, Words.CUSTOMS_DOCUMENT_TYPE, Words.ALL);
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<StockCheckinGroupLight, StockCheckinGroupSearchConfiguration.STOCK_CHECK_IN_GROUP_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.searchCriteria1 = null;
            this.searchCriteria2 = null;
            this.searchCriteria4 = null;
            this.searchCriteria5 = null;
            this.filterCriteria1 = null;
            this.period.setCheckBoxChecked(false);
        } else if (name == FILTER_DATE) {
            TitledPeriodEditor ed = (TitledPeriodEditor)value;
            PeriodComplete per = new PeriodComplete();
            per.setStartDate(ed.getStartDate());
            per.setEndDate(ed.getEndDate());
            this.searchCriteria2 = per;
        } else if (name == FILTER_NUMBER_NAME_CUSDOCID) {
            ConfigurableSearchTextField textfield = (ConfigurableSearchTextField)source;
            this.filterCriteria1 = (StockCheckInOutGroupSearchTypeE)textfield.getSearchType();
            this.searchCriteria1 = (String)value;
        } else if (name == FILTER_COSTCENTER) {
            this.searchCriteria4 = value instanceof CostCenterComplete ? (CostCenterComplete)value : (value instanceof Node ? (CostCenterComplete)((Node)value).getValue() : null);
        } else if (name == FILTER_CUSTOMS_DOC_TYPE) {
            this.searchCriteria5 = value instanceof CustomsDocumentTypeComplete ? (CustomsDocumentTypeComplete)value : (value instanceof Node ? (CustomsDocumentTypeComplete)((Node)value).getValue() : null);
        }
        StockCheckinGroupSearchConfiguration c = new StockCheckinGroupSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        String v = this.searchCriteria1;
        if (v != null) {
            try {
                Integer a = Integer.valueOf(v.trim());
                c.setNumber(a);
                c.setName(v);
                c.setCustomsDocumentId(v);
            }
            catch (NumberFormatException e) {
                c.setNumber(null);
                c.setName(v);
                c.setCustomsDocumentId(v);
            }
        }
        if (this.filterCriteria1 == null) {
            c.setSearchType(StockCheckInOutGroupSearchTypeE.ALL);
        } else {
            c.setSearchType(this.filterCriteria1);
        }
        c.setCheckinDate(this.searchCriteria2);
        c.setDepartment(this.searchCriteria4);
        c.setCustomsDocumentType(this.searchCriteria5);
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node node) {
        this.costCenters.refreshPossibleValues(NodeToolkit.getAffixList(CostCenterComplete.class));
        this.costCenters.addItem(Words.ALL);
        this.costCenters.setSelectedItem(Words.ALL);
        this.customsDocumentTypes.refreshPossibleValues(NodeToolkit.getAffixList(CustomsDocumentTypeComplete.class));
        this.customsDocumentTypes.addItem(Words.ALL);
        this.customsDocumentTypes.setSelectedItem(Words.ALL);
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<StockCheckinGroupLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(StoreCheckinSearchAlgorithm.class);
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<StockCheckinGroupLight> model) {
        return model != null;
    }

    @Override
    public boolean isDeletable(RowModel<StockCheckinGroupLight> model) {
        return false;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.NONE;
    }

    @Override
    protected RowEditorFactory<StockCheckinGroupLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<StockCheckinGroupLight> rowEditor = new MessageProvidedRowEditor<StockCheckinGroupLight>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            CheckinTemplateDetailsPanel d0 = new CheckinTemplateDetailsPanel((RowEditor<StockCheckinGroupLight>)rowEditor, p);
            SpecificationDetailsPanel d1 = new SpecificationDetailsPanel((RowEditor<StockCheckinGroupLight>)rowEditor, p);
            ArticleDetailsPanel d2 = new ArticleDetailsPanel((RowEditor<StockCheckinGroupLight>)rowEditor, p);
            if (model.isAddRow()) {
                rowEditor.add(d0, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
                rowEditor.add(d2, (Object)new TableLayoutConstraint(0, 2, 1.0, 1.0));
                rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 1, 1.0, 1.0));
                rowEditor.addToFocusQueue(d1);
                rowEditor.addToFocusQueue(d2);
                rowEditor.allInstalled();
                rowEditor.setVisibleContainer(this.getTable());
            } else {
                rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
                rowEditor.add(d2, (Object)new TableLayoutConstraint(0, 1, 1.0, 1.0));
                rowEditor.addToFocusQueue(d1);
                rowEditor.addToFocusQueue(d2);
                rowEditor.allInstalled();
                rowEditor.setVisibleContainer(this.getTable());
            }
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new GroupStockCheckinModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> infos = new ArrayList<TableColumnInfo>();
        infos.add(new TableColumnInfo(Words.NO_NUMBER, "", (Class)IntegerConverter.class, (Enum<?>)StockCheckinGroupSearchConfiguration.STOCK_CHECK_IN_GROUP_COLUMN.NUMBER, StockCheckinGroupLight_.number, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth));
        infos.add(new TableColumnInfo(Words.NAME, "", (Class)StringConverter.class, (Enum<?>)StockCheckinGroupSearchConfiguration.STOCK_CHECK_IN_GROUP_COLUMN.NAME, StockCheckinGroupLight_.name, 100, Integer.MAX_VALUE, 100));
        infos.add(new TableColumnInfo(Words.DEPARTMENT, "", (Class)CostCenterConverter.class, (Enum<?>)StockCheckinGroupSearchConfiguration.STOCK_CHECK_IN_GROUP_COLUMN.DEPARTMENT, StockCheckinGroupLight_.costCenter, TableColumnInfo.costCenter, TableColumnInfo.costCenter, TableColumnInfo.costCenter));
        infos.add(new TableColumnInfo(WordsToolkit.toUpperCase((String)Words.CUSTOMS_DOCUMENTS), "", CustomsDocumentListConverter.class, null, StockCheckinGroupLight_.documents, 100, Integer.MAX_VALUE, 100));
        infos.add(new TableColumnInfo(Words.DATE, "", (Class)DateConverter.class, (Enum<?>)StockCheckinGroupSearchConfiguration.STOCK_CHECK_IN_GROUP_COLUMN.DATE, StockCheckinGroupLight_.checkinDate, TableColumnInfo.dateColumnWidth + TableColumnInfo.smartTwo, TableColumnInfo.dateColumnWidth + TableColumnInfo.smartTwo, TableColumnInfo.dateColumnWidth + TableColumnInfo.smartTwo));
        return infos;
    }
}

