/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.checkin.article.details;

import ch.icit.pegasus.client.gui.modules.importer.utils.ImporterItemView;
import ch.icit.pegasus.client.gui.modules.shared.CheckInOutTemplateDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.buttons.ViewButton;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBox;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.ordering.template.GroupCheckinoutTemplateComplete;
import ch.icit.pegasus.server.core.dtos.ordering.template.GroupCheckinoutTemplateLight;
import ch.icit.pegasus.server.core.dtos.ordering.template.OrderTemplatePositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.template.OrderTemplateReference;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.GroupCheckInAccess;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchTypeE;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupComplete_;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockCheckinComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockCheckinComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.dtos.utils.ArticlePriceCalculationToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.StringUtil;
import ch.icit.utils.ExcelRow;
import ch.icit.utils.ExcelToolkit;
import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class CheckinTemplateDetailsPanel
extends CheckInOutTemplateDetailsPanel<StockCheckinGroupLight> {
    private static final long serialVersionUID = 1L;
    private ViewButton downloadTemplate;
    private TextButton importButton;
    private TitledItem<StorePositionSearchBox> defaultStore;

    public CheckinTemplateDetailsPanel(RowEditor<StockCheckinGroupLight> editor, RDProvider provider) {
        super(editor, provider);
        if (provider.isWritable(GroupCheckInAccess.CHECKIN_IMPORT)) {
            this.importButton = new TextButton(Words.IMPORT);
            this.defaultStore = new TitledItem<StorePositionSearchBox>(new StorePositionSearchBox(true, provider), Words.STORE_POSITION, TitledItem.TitledItemOrientation.NORTH);
            this.downloadTemplate = new ViewButton();
            this.downloadTemplate.addButtonListener(this);
            this.importButton.addButtonListener(this);
            this.importButton.getFader().setProgress(1.0f);
            this.defaultStore.getFader().setProgress(1.0f);
            this.defaultStore.getElement().setNode((Node<StorePositionLight>)new DTOProxyNode());
            this.addToView(this.downloadTemplate);
            this.addToView(this.importButton);
            this.addToView(this.defaultStore);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.importButton != null) {
            this.importButton.setEnabled(isEnabled);
        }
        if (this.defaultStore != null) {
            this.defaultStore.setEnabled(isEnabled);
        }
        if (this.downloadTemplate != null) {
            this.downloadTemplate.setEnabled(isEnabled);
        }
    }

    @Override
    protected void layoutOtherThings(int w, int h) {
        if (this.importButton != null) {
            this.downloadTemplate.setLocation((int)((double)w - (this.downloadTemplate.getPreferredSize().getWidth() + (double)this.horizontalBorder)), (int)((double)h - (this.downloadTemplate.getPreferredSize().getHeight() + (double)this.verticalBorder)));
            this.downloadTemplate.setSize(this.downloadTemplate.getPreferredSize());
            this.importButton.setLocation((int)((double)w - (this.importButton.getPreferredSize().getWidth() + this.downloadTemplate.getPreferredSize().getWidth() + (double)(this.horizontalBorder * 2))), (int)((double)h - (this.importButton.getPreferredSize().getHeight() + (double)this.verticalBorder)));
            this.importButton.setSize(this.importButton.getPreferredSize());
            this.defaultStore.setLocation((int)((double)w - (this.importButton.getPreferredSize().getWidth() + 250.0 + this.downloadTemplate.getPreferredSize().getWidth() + (double)(this.horizontalBorder * 3))), (int)((double)h - (this.defaultStore.getPreferredSize().getHeight() + (double)this.verticalBorder)));
            this.defaultStore.setSize(250, (int)this.defaultStore.getPreferredSize().getHeight());
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        ThreadSafeExecutable run;
        if (this.copy == source) {
            this.editor.showCommittingAnimation(Words.COPY_TEMPLATE);
            this.editor.setEnabled(false);
            run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    Node data = CheckinTemplateDetailsPanel.this.editor.getModel().getNode();
                    GroupCheckinoutTemplateLight g = (GroupCheckinoutTemplateLight)((SearchTextField2)CheckinTemplateDetailsPanel.this.groupSearch.getElement()).getNode().getValue();
                    data.getChildNamed(StockCheckinGroupComplete_.costCenter).setValue((Object)g.getCostCenter(), 0L);
                    Node poses = data.getChildNamed(StockCheckinGroupComplete_.stockCheckins);
                    Iterator it = poses.getFailSafeChildIterator();
                    while (it.hasNext()) {
                        Node pos = (Node)it.next();
                        poses.removeChild(pos, 0L);
                    }
                    GroupCheckinoutTemplateComplete gc = (GroupCheckinoutTemplateComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getGroupCheckinoutTemplate((OrderTemplateReference)g).getValue();
                    for (OrderTemplatePositionComplete p : gc.getPositions()) {
                        ManualStockCheckinComplete pos = new ManualStockCheckinComplete();
                        pos.setAmount(new StoreQuantityComplete(p.getAmount()));
                        pos.setStorePosition(p.getReceivingStorePosition());
                        pos.setExpiryDate(CalendarUtil.getInfinityDate());
                        PriceComplete brutto = ArticlePriceCalculationToolkit.getBruttoPrice((BasicArticleLight)p.getArticle(), (Timestamp)new Timestamp(System.currentTimeMillis()), null, (boolean)false);
                        pos.setPrice(new PriceComplete(brutto));
                        pos.setPriceUnit(p.getArticle().getFloatStoreUnit());
                        Node nPos = INodeCreator.getDefaultImpl().getNode4DTO((Object)pos, true, false);
                        Node article = nPos.getChildNamed(ManualStockCheckinComplete_.article);
                        if (article == null) {
                            article = new DTOProxyNode();
                            article.setName(ManualStockCheckinComplete_.article);
                            nPos.addChild(article, 0L);
                        }
                        article.setValue((Object)p.getArticle(), 0L);
                        poses.addChild(nPos, 0L);
                    }
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            CheckinTemplateDetailsPanel.this.editor.hideCommittingAnimation();
                            CheckinTemplateDetailsPanel.this.editor.setEnabled(true);
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showExceptionPopUp((Throwable)exception, ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), CheckinTemplateDetailsPanel.this.editor);
                            CheckinTemplateDetailsPanel.this.editor.hideCommittingAnimation();
                            CheckinTemplateDetailsPanel.this.editor.setEnabled(true);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
        if (source == this.importButton) {
            if (this.defaultStore.getElement().getNode().getValue() == null) {
                InnerPopupFactory.showErrorDialog("Select default store position first", (Component)this);
                return;
            }
            this.editor.setEnabled(false);
            run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    File loadedFile = FileChooserUtil.loadFile();
                    if (loadedFile == null) {
                        return null;
                    }
                    boolean unableToImportAll = false;
                    ArrayList<String> messages = new ArrayList<String>();
                    List rows = ExcelToolkit.readRows((File)loadedFile);
                    int currentRow = 0;
                    for (ExcelRow row : rows) {
                        ++currentRow;
                        Integer catitArticleNo = ExcelToolkit.readAsInteger((ExcelRow)row, (int)0);
                        String customerArticleNo = ExcelToolkit.readAsString((ExcelRow)row, (int)1);
                        String sapArticleNo = ExcelToolkit.readAsString((ExcelRow)row, (int)2);
                        sapArticleNo = ExcelToolkit.convertStringToIntegerNumber((String)sapArticleNo);
                        String unitOfMeasure = ExcelToolkit.readAsString((ExcelRow)row, (int)3);
                        Integer amount = ExcelToolkit.readAsInteger((ExcelRow)row, (int)4);
                        BasicArticleSearchConfiguration config = new BasicArticleSearchConfiguration();
                        if (catitArticleNo != null) {
                            config.setSearchType(BasicArticleSearchTypeE.ARTICLE_NUMBER);
                            config.setNumber(catitArticleNo);
                        } else if (!StringUtil.isBlank((String)customerArticleNo)) {
                            config.setSearchType(BasicArticleSearchTypeE.CUSTOMER_NUMBER);
                            config.setCustomerArticleNo(customerArticleNo);
                            config.setExactMatch(Boolean.valueOf(true));
                        } else if (!StringUtil.isBlank((String)sapArticleNo)) {
                            config.setSearchType(BasicArticleSearchTypeE.SAP_NUMBER);
                            config.setName(sapArticleNo);
                            config.setExactMatch(Boolean.valueOf(true));
                        }
                        if (amount == null) {
                            unableToImportAll = true;
                            messages.add("Amount is not set on row " + currentRow);
                            continue;
                        }
                        if (unitOfMeasure == null) {
                            unableToImportAll = true;
                            messages.add("Unit of Measure is not set on row " + currentRow);
                            continue;
                        }
                        SearchResult result = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)config);
                        if (result.getNumberOfResults() > 1L) {
                            unableToImportAll = true;
                            messages.add("More than one Article found for row " + currentRow);
                            continue;
                        }
                        if (result.getNumberOfResults() == 0L) {
                            unableToImportAll = true;
                            messages.add("No Article found for row " + currentRow);
                            continue;
                        }
                        BasicArticleLight artL = (BasicArticleLight)result.getSingleResult();
                        if (artL == null) {
                            unableToImportAll = true;
                            messages.add("No Article found for row " + customerArticleNo);
                            continue;
                        }
                        BasicArticleComplete artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(artL.getId())).getValue();
                        if (artC == null) {
                            unableToImportAll = true;
                            messages.add("No Article found for row " + currentRow);
                            continue;
                        }
                        HashMap<String, UnitComplete> unitIndex = new HashMap<String, UnitComplete>();
                        PackagingQuantityBaseComplete conversion = (PackagingQuantityBaseComplete)artC.getPackingQuantitiesVariant((java.util.Date)new Date(System.currentTimeMillis()));
                        for (PackagingQuantityComplete packing : conversion.getPackingQuantities()) {
                            UnitComplete currentUnit = packing.getUnit();
                            while (currentUnit.getSuperUnit() != null) {
                                currentUnit = currentUnit.getSuperUnit();
                            }
                            while (currentUnit != null) {
                                unitIndex.put(currentUnit.getName().toLowerCase(), currentUnit);
                                unitIndex.put(currentUnit.getShortName().toLowerCase(), currentUnit);
                                currentUnit = currentUnit.getSubUnit();
                            }
                        }
                        UnitComplete uom = (UnitComplete)unitIndex.get(unitOfMeasure.toLowerCase());
                        if (uom == null) {
                            unableToImportAll = true;
                            messages.add("Unit not found for " + artL.toString() + ": " + unitOfMeasure);
                            continue;
                        }
                        ManualStockCheckinComplete c = new ManualStockCheckinComplete();
                        c.setArticle((BasicArticleLight)artC);
                        c.setClientOId(Long.valueOf(ADTO.getNextId()));
                        c.setAmount(new StoreQuantityComplete(Long.valueOf(amount.longValue()), uom));
                        c.setExpiryDate(CalendarUtil.getInfinityDate());
                        c.setLabelPrintCount(Integer.valueOf(1));
                        StorePositionLight position = (StorePositionLight)((StorePositionSearchBox)CheckinTemplateDetailsPanel.this.defaultStore.getElement()).getNode().getValue();
                        c.setStorePosition(position);
                        SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                        PriceComplete p = new PriceComplete();
                        p.setClientOId(Long.valueOf(p.getNextId()));
                        p.setCurrency(s.getCurrency());
                        p.setPrice(Double.valueOf(0.0));
                        c.setPrice(p);
                        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)c, true, false);
                        CheckinTemplateDetailsPanel.this.editor.getModel().getNode().getChildNamed(StockCheckinGroupComplete_.stockCheckins).addChild(n, 0L);
                    }
                    ViewNode retNode = new ViewNode("ret");
                    if (unableToImportAll) {
                        retNode.setValue(messages, 0L);
                    }
                    return retNode;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            CheckinTemplateDetailsPanel.this.editor.setEnabled(true);
                            if (node == null) {
                                InnerPopupFactory.showErrorDialog("No file selected to process", (Component)CheckinTemplateDetailsPanel.this);
                                return;
                            }
                            if (node.getValue() != null) {
                                List messages = (List)node.getValue();
                                InnerPopupFactory.showWarningDialog(ScreenValidationObject.createList((List)messages, (ScreenValidationObject.ValidationStateE)ScreenValidationObject.ValidationStateE.WARNING), "Unable to add all Articles from import", (Component)CheckinTemplateDetailsPanel.this);
                                return;
                            }
                            InnerPopupFactory.showMessageDialog("Successfully imported", CheckinTemplateDetailsPanel.this);
                        }

                        public void errorOccurred(ClientException exception) {
                            CheckinTemplateDetailsPanel.this.editor.setEnabled(true);
                            InnerPopupFactory.showErrorDialog((Exception)exception, (Component)CheckinTemplateDetailsPanel.this);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
        if (this.downloadTemplate == null) {
            this.editor.setEnabled(false);
            try {
                File f = this.downloadFile();
                if (f == null) {
                    InnerPopupFactory.showErrorDialog("No template ready. Please contact support.", (Component)this);
                }
                this.editor.setEnabled(true);
                Desktop.getDesktop().open(f);
            }
            catch (IOException e) {
                InnerPopupFactory.showErrorDialog(e, (Component)this);
            }
            this.editor.setEnabled(true);
        }
    }

    private File downloadFile() throws IOException {
        File tempFile = File.createTempFile("ImporterFile_", ".xlsx");
        URL url = this.createURL();
        if (url == null) {
            return null;
        }
        FileUtils.copyURLToFile((URL)url, (File)tempFile);
        return tempFile;
    }

    private URL createURL() throws MalformedURLException {
        return ImporterItemView.class.getResource("/importtemplates/CheckinTemplate.xlsx");
    }
}

