/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.checkin.recipe;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.checkin.recipe.RecipeGroupStockCheckinModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.checkin.recipe.details.ComponentDetailsPanel;
import ch.icit.pegasus.client.gui.modules.checkin.recipe.details.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.ConfigurableSearchTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.RecipeStoreCheckinSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.production_new.store.recipe.RecipeStockCheckinGroupLight;
import ch.icit.pegasus.server.core.dtos.production_new.store.recipe.RecipeStockCheckinGroupLight_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.RecipeGroupCheckInAccess;
import ch.icit.pegasus.server.core.dtos.search.RecipeStockCheckinGroupSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.StockCheckinGroupSearchConfiguration;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class RecipeGroupStockCheckinModule
extends ScreenTableView<RecipeStockCheckinGroupLight, RecipeStockCheckinGroupSearchConfiguration.RECIPE_STOCK_CHECK_IN_GROUP_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_NUMBER_NAME = "number_name_filters";
    private static final String FILTER_DATE = "date_filter";
    private static final String FILTER_DEPARTMENT = "department_filter";
    private String searchCriteria1 = null;
    private PeriodComplete searchCriteria2 = null;
    private CostCenterComplete searchCriteria4;
    private ComboBox departments;
    private TitledPeriodEditor period;

    public RecipeGroupStockCheckinModule() {
        super(RecipeStockCheckinGroupLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.period.kill();
        this.period = null;
        this.departments.kill();
        this.departments = null;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return RecipeGroupCheckInAccess.MODULE_RECIPE_CHECK_IN_GROUPED;
    }

    public RecipeGroupStockCheckinModuleDataHandler getDataHandler() {
        return (RecipeGroupStockCheckinModuleDataHandler)this.getTable().getModel().getDataHandler();
    }

    public boolean isChargeBased() {
        return true;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", StockCheckinGroupSearchConfiguration.STOCK_CHECK_IN_GROUP_COLUMN.NUMBER + "<>" + true);
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.addSearchField(FILTER_NUMBER_NAME, Words.NAME_OR_NUMBER, "");
        this.departments = new ComboBox(null, null, ConverterRegistry.getConverter(CostCenterConverter.class));
        this.filterChain.addSelectionComboBox(this.departments, FILTER_DEPARTMENT, Words.DEPARTMENT, Words.ALL);
        PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
        this.period = this.filterChain.addPeriodSelection(FILTER_DATE, p.getStartDate(), p.getEndDate(), null, true);
        this.period.setCheckBoxEnabled();
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<RecipeStockCheckinGroupLight, RecipeStockCheckinGroupSearchConfiguration.RECIPE_STOCK_CHECK_IN_GROUP_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.searchCriteria1 = null;
            this.searchCriteria2 = null;
            this.searchCriteria4 = null;
            this.period.setCheckBoxChecked(false);
        } else if (name == FILTER_DATE) {
            TitledPeriodEditor ed = (TitledPeriodEditor)value;
            PeriodComplete per = new PeriodComplete();
            per.setStartDate(ed.getStartDate());
            per.setEndDate(ed.getEndDate());
            this.searchCriteria2 = per;
        } else if (name == FILTER_NUMBER_NAME) {
            ConfigurableSearchTextField textfield = (ConfigurableSearchTextField)source;
            this.searchCriteria1 = (String)value;
        } else if (name == FILTER_DEPARTMENT) {
            this.searchCriteria4 = value instanceof CostCenterComplete ? (CostCenterComplete)value : (value instanceof Node ? (CostCenterComplete)((Node)value).getValue() : null);
        }
        RecipeStockCheckinGroupSearchConfiguration c = new RecipeStockCheckinGroupSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        String v = this.searchCriteria1;
        if (v != null) {
            try {
                Integer a = Integer.valueOf(v.trim());
                c.setNumber(a);
                c.setName(v);
            }
            catch (NumberFormatException e) {
                c.setNumber(null);
                c.setName(v);
            }
        }
        c.setCheckinDate(this.searchCriteria2);
        c.setDepartment(this.searchCriteria4);
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node node) {
        this.departments.refreshPossibleValues(NodeToolkit.getAffixList(CostCenterComplete.class));
        this.departments.addItem(Words.ALL);
        this.departments.setSelectedItem(Words.ALL);
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<RecipeStockCheckinGroupLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(RecipeStoreCheckinSearchAlgorithm.class);
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<RecipeStockCheckinGroupLight> model) {
        return model != null;
    }

    @Override
    public boolean isDeletable(RowModel<RecipeStockCheckinGroupLight> model) {
        return false;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.NONE;
    }

    @Override
    protected RowEditorFactory<RecipeStockCheckinGroupLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<RecipeStockCheckinGroupLight> rowEditor = new MessageProvidedRowEditor<RecipeStockCheckinGroupLight>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            SpecificationDetailsPanel d1 = new SpecificationDetailsPanel((RowEditor<RecipeStockCheckinGroupLight>)rowEditor, p);
            ComponentDetailsPanel d2 = new ComponentDetailsPanel((RowEditor<RecipeStockCheckinGroupLight>)rowEditor, p);
            rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 0, 1.0, 0.0));
            rowEditor.add(d2, (Object)new TableLayoutConstraint(0, 1, 1.0, 1.0));
            rowEditor.addToFocusQueue(d1);
            rowEditor.addToFocusQueue(d2);
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new RecipeGroupStockCheckinModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> info = new ArrayList<TableColumnInfo>();
        info.add(new TableColumnInfo(Words.NO_NUMBER, "", (Class)IntegerConverter.class, (Enum<?>)RecipeStockCheckinGroupSearchConfiguration.RECIPE_STOCK_CHECK_IN_GROUP_COLUMN.NUMBER, RecipeStockCheckinGroupLight_.number, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth));
        info.add(new TableColumnInfo(Words.NAME, "", (Class)StringConverter.class, (Enum<?>)RecipeStockCheckinGroupSearchConfiguration.RECIPE_STOCK_CHECK_IN_GROUP_COLUMN.NAME, RecipeStockCheckinGroupLight_.name, 100, Integer.MAX_VALUE, 100));
        info.add(new TableColumnInfo(Words.DEPARTMENT, "", (Class)CostCenterConverter.class, (Enum<?>)RecipeStockCheckinGroupSearchConfiguration.RECIPE_STOCK_CHECK_IN_GROUP_COLUMN.DEPARTMENT, RecipeStockCheckinGroupLight_.costCenter, TableColumnInfo.costCenter, TableColumnInfo.costCenter, TableColumnInfo.costCenter));
        info.add(new TableColumnInfo(Words.DATE, "", (Class)DateConverter.class, (Enum<?>)RecipeStockCheckinGroupSearchConfiguration.RECIPE_STOCK_CHECK_IN_GROUP_COLUMN.DATE, RecipeStockCheckinGroupLight_.checkinDate, TableColumnInfo.dateColumnWidth + TableColumnInfo.smartTwo, TableColumnInfo.dateColumnWidth + TableColumnInfo.smartTwo, TableColumnInfo.dateColumnWidth + TableColumnInfo.smartTwo));
        return info;
    }
}

