/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.checkin.recipe;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.services.interfaces.weeklyplan.WeeklyPlanServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CustomsDocumentTypeComplete;
import ch.icit.pegasus.server.core.dtos.production_new.store.recipe.RecipeStockCheckinGroupComplete;
import ch.icit.pegasus.server.core.dtos.production_new.store.recipe.RecipeStockCheckinGroupLight;
import ch.icit.pegasus.server.core.dtos.production_new.store.recipe.RecipeStockCheckinGroupReference;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.RecipeProduceTransactionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.remark.ManualStockCheckoutRemarkComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.util.Iterator;

public class RecipeGroupStockCheckinModuleDataHandler
extends DefaultDataHandler<RecipeStockCheckinGroupLight, RecipeStockCheckinGroupComplete> {
    public RecipeGroupStockCheckinModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                RecipeStockCheckinGroupLight group = (RecipeStockCheckinGroupLight)node.getValue(RecipeStockCheckinGroupLight.class);
                RecipeStockCheckinGroupComplete ngroup = (RecipeStockCheckinGroupComplete)((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).getRecipeCheckinGroup(new RecipeStockCheckinGroupReference(group.getId())).getValue();
                node.removeExistingValues();
                node.setValue((Object)ngroup, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public void updateData(final Node<RecipeStockCheckinGroupLight> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                RecipeStockCheckinGroupComplete g = (RecipeStockCheckinGroupComplete)node.getValue(RecipeStockCheckinGroupComplete.class);
                g.getStockCheckins().forEach(transaction -> transaction.setRecipeCheckinGroup((RecipeStockCheckinGroupReference)g));
                g.getStockCheckinCorrections().forEach(transaction -> transaction.setRecipeCheckinGroup((RecipeStockCheckinGroupReference)g));
                RecipeStockCheckinGroupComplete gn = (RecipeStockCheckinGroupComplete)((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).updateRecipeCheckinGroup(g).getValue();
                node.removeExistingValues();
                node.setValue((Object)gn, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<RecipeStockCheckinGroupComplete> createEmptyNode() {
        RecipeStockCheckinGroupComplete d = new RecipeStockCheckinGroupComplete();
        d.setClientOId(Long.valueOf(ADTO.getNextId()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)d, false, false);
        return n;
    }

    @Override
    public void createNewData(final Node<RecipeStockCheckinGroupComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit(RecipeStockCheckinGroupComplete.class);
                RecipeStockCheckinGroupComplete g = (RecipeStockCheckinGroupComplete)node.getValue(RecipeStockCheckinGroupComplete.class);
                Iterator it = g.getStockCheckins().iterator();
                while (it.hasNext()) {
                    RecipeProduceTransactionComplete c = (RecipeProduceTransactionComplete)it.next();
                    if (c.getQuantity().getAmount() == null || c.getQuantity().getAmount() != null && c.getQuantity().getAmount() != 0L) continue;
                    it.remove();
                }
                if (g.getEligibleLocations().isEmpty()) {
                    g.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                g.getStockCheckins().forEach(transaction -> transaction.setRecipeCheckinGroup((RecipeStockCheckinGroupReference)g));
                g.getStockCheckinCorrections().forEach(transaction -> transaction.setRecipeCheckinGroup((RecipeStockCheckinGroupReference)g));
                RecipeStockCheckinGroupComplete gn = (RecipeStockCheckinGroupComplete)((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).createRecipeCheckinGroup(g).getValue();
                node.removeExistingValues();
                node.setValue((Object)gn, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                RecipeGroupStockCheckinModuleDataHandler.this.setCurrentLoadMaximum(7);
                RecipeGroupStockCheckinModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CurrencyComplete.class);
                RecipeGroupStockCheckinModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CostCenterComplete.class);
                RecipeGroupStockCheckinModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                RecipeGroupStockCheckinModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CustomsDocumentTypeComplete.class);
                RecipeGroupStockCheckinModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ManualStockCheckoutRemarkComplete.class);
                RecipeGroupStockCheckinModuleDataHandler.this.showNextMessage(progressListener);
                UnitToolkit.loadUnits();
                RecipeGroupStockCheckinModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return RecipeGroupStockCheckinModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<RecipeStockCheckinGroupComplete> resetData(Node<RecipeStockCheckinGroupComplete> node) {
        RecipeStockCheckinGroupComplete n = new RecipeStockCheckinGroupComplete();
        n.setClientOId(Long.valueOf(ADTO.getNextId()));
        n.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)n, true, false);
    }

    @Override
    public Class<RecipeStockCheckinGroupComplete> getCommittingClass() {
        return RecipeStockCheckinGroupComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<RecipeStockCheckinGroupLight> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

