/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.checkout.recipe.positionbased.details;

import ch.icit.pegasus.client.converter.QuantityConverter2Decimal;
import ch.icit.pegasus.client.converter.RecipeChargeConverter;
import ch.icit.pegasus.client.converter.RecipeConverter;
import ch.icit.pegasus.client.converter.StorePositionConverter;
import ch.icit.pegasus.client.converter.StorePositionShortNameConverter;
import ch.icit.pegasus.client.converter.StoreViewConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.defaults.DefaultTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.defaults.DefaultTable2RowPanelLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.weeklyplan.WeeklyPlanServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.server.core.calculator.IQuantity;
import ch.icit.pegasus.server.core.calculator.IUnit;
import ch.icit.pegasus.server.core.calculator.UnitCalculator;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.production_new.charges.RecipeChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.production_new.store.recipe.RecipeStockCheckoutGroupComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.store.recipe.RecipeStockCheckoutGroupLight;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.RecipeConsumeTransactionComplete;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.RecipeConsumeTransactionComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.RecipeMoveTransactionComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeReference;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class ComponentDetailsPanel
extends TableDetailsPanel<RecipeStockCheckoutGroupLight> {
    private static final long serialVersionUID = 1L;

    public ComponentDetailsPanel(RowEditor<RecipeStockCheckoutGroupLight> editor, RDProvider provider) {
        super(editor, provider, editor.getModel().isAddRow());
        this.setTitleText(Words.RECIPES);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        if (add) {
            columns.add(new TableColumnInfo(Words.RECIPE, null, null, null, "", 40));
            columns.add(new TableColumnInfo(Words.STORE, null, null, null, "", 30));
            columns.add(new TableColumnInfo(Words.POSITION, null, null, null, "", 30));
            columns.add(new TableColumnInfo(Words.STOCK, null, null, null, "", 2 * this.getTable().getCellPadding() + InputComboBox2.getPreferredWidth(this, 7)));
            columns.add(new TableColumnInfo(Words.AMOUNT, null, null, null, "", 2 * this.getTable().getCellPadding() + InputComboBox2.getPreferredWidth(this, 11)));
            columns.add(new TableColumnInfo("", null, null, null, "", 2 * this.getTable().getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL)));
            ((TableColumnInfo)columns.get(0)).setxExpand(0.6);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.2);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.2);
            ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        } else {
            columns.add(new TableColumnInfo(Words.RECIPE, null, null, null, "", 40));
            columns.add(new TableColumnInfo(Words.ORIGIN, null, null, null, "", 30));
            columns.add(new TableColumnInfo(Words.CHARGE, null, null, null, "", 2 * this.getTable().getCellPadding() + InputComboBox2.getPreferredWidth(this, 7)));
            columns.add(new TableColumnInfo(Words.AMOUNT, null, null, null, "", 2 * this.getTable().getCellPadding() + InputComboBox2.getPreferredWidth(this, 11)));
            ((TableColumnInfo)columns.get(0)).setxExpand(0.6);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.2);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.2);
            ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        }
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        RecipeConsumeTransactionComplete c = new RecipeConsumeTransactionComplete();
        c.setClientOId(Long.valueOf(ADTO.getNextId()));
        c.setQuantity(new StoreQuantityComplete(Long.valueOf(0L), ((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getDefaultRecipeUnit()));
        this.table.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)c, true, false), 0L);
    }

    @Override
    public void childRemoved() {
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(final Table2RowModel model, boolean isHeader) {
        DefaultTable2RowPanel row = new DefaultTable2RowPanel(model);
        boolean add = this.editor.getModel().isAddRow();
        if (add) {
            Node csn = model.getNode().getChildNamed(new String[]{"currentStock"});
            if (csn == null) {
                UnitComplete pieceUnit = ((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getPieceUnit();
                csn = INodeCreator.getDefaultImpl().getNode4DTO((Object)new QuantityComplete(Double.valueOf(0.0), pieceUnit), false, false);
                csn.setName("currentStock");
                model.getNode().addChild(csn, 0L);
            }
            final Node currentStockNode = csn;
            SearchTextField2<RecipeComplete> recipeSearchField = SearchTextField2Factory.getRecipeSearchField(true, model.getNode().getChildNamed(RecipeConsumeTransactionComplete_.recipe));
            final ComboBox storeCombo = new ComboBox((Node)new DTOProxyNode(), null, ConverterRegistry.getConverter(StoreViewConverter.class));
            final ComboBox positionCombo = new ComboBox(model.getNode().getChildNamed(RecipeMoveTransactionComplete_.originStore), null, ConverterRegistry.getConverter(StorePositionConverter.class));
            final TextLabel currentStock = new TextLabel(currentStockNode, ConverterRegistry.getConverter(QuantityConverter2Decimal.class));
            InputComboBox2 component = new InputComboBox2(model.getNode().getChildNamed(new DtoField[]{RecipeConsumeTransactionComplete_.quantity, StoreQuantityComplete_.amount}), model.getNode().getChildNamed(new DtoField[]{RecipeConsumeTransactionComplete_.quantity, StoreQuantityComplete_.unit}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
            recipeSearchField.addSearchTextFieldListener((source, n) -> {
                RecipeComplete recipe = (RecipeComplete)n.getValue();
                if (recipe != null) {
                    UnitComplete unit = recipe.getCurrentVariant().getYield().getUnit();
                    model.getNode().getChildNamed(new DtoField[]{RecipeConsumeTransactionComplete_.quantity, StoreQuantityComplete_.unit}).setValue((Object)unit, 0L);
                    if (component instanceof InputComboBox2) {
                        InputComboBox2 combo = component;
                        combo.setSelectedUnit(unit);
                        List units = UnitConversionToolkit.getPossibleUnits((RecipeVariantLight)recipe.getCurrentVariant());
                        combo.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(units));
                        component.getUnitNode().setValue((Object)unit, 0L);
                    }
                }
                ThreadSafeExecutable run = new ThreadSafeExecutable(){

                    @Override
                    public Node<?> loadData() throws Exception {
                        ListWrapper stock = ((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).getStockForRecipe(new RecipeReference(((RecipeComplete)n.getValue(RecipeComplete.class)).getId()));
                        return INodeCreator.getDefaultImpl().createNodes(stock.getList(), false, false);
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return new RemoteLoader(){

                            public void remoteObjectLoaded(Node<?> node) {
                                storeCombo.refreshPossibleValues(node);
                            }

                            public void errorOccurred(ClientException exception) {
                                InnerPopupFactory.showErrorDialog((Exception)exception, (Component)ComponentDetailsPanel.this);
                            }
                        };
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
            });
            row.addLayoutComponent(recipeSearchField, DefaultTable2RowPanelLayout.LayoutType.FILL);
            storeCombo.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    ThreadSafeExecutable run = new ThreadSafeExecutable(){

                        @Override
                        public Node<?> loadData() throws Exception {
                            RecipeReference recipe = (RecipeReference)model.getNode().getChildNamed(RecipeConsumeTransactionComplete_.recipe).getValue();
                            StoreReference store = (StoreReference)storeCombo.getNode().getValue();
                            ListWrapper stock = ((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).getStockForRecipeAndStore(new RecipeReference(recipe.getId()), new StoreReference(store.getId()));
                            return INodeCreator.getDefaultImpl().createNodes(stock.getList(), false, false);
                        }

                        @Override
                        public RemoteLoader getInvoker() {
                            return new RemoteLoader(){

                                public void remoteObjectLoaded(Node<?> node) {
                                    positionCombo.refreshPossibleValues(node);
                                }

                                public void errorOccurred(ClientException exception) {
                                    InnerPopupFactory.showErrorDialog((Exception)exception, (Component)ComponentDetailsPanel.this);
                                }
                            };
                        }

                        @Override
                        public long getID() {
                            return 0L;
                        }
                    };
                    ThreadSafeLoader.run(run);
                }
            });
            row.addLayoutComponent(storeCombo, DefaultTable2RowPanelLayout.LayoutType.FILL);
            positionCombo.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    ThreadSafeExecutable run = new ThreadSafeExecutable(){

                        @Override
                        public Node<?> loadData() throws Exception {
                            RecipeReference product = (RecipeReference)model.getNode().getChildNamed(RecipeConsumeTransactionComplete_.recipe).getValue();
                            StorePositionLight storePosition = (StorePositionLight)positionCombo.getNode().getValue();
                            ListWrapper stock = ((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).getRecipeBatchesForPosition(new RecipeReference(product.getId()), storePosition);
                            QuantityComplete sum = null;
                            for (RecipeChargeBatchComplete recipeChargeComplete : stock.getList()) {
                                if (sum == null) {
                                    sum = new QuantityComplete(recipeChargeComplete.getQuantity());
                                    continue;
                                }
                                double conversionFactorForRecipe = UnitCalculator.getConversionFactorForRecipe((IQuantity)new QuantityComplete(recipeChargeComplete.getQuantity()), (IUnit)sum.getUnit());
                                sum.setQuantity(Double.valueOf(sum.getQuantity() + conversionFactorForRecipe));
                            }
                            if (sum == null) {
                                sum = new QuantityComplete(Double.valueOf(0.0), ((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getPieceUnit());
                            }
                            currentStockNode.setValue(sum, 0L);
                            return INodeCreator.getDefaultImpl().createNodes(stock.getList(), false, false);
                        }

                        @Override
                        public RemoteLoader getInvoker() {
                            return new RemoteLoader(){

                                public void remoteObjectLoaded(Node<?> node) {
                                    currentStock.updateString();
                                }

                                public void errorOccurred(ClientException exception) {
                                    InnerPopupFactory.showErrorDialog((Exception)exception, (Component)ComponentDetailsPanel.this);
                                }
                            };
                        }

                        @Override
                        public long getID() {
                            return 0L;
                        }
                    };
                    ThreadSafeLoader.run(run);
                }
            });
            row.addLayoutComponent(positionCombo, DefaultTable2RowPanelLayout.LayoutType.FILL);
            row.addLayoutComponent(currentStock, DefaultTable2RowPanelLayout.LayoutType.FILL);
            row.addLayoutComponent(component, DefaultTable2RowPanelLayout.LayoutType.FIX);
            row.addLayoutComponent(new DeleteButton((source, x, y) -> model.getNode().getParent().removeChild(model.getNode(), 0L)), DefaultTable2RowPanelLayout.LayoutType.FIX);
            row.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        } else {
            row.addLayoutComponent(new TextLabel(model.getNode().getChildNamed(RecipeConsumeTransactionComplete_.recipe), ConverterRegistry.getConverter(RecipeConverter.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
            row.addLayoutComponent(new TextLabel(model.getNode().getChildNamed(RecipeConsumeTransactionComplete_.originStore), ConverterRegistry.getConverter(StorePositionShortNameConverter.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
            row.addLayoutComponent(new TextLabel(model.getNode().getChildNamed(RecipeConsumeTransactionComplete_.recipeCharge), ConverterRegistry.getConverter(RecipeChargeConverter.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
            row.addLayoutComponent(new TextLabel(model.getNode().getChildNamed(RecipeConsumeTransactionComplete_.quantity), ConverterRegistry.getConverter(QuantityConverter2Decimal.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
            row.setUseControlSkin(Table2RowPanel.TableControlsType.NONE);
        }
        return row;
    }

    @Override
    public void setNode(Node node) {
        super.setNode(node);
        this.table.getModel().setNode(node.getChildNamed(RecipeStockCheckoutGroupComplete_.stockCheckouts));
    }
}

