/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.customer;

import ch.icit.pegasus.client.converter.ContactLocationConverter;
import ch.icit.pegasus.client.converter.FileReferenceConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.customer.CustomerModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.customer.details.AllergenInfoSheetDetailsPanel;
import ch.icit.pegasus.client.gui.modules.customer.details.ContactDetailsPanel;
import ch.icit.pegasus.client.gui.modules.customer.details.ContactsDetailsPanel;
import ch.icit.pegasus.client.gui.modules.customer.details.DeliveryDetailsPanel;
import ch.icit.pegasus.client.gui.modules.customer.details.InvoiceDetailsPanel;
import ch.icit.pegasus.client.gui.modules.customer.details.ManHourCostDetailsPanel;
import ch.icit.pegasus.client.gui.modules.customer.details.PaymentDetailsPanel;
import ch.icit.pegasus.client.gui.modules.customer.details.SpecDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.CombinedDetailsParagraph;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.CustomerSearchAlgorithm;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.CustomerAccess;
import ch.icit.pegasus.server.core.dtos.search.CustomerSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomerModule
extends ScreenTableView<CustomerLight, CustomerSearchConfiguration.CUSTOMER_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(CustomerModule.class);
    private static final String FILTER_NAME = "number_filter";
    private String searchCriteria1 = null;

    public CustomerModule() {
        super(CustomerLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return CustomerAccess.MODULE_CUSTOMER;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", CustomerSearchConfiguration.CUSTOMER_COLUMN.NUMBER + "<>" + true);
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (Boolean.TRUE.equals(settings.getCompany().getSolarCompanyType())) {
            this.filterChain.setResetButtonWidth(120);
        }
        this.filterChain.addSearchField(FILTER_NAME, Words.NUMBER_OR_NAME, "");
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<CustomerLight, CustomerSearchConfiguration.CUSTOMER_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.searchCriteria1 = null;
        } else if (name == FILTER_NAME) {
            this.searchCriteria1 = (String)value;
        }
        CustomerSearchConfiguration c = new CustomerSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        try {
            c.setNumber(Integer.valueOf(this.searchCriteria1));
            c.setName(null);
            c.setCode(null);
        }
        catch (NumberFormatException e) {
            c.setName(this.searchCriteria1);
            c.setCode(this.searchCriteria1);
            c.setNumber(null);
        }
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<CustomerLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(CustomerSearchAlgorithm.class);
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<CustomerLight> model) {
        return true;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.ONE;
    }

    @Override
    protected RowEditorFactory<CustomerLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<CustomerLight> rowEditor = new MessageProvidedRowEditor<CustomerLight>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            SystemSettingsComplete settingsComplete = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            SpecDetailsPanel d1 = new SpecDetailsPanel((RowEditor<CustomerLight>)rowEditor, p);
            PaymentDetailsPanel d2 = new PaymentDetailsPanel((RowEditor<CustomerLight>)rowEditor, p);
            DeliveryDetailsPanel d21 = new DeliveryDetailsPanel((RowEditor<CustomerLight>)rowEditor, p);
            ContactsDetailsPanel d3 = new ContactsDetailsPanel((RowEditor<CustomerLight>)rowEditor, p);
            ContactDetailsPanel d4 = new ContactDetailsPanel((RowEditor<CustomerLight>)rowEditor, p);
            rowEditor.addToFocusQueue(d1);
            rowEditor.addToFocusQueue(d2);
            rowEditor.addToFocusQueue(d21);
            if (!Boolean.TRUE.equals(settingsComplete.getCompany().getSolarCompanyType())) {
                InvoiceDetailsPanel<CustomerLight> d5 = new InvoiceDetailsPanel<CustomerLight>(rowEditor, p);
                try {
                    ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                }
                catch (ClientServerCallException clientServerCallException) {
                    // empty catch block
                }
                AllergenInfoSheetDetailsPanel d7 = new AllergenInfoSheetDetailsPanel((RowEditor<CustomerLight>)rowEditor, p);
                ManHourCostDetailsPanel d6 = new ManHourCostDetailsPanel((RowEditor<CustomerLight>)rowEditor, p);
                d3.getTable().setDetailsFocusView(d4);
                d3.getTable().getModel().addTableSelectionListener(d4);
                CombinedDetailsParagraph ccdp = new CombinedDetailsParagraph();
                ccdp.add((Component)d1, new TableLayoutConstraint(0, 0, 0.0, 1.0));
                ccdp.add((Component)d2, new TableLayoutConstraint(1, 0, 0.5, 1.0));
                ccdp.add((Component)d21, new TableLayoutConstraint(2, 0, 0.5, 1.0));
                CombinedDetailsParagraph ccdp2 = new CombinedDetailsParagraph();
                ccdp2.add(d5, new TableLayoutConstraint(0, 0, 0.5, 1.0));
                ccdp2.add((Component)d6, new TableLayoutConstraint(1, 0, 0.5, 1.0));
                CombinedDetailsParagraph ccdp3 = new CombinedDetailsParagraph();
                ccdp3.add((Component)d3, new TableLayoutConstraint(0, 0, 0.0, 1.0));
                ccdp3.add((Component)d4, new TableLayoutConstraint(1, 0, 1.0, 1.0));
                int row = 0;
                rowEditor.add(ccdp, (Object)new TableLayoutConstraint(0, row++, 1.0, 1.0));
                rowEditor.add(ccdp2, (Object)new TableLayoutConstraint(0, row++, 1.0, 1.0));
                rowEditor.add(d7, (Object)new TableLayoutConstraint(0, row++, 1.0, 1.0));
                rowEditor.add(ccdp3, (Object)new TableLayoutConstraint(0, row++, 1.0, 1.0));
                rowEditor.addToFocusQueue(d5);
                rowEditor.addToFocusQueue(d6);
                rowEditor.addToFocusQueue(d7);
            } else {
                d3.getTable().setDetailsFocusView(d4);
                d3.getTable().getModel().addTableSelectionListener(d4);
                CombinedDetailsParagraph ccdp = new CombinedDetailsParagraph();
                ccdp.add((Component)d1, new TableLayoutConstraint(0, 0, 0.0, 1.0));
                ccdp.add((Component)d2, new TableLayoutConstraint(1, 0, 0.5, 1.0));
                ccdp.add((Component)d21, new TableLayoutConstraint(2, 0, 0.5, 1.0));
                CombinedDetailsParagraph ccdp3 = new CombinedDetailsParagraph();
                ccdp3.add((Component)d3, new TableLayoutConstraint(0, 0, 0.0, 1.0));
                ccdp3.add((Component)d4, new TableLayoutConstraint(1, 0, 1.0, 1.0));
                int row = 0;
                rowEditor.add(ccdp, (Object)new TableLayoutConstraint(0, row++, 1.0, 1.0));
                rowEditor.add(ccdp3, (Object)new TableLayoutConstraint(0, row++, 1.0, 1.0));
            }
            rowEditor.addToFocusQueue(d4);
            rowEditor.addToFocusQueue(d3);
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new CustomerModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> infos = new ArrayList<TableColumnInfo>();
        SystemSettingsComplete settingsComplete = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        infos.add(new TableColumnInfo(Words.NO_NUMBER, "", (Class)IntegerConverter.class, (Enum<?>)CustomerSearchConfiguration.CUSTOMER_COLUMN.NUMBER, CustomerLight_.number, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth));
        infos.add(new TableColumnInfo("", "", FileReferenceConverter.class, null, CustomerLight_.image, TableColumnInfo.imageIndicatorWidth, TableColumnInfo.imageIndicatorWidth, TableColumnInfo.imageIndicatorWidth));
        infos.add(new TableColumnInfo(Words.NAME, "", (Class)StringConverter.class, (Enum<?>)CustomerSearchConfiguration.CUSTOMER_COLUMN.NAME, CustomerLight_.name, 100, Integer.MAX_VALUE, 100));
        infos.add(new TableColumnInfo(Words.CODE, "", (Class)StringConverter.class, (Enum<?>)CustomerSearchConfiguration.CUSTOMER_COLUMN.CODE, CustomerLight_.code, TableColumnInfo.customerCodeWidth, TableColumnInfo.customerCodeWidth, TableColumnInfo.customerCodeWidth));
        if (!Boolean.TRUE.equals(settingsComplete.getCompany().getSolarCompanyType())) {
            infos.add(new TableColumnInfo(Words.COUNTRY, "", (Class)ContactLocationConverter.class, (Enum<?>)CustomerSearchConfiguration.CUSTOMER_COLUMN.COUNTRY, CustomerLight_.headQuarters, 100, Integer.MAX_VALUE, 100));
        }
        return infos;
    }
}

