/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.customer.details;

import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowSelectionListener;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.panels.ContactPanel;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class ContactDetailsPanel
extends DefaultDetailsPanel<CustomerLight>
implements Table2RowSelectionListener {
    private static final long serialVersionUID = 1L;
    private ContactPanel contactPanel;

    public ContactDetailsPanel(RowEditor<CustomerLight> editor, RDProvider provider) {
        super(editor, provider);
        this.shape.setText(Words.NO_CONTACT_IS_SELECTED);
        this.contactPanel = new ContactPanel(null, false, false, provider, null);
        this.setTitleText(Words.CONTACT);
        this.setOpaque(false);
        this.setCustomLayouter(new Layout());
        this.contactPanel.getFader().setPermanent(true);
        this.shape.getFader().setPermanent(true);
        this.contactPanel.setProgress(0.0f);
        this.shape.setProgress(0.0f);
        this.shape.setOutLineColor(this.contactPanel.getComponentForeground());
        this.currentState = null;
        this.addToView(this.contactPanel);
        this.addToView(this.shape);
        this.switchState(Button.ButtonState.STATE_NOTSELECTED);
    }

    @Override
    public void switchState(Button.ButtonState newState) {
        if (this.currentState != newState) {
            this.currentState = newState;
            if (this.currentState == Button.ButtonState.STATE_SELECTED) {
                this.contactPanel.fadeIn();
                this.shape.fadeOut(false);
            } else if (this.currentState == Button.ButtonState.STATE_NOTSELECTED) {
                this.contactPanel.fadeOut(false);
                this.shape.fadeIn();
            }
            this.fireFocusCycleChanged(this);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        if (this.currentState == Button.ButtonState.STATE_SELECTED) {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.contactPanel);
            return focusList;
        }
        return null;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.contactPanel.kill();
        this.contactPanel = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.contactPanel.setEnabled(isEnabled);
    }

    public void setMasterNode(Node<?> node) {
        if (node == null && this.currentState == Button.ButtonState.STATE_SELECTED) {
            this.switchState(Button.ButtonState.STATE_NOTSELECTED);
        } else if (node != null) {
            this.contactPanel.setNode(node);
            if (this.currentState == Button.ButtonState.STATE_NOTSELECTED) {
                this.switchState(Button.ButtonState.STATE_SELECTED);
            }
        }
    }

    @Override
    public void tableRowSelected(Table2 sourceTable, Table2RowPanel panel) {
        if (panel != null) {
            this.setMasterNode(panel.getModel().getNode());
        } else {
            this.setMasterNode(null);
        }
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ContactDetailsPanel.this.shape.setLocation(0, 0);
            ContactDetailsPanel.this.shape.setSize(parent.getWidth(), parent.getHeight());
            ContactDetailsPanel.this.contactPanel.setLocation(ContactDetailsPanel.this.horizontalBorder, ContactDetailsPanel.this.verticalBorder);
            ContactDetailsPanel.this.contactPanel.setSize(parent.getWidth() - 2 * ContactDetailsPanel.this.horizontalBorder, parent.getHeight() - ContactDetailsPanel.this.verticalBorder * 2);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ContactDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ContactDetailsPanel.this.contactPanel.getPreferredSize().getHeight());
            return new Dimension(0, h += ContactDetailsPanel.this.verticalBorder);
        }
    }
}

