/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.customer.details;

import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.supplier.details.utils.ContactNameConverter;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.server.core.dtos.masterdata.ContactComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ContactComplete_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerComplete_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ContactsDetailsPanel
extends TableDetailsPanel<CustomerLight>
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private boolean isDeletable = true;

    public ContactsDetailsPanel(RowEditor<CustomerLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.CONTACTS);
        this.setOpaque(false);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 60, 60, 60));
        columns.add(new TableColumnInfo(Words.FUNCTION, null, null, null, "", 30, 30, 30));
        int aW = this.table.getCellPadding() * 2 + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", null, null, null, "", aW, aW, aW));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setRequestFocusOnAdd(true);
        table.setOverrideName(CustomerComplete_.contacts);
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        Node hqNode = this.editor.getModel().getNode().getChildNamed(CustomerComplete_.headQuarters);
        ContactComplete hq = new ContactComplete();
        hq.setCity((String)hqNode.getChildNamed(ContactComplete_.city).getValue());
        hq.setCountry((String)hqNode.getChildNamed(ContactComplete_.country).getValue());
        hq.setEmail("");
        hq.setFax((String)hqNode.getChildNamed(ContactComplete_.fax).getValue());
        hq.setFirstName("");
        hq.setFunction("");
        hq.setLastName("");
        hq.setMobile("");
        hq.setProvince((String)hqNode.getChildNamed(ContactComplete_.province).getValue());
        hq.setSitaCode("");
        hq.setStation("");
        hq.setStreet((String)hqNode.getChildNamed(ContactComplete_.street).getValue());
        hq.setStreetNumber((String)hqNode.getChildNamed(ContactComplete_.streetNumber).getValue());
        hq.setTel("");
        hq.setTitle("");
        hq.setZipCode((String)hqNode.getChildNamed(ContactComplete_.zipCode).getValue());
        hq.setClientOId(Long.valueOf(System.currentTimeMillis()));
        Node newChild = INodeCreator.getDefaultImpl().getNode4DTO((Object)hq, true, false);
        this.editor.getModel().getNode().getChildNamed(CustomerComplete_.contacts).addChild(newChild, System.currentTimeMillis());
        this.table.relayoutRequested();
        this.editor.revalidate();
    }

    @Override
    public void childRemoved() {
        this.editor.revalidate();
        this.table.relayoutRequested();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl rowPanel = new TableRowImpl(model);
        rowPanel.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return rowPanel;
    }

    @Override
    public void setNode(Node<?> node) {
        this.table.getModel().setNode(this.createList(node));
        node.getChildNamed(CustomerComplete_.contacts).addNodeListener((NodeListener)this);
        Node contacts = node.getChildNamed(CustomerComplete_.contacts);
        Iterator it = contacts.getChilds();
        while (it.hasNext()) {
            Node contact = (Node)it.next();
            this.childAdded(contacts, contact);
        }
    }

    private Node<?> createList(Node<?> n) {
        ViewNode list = new ViewNode("ContactList");
        list.addChild(n.getChildNamed(CustomerComplete_.headQuarters), 0L);
        return list;
    }

    public void childAdded(Node<?> source, Node<?> child) {
        if (source.getName().equals(CustomerComplete_.contacts.getFieldName()) && !this.table.getModel().getNode().contains(child)) {
            this.table.getModel().getNode().addChild(child, 0L);
        }
    }

    public void childRemoved(Node<?> source, Node<?> child) {
        if (source.getName().equals(CustomerComplete_.contacts.getFieldName())) {
            this.table.getModel().getNode().removeChild(child, 0L);
        }
    }

    public void valueChanged(Node<?> node) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public void requestFocusInWindowNow() {
        this.table.requestFocusInWindowNow();
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel name;
        private TextLabel function;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setSelectable(true);
            this.name = new TextLabel(m.getNode(), ConverterRegistry.getConverter(ContactNameConverter.class));
            this.name.addNodeToTextLabel(this.model.getNode().getChildNamed(ContactComplete_.firstName));
            this.name.addNodeToTextLabel(this.model.getNode().getChildNamed(ContactComplete_.lastName));
            if (this.model.getNode().getParent() instanceof ListNode && ContactsDetailsPanel.this.isDeletable) {
                this.delete = new DeleteButton();
                this.delete.addButtonListener(this);
            } else {
                this.setUseControlSkin(Table2RowPanel.TableControlsType.NONE);
            }
            this.function = new TextLabel(this.model.getNode().getChildNamed(ContactComplete_.function), ConverterRegistry.getConverter(StringConverter.class));
            this.setLayout(new InnerLayout());
            this.add(this.name);
            this.add(this.function);
            if (this.delete != null) {
                this.add(this.delete);
            }
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.name.getText();
                }
                case 1: {
                    return this.function.getText();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.name.setEnabled(isEnabled);
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled);
            }
            this.function.setEnabled(isEnabled);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            focusList.add(this);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.requestFocusInWindow();
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.name.kill();
            this.function.kill();
            if (this.delete != null) {
                this.delete.kill();
            }
            this.name = null;
            this.function = null;
            this.delete = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            long currentID = System.currentTimeMillis();
            if (ContactsDetailsPanel.this.editor.getModel().getNode().getChildNamed(CustomerComplete_.billingContact).getValue().equals(this.model.getNode().getValue())) {
                ContactsDetailsPanel.this.editor.getModel().getNode().getChildNamed(CustomerComplete_.billingContact).setValue(null, currentID);
            }
            ContactsDetailsPanel.this.editor.getModel().getNode().getChildNamed(CustomerComplete_.contacts).removeChild(this.model.getNode(), System.currentTimeMillis());
            ContactsDetailsPanel.this.table.getButtonHandler().childRemoved();
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.function.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.function.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.function.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.function.getPreferredSize().getHeight());
                TableRowImpl.this.setControlsX(currentX += w);
                if (TableRowImpl.this.delete != null) {
                    TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, ContactsDetailsPanel.this.table.getDefaultRowHeight());
            }
        }
    }
}

