/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.customer.details;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDInputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.CustomerAccess;
import ch.icit.pegasus.server.core.dtos.supply.CustomerComplete_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.DepartmentManHoursCostComplete;
import ch.icit.pegasus.server.core.dtos.supply.DepartmentManHoursCostComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ManHourCostDetailsPanel
extends TableDetailsPanel<CustomerLight> {
    private static final long serialVersionUID = 1L;
    private boolean canDelete;

    public ManHourCostDetailsPanel(RowEditor<CustomerLight> editor, RDProvider provider) {
        super(editor, provider, provider.isWritable(CustomerAccess.MAN_HOURS_ADD));
        this.setTitleText(Words.TENDER_PROCESS_COSTS);
        this.canDelete = provider.isWritable(CustomerAccess.MAN_HOURS_REMOVE);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.DEPARTMENT, null, null, null, "", 30, 30, 30));
        int tv = TableColumnInfo.periodColumnWidth * 2;
        columns.add(new TableColumnInfo(Words.VALIDITY, null, null, null, "", tv, tv, tv));
        tv = TableColumnInfo.priceColumnWidth + 2 * this.table.getCellPadding() + 20;
        columns.add(new TableColumnInfo(Words.MAN_HOUR_COST, null, null, null, "", tv, tv, tv));
        int tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setProvider(null);
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        Node latestData;
        InternalCostCenterComplete department = this.getFreeCosts();
        DepartmentManHoursCostComplete cost = new DepartmentManHoursCostComplete();
        cost.setDepartment((CostCenterComplete)department);
        cost.setManHourCost(new PriceComplete(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCurrency(), Double.valueOf(0.0)));
        Node node = latestData = this.table.getModel().getNode().getChildCount() > 0 ? this.table.getModel().getNode().getChildAt(this.table.getModel().getNode().getChildCount() - 1) : null;
        if (latestData != null) {
            Date d;
            Node latestDateStart = latestData.getChildNamed(new DtoField[]{DepartmentManHoursCostComplete_.validity, PeriodComplete_.startDate});
            Node latestDateEnd = latestData.getChildNamed(new DtoField[]{DepartmentManHoursCostComplete_.validity, PeriodComplete_.endDate});
            Date lastEnd = (Date)latestDateEnd.getValue();
            Date lastStart = (Date)latestDateStart.getValue();
            boolean isFuture = false;
            if (lastStart.getTime() > System.currentTimeMillis()) {
                isFuture = true;
            }
            boolean wasInfinity = false;
            if (CalendarUtil.isInfinityDate((Date)lastEnd)) {
                wasInfinity = true;
                if (isFuture) {
                    d = new Date(lastStart.getTime());
                    d = new PeriodComplete(null, d).getEndDate();
                    latestDateEnd.setValue((Object)d, 0L);
                } else {
                    d = new Date(System.currentTimeMillis());
                    d = new PeriodComplete(d, null).getStartDate();
                    d = new PeriodComplete(null, d).getEndDate();
                    latestDateEnd.setValue((Object)d, 0L);
                }
                d = new PeriodComplete(null, d).getEndDate();
            } else {
                d = lastEnd;
                d = new PeriodComplete(null, d).getEndDate();
            }
            d.setTime(d.getTime() + 2L);
            PeriodComplete period = new PeriodComplete(d, d);
            if (wasInfinity) {
                period.setEndDate(CalendarUtil.getInfinityDate());
            }
            cost.setValidity(period);
        } else {
            cost.setValidity(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
        }
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)cost, true, false);
        this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
    }

    @Override
    public void childRemoved() {
        this.editor.validate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl rowPanel = new TableRowImpl(model);
        rowPanel.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return rowPanel;
    }

    public InternalCostCenterComplete getFreeCosts() {
        Node cc = NodeToolkit.getAffixList(InternalCostCenterComplete.class);
        Iterator it = cc.getChilds();
        while (it.hasNext()) {
            Node c = (Node)it.next();
            boolean found = false;
            if (c.getValue() instanceof InternalCostCenterComplete) {
                for (Table2RowPanel p : this.table.getRows()) {
                    if (!((CostCenterComplete)c.getValue()).equals(p.getModel().getNode().getChildNamed(DepartmentManHoursCostComplete_.department).getValue())) continue;
                    found = true;
                }
            } else {
                found = true;
            }
            if (found) continue;
            return (InternalCostCenterComplete)c.getValue();
        }
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        return new ArrayList<ScreenValidationObject>();
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.table.getModel().setNode(node.getChildNamed(CustomerComplete_.manHourCosts));
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private RDComboBox department;
        private RDInputComboBox price;
        private TitledPeriodEditor period;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.department = new RDComboBox(ManHourCostDetailsPanel.this.provider, ConverterRegistry.getConverter(CostCenterConverter.class));
            this.department.refreshPossibleValues(NodeToolkit.getAffixList(InternalCostCenterComplete.class));
            this.department.setOverrideName(CustomerAccess.MAN_HOURS_DEPARTMENT);
            this.department.setNode(m.getNode().getChildNamed(DepartmentManHoursCostComplete_.department));
            this.price = new RDInputComboBox(ManHourCostDetailsPanel.this.provider, InputComboBox.InputComboBoxType.PRICE_DOUBLE);
            this.price.setOverrideName(CustomerAccess.MAN_HOURS_PRICE);
            this.price.setNode(m.getNode().getChildNamed(DepartmentManHoursCostComplete_.manHourCost));
            this.price.setUseMaxKommaStellen(true);
            this.price.setMaxKommaStellen(3);
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.period = new TitledPeriodEditor(null, null, false, ManHourCostDetailsPanel.this.provider, CustomerAccess.MAN_HOURS_DATE);
            this.period.enableInfinity(false, true);
            this.period.setStartDateNode(m.getNode().getChildNamed(new DtoField[]{DepartmentManHoursCostComplete_.validity, PeriodComplete_.startDate}));
            this.period.setEndDateNode(m.getNode().getChildNamed(new DtoField[]{DepartmentManHoursCostComplete_.validity, PeriodComplete_.endDate}));
            this.setLayout(new Layout());
            this.add(this.department);
            this.add(this.delete);
            this.add(this.price);
            this.add(this.period);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.department.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled && ManHourCostDetailsPanel.this.canDelete);
            this.price.setEnabled(isEnabled);
            this.period.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.department.kill();
            this.department = null;
            this.price.kill();
            this.price = null;
            this.period.kill();
            this.period = null;
            this.delete.kill();
            this.delete = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.department);
            CheckedListAdder.addToList(focusList, this.period);
            CheckedListAdder.addToList(focusList, this.price);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.department.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.department.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.department.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.department.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.period.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.period.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.period.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.period.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.price.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.price.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.price.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.price.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

