/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dailyops;

import ch.icit.pegasus.client.converter.CustomerCodeConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.FlightStateEWithWarningConverter;
import ch.icit.pegasus.client.converter.FlightTrackingNumberConverter;
import ch.icit.pegasus.client.converter.LegFromAirportConverter;
import ch.icit.pegasus.client.converter.LegToAirportConverter;
import ch.icit.pegasus.client.converter.LogTimeConverter;
import ch.icit.pegasus.client.converter.LogUserConverter;
import ch.icit.pegasus.client.converter.PaxConfigConverter;
import ch.icit.pegasus.client.converter.StowingListAircraftConverter;
import ch.icit.pegasus.client.converter.StowingListNameConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.dailyops.FlightDailyOpsModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.flight.FlightModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.flight.details.AdHocFlightDataDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.AdHocStwDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.AdditionalOrderDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.AlaCarteMenusDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.BondedEquipmentSealsDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.CustomsDocumentsDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.DelaysDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.EditPaxDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.FlightStateDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.RegularOrderDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.RemarkDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.SealDefinitionDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.SpecialMenusDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.TrucksDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flightschedule.details.HandlingCostDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flightschedule.details.StowingListDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.CombinedDetailsParagraph;
import ch.icit.pegasus.client.gui.table.InputMessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.fake.FakeSmartScreenTableRow;
import ch.icit.pegasus.client.gui.utils.RowTransferObject;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiHaulTypeSelectionComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiSelectionPanel;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.filterchain.UIStateLoadable;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.FlightSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.RetailInMotionSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.edelweiss.EdelweissSettingsComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.ReturnsCountStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.IStowingListLight;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.SubModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleTypeE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.AFlightAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightDailyOpsAccess;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class FlightDailyOpsModule
extends ScreenTableView<FlightLight, FlightSearchConfiguration.FLIGHT_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_FLIGHT = "flight_number";
    private static final String FILTER_CUSTOMER = "filter_customer";
    private static final String FILTER_DATE = "flight_date";
    private static final String FILTER_STATE = "filter_state";
    private static final String FILTER_STOWAGE_TYPE = "flight_stowage_type";
    private static final String FILTER_RC_STATE = "filter_rc_state";
    private static final String FILTER_STA_STD = "filter_sta_std";
    private static final String FILTER_HAUL_TYPE = "flightHaulType";
    private static final String FILTER_AIS_NEEDED = "aisPrintNeeded";
    private static final String FILTER_DELIVERY_AIRPORT = "DeliveryAirport";
    private String filterCriteria1;
    private CustomerLight filterCriteria2;
    private FlightStateE filterCriteria3;
    private Date filterCriteria4;
    private FlightSearchConfiguration.STOWAGE_TYPE_COLUMN filterCriteria5 = FlightSearchConfiguration.STOWAGE_TYPE_COLUMN.ALL;
    private ReturnsCountStateE rcState;
    private FlightSearchConfiguration.FLIGHT_STD_STA staStd;
    private List<HaulTypeComplete> haulType;
    private Boolean haultypeActivated = Boolean.FALSE;
    private Boolean aisPrintNeeded;
    private AirportComplete selectedDeliveryAirport;
    public static IStowingListLight currentStowingList;
    private ComboBox stateCombo;
    private ComboBox stowageTypeCombo;
    private ComboBox rcStateBox;
    private boolean onlyOpenFlights;
    private boolean ignoreCancelledFlights;
    private ComboBox periodSearchMode;
    private MultiSelectionPanel<MultiHaulTypeSelectionComboBox> haulPanel;
    private ComboBox aisPrintBox;

    public FlightDailyOpsModule() {
        super(FlightLight.class);
        this.isSynchronSearch = false;
        RDProvider p = new RDProvider(this.getCurrentAccessRight(this.getInvoker()), false);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.stateCombo != null) {
            this.stateCombo.kill();
        }
        if (this.stowageTypeCombo != null) {
            this.stowageTypeCombo.kill();
        }
        if (this.rcStateBox != null) {
            this.rcStateBox.kill();
        }
        if (this.aisPrintBox != null) {
            this.aisPrintBox.kill();
        }
        if (this.periodSearchMode != null) {
            this.periodSearchMode.kill();
        }
        if (this.haulPanel != null) {
            this.haulPanel.kill();
        }
        this.stateCombo = null;
        this.stowageTypeCombo = null;
        this.rcStateBox = null;
        this.periodSearchMode = null;
        this.haulPanel = null;
        this.aisPrintBox = null;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return FlightDailyOpsAccess.MODULE_FLIGHT_DAILY_OPS;
    }

    @Override
    public RowTransferObject<FlightLight> getRowAttributes(RowModel<FlightLight> model) {
        boolean mysticBoolean = false;
        RowTransferObject<FlightLight> o = new RowTransferObject<FlightLight>(model.getDTO(FlightLight.class), new FakeSmartScreenTableRow<FlightLight>(model), model.getParentModel().getDataHandler(), mysticBoolean, model, this);
        return o;
    }

    @Override
    public ASearchConfiguration<FlightLight, FlightSearchConfiguration.FLIGHT_COLUMN> getEmptySearchConfiguration() {
        return this.getSearchParameters(null, null, false, true, this.filterChain);
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", FlightSearchConfiguration.FLIGHT_COLUMN.OUTBOUND_CODE.toString() + "<>" + true);
        c.addProperty(FILTER_DATE, "25.04.2011");
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.stateCombo = ComboBoxFactory.getFlightStateComboBox(true);
        this.stowageTypeCombo = ComboBoxFactory.getStowageTypeComboBox(true);
        this.rcStateBox = ComboBoxFactory.getReturnCountStateComboBox(true);
        this.aisPrintBox = ComboBoxFactory.getAISPrintNeededComboBox(true);
        this.stateCombo.setSelectedItem(Words.ALL);
        this.filterChain.addSearchField(FILTER_FLIGHT, Words.DELIVERY_NO_OR_NAME, "");
        this.filterChain.addCustomerSearchField(FILTER_CUSTOMER);
        this.filterChain.addSelectionComboBox(this.stateCombo, FILTER_STATE, Words.STATE, Words.ALL);
        this.filterChain.addSelectionComboBox(this.stowageTypeCombo, 125, FILTER_STOWAGE_TYPE, Words.STOWAGE_TYPE, FlightSearchConfiguration.STOWAGE_TYPE_COLUMN.ALL);
        this.filterChain.addSelectionComboBox(this.rcStateBox, 135, FILTER_RC_STATE, Words.RC_STATE, FlightSearchConfiguration.STOWAGE_TYPE_COLUMN.ALL);
        this.periodSearchMode = new ComboBox();
        this.periodSearchMode.addItem(FlightSearchConfiguration.FLIGHT_STD_STA.staOnly);
        this.periodSearchMode.addItem(FlightSearchConfiguration.FLIGHT_STD_STA.stdOnly);
        this.periodSearchMode.addItem(FlightSearchConfiguration.FLIGHT_STD_STA.staStd);
        this.periodSearchMode.setDefaultIndex(FlightSearchConfiguration.FLIGHT_STD_STA.staStd);
        this.filterChain.addSelectionComboBox(this.periodSearchMode, 100, FILTER_STA_STD, " ", FlightSearchConfiguration.FLIGHT_STD_STA.staStd);
        UIStateLoadable p = this.filterChain.addDateSelection(FILTER_DATE, Words.DATE, new Date(this.getDefaultTime()));
        p.setShouldPersist(false);
        MultiHaulTypeSelectionComboBox haulCombo = new MultiHaulTypeSelectionComboBox(INodeCreator.getDefaultImpl().createNodes(new ArrayList(), false));
        this.haulPanel = new MultiSelectionPanel<MultiHaulTypeSelectionComboBox>(haulCombo);
        this.haulPanel.setShouldPersist(true);
        this.filterChain.addMultiSelection(this.haulPanel, FILTER_HAUL_TYPE, Words.HAUL_TYPE);
        this.filterChain.addSelectionComboBox(this.aisPrintBox, 110, FILTER_AIS_NEEDED, Words.AIS_PRINT, Words.ALL);
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (CompanyUtil.isSCK((SystemSettingsComplete)settings)) {
            this.filterChain.addAirportSearchField(FILTER_DELIVERY_AIRPORT);
        }
        this.filterChain.addResetButton();
    }

    protected long getDefaultTime() {
        long t = System.currentTimeMillis();
        return t += 86400000L;
    }

    @Override
    public ASearchConfiguration<FlightLight, FlightSearchConfiguration.FLIGHT_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.filterCriteria1 = null;
            this.filterCriteria2 = null;
            this.filterCriteria3 = null;
            this.filterCriteria4 = null;
            this.filterCriteria5 = FlightSearchConfiguration.STOWAGE_TYPE_COLUMN.ALL;
            this.onlyOpenFlights = false;
            this.ignoreCancelledFlights = false;
            this.rcState = null;
            this.aisPrintNeeded = null;
            this.staStd = FlightSearchConfiguration.FLIGHT_STD_STA.staStd;
            this.haultypeActivated = Boolean.FALSE;
            this.selectedDeliveryAirport = null;
        } else if (name == FILTER_FLIGHT) {
            this.filterCriteria1 = (String)value;
        } else if (name == FILTER_STA_STD) {
            this.staStd = (FlightSearchConfiguration.FLIGHT_STD_STA)value;
        } else if (name == FILTER_CUSTOMER) {
            this.filterCriteria2 = value instanceof CustomerLight ? (CustomerLight)value : null;
        } else if (name == FILTER_STATE) {
            if (value instanceof FlightStateE) {
                this.filterCriteria3 = (FlightStateE)value;
            } else if (value instanceof String) {
                if (value.equals(Words.ALL)) {
                    this.filterCriteria3 = null;
                    this.onlyOpenFlights = false;
                } else if (value.equals(Words.ALL_EXCEPT_PLANNED)) {
                    this.filterCriteria3 = null;
                    this.onlyOpenFlights = true;
                    this.ignoreCancelledFlights = false;
                } else if (value.equals(Words.ALL_EXCEPT_PLANNED_AND_CANCELLED)) {
                    this.filterCriteria3 = null;
                    this.onlyOpenFlights = true;
                    this.ignoreCancelledFlights = true;
                }
            } else {
                this.filterCriteria3 = null;
            }
        } else if (name == FILTER_HAUL_TYPE) {
            if (value instanceof Object[]) {
                this.haulType = new ArrayList<HaulTypeComplete>();
                for (Object a : (Object[])value) {
                    this.haulType.add((HaulTypeComplete)a);
                }
            } else if (value instanceof Boolean) {
                this.haultypeActivated = (Boolean)value;
            } else {
                this.haulType = null;
            }
        } else if (name == FILTER_DATE) {
            this.filterCriteria4 = (Date)value;
        } else if (name == FILTER_STOWAGE_TYPE) {
            this.filterCriteria5 = (FlightSearchConfiguration.STOWAGE_TYPE_COLUMN)value;
        } else if (name == FILTER_RC_STATE) {
            this.rcState = value instanceof String ? null : (ReturnsCountStateE)value;
        } else if (name == FILTER_AIS_NEEDED) {
            this.aisPrintNeeded = value != null ? (value.equals(Words.ALL) ? null : (value.equals(Words.HAS_CHANGES) ? Boolean.valueOf(true) : (value.equals(Words.NO_CHANGES) ? Boolean.valueOf(false) : null))) : null;
        } else if (name == FILTER_DELIVERY_AIRPORT) {
            this.selectedDeliveryAirport = value instanceof AirportComplete ? (AirportComplete)value : (value instanceof Node ? (AirportComplete)((Node)value).getValue() : null);
        }
        long t = this.getDefaultTime();
        if (this.filterCriteria4 != null) {
            t = this.filterCriteria4.getTime();
        }
        PeriodComplete p = new PeriodComplete(new Date(t), new Date(t));
        FlightSearchConfiguration c = new FlightSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        c.setCustomer(this.filterCriteria2);
        c.setFlightNumber(this.filterCriteria1);
        c.setFlightState(this.filterCriteria3);
        c.setDayPeriod(p);
        c.setStowageType(this.filterCriteria5);
        c.setLastUpdate(null);
        c.setOnlyOpenFlights(Boolean.valueOf(this.onlyOpenFlights));
        c.setRcState(this.rcState);
        c.setHaulTypeList(this.haulType);
        c.setShowNullHaulTypes(this.haultypeActivated);
        c.setIgnoreCancelledFlights(Boolean.valueOf(this.ignoreCancelledFlights));
        c.setAisPrintNeeded(this.aisPrintNeeded);
        c.setDeliveryAirport(this.selectedDeliveryAirport);
        c.setFlightStdSta((FlightSearchConfiguration.FLIGHT_STD_STA)this.periodSearchMode.getSelectedItem());
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<FlightLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(FlightSearchAlgorithm.class);
    }

    @Override
    public boolean isAnalysisModuleAllowed(SubModuleAccessRightComplete subModule) {
        if (subModule.getModule().getInvokingName().equals(FlightDailyOpsAccess.ANALYSIS_UPDATE_PRE_ORDERS.getIdentifier())) {
            return false;
        }
        if (subModule.getModule().getInvokingName().equals(FlightDailyOpsAccess.ANALYSIS_UPDATE_MAX_PAX.getIdentifier())) {
            return false;
        }
        if (subModule.getModule().getInvokingName().equals(FlightDailyOpsAccess.ANALYSIS_UPDATE_PAX_FORECAST_FILE_BASED.getIdentifier())) {
            return false;
        }
        if (subModule.getModule().getInvokingName().equals(FlightDailyOpsAccess.ANALYSIS_FLIGHT_RETAIL_IN_MOTION.getIdentifier())) {
            RetailInMotionSettingsComplete settings = (RetailInMotionSettingsComplete)NodeToolkit.getAffixClass(RetailInMotionSettingsComplete.class).getValue();
            return settings != null && Boolean.TRUE.equals(settings.getUseRetailInMotionInterface());
        }
        if (subModule.getModule().getInvokingName().equals(FlightAccess.ANALYSIS_FLIGHT_VECTOR_SALES_VALIDATION.getIdentifier())) {
            RetailInMotionSettingsComplete settings = (RetailInMotionSettingsComplete)NodeToolkit.getAffixClass(RetailInMotionSettingsComplete.class).getValue();
            return settings != null && Boolean.TRUE.equals(settings.getUseRetailInMotionInterface());
        }
        if (subModule.getModule().getInvokingName().equals(FlightAccess.ANALYSIS_EDELWEISS_PAX_VALIDATION.getIdentifier())) {
            EdelweissSettingsComplete settings = (EdelweissSettingsComplete)NodeToolkit.getAffixClass(EdelweissSettingsComplete.class).getValue();
            return settings != null && Boolean.TRUE.equals(settings.getUseEdelweissInterface());
        }
        return true;
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<FlightLight> model) {
        Object o;
        Object o2;
        FlightLight flight;
        try {
            if (model == null || model.getNode() == null || model.getNode().getValue() == null || ((ADTO)model.getNode().getValue()).getId() == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        if (screen.getInvokingName().equals(FlightAccess.ACTION_ADD_DELIVERY_SLIP.getIdentifier())) {
            FlightLight flight2 = model.getDTO();
            switch (flight2.getFlightState()) {
                case CANCELLED: 
                case CLOSED: 
                case DELETED: 
                case DISPATCHED: 
                case EN_ROUTE: 
                case OPEN: {
                    return true;
                }
                case PLANNED: {
                    return false;
                }
            }
            return true;
        }
        if (screen.getInvokingName().equals(FlightAccess.ACTION_CLOSE_FLIGHT.getIdentifier())) {
            FlightLight flight3 = model.getDTO();
            switch (flight3.getFlightState()) {
                case CANCELLED: 
                case CLOSED: {
                    return false;
                }
                case DELETED: 
                case DISPATCHED: 
                case EN_ROUTE: 
                case OPEN: 
                case PLANNED: {
                    break;
                }
            }
            return true;
        }
        if (screen.getInvokingName().equals(AFlightAccess.ACTION_UPDATE_FORECAST_PAX.getIdentifier())) {
            flight = model.getDTO();
            switch (flight.getFlightState()) {
                case CANCELLED: 
                case CLOSED: 
                case DELETED: 
                case DISPATCHED: 
                case EN_ROUTE: {
                    RDProvider p = new RDProvider(this.getCurrentAccessRight(this.getInvoker()), false);
                    boolean ignoreRestriction = p.isWritable("ignore_en_route_restrictions");
                    return ignoreRestriction;
                }
                case OPEN: {
                    return true;
                }
                case PLANNED: {
                    break;
                }
            }
        }
        if (screen.getInvokingName().equals(FlightAccess.PRINT_FLIGHT_KITCHEN_FORECAST.getIdentifier()) && model.getNode().getChildNamed(FlightLight_.excludeFromKitchenForecast) != null && (o2 = model.getNode().getChildNamed(FlightLight_.excludeFromKitchenForecast).getValue()) != null) {
            return (Boolean)o2 == false;
        }
        if (screen.getInvokingName().equals(AFlightAccess.ACTION_SWITCH_RIM_PRODUCT_CUSTOMER.getIdentifier()) && !Boolean.TRUE.equals((flight = model.getDTO()).getHasRetailInMotionTransactions())) {
            return false;
        }
        if (screen.getInvokingName().equals(FlightDailyOpsAccess.ANALYSIS_UPDATE_PRE_ORDERS.getIdentifier())) {
            return false;
        }
        if (screen.getInvokingName().equals(FlightDailyOpsAccess.ANALYSIS_UPDATE_MAX_PAX.getIdentifier())) {
            return false;
        }
        if (screen.getInvokingName().equals(FlightDailyOpsAccess.ANALYSIS_UPDATE_PAX_FORECAST_FILE_BASED.getIdentifier())) {
            return false;
        }
        boolean invoiceClosed = false;
        if (model.getNode().getChildNamed(FlightLight_.isInvoiceClosed) != null && (o = model.getNode().getChildNamed(FlightLight_.isInvoiceClosed).getValue()) != null) {
            invoiceClosed = (Boolean)o;
        }
        if ((screen.getType() == SubModuleTypeE.ACTION || screen.getType() == SubModuleTypeE.TOOL) && invoiceClosed) {
            return false;
        }
        if (model.getNode().getChildNamed(FlightLight_.upliftCount) != null && (o = model.getNode().getChildNamed(FlightLight_.upliftCount).getValue()) != null) {
            boolean uplift = (Boolean)o;
            if (screen.getInvokingName().equals(FlightDailyOpsAccess.TOOL_RETURNS_COUNT_DRAWER_BASED.getIdentifier())) {
                return !uplift;
            }
            if (screen.getInvokingName().equals(FlightDailyOpsAccess.TOOL_RETURNS_COUNT_EQUIPMENT_BASED.getIdentifier())) {
                return !uplift;
            }
            if (screen.getInvokingName().equals(FlightDailyOpsAccess.TOOL_UPLIFT_COUNT.getIdentifier())) {
                return uplift;
            }
            if (screen.getInvokingName().equals(FlightDailyOpsAccess.PRINT_COUNT_WORK_SHEET.getIdentifier())) {
                return !uplift;
            }
            if (screen.getInvokingName().equals(FlightDailyOpsAccess.PRINT_UPLIFT_COUNT_WORK_SHEET.getIdentifier())) {
                return uplift;
            }
            if (screen.getInvokingName().equals(FlightDailyOpsAccess.PRINT_UPLIFT_COUNT_SLIP.getIdentifier())) {
                return uplift;
            }
            if (screen.getInvokingName().equals(FlightDailyOpsAccess.PRINT_RETURNS_COUNT_SLIP.getIdentifier())) {
                return !uplift;
            }
        }
        if (screen.getInvokingName().equals(FlightAccess.EXPORT_RETAIL_IN_MOTION.getIdentifier()) || screen.getInvokingName().equals(FlightAccess.TOOL_EDIT_RIM_TRANSACTIONS.getIdentifier()) || screen.getInvokingName().equals(FlightAccess.ACTION_MOVE_RIM_TRANSACTIONS.getIdentifier()) || screen.getInvokingName().equals(FlightAccess.ACTION_SWITCH_RIM_PRODUCT_CUSTOMER.getIdentifier()) || screen.getInvokingName().equals(FlightAccess.ACTION_CHECKOUT_SOB_DATA.getIdentifier())) {
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            RetailInMotionSettingsComplete rimSettings = (RetailInMotionSettingsComplete)NodeToolkit.getAffixClass(RetailInMotionSettingsComplete.class).getValue();
            boolean showCheckout = true;
            if (settings != null && Boolean.TRUE.equals(rimSettings.getUseRetailInMotionInterface())) {
                FlightLight flight4;
                if ((screen.getInvokingName().equals(AFlightAccess.ACTION_SWITCH_RIM_PRODUCT_CUSTOMER.getIdentifier()) || screen.getInvokingName().equals(AFlightAccess.ACTION_MOVE_RIM_TRANSACTIONS.getIdentifier())) && !Boolean.TRUE.equals((flight4 = model.getDTO()).getHasRetailInMotionTransactions())) {
                    showCheckout = false;
                }
                if (screen.getInvokingName().equals(AFlightAccess.ACTION_CHECKOUT_SOB_DATA.getIdentifier()) && Boolean.TRUE.equals((flight4 = model.getDTO()).getRetailInMotionCheckoutDone())) {
                    showCheckout = false;
                }
                if (!Boolean.TRUE.equals(rimSettings.getUseRetailInMotionInterface()) || !Boolean.TRUE.equals(rimSettings.getAutoReceiveData())) {
                    showCheckout = false;
                }
            } else {
                showCheckout = false;
            }
            if (showCheckout) {
                return true;
            }
            return Boolean.TRUE.equals(settings.getChangeFlightStateToEnRouteWhenRcCheckout());
        }
        if (screen.getInvokingName().equals(FlightDailyOpsAccess.TOOL_FLIGHT_STOWING_EDITOR.getIdentifier())) {
            Object n = model.getNode().getValueForNamed("activeStowingList");
            return n != null;
        }
        return true;
    }

    @Override
    public boolean isDeletable(RowModel<FlightLight> model) {
        return false;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected RowEditorFactory<FlightLight> getRowEditorFactory() {
        return model -> {
            InputMessageProvidedRowEditor<FlightLight> rowEditor = new InputMessageProvidedRowEditor<FlightLight>(model, Words.ARE_YOU_SURE_TO_SAVE_FLIGHT);
            RDProvider p = this.createProvider(model.isAddRow());
            if (rowEditor.getModel().isAddRow()) {
                AdHocStwDetailsPanel d2 = new AdHocStwDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                AdHocFlightDataDetailsPanel d3 = new AdHocFlightDataDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                FlightStateDetailsPanel d1 = new FlightStateDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                d2.setDetailsPanel(d3);
                d3.setStwDetailsPanel(d2);
                d2.setReferencedLegTable(d2.getLegTable());
                d3.setReferencedLegTable(d2.getLegTable());
                CombinedDetailsParagraph c1 = new CombinedDetailsParagraph();
                c1.add((Component)d3, new TableLayoutConstraint(0, 0, 1.0, 0.5));
                c1.add((Component)d1, new TableLayoutConstraint(0, 1, 1.0, 0.5));
                CombinedDetailsParagraph c2 = new CombinedDetailsParagraph();
                c2.add((Component)c1, new TableLayoutConstraint(0, 0, 0.3f, 1.0));
                c2.add((Component)d2, new TableLayoutConstraint(1, 0, 0.7f, 1.0));
                rowEditor.add(c2, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
                rowEditor.addToFocusQueue(d3);
                rowEditor.addToFocusQueue(d2);
                rowEditor.addToFocusQueue(d1);
            } else {
                FlightStateDetailsPanel d1 = new FlightStateDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                RegularOrderDetailsPanel d40 = null;
                SpecialMenusDetailsPanel d4 = null;
                AlaCarteMenusDetailsPanel d41 = null;
                AdditionalOrderDetailsPanel d5 = null;
                StowingListDetailsPanel<FlightLight> d6 = null;
                RemarkDetailsPanel d7 = null;
                CustomsDocumentsDetailsPanel d8 = null;
                CombinedDetailsParagraph h1 = null;
                CombinedDetailsParagraph h11 = null;
                CombinedDetailsParagraph h2 = null;
                CombinedDetailsParagraph h21 = null;
                DelaysDetailsPanel d9 = null;
                HandlingCostDetailsPanel<FlightLight> d10 = null;
                HandlingCostDetailsPanel<FlightLight> d102 = null;
                TrucksDetailsPanel d11 = null;
                SealDefinitionDetailsPanel d12 = new SealDefinitionDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                BondedEquipmentSealsDetailsPanel d13 = new BondedEquipmentSealsDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                EditPaxDetailsPanel d2 = null;
                d7 = new RemarkDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                d9 = new DelaysDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                d10 = new HandlingCostDetailsPanel<FlightLight>(rowEditor, p, false, false);
                d102 = new HandlingCostDetailsPanel<FlightLight>(rowEditor, p, false, true);
                d40 = new RegularOrderDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                d2 = new EditPaxDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                d4 = new SpecialMenusDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                d41 = new AlaCarteMenusDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                d5 = new AdditionalOrderDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                d6 = new StowingListDetailsPanel<FlightLight>(rowEditor, p, FlightLight_.activeStowingList, true, (FlightModuleDataHandler)this.getTable().getModel().getDataHandler(), d4, d5, d12, d2.getPaxTable());
                d8 = new CustomsDocumentsDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                d11 = new TrucksDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                h1 = new CombinedDetailsParagraph();
                h1.add((Component)d1, new TableLayoutConstraint(0, 0, 0.5, 1.0));
                h1.add((Component)d2, new TableLayoutConstraint(1, 0, 0.5, 1.0));
                h11 = new CombinedDetailsParagraph();
                h11.add((Component)d9, new TableLayoutConstraint(0, 0, 0.2f, 1.0));
                h11.add(d6, new TableLayoutConstraint(1, 0, 0.8f, 1.0));
                h2 = new CombinedDetailsParagraph();
                h2.add((Component)d8, new TableLayoutConstraint(0, 0, 1.0, 1.0));
                h21 = new CombinedDetailsParagraph();
                h21.add(d10, new TableLayoutConstraint(0, 0, 0.5, 1.0));
                h21.add(d102, new TableLayoutConstraint(1, 0, 0.5, 1.0));
                rowEditor.add(h1, (Object)new TableLayoutConstraint(0, 0, 1.0, 0.0));
                rowEditor.add(h11, (Object)new TableLayoutConstraint(0, 1, 1.0, 0.0));
                rowEditor.add(h2, (Object)new TableLayoutConstraint(0, 2, 1.0, 0.0));
                rowEditor.add(h21, (Object)new TableLayoutConstraint(0, 3, 1.0, 0.0));
                rowEditor.add(d7, (Object)new TableLayoutConstraint(0, 4, 1.0, 0.0));
                rowEditor.add(d40, (Object)new TableLayoutConstraint(0, 5, 1.0, 0.0));
                rowEditor.add(d4, (Object)new TableLayoutConstraint(0, 6, 1.0, 0.0));
                rowEditor.add(d41, (Object)new TableLayoutConstraint(0, 7, 1.0, 0.0));
                rowEditor.add(d5, (Object)new TableLayoutConstraint(0, 8, 1.0, 0.0));
                rowEditor.add(d12, (Object)new TableLayoutConstraint(0, 9, 1.0, 1.0));
                rowEditor.add(d13, (Object)new TableLayoutConstraint(0, 10, 1.0, 1.0));
                rowEditor.add(d11, (Object)new TableLayoutConstraint(0, 11, 1.0, 1.0));
                rowEditor.addToFocusQueue(d1);
                rowEditor.addToFocusQueue(d2);
                rowEditor.addToFocusQueue(d6);
                rowEditor.addToFocusQueue(d9);
                rowEditor.addToFocusQueue(d8);
                rowEditor.addToFocusQueue(d10);
                rowEditor.addToFocusQueue(d102);
                rowEditor.addToFocusQueue(d7);
                rowEditor.addToFocusQueue(d40);
                rowEditor.addToFocusQueue(d4);
                rowEditor.addToFocusQueue(d41);
                rowEditor.addToFocusQueue(d5);
                rowEditor.addToFocusQueue(d11);
            }
            rowEditor.allInstalled();
            rowEditor.updateEnableStateToDetailsPanel();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new FlightDailyOpsModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> infos = new ArrayList<TableColumnInfo>();
        infos.add(new TableColumnInfo(Words.STATE, "", (Class)FlightStateEWithWarningConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.STATE, "", 131, 131, 131));
        SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        boolean isSCK = CompanyUtil.isSCK((SystemSettingsComplete)s);
        if (isSCK) {
            infos.add(new TableColumnInfo(Words.INBOUND, "", (Class)StringConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.INBOUND_CODE, FlightLight_.inboundCode, 60, 80, 60));
            infos.add(new TableColumnInfo(Words.STA, "", (Class)DateTimeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.PLANNED_ARRIVAL, FlightLight_.realsta, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
            infos.add(new TableColumnInfo(Words.FROM, "", LegFromAirportConverter.class, null, FlightLight_.legs, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth));
            infos.add(new TableColumnInfo(Words.OUTBOUND, "", (Class)StringConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.OUTBOUND_CODE, FlightLight_.outboundCode, 60, 80, 60));
            infos.add(new TableColumnInfo(Words.STD, "", (Class)DateTimeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.PLANNED_DEPARTURE, FlightLight_.realstd, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
            infos.add(new TableColumnInfo(Words.TO, "", LegToAirportConverter.class, null, FlightLight_.legs, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth));
        } else {
            infos.add(new TableColumnInfo(Words.OUTBOUND, "", (Class)StringConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.OUTBOUND_CODE, FlightLight_.outboundCode, 60, 80, 60));
            infos.add(new TableColumnInfo(Words.STD, "", (Class)DateTimeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.PLANNED_DEPARTURE, FlightLight_.realstd, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
            infos.add(new TableColumnInfo(Words.TO, "", LegToAirportConverter.class, null, FlightLight_.legs, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth));
            infos.add(new TableColumnInfo(Words.INBOUND, "", (Class)StringConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.INBOUND_CODE, FlightLight_.inboundCode, 60, 80, 60));
            infos.add(new TableColumnInfo(Words.STA, "", (Class)DateTimeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.PLANNED_ARRIVAL, FlightLight_.realsta, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
            infos.add(new TableColumnInfo(Words.FROM, "", LegFromAirportConverter.class, null, FlightLight_.legs, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth));
        }
        infos.add(new TableColumnInfo(Words.CUST, "", (Class)CustomerCodeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.CARRIER, FlightLight_.customer, 40, 40, 40));
        infos.add(new TableColumnInfo(Words.PAX_COUNT, "", PaxConfigConverter.class, null, "", 80, Integer.MAX_VALUE, 80));
        infos.add(new TableColumnInfo(Words.TRACKINGNO, "", FlightTrackingNumberConverter.class, null, FlightLight_.trackingNumber, 60, 60, 60));
        infos.add(new TableColumnInfo(Words.STOWING, "", (Class)StowingListNameConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.STOWINGLIST, FlightLight_.activeStowingList, 85, 180, 85));
        infos.add(new TableColumnInfo(Words.AIRCRAFT, "", StowingListAircraftConverter.class, null, FlightLight_.activeStowingList, 85, 85, 85));
        infos.add(new TableColumnInfo(Words.LAST_UPDATE, "", (Class)LogTimeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.LAST_UPDATE, FlightLight_.log, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
        infos.add(new TableColumnInfo(Words.DISPATCH, "", (Class)LogUserConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.DISPATCH, FlightLight_.log, 70, 170, 70));
        return infos;
    }
}

