/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dailyopskitchen;

import ch.icit.pegasus.client.converter.CustomerCodeConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.LegFromAirportConverter;
import ch.icit.pegasus.client.converter.LegToAirportConverter;
import ch.icit.pegasus.client.converter.PaxConfigConverter;
import ch.icit.pegasus.client.converter.StowingListNameConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.gui.modules.dailyops.FlightDailyOpsModule;
import ch.icit.pegasus.client.gui.modules.dailyopskitchen.KitchenDailyOpsModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.dailyopskitchen.details.FlightArticleByArticleSubstitutionDetailsPanel;
import ch.icit.pegasus.client.gui.modules.dailyopskitchen.details.FlightArticleByRecipeSubstitutionDetailsPanel;
import ch.icit.pegasus.client.gui.modules.dailyopskitchen.details.FlightDataDetailsPanel;
import ch.icit.pegasus.client.gui.modules.dailyopskitchen.details.FlightRecipeByArticleSubstitutionDetailsPanel;
import ch.icit.pegasus.client.gui.modules.itemsubstitution.details.ProductByProductSubstitutionDetailsPanel;
import ch.icit.pegasus.client.gui.modules.itemsubstitution.details.RecipeByRecipeSubstitutionDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.InputMessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.renderer.FlightSubstitutionStateRenderer;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiHaulTypeSelectionComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiSelectionPanel;
import ch.icit.pegasus.client.gui.utils.filterchain.UIStateLoadable;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.IStowingListLight;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleTypeE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.KitchenOpsAccess;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class KitchenDailyOpsModule
extends FlightDailyOpsModule {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_FLIGHT = "flight_number";
    private static final String FILTER_CUSTOMER = "filter_customer";
    private static final String FILTER_DATE = "flight_date";
    private static final String FILTER_STATE = "filter_state";
    private static final String FILTER_STA_STD = "filter_sta_std";
    private static final String FILTER_HAUL_TYPE = "flightHaulType";
    private static final String FILTER_HAS_SUBSTITUTIONS = "hasSubstitutions";
    private static final String FILTER_AIS_NEEDED = "aisPrintNeeded";
    private String filterCriteria1;
    private CustomerLight filterCriteria2;
    private Boolean filterCriteria3;
    private Date filterCriteria4;
    private FlightSearchConfiguration.FLIGHT_STD_STA staStd;
    private List<HaulTypeComplete> haulType;
    private Boolean haultypeActivated = Boolean.FALSE;
    private Boolean hasSubstitutions;
    private Boolean aisPrintNeeded;
    public static IStowingListLight currentStowingList;
    private ComboBox stateCombo;
    private ComboBox periodSearchMode;
    private MultiSelectionPanel<MultiHaulTypeSelectionComboBox> haulPanel;
    private ComboBox aisPrintBox;

    public KitchenDailyOpsModule() {
        this.isSynchronSearch = false;
        RDProvider p = new RDProvider(this.getCurrentAccessRight(this.getInvoker()), false);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.stateCombo.kill();
        this.periodSearchMode.kill();
        this.haulPanel.kill();
        this.aisPrintBox.kill();
        this.stateCombo = null;
        this.periodSearchMode = null;
        this.haulPanel = null;
        this.aisPrintBox = null;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return KitchenOpsAccess.MODULE_KITCHEN_OPS;
    }

    @Override
    protected void createFilterChain(long id) {
        this.stateCombo = ComboBoxFactory.getApprovedComboBox(true);
        this.aisPrintBox = ComboBoxFactory.getAISPrintNeededComboBox(true);
        this.filterChain.addSearchField(FILTER_FLIGHT, Words.FLIGHT_NUMBER, "");
        this.filterChain.addCustomerSearchField(FILTER_CUSTOMER);
        this.filterChain.addSelectionComboBox(this.stateCombo, 110, FILTER_STATE, Words.STATE, Words.ALL);
        this.periodSearchMode = new ComboBox();
        this.periodSearchMode.addItem(FlightSearchConfiguration.FLIGHT_STD_STA.staOnly);
        this.periodSearchMode.addItem(FlightSearchConfiguration.FLIGHT_STD_STA.stdOnly);
        this.periodSearchMode.addItem(FlightSearchConfiguration.FLIGHT_STD_STA.staStd);
        this.periodSearchMode.setDefaultIndex(FlightSearchConfiguration.FLIGHT_STD_STA.staStd);
        this.filterChain.addSelectionComboBox(this.periodSearchMode, 100, FILTER_STA_STD, " ", FlightSearchConfiguration.FLIGHT_STD_STA.staStd);
        UIStateLoadable p = this.filterChain.addDateSelection(FILTER_DATE, Words.DATE, new Date(this.getDefaultTime()));
        p.setShouldPersist(false);
        MultiHaulTypeSelectionComboBox haulCombo = new MultiHaulTypeSelectionComboBox(INodeCreator.getDefaultImpl().createNodes(new ArrayList(), false));
        this.haulPanel = new MultiSelectionPanel<MultiHaulTypeSelectionComboBox>(haulCombo);
        this.haulPanel.setShouldPersist(true);
        this.filterChain.addMultiSelection(this.haulPanel, FILTER_HAUL_TYPE, Words.HAUL_TYPE);
        this.filterChain.addSelectionComboBox(this.aisPrintBox, 100, FILTER_AIS_NEEDED, Words.AIS_PRINT, Words.ALL);
        this.filterChain.addSelectionComboBox(ComboBoxFactory.getHasSubstitutions(true), 120, FILTER_HAS_SUBSTITUTIONS, Words.HAS_SUBSTITUTIONS, Words.ALL);
        this.filterChain.addResetButton();
    }

    @Override
    protected boolean showDeletedComboBox() {
        return false;
    }

    @Override
    public ASearchConfiguration<FlightLight, FlightSearchConfiguration.FLIGHT_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.filterCriteria1 = null;
            this.filterCriteria2 = null;
            this.filterCriteria3 = null;
            this.filterCriteria4 = null;
            this.hasSubstitutions = null;
            this.aisPrintNeeded = null;
            this.staStd = FlightSearchConfiguration.FLIGHT_STD_STA.staStd;
            this.haultypeActivated = Boolean.FALSE;
        } else if (name == FILTER_FLIGHT) {
            this.filterCriteria1 = (String)value;
        } else if (name == FILTER_STA_STD) {
            this.staStd = (FlightSearchConfiguration.FLIGHT_STD_STA)value;
        } else if (name == FILTER_CUSTOMER) {
            this.filterCriteria2 = value instanceof CustomerLight ? (CustomerLight)value : null;
        } else if (name == FILTER_STATE) {
            this.filterCriteria3 = value instanceof String ? (Words.APPROVED_SUM.equals(value) ? Boolean.valueOf(true) : (Words.NOT_APPROVED.equals(value) ? Boolean.valueOf(false) : null)) : null;
        } else if (name == FILTER_HAUL_TYPE) {
            if (value instanceof Object[]) {
                this.haulType = new ArrayList<HaulTypeComplete>();
                for (Object a : (Object[])value) {
                    this.haulType.add((HaulTypeComplete)a);
                }
            } else if (value instanceof Boolean) {
                this.haultypeActivated = (Boolean)value;
            } else {
                this.haulType = null;
            }
        } else if (name == FILTER_DATE) {
            this.filterCriteria4 = (Date)value;
        } else if (name == FILTER_HAS_SUBSTITUTIONS) {
            this.hasSubstitutions = value instanceof String ? (Words.NO_SUBSTITUTIONS.equals(value) ? Boolean.valueOf(false) : (Words.HAS_SUBSTITUTIONS.equals(value) ? Boolean.valueOf(true) : null)) : null;
        } else if (name == FILTER_AIS_NEEDED) {
            this.aisPrintNeeded = value != null ? (value.equals(Words.ALL) ? null : (value.equals(Words.HAS_CHANGES) ? Boolean.valueOf(true) : (value.equals(Words.NO_CHANGES) ? Boolean.valueOf(false) : null))) : null;
        }
        long t = this.getDefaultTime();
        if (this.filterCriteria4 != null) {
            t = this.filterCriteria4.getTime();
        }
        PeriodComplete p = new PeriodComplete(new Date(t), new Date(t));
        FlightSearchConfiguration c = new FlightSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        c.setCustomer(this.filterCriteria2);
        c.setFlightNumber(this.filterCriteria1);
        c.setApprovedState(this.filterCriteria3);
        c.setDayPeriod(p);
        c.setLastUpdate(null);
        c.setOnlyOpenFlights(Boolean.valueOf(true));
        c.setHaulTypeList(this.haulType);
        c.setShowNullHaulTypes(this.haultypeActivated);
        c.setHasSubstitions(this.hasSubstitutions);
        c.setAisPrintNeeded(this.aisPrintNeeded);
        c.setFlightStdSta((FlightSearchConfiguration.FLIGHT_STD_STA)this.periodSearchMode.getSelectedItem());
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<FlightLight> model) {
        Object o;
        if (model == null || model.getNode() == null || model.getNode().getValue() == null || ((ADTO)model.getNode().getValue()).getId() == null) {
            return false;
        }
        boolean invoiceClosed = false;
        if (model.getNode().getChildNamed(FlightLight_.isInvoiceClosed) != null && (o = model.getNode().getChildNamed(FlightLight_.isInvoiceClosed).getValue()) != null) {
            invoiceClosed = (Boolean)o;
        }
        if ((screen.getType() == SubModuleTypeE.ACTION || screen.getType() == SubModuleTypeE.TOOL) && invoiceClosed) {
            return false;
        }
        if (screen.getInvokingName().equals(KitchenOpsAccess.TOOL_FLIGHT_STOWING_EDITOR.getIdentifier())) {
            Object n = model.getNode().getValueForNamed("activeStowingList");
            return n != null;
        }
        return !screen.getInvokingName().equals(KitchenOpsAccess.ACTION_APPROVE_FLIGHT_SUBSTITUTIONS.getIdentifier()) || ((FlightLight)model.getNode().getValue(FlightLight.class)).getSubstitutionsApproved() == false;
    }

    @Override
    protected RowEditorFactory<FlightLight> getRowEditorFactory() {
        return model -> {
            InputMessageProvidedRowEditor<FlightLight> rowEditor = new InputMessageProvidedRowEditor<FlightLight>(model, Words.ARE_YOU_SURE_TO_SAVE_FLIGHT);
            RDProvider p = this.createProvider(model.isAddRow());
            FlightDataDetailsPanel d0 = new FlightDataDetailsPanel((RowEditor)rowEditor, p);
            FlightArticleByArticleSubstitutionDetailsPanel d1 = new FlightArticleByArticleSubstitutionDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
            FlightArticleByRecipeSubstitutionDetailsPanel d2 = new FlightArticleByRecipeSubstitutionDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
            ProductByProductSubstitutionDetailsPanel<FlightLight> d3 = new ProductByProductSubstitutionDetailsPanel<FlightLight>(rowEditor, p){

                @Override
                public boolean getShowFlightColumn() {
                    return false;
                }
            };
            FlightRecipeByArticleSubstitutionDetailsPanel d4 = new FlightRecipeByArticleSubstitutionDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
            RecipeByRecipeSubstitutionDetailsPanel<FlightLight> d5 = new RecipeByRecipeSubstitutionDetailsPanel<FlightLight>(rowEditor, p){

                @Override
                public boolean getShowFlightColumn() {
                    return false;
                }
            };
            rowEditor.add(d0, (Object)new TableLayoutConstraint(0, 0, 1.0, 0.0));
            rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 1, 1.0, 1.0));
            rowEditor.add(d2, (Object)new TableLayoutConstraint(0, 2, 1.0, 1.0));
            rowEditor.add(d3, (Object)new TableLayoutConstraint(0, 3, 1.0, 1.0));
            rowEditor.add(d4, (Object)new TableLayoutConstraint(0, 4, 1.0, 1.0));
            rowEditor.add(d5, (Object)new TableLayoutConstraint(0, 5, 1.0, 1.0));
            rowEditor.addToFocusQueue(d0);
            rowEditor.addToFocusQueue(d1);
            rowEditor.addToFocusQueue(d2);
            rowEditor.addToFocusQueue(d3);
            rowEditor.addToFocusQueue(d4);
            rowEditor.addToFocusQueue(d5);
            rowEditor.allInstalled();
            rowEditor.updateEnableStateToDetailsPanel();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new KitchenDailyOpsModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> info = new ArrayList<TableColumnInfo>();
        info.add(new TableColumnInfo(Words.STATE, "", FlightSubstitutionStateRenderer.class, null, "", 83, 83, 83));
        info.add(new TableColumnInfo(Words.OUTBOUND, "", (Class)StringConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.OUTBOUND_CODE, FlightLight_.outboundCode, 60, 80, 60));
        info.add(new TableColumnInfo(Words.STD, "", (Class)DateTimeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.PLANNED_DEPARTURE, FlightLight_.realstd, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
        info.add(new TableColumnInfo(Words.TO, "", LegToAirportConverter.class, null, FlightLight_.legs, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth));
        info.add(new TableColumnInfo(Words.INBOUND, "", (Class)StringConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.INBOUND_CODE, FlightLight_.inboundCode, 60, 80, 60));
        info.add(new TableColumnInfo(Words.STA, "", (Class)DateTimeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.PLANNED_ARRIVAL, FlightLight_.realsta, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
        info.add(new TableColumnInfo(Words.FROM, "", LegFromAirportConverter.class, null, FlightLight_.legs, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth));
        info.add(new TableColumnInfo(Words.CUST, "", (Class)CustomerCodeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.CARRIER, FlightLight_.customer, 40, 40, 40));
        info.add(new TableColumnInfo(Words.PAX_COUNT, "", PaxConfigConverter.class, null, "", 80, Integer.MAX_VALUE, 80));
        info.add(new TableColumnInfo(Words.STOWING, "", (Class)StowingListNameConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.STOWINGLIST, FlightLight_.activeStowingList, 85, 180, 85));
        return info;
    }
}

