/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.converter.KonterProbenLastUpdateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelKillable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBox;
import ch.icit.pegasus.client.gui.utils.tables.CustomerSearchTable;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.internalconsumption.KonterProbenSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.internalconsumption.KonterProbenSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.util.DailyTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class InternalConsumptionExchangeInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private ScrollPane scrollPane;
    private JPanelKillable contentPane;
    private TitledItem<CheckBox> active;
    private TitledItem<CheckBox> includeMeals;
    private TitledItem<CheckBox> includeSPMLs;
    private TitledItem<CheckBox> includeAdditionals;
    private TitledItem<CheckBox> includeAlaCarte;
    private TitledItem<CheckBox> includeStandards;
    private TitledItem<TextField> addDays;
    private TitledItem<TextField> dayPeriod;
    private TitledItem<TextField> defaultName;
    private CustomerSearchTable excludeCustomers;
    private TitledItem<StorePositionSearchBox> defaultTarget;
    private TitledItem<TextField> startTime;
    private TitledItem<TextField> endTime;
    private TextLabel lastUpdates;
    private TablePanelAddSaveButton generateConsumption;
    private TablePanelAddSaveButton saveButton;
    private final DataExchangeModule module;
    protected Node<KonterProbenSettingsComplete> settings;
    protected KonterProbenSettingsComplete edsc;

    public InternalConsumptionExchangeInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.contentPane = new JPanelKillable();
        this.contentPane.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
        this.scrollPane = new ScrollPane();
        this.scrollPane.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
        this.scrollPane.getHorizontalScrollBar().setBackground(this.scrollPane.getBackground());
        this.scrollPane.getVerticalScrollBar().setBackground(this.scrollPane.getBackground());
        this.scrollPane.setViewportView(this.contentPane);
        this.active = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(KonterProbenSettingsComplete_.active)), "Active", TitledItem.TitledItemOrientation.EAST);
        this.active.getElement().addButtonListener(this);
        this.includeMeals = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(KonterProbenSettingsComplete_.includeMeals)), "Include Meals", TitledItem.TitledItemOrientation.EAST);
        this.includeSPMLs = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(KonterProbenSettingsComplete_.includeSPMLs)), "Include Special Meals", TitledItem.TitledItemOrientation.EAST);
        this.includeAlaCarte = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(KonterProbenSettingsComplete_.includeAlaCarte)), "Include ala Carte", TitledItem.TitledItemOrientation.EAST);
        this.includeAdditionals = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(KonterProbenSettingsComplete_.includeAdditionals)), "Include Additionals", TitledItem.TitledItemOrientation.EAST);
        this.includeStandards = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(KonterProbenSettingsComplete_.includeStandards)), "Include Standards", TitledItem.TitledItemOrientation.EAST);
        this.addDays = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(KonterProbenSettingsComplete_.addDays), TextFieldType.INT), "Add Days", TitledItem.TitledItemOrientation.NORTH);
        this.dayPeriod = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(KonterProbenSettingsComplete_.dayPeriod), TextFieldType.INT), "Day Period", TitledItem.TitledItemOrientation.NORTH);
        this.startTime = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(KonterProbenSettingsComplete_.startTime), TextFieldType.DAYTIME), "Start Time", TitledItem.TitledItemOrientation.NORTH);
        this.endTime = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(KonterProbenSettingsComplete_.endTime), TextFieldType.DAYTIME), "End Time", TitledItem.TitledItemOrientation.NORTH);
        this.defaultName = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(KonterProbenSettingsComplete_.defaultName)), "Default Name", TitledItem.TitledItemOrientation.NORTH);
        this.excludeCustomers = new CustomerSearchTable("Exclude Customers");
        this.defaultTarget = new TitledItem<StorePositionSearchBox>(new StorePositionSearchBox((Node<StorePositionLight>)this.settings.getChildNamed(KonterProbenSettingsComplete_.targetPosition)), "Default Target", TitledItem.TitledItemOrientation.NORTH);
        this.lastUpdates = new TextLabel(this.settings, ConverterRegistry.getConverter(KonterProbenLastUpdateConverter.class));
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText("History");
        this.sendPanel.setHasBackground(true);
        this.generateConsumption = new TablePanelAddSaveButton();
        this.generateConsumption.setText("Generate");
        this.generateConsumption.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.contentPane.setLayout(new ConfigLayout());
        this.configPanel.setLayout(new ScrollPaneLayout());
        this.contentPane.add(this.active);
        this.contentPane.add(this.includeMeals);
        this.contentPane.add(this.includeSPMLs);
        this.contentPane.add(this.defaultName);
        this.contentPane.add(this.excludeCustomers);
        this.contentPane.add(this.defaultTarget);
        this.contentPane.add(this.includeAdditionals);
        this.contentPane.add(this.includeAlaCarte);
        this.contentPane.add(this.includeStandards);
        this.contentPane.add(this.addDays);
        this.contentPane.add(this.dayPeriod);
        this.contentPane.add(this.lastUpdates);
        this.contentPane.add(this.startTime);
        this.contentPane.add(this.endTime);
        this.configPanel.add(this.scrollPane);
        this.sendPanel.add(this.saveButton);
        this.sendPanel.add(this.generateConsumption);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                try {
                    InternalConsumptionExchangeInsert.this.edsc = (KonterProbenSettingsComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getKonterProbenSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                InternalConsumptionExchangeInsert.this.edsc.setTimerServiceSettings(InternalConsumptionExchangeInsert.this.createTimerService());
                InternalConsumptionExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)InternalConsumptionExchangeInsert.this.edsc, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return InternalConsumptionExchangeInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.active.setEnabled(isEnabled);
            boolean b = isEnabled && this.active.getElement().isChecked();
            this.generateConsumption.setEnabled(isEnabled);
            this.includeMeals.setEnabled(b);
            this.includeSPMLs.setEnabled(b);
            this.addDays.setEnabled(b);
            this.dayPeriod.setEnabled(b);
            this.includeAdditionals.setEnabled(b);
            this.includeAlaCarte.setEnabled(b);
            this.includeStandards.setEnabled(b);
            this.startTime.setEnabled(b);
            this.endTime.setEnabled(b);
            this.lastUpdates.setEnabled(b);
            this.defaultTarget.setEnabled(b);
            this.defaultName.setEnabled(b);
            this.excludeCustomers.setEnabled(b);
            this.saveButton.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.scrollPane.kill();
            this.includeAlaCarte.kill();
            this.includeAdditionals.kill();
            this.includeSPMLs.kill();
            this.includeMeals.kill();
            this.includeStandards.kill();
            this.addDays.kill();
            this.dayPeriod.kill();
            this.defaultName.kill();
            this.defaultTarget.kill();
            this.excludeCustomers.kill();
            this.lastUpdates.kill();
            this.saveButton.kill();
            this.active.kill();
            this.startTime.kill();
            this.endTime.kill();
            this.startTime = null;
            this.endTime = null;
            this.scrollPane = null;
            this.defaultName = null;
            this.defaultTarget = null;
            this.excludeCustomers = null;
            this.includeMeals = null;
            this.includeSPMLs = null;
            this.includeAdditionals = null;
            this.includeAlaCarte = null;
            this.includeStandards = null;
            this.addDays = null;
            this.dayPeriod = null;
            this.saveButton = null;
        }
        this.sendPanel = null;
        this.configPanel = null;
        this.lastUpdates = null;
        this.active = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return "Konter Proben";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.generateConsumption) {
            this.setEnabled(false);
            this.ensureAnimation("Generate Konter Proben");
            this.processFiles();
            this.module.started();
            return;
        }
        if (source != this.saveButton) {
            this.setEnabled(this.isEnabled());
            return;
        }
        List<ScreenValidationObject> a = this.validateKonterProbenConfig();
        if (a.isEmpty()) {
            this.ensureAnimation(Words.SAVE_DATA);
            this.saveConfig();
            return;
        }
        InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
        this.setEnabled(true);
    }

    private List<ScreenValidationObject> validateKonterProbenConfig() {
        return new ArrayList<ScreenValidationObject>();
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                InternalConsumptionExchangeInsert.this.settings.commit(KonterProbenSettingsComplete.class);
                KonterProbenSettingsComplete rimsc = (KonterProbenSettingsComplete)InternalConsumptionExchangeInsert.this.settings.getValue();
                rimsc.setTimerServiceSettings(InternalConsumptionExchangeInsert.this.createTimerService());
                if (Boolean.TRUE.equals(rimsc.getActive())) {
                    KonterProbenSettingsComplete konterProben = rimsc = (KonterProbenSettingsComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).updateKonterProbenSettings(rimsc).getValue();
                    TimerServiceSettingsComplete ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(konterProben.getTimerServiceSettings()).getValue();
                    konterProben.setTimerServiceSettings(ts);
                    konterProben = (KonterProbenSettingsComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).updateKonterProbenSettings(konterProben).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.KONTER_PROBEN_EXCHANGE, konterProben.getActive().booleanValue(), ts, -1L);
                    Node s = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                    Node settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)rimsc, false, false);
                    InternalConsumptionExchangeInsert.this.lastUpdates.setNode(settings);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.KONTER_PROBEN_EXCHANGE);
                    rimsc = (KonterProbenSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimsc).getValue();
                    Node s = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                    Node settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)rimsc, false, false);
                    InternalConsumptionExchangeInsert.this.lastUpdates.setNode(settings);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        InternalConsumptionExchangeInsert.this.hideAnimation();
                        InternalConsumptionExchangeInsert.this.module.ended();
                        InternalConsumptionExchangeInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)InternalConsumptionExchangeInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createTimerService() {
        TimerServiceSettingsComplete ts = new TimerServiceSettingsComplete();
        ts.setClientOId(Long.valueOf(ADTO.getNextId()));
        ts.setTimerServiceConfig((TimerServiceConfigComplete)new DailyTimeComplete(Integer.valueOf(4), Integer.valueOf(0)));
        ts.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return ts;
    }

    private void processFiles() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n = new Node();
                ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).generateKonterProbenManually();
                n.setValue((Object)true, 0L);
                InternalConsumptionExchangeInsert.this.edsc = (KonterProbenSettingsComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getKonterProbenSettings().getValue();
                InternalConsumptionExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)InternalConsumptionExchangeInsert.this.edsc, false, false);
                InternalConsumptionExchangeInsert.this.lastUpdates.setNode((Node)InternalConsumptionExchangeInsert.this.settings);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        boolean read = (Boolean)node.getValue();
                        InternalConsumptionExchangeInsert.this.hideAnimation();
                        InternalConsumptionExchangeInsert.this.module.ended();
                        InternalConsumptionExchangeInsert.this.setEnabled(true);
                        if (read) {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_IMPORTED, InternalConsumptionExchangeInsert.this.generateConsumption);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, Words.UNABLE_TO_CREATE_EDELWEISS_IMPORT, (Component)InternalConsumptionExchangeInsert.this.generateConsumption);
                        InternalConsumptionExchangeInsert.this.hideAnimation();
                        InternalConsumptionExchangeInsert.this.setEnabled(true);
                        InternalConsumptionExchangeInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ScrollPaneLayout
    extends DefaultLayout {
        private ScrollPaneLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            InternalConsumptionExchangeInsert.this.configPanel.layoutTitle(parent);
            InternalConsumptionExchangeInsert.this.scrollPane.setLocation(1, InternalConsumptionExchangeInsert.this.configPanel.getTitleHeight());
            InternalConsumptionExchangeInsert.this.scrollPane.setSize(parent.getWidth() - 2, parent.getHeight() - (InternalConsumptionExchangeInsert.this.configPanel.getTitleHeight() + 1));
        }
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            InternalConsumptionExchangeInsert.this.active.setLocation(border, border);
            InternalConsumptionExchangeInsert.this.active.setSize(InternalConsumptionExchangeInsert.this.active.getPreferredSize());
            InternalConsumptionExchangeInsert.this.includeMeals.setLocation(border, InternalConsumptionExchangeInsert.this.active.getY() + InternalConsumptionExchangeInsert.this.active.getHeight() + border);
            InternalConsumptionExchangeInsert.this.includeMeals.setSize(InternalConsumptionExchangeInsert.this.includeMeals.getPreferredSize());
            InternalConsumptionExchangeInsert.this.includeSPMLs.setLocation(border, InternalConsumptionExchangeInsert.this.includeMeals.getY() + InternalConsumptionExchangeInsert.this.includeMeals.getHeight());
            InternalConsumptionExchangeInsert.this.includeSPMLs.setSize(InternalConsumptionExchangeInsert.this.includeSPMLs.getPreferredSize());
            InternalConsumptionExchangeInsert.this.includeAlaCarte.setLocation(border, InternalConsumptionExchangeInsert.this.includeSPMLs.getY() + InternalConsumptionExchangeInsert.this.includeSPMLs.getHeight());
            InternalConsumptionExchangeInsert.this.includeAlaCarte.setSize(InternalConsumptionExchangeInsert.this.includeAlaCarte.getPreferredSize());
            InternalConsumptionExchangeInsert.this.includeAdditionals.setLocation(border, InternalConsumptionExchangeInsert.this.includeAlaCarte.getY() + InternalConsumptionExchangeInsert.this.includeAlaCarte.getHeight());
            InternalConsumptionExchangeInsert.this.includeAdditionals.setSize(InternalConsumptionExchangeInsert.this.includeAdditionals.getPreferredSize());
            InternalConsumptionExchangeInsert.this.includeStandards.setLocation(border, InternalConsumptionExchangeInsert.this.includeAdditionals.getY() + InternalConsumptionExchangeInsert.this.includeAdditionals.getHeight());
            InternalConsumptionExchangeInsert.this.includeStandards.setSize(InternalConsumptionExchangeInsert.this.includeStandards.getPreferredSize());
            InternalConsumptionExchangeInsert.this.addDays.setLocation(border, InternalConsumptionExchangeInsert.this.includeStandards.getY() + InternalConsumptionExchangeInsert.this.includeStandards.getHeight() + border);
            InternalConsumptionExchangeInsert.this.addDays.setSize(InternalConsumptionExchangeInsert.this.addDays.getPreferredSize());
            InternalConsumptionExchangeInsert.this.dayPeriod.setLocation(border, InternalConsumptionExchangeInsert.this.addDays.getY() + InternalConsumptionExchangeInsert.this.addDays.getHeight());
            InternalConsumptionExchangeInsert.this.dayPeriod.setSize(InternalConsumptionExchangeInsert.this.dayPeriod.getPreferredSize());
            InternalConsumptionExchangeInsert.this.defaultName.setLocation(border, InternalConsumptionExchangeInsert.this.dayPeriod.getY() + InternalConsumptionExchangeInsert.this.dayPeriod.getHeight());
            InternalConsumptionExchangeInsert.this.defaultName.setSize(InternalConsumptionExchangeInsert.this.defaultName.getPreferredSize());
            InternalConsumptionExchangeInsert.this.defaultTarget.setLocation(border, InternalConsumptionExchangeInsert.this.defaultName.getY() + InternalConsumptionExchangeInsert.this.defaultName.getHeight());
            InternalConsumptionExchangeInsert.this.defaultTarget.setSize(300, (int)InternalConsumptionExchangeInsert.this.defaultTarget.getPreferredSize().getHeight());
            InternalConsumptionExchangeInsert.this.startTime.setLocation(border, InternalConsumptionExchangeInsert.this.defaultTarget.getY() + InternalConsumptionExchangeInsert.this.defaultTarget.getHeight() + border);
            InternalConsumptionExchangeInsert.this.startTime.setSize(InternalConsumptionExchangeInsert.this.startTime.getPreferredSize());
            InternalConsumptionExchangeInsert.this.endTime.setLocation(InternalConsumptionExchangeInsert.this.startTime.getX() + InternalConsumptionExchangeInsert.this.startTime.getWidth() + border, InternalConsumptionExchangeInsert.this.startTime.getY());
            InternalConsumptionExchangeInsert.this.endTime.setSize(InternalConsumptionExchangeInsert.this.endTime.getPreferredSize());
            InternalConsumptionExchangeInsert.this.lastUpdates.setLocation(border, InternalConsumptionExchangeInsert.this.endTime.getY() + InternalConsumptionExchangeInsert.this.endTime.getHeight());
            InternalConsumptionExchangeInsert.this.lastUpdates.setSize(InternalConsumptionExchangeInsert.this.lastUpdates.getPreferredSize());
            InternalConsumptionExchangeInsert.this.excludeCustomers.setLocation(border, InternalConsumptionExchangeInsert.this.lastUpdates.getY() + InternalConsumptionExchangeInsert.this.lastUpdates.getHeight() + border);
            InternalConsumptionExchangeInsert.this.excludeCustomers.setSize(parent.getWidth() - 2 * InternalConsumptionExchangeInsert.this.excludeCustomers.getX(), 200);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border;
            int h = border = 10;
            h = (int)((double)h + InternalConsumptionExchangeInsert.this.active.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + InternalConsumptionExchangeInsert.this.includeMeals.getPreferredSize().getHeight());
            h = (int)((double)h + InternalConsumptionExchangeInsert.this.includeSPMLs.getPreferredSize().getHeight());
            h = (int)((double)h + InternalConsumptionExchangeInsert.this.includeAlaCarte.getPreferredSize().getHeight());
            h = (int)((double)h + InternalConsumptionExchangeInsert.this.includeAdditionals.getPreferredSize().getHeight());
            h = (int)((double)h + InternalConsumptionExchangeInsert.this.includeStandards.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + InternalConsumptionExchangeInsert.this.addDays.getPreferredSize().getHeight());
            h = (int)((double)h + InternalConsumptionExchangeInsert.this.dayPeriod.getPreferredSize().getHeight());
            h = (int)((double)h + InternalConsumptionExchangeInsert.this.defaultName.getPreferredSize().getHeight());
            h = (int)((double)h + InternalConsumptionExchangeInsert.this.defaultTarget.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + InternalConsumptionExchangeInsert.this.startTime.getPreferredSize().getHeight());
            h = (int)((double)h + InternalConsumptionExchangeInsert.this.lastUpdates.getPreferredSize().getHeight());
            h = (int)((double)h + InternalConsumptionExchangeInsert.this.saveButton.getPreferredSize().getHeight());
            h += border;
            return new Dimension(0, h += 200);
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            InternalConsumptionExchangeInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            InternalConsumptionExchangeInsert.this.generateConsumption.setLocation(border, (int)((double)parent.getHeight() - (InternalConsumptionExchangeInsert.this.generateConsumption.getPreferredSize().getHeight() + (double)border)));
            InternalConsumptionExchangeInsert.this.generateConsumption.setSize(InternalConsumptionExchangeInsert.this.generateConsumption.getPreferredSize());
            InternalConsumptionExchangeInsert.this.saveButton.setLocation(InternalConsumptionExchangeInsert.this.generateConsumption.getX() + InternalConsumptionExchangeInsert.this.generateConsumption.getWidth() + border, InternalConsumptionExchangeInsert.this.generateConsumption.getY());
            InternalConsumptionExchangeInsert.this.saveButton.setSize(InternalConsumptionExchangeInsert.this.saveButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (InternalConsumptionExchangeInsert.this.animation != null) {
                InternalConsumptionExchangeInsert.this.animation.setLocation((int)((double)parent.getWidth() - InternalConsumptionExchangeInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - InternalConsumptionExchangeInsert.this.animation.getPreferredSize().getHeight()) / 2);
                InternalConsumptionExchangeInsert.this.animation.setSize(InternalConsumptionExchangeInsert.this.animation.getPreferredSize());
            }
            if (InternalConsumptionExchangeInsert.this.isInserted) {
                InternalConsumptionExchangeInsert.this.configPanel.setLocation(border, border);
                InternalConsumptionExchangeInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                InternalConsumptionExchangeInsert.this.sendPanel.setLocation(InternalConsumptionExchangeInsert.this.configPanel.getX() + InternalConsumptionExchangeInsert.this.configPanel.getWidth() + border, border);
                InternalConsumptionExchangeInsert.this.sendPanel.setSize(InternalConsumptionExchangeInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

