/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.textfield.PasswordTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.JimdoServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.JimdoSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.JimdoSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.util.TimeDurationComplete;
import ch.icit.pegasus.server.core.dtos.util.TimeUnitE;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class JimdoOrderImportInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TitledItem<CheckBox> useJimdoInterface;
    private TitledItem<TextField> orderMailServer;
    private TitledItem<TextField> orderMailServerUser;
    private TitledItem<PasswordTextField> orderMailServerPassword;
    private TitledItem<TextField> stornoMailAddress;
    private TitledItem<TextField> orderMailAddress;
    private TitledItem<TextField> qrBCCMailAddress;
    private TitledItem<CheckBox> sendGuddInvoice;
    private TitledItem<CheckBox> sendQRCodeWithGuddInvoice;
    private TitledItem<TextField> sendMailServer;
    private TitledItem<TextField> sendMailServerUser;
    private TitledItem<PasswordTextField> sendMailServerPassword;
    private TitledItem<TextField> mailSender;
    private TitledItem<TextField> defaultFlightName;
    private TitledItem<SearchTextField2<CustomerLight>> customer;
    private TitledItem<SearchTextField2<StowingListTemplateComplete>> stowingList;
    private TitledItem<TextField> jimdoMailAddress;
    private TitledItem<TextField> alertMessageAddress;
    private TitledItem<TextField> financeMailAddress;
    private TitledItem<TextField> productionMailAddress;
    private TitledItem<TextField> qrCodeMessageSubject;
    private TitledItem<TextField> qrCodeMessageTemplate;
    private TitledItem<TextField> qrCodeWithInvoiceMessageSubject;
    private TitledItem<TextField> qrCodeWithInvoiceMessageTemplate;
    private TitledItem<TextField> invoiceMessageSubject;
    private TitledItem<TextField> invoiceMessageTemplate;
    private TitledItem<TextField> messageStornoOk;
    private TitledItem<TextField> messageStornoAlreadyPickedUp;
    private TitledItem<TextField> messageStornoNotPossibleTime;
    private TitledItem<TextField> messageStornoNotPossibleMailNumberError;
    private TablePanelAddSaveButton saveButton;
    private TablePanelAddSaveButton readButton;
    private final DataExchangeModule module;
    protected Node<JimdoSettingsComplete> settings;
    protected JimdoSettingsComplete arisc;

    public JimdoOrderImportInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.useJimdoInterface = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(JimdoSettingsComplete_.useJimdoInterface)), "Enable Jimdo Order Interface", TitledItem.TitledItemOrientation.EAST);
        this.useJimdoInterface.getElement().addButtonListener(this);
        this.orderMailServer = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(JimdoSettingsComplete_.orderMailServer)), "Order Mail Server", TitledItem.TitledItemOrientation.NORTH);
        this.orderMailServerUser = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(JimdoSettingsComplete_.orderMailServerUser)), "Order Mail User", TitledItem.TitledItemOrientation.NORTH);
        this.orderMailServerPassword = new TitledItem<PasswordTextField>(new PasswordTextField(this.settings.getChildNamed(JimdoSettingsComplete_.orderMailServerPassword)), "Order Mail Passwords", TitledItem.TitledItemOrientation.NORTH);
        this.orderMailAddress = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(JimdoSettingsComplete_.orderMailAddress)), "Order Mail Address", TitledItem.TitledItemOrientation.NORTH);
        this.qrBCCMailAddress = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(JimdoSettingsComplete_.qrBCCMailAddress)), "QR Code BCC Address", TitledItem.TitledItemOrientation.NORTH);
        this.sendGuddInvoice = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(JimdoSettingsComplete_.sendInvoice)), "Send gudd. Invoice", TitledItem.TitledItemOrientation.EAST);
        this.sendQRCodeWithGuddInvoice = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(JimdoSettingsComplete_.sendInvoiceWithQRCode)), "Send Invoice with QR Code", TitledItem.TitledItemOrientation.EAST);
        this.defaultFlightName = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(JimdoSettingsComplete_.defaultFlightName)), "Default Flight Name", TitledItem.TitledItemOrientation.NORTH);
        this.qrCodeMessageSubject = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(JimdoSettingsComplete_.mailSubject)), "QR Code Message Subject", TitledItem.TitledItemOrientation.NORTH);
        this.qrCodeMessageTemplate = new TitledItem<TextField>(new TextField(), "QR Code Message Template", TitledItem.TitledItemOrientation.NORTH);
        this.qrCodeMessageTemplate.getElement().setMaxChar(Integer.MAX_VALUE);
        this.qrCodeMessageTemplate.getElement().setNode(this.settings.getChildNamed(JimdoSettingsComplete_.mailMessage));
        this.qrCodeWithInvoiceMessageSubject = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(JimdoSettingsComplete_.qrWithInvoiceMailSubject)), "QR Code with Invoice Message Subject", TitledItem.TitledItemOrientation.NORTH);
        this.qrCodeWithInvoiceMessageTemplate = new TitledItem<TextField>(new TextField(), "QR Code with Invoice Message Template", TitledItem.TitledItemOrientation.NORTH);
        this.qrCodeWithInvoiceMessageTemplate.getElement().setMaxChar(Integer.MAX_VALUE);
        this.qrCodeWithInvoiceMessageTemplate.getElement().setNode(this.settings.getChildNamed(JimdoSettingsComplete_.qrWithInvoiceMailMessage));
        this.invoiceMessageSubject = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(JimdoSettingsComplete_.invoiceMailSubject)), "Invoice Message Subject", TitledItem.TitledItemOrientation.NORTH);
        this.invoiceMessageTemplate = new TitledItem<TextField>(new TextField(), "Invoice Message Template", TitledItem.TitledItemOrientation.NORTH);
        this.invoiceMessageTemplate.getElement().setMaxChar(Integer.MAX_VALUE);
        this.invoiceMessageTemplate.getElement().setNode(this.settings.getChildNamed(JimdoSettingsComplete_.invoiceMailMessage));
        this.sendMailServer = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(JimdoSettingsComplete_.sendMailServer)), "Send Mail Server", TitledItem.TitledItemOrientation.NORTH);
        this.sendMailServerUser = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(JimdoSettingsComplete_.sendMailServerUser)), "Send Mail User", TitledItem.TitledItemOrientation.NORTH);
        this.sendMailServerPassword = new TitledItem<PasswordTextField>(new PasswordTextField(this.settings.getChildNamed(JimdoSettingsComplete_.sendMailServerPassword)), "Send Mail Passwords", TitledItem.TitledItemOrientation.NORTH);
        this.mailSender = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(JimdoSettingsComplete_.mailSenderAddress)), "Mail Sender", TitledItem.TitledItemOrientation.NORTH);
        this.productionMailAddress = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(JimdoSettingsComplete_.productionMailAddress)), "Production Mail Address", TitledItem.TitledItemOrientation.NORTH);
        this.alertMessageAddress = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(JimdoSettingsComplete_.alertMailAddress)), "Alert Mail Address", TitledItem.TitledItemOrientation.NORTH);
        this.customer = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(false, this.settings.getChildNamed(JimdoSettingsComplete_.jimdoCustomer)), "Jimdo Customer", TitledItem.TitledItemOrientation.NORTH);
        this.stowingList = new TitledItem<SearchTextField2<StowingListTemplateComplete>>(SearchTextField2Factory.getStowingTemplateSearchField(true, this.settings.getChildNamed(JimdoSettingsComplete_.defaultAdHocStowing)), "Default Stowing List", TitledItem.TitledItemOrientation.NORTH);
        this.jimdoMailAddress = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(JimdoSettingsComplete_.jimdoSenderAddress)), "Jimdo Sender Mail", TitledItem.TitledItemOrientation.NORTH);
        this.stornoMailAddress = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(JimdoSettingsComplete_.stornoMailAddress)), "Storno Mail", TitledItem.TitledItemOrientation.NORTH);
        this.financeMailAddress = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(JimdoSettingsComplete_.financeMailAddress)), "Finance Mail", TitledItem.TitledItemOrientation.NORTH);
        this.messageStornoOk = new TitledItem<TextField>(new TextField(), "Storno OK Message", TitledItem.TitledItemOrientation.NORTH);
        this.messageStornoOk.getElement().setMaxChar(Integer.MAX_VALUE);
        this.messageStornoOk.getElement().setNode(this.settings.getChildNamed(JimdoSettingsComplete_.messageStornoOk));
        this.messageStornoAlreadyPickedUp = new TitledItem<TextField>(new TextField(), "Storno already picked up Message", TitledItem.TitledItemOrientation.NORTH);
        this.messageStornoAlreadyPickedUp.getElement().setMaxChar(Integer.MAX_VALUE);
        this.messageStornoAlreadyPickedUp.getElement().setNode(this.settings.getChildNamed(JimdoSettingsComplete_.messageStornoAlreadyPickedUp));
        this.messageStornoNotPossibleTime = new TitledItem<TextField>(new TextField(), "Storno to late Message", TitledItem.TitledItemOrientation.NORTH);
        this.messageStornoNotPossibleTime.getElement().setMaxChar(Integer.MAX_VALUE);
        this.messageStornoNotPossibleTime.getElement().setNode(this.settings.getChildNamed(JimdoSettingsComplete_.messageStornoNotPossibleTime));
        this.messageStornoNotPossibleMailNumberError = new TitledItem<TextField>(new TextField(), "Storno Error occured Message", TitledItem.TitledItemOrientation.NORTH);
        this.messageStornoNotPossibleMailNumberError.getElement().setMaxChar(Integer.MAX_VALUE);
        this.messageStornoNotPossibleMailNumberError.getElement().setNode(this.settings.getChildNamed(JimdoSettingsComplete_.messageStornoNotPossibleMailNumberError));
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.readButton = new TablePanelAddSaveButton();
        this.readButton.setText("Read");
        this.readButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.useJimdoInterface);
        this.configPanel.add(this.orderMailServer);
        this.configPanel.add(this.orderMailServerUser);
        this.configPanel.add(this.orderMailServerPassword);
        this.configPanel.add(this.defaultFlightName);
        this.configPanel.add(this.qrCodeMessageSubject);
        this.configPanel.add(this.qrCodeMessageTemplate);
        this.configPanel.add(this.qrCodeWithInvoiceMessageSubject);
        this.configPanel.add(this.qrCodeWithInvoiceMessageTemplate);
        this.configPanel.add(this.invoiceMessageSubject);
        this.configPanel.add(this.invoiceMessageTemplate);
        this.configPanel.add(this.mailSender);
        this.configPanel.add(this.alertMessageAddress);
        this.configPanel.add(this.jimdoMailAddress);
        this.configPanel.add(this.stornoMailAddress);
        this.configPanel.add(this.financeMailAddress);
        this.configPanel.add(this.messageStornoOk);
        this.configPanel.add(this.messageStornoAlreadyPickedUp);
        this.configPanel.add(this.messageStornoNotPossibleTime);
        this.configPanel.add(this.messageStornoNotPossibleMailNumberError);
        this.configPanel.add(this.orderMailAddress);
        this.configPanel.add(this.qrBCCMailAddress);
        this.configPanel.add(this.sendGuddInvoice);
        this.configPanel.add(this.sendQRCodeWithGuddInvoice);
        this.configPanel.add(this.sendMailServer);
        this.configPanel.add(this.sendMailServerUser);
        this.configPanel.add(this.sendMailServerPassword);
        this.configPanel.add(this.productionMailAddress);
        this.configPanel.add(this.customer);
        this.configPanel.add(this.stowingList);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.readButton);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllTimeDurations();
                try {
                    JimdoOrderImportInsert.this.arisc = (JimdoSettingsComplete)((JimdoServiceManager)ServiceManagerRegistry.getService(JimdoServiceManager.class)).getSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (JimdoOrderImportInsert.this.arisc == null) {
                    JimdoSettingsComplete s = new JimdoSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    JimdoOrderImportInsert.this.arisc = s;
                }
                JimdoOrderImportInsert.this.arisc.setTimerServiceSettings(JimdoOrderImportInsert.this.createTimerService());
                JimdoOrderImportInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)JimdoOrderImportInsert.this.arisc, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return JimdoOrderImportInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createTimerService() {
        TimerServiceSettingsComplete ts = new TimerServiceSettingsComplete();
        ts.setClientOId(Long.valueOf(ADTO.getNextId()));
        ts.setTimerServiceConfig((TimerServiceConfigComplete)new TimeDurationComplete(TimeUnitE.SECOND, Double.valueOf(30.0)));
        ts.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return ts;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useJimdoInterface.setEnabled(isEnabled);
            boolean b = isEnabled && this.useJimdoInterface.getElement().isChecked();
            this.orderMailServer.setEnabled(b);
            this.orderMailServerUser.setEnabled(b);
            this.orderMailServerPassword.setEnabled(b);
            this.defaultFlightName.setEnabled(b);
            this.qrCodeMessageSubject.setEnabled(b);
            this.qrCodeMessageTemplate.setEnabled(b);
            this.qrCodeWithInvoiceMessageSubject.setEnabled(b);
            this.qrCodeWithInvoiceMessageTemplate.setEnabled(b);
            this.invoiceMessageSubject.setEnabled(b);
            this.invoiceMessageTemplate.setEnabled(b);
            this.mailSender.setEnabled(b);
            this.alertMessageAddress.setEnabled(b);
            this.customer.setEnabled(b);
            this.stowingList.setEnabled(isEnabled);
            this.saveButton.setEnabled(isEnabled);
            this.readButton.setEnabled(isEnabled);
            this.jimdoMailAddress.setEnabled(isEnabled);
            this.stornoMailAddress.setEnabled(isEnabled);
            this.financeMailAddress.setEnabled(isEnabled);
            this.messageStornoOk.setEnabled(isEnabled);
            this.messageStornoAlreadyPickedUp.setEnabled(isEnabled);
            this.messageStornoNotPossibleTime.setEnabled(isEnabled);
            this.messageStornoNotPossibleMailNumberError.setEnabled(isEnabled);
            this.orderMailAddress.setEnabled(isEnabled);
            this.qrBCCMailAddress.setEnabled(isEnabled);
            this.sendGuddInvoice.setEnabled(isEnabled);
            this.sendQRCodeWithGuddInvoice.setEnabled(isEnabled);
            this.sendMailServer.setEnabled(isEnabled);
            this.sendMailServerUser.setEnabled(isEnabled);
            this.sendMailServerPassword.setEnabled(isEnabled);
            this.productionMailAddress.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.stowingList.kill();
            this.saveButton.kill();
            this.useJimdoInterface.kill();
            this.orderMailServer.kill();
            this.orderMailServerUser.kill();
            this.orderMailServerPassword.kill();
            this.defaultFlightName.kill();
            this.mailSender.kill();
            this.alertMessageAddress.kill();
            this.qrCodeMessageTemplate.kill();
            this.qrCodeMessageSubject.kill();
            this.qrCodeWithInvoiceMessageTemplate.kill();
            this.qrCodeWithInvoiceMessageSubject.kill();
            this.invoiceMessageTemplate.kill();
            this.invoiceMessageSubject.kill();
            this.customer.kill();
            this.jimdoMailAddress.kill();
            this.stornoMailAddress.kill();
            this.financeMailAddress.kill();
            this.messageStornoOk.kill();
            this.messageStornoAlreadyPickedUp.kill();
            this.messageStornoNotPossibleTime.kill();
            this.messageStornoNotPossibleMailNumberError.kill();
            this.orderMailAddress.kill();
            this.qrBCCMailAddress.kill();
            this.sendGuddInvoice.kill();
            this.sendQRCodeWithGuddInvoice.kill();
            this.sendMailServer.kill();
            this.sendMailServerUser.kill();
            this.sendMailServerPassword.kill();
            this.productionMailAddress.kill();
            this.readButton.kill();
        }
        this.orderMailServer = null;
        this.orderMailServerUser = null;
        this.orderMailServerPassword = null;
        this.defaultFlightName = null;
        this.mailSender = null;
        this.alertMessageAddress = null;
        this.qrCodeMessageSubject = null;
        this.qrCodeMessageTemplate = null;
        this.qrCodeWithInvoiceMessageSubject = null;
        this.qrCodeWithInvoiceMessageTemplate = null;
        this.invoiceMessageSubject = null;
        this.invoiceMessageTemplate = null;
        this.customer = null;
        this.jimdoMailAddress = null;
        this.stornoMailAddress = null;
        this.financeMailAddress = null;
        this.messageStornoOk = null;
        this.messageStornoAlreadyPickedUp = null;
        this.messageStornoNotPossibleTime = null;
        this.messageStornoNotPossibleMailNumberError = null;
        this.orderMailAddress = null;
        this.qrBCCMailAddress = null;
        this.sendGuddInvoice = null;
        this.sendQRCodeWithGuddInvoice = null;
        this.sendMailServer = null;
        this.sendMailServerUser = null;
        this.sendMailServerPassword = null;
        this.productionMailAddress = null;
        this.sendPanel = null;
        this.configPanel = null;
        this.stowingList = null;
        this.saveButton = null;
        this.useJimdoInterface = null;
        this.readButton = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return "Jimdo Interface";
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.saveButton) {
            this.setEnabled(false);
            this.ensureAnimation(Words.SAVE_DATA);
            this.saveConfig();
            this.module.started();
        } else if (source == this.readButton) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    ((JimdoServiceManager)ServiceManagerRegistry.getService(JimdoServiceManager.class)).readMails();
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            JimdoOrderImportInsert.this.setEnabled(true);
                            JimdoOrderImportInsert.this.hideAnimation();
                            InnerPopupFactory.showMessageDialog("Data loaded", JimdoOrderImportInsert.this);
                        }

                        public void errorOccurred(ClientException exception) {
                            JimdoOrderImportInsert.this.setEnabled(true);
                            JimdoOrderImportInsert.this.hideAnimation();
                            InnerPopupFactory.showErrorDialog((Exception)exception, (Component)JimdoOrderImportInsert.this);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            this.setEnabled(false);
            this.ensureAnimation("Read");
            ThreadSafeLoader.run(run);
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                JimdoOrderImportInsert.this.settings.commit(JimdoSettingsComplete.class);
                JimdoSettingsComplete arisc = (JimdoSettingsComplete)JimdoOrderImportInsert.this.settings.getValue();
                if (arisc.getUseJimdoInterface().booleanValue()) {
                    arisc.setTimerServiceSettings(JimdoOrderImportInsert.this.createTimerService());
                    TimerServiceSettingsComplete ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(arisc.getTimerServiceSettings()).getValue();
                    arisc.setTimerServiceSettings(ts);
                    arisc = (JimdoSettingsComplete)((JimdoServiceManager)ServiceManagerRegistry.getService(JimdoServiceManager.class)).updateSettings(arisc).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.JIMDO_ORDER_INTERFACE, true, ts, -1L);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.JIMDO_ORDER_INTERFACE);
                    arisc = (JimdoSettingsComplete)((JimdoServiceManager)ServiceManagerRegistry.getService(JimdoServiceManager.class)).updateSettings(arisc).getValue();
                    Node s = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                    Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)arisc, false, false);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        JimdoOrderImportInsert.this.hideAnimation();
                        JimdoOrderImportInsert.this.module.ended();
                        JimdoOrderImportInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)JimdoOrderImportInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            JimdoOrderImportInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            JimdoOrderImportInsert.this.useJimdoInterface.setLocation(border, border + JimdoOrderImportInsert.this.configPanel.getTitleHeight());
            JimdoOrderImportInsert.this.useJimdoInterface.setSize(JimdoOrderImportInsert.this.useJimdoInterface.getPreferredSize());
            JimdoOrderImportInsert.this.orderMailServer.setLocation(JimdoOrderImportInsert.this.useJimdoInterface.getX(), JimdoOrderImportInsert.this.useJimdoInterface.getY() + JimdoOrderImportInsert.this.useJimdoInterface.getHeight() + border * 2);
            JimdoOrderImportInsert.this.orderMailServer.setSize(300, (int)JimdoOrderImportInsert.this.orderMailServer.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.orderMailServerUser.setLocation(JimdoOrderImportInsert.this.useJimdoInterface.getX(), JimdoOrderImportInsert.this.orderMailServer.getY() + JimdoOrderImportInsert.this.orderMailServer.getHeight() + border);
            JimdoOrderImportInsert.this.orderMailServerUser.setSize(300, (int)JimdoOrderImportInsert.this.orderMailServerUser.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.orderMailServerPassword.setLocation(JimdoOrderImportInsert.this.useJimdoInterface.getX(), JimdoOrderImportInsert.this.orderMailServerUser.getY() + JimdoOrderImportInsert.this.orderMailServerUser.getHeight() + border);
            JimdoOrderImportInsert.this.orderMailServerPassword.setSize(300, (int)JimdoOrderImportInsert.this.orderMailServerPassword.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.orderMailAddress.setLocation(JimdoOrderImportInsert.this.useJimdoInterface.getX(), JimdoOrderImportInsert.this.orderMailServerPassword.getY() + JimdoOrderImportInsert.this.orderMailServerPassword.getHeight() + border);
            JimdoOrderImportInsert.this.orderMailAddress.setSize(300, (int)JimdoOrderImportInsert.this.orderMailAddress.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.stornoMailAddress.setLocation(JimdoOrderImportInsert.this.useJimdoInterface.getX(), JimdoOrderImportInsert.this.orderMailAddress.getY() + JimdoOrderImportInsert.this.orderMailAddress.getHeight() + border);
            JimdoOrderImportInsert.this.stornoMailAddress.setSize(300, (int)JimdoOrderImportInsert.this.stornoMailAddress.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.sendMailServer.setLocation(JimdoOrderImportInsert.this.orderMailServer.getX() + JimdoOrderImportInsert.this.orderMailServer.getWidth() + border, JimdoOrderImportInsert.this.orderMailServer.getY());
            JimdoOrderImportInsert.this.sendMailServer.setSize(300, (int)JimdoOrderImportInsert.this.sendMailServer.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.sendMailServerUser.setLocation(JimdoOrderImportInsert.this.sendMailServer.getX(), JimdoOrderImportInsert.this.sendMailServer.getY() + JimdoOrderImportInsert.this.sendMailServer.getHeight() + border);
            JimdoOrderImportInsert.this.sendMailServerUser.setSize(300, (int)JimdoOrderImportInsert.this.sendMailServerUser.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.sendMailServerPassword.setLocation(JimdoOrderImportInsert.this.sendMailServer.getX(), JimdoOrderImportInsert.this.sendMailServerUser.getY() + JimdoOrderImportInsert.this.sendMailServerUser.getHeight() + border);
            JimdoOrderImportInsert.this.sendMailServerPassword.setSize(300, (int)JimdoOrderImportInsert.this.sendMailServerPassword.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.mailSender.setLocation(JimdoOrderImportInsert.this.sendMailServer.getX(), JimdoOrderImportInsert.this.sendMailServerPassword.getY() + JimdoOrderImportInsert.this.sendMailServerPassword.getHeight() + border);
            JimdoOrderImportInsert.this.mailSender.setSize(300, (int)JimdoOrderImportInsert.this.mailSender.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.qrBCCMailAddress.setLocation(JimdoOrderImportInsert.this.mailSender.getX(), JimdoOrderImportInsert.this.mailSender.getY() + JimdoOrderImportInsert.this.mailSender.getHeight() + border);
            JimdoOrderImportInsert.this.qrBCCMailAddress.setSize(300, (int)JimdoOrderImportInsert.this.qrBCCMailAddress.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.sendGuddInvoice.setLocation(JimdoOrderImportInsert.this.mailSender.getX(), JimdoOrderImportInsert.this.qrBCCMailAddress.getY() + JimdoOrderImportInsert.this.qrBCCMailAddress.getHeight() + border);
            JimdoOrderImportInsert.this.sendGuddInvoice.setSize(JimdoOrderImportInsert.this.sendGuddInvoice.getPreferredSize());
            JimdoOrderImportInsert.this.sendQRCodeWithGuddInvoice.setLocation(JimdoOrderImportInsert.this.mailSender.getX(), JimdoOrderImportInsert.this.sendGuddInvoice.getY() + JimdoOrderImportInsert.this.sendGuddInvoice.getHeight() + border);
            JimdoOrderImportInsert.this.sendQRCodeWithGuddInvoice.setSize(JimdoOrderImportInsert.this.sendQRCodeWithGuddInvoice.getPreferredSize());
            JimdoOrderImportInsert.this.jimdoMailAddress.setLocation(JimdoOrderImportInsert.this.stornoMailAddress.getX(), JimdoOrderImportInsert.this.stornoMailAddress.getY() + JimdoOrderImportInsert.this.stornoMailAddress.getHeight() + border * 2);
            JimdoOrderImportInsert.this.jimdoMailAddress.setSize(300, (int)JimdoOrderImportInsert.this.jimdoMailAddress.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.productionMailAddress.setLocation(JimdoOrderImportInsert.this.stornoMailAddress.getX(), JimdoOrderImportInsert.this.jimdoMailAddress.getY() + JimdoOrderImportInsert.this.jimdoMailAddress.getHeight() + border);
            JimdoOrderImportInsert.this.productionMailAddress.setSize(300, (int)JimdoOrderImportInsert.this.sendMailServerPassword.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.alertMessageAddress.setLocation(JimdoOrderImportInsert.this.stornoMailAddress.getX(), JimdoOrderImportInsert.this.productionMailAddress.getY() + JimdoOrderImportInsert.this.productionMailAddress.getHeight() + border);
            JimdoOrderImportInsert.this.alertMessageAddress.setSize(300, (int)JimdoOrderImportInsert.this.alertMessageAddress.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.financeMailAddress.setLocation(JimdoOrderImportInsert.this.stornoMailAddress.getX(), JimdoOrderImportInsert.this.alertMessageAddress.getY() + JimdoOrderImportInsert.this.alertMessageAddress.getHeight() + border);
            JimdoOrderImportInsert.this.financeMailAddress.setSize(300, (int)JimdoOrderImportInsert.this.financeMailAddress.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.defaultFlightName.setLocation(JimdoOrderImportInsert.this.useJimdoInterface.getX(), JimdoOrderImportInsert.this.financeMailAddress.getY() + JimdoOrderImportInsert.this.financeMailAddress.getHeight() + border * 2);
            JimdoOrderImportInsert.this.defaultFlightName.setSize(300, (int)JimdoOrderImportInsert.this.defaultFlightName.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.customer.setLocation(JimdoOrderImportInsert.this.useJimdoInterface.getX(), JimdoOrderImportInsert.this.defaultFlightName.getY() + JimdoOrderImportInsert.this.defaultFlightName.getHeight() + border);
            JimdoOrderImportInsert.this.customer.setSize(300, (int)JimdoOrderImportInsert.this.customer.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.stowingList.setLocation(JimdoOrderImportInsert.this.useJimdoInterface.getX(), JimdoOrderImportInsert.this.customer.getY() + JimdoOrderImportInsert.this.customer.getHeight() + border);
            JimdoOrderImportInsert.this.stowingList.setSize(300, (int)JimdoOrderImportInsert.this.stowingList.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.qrCodeMessageSubject.setLocation(JimdoOrderImportInsert.this.useJimdoInterface.getX(), JimdoOrderImportInsert.this.stowingList.getY() + JimdoOrderImportInsert.this.stowingList.getHeight() + border * 2);
            JimdoOrderImportInsert.this.qrCodeMessageSubject.setSize(300, (int)JimdoOrderImportInsert.this.qrCodeMessageSubject.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.qrCodeMessageTemplate.setLocation(JimdoOrderImportInsert.this.useJimdoInterface.getX(), JimdoOrderImportInsert.this.qrCodeMessageSubject.getY() + JimdoOrderImportInsert.this.qrCodeMessageSubject.getHeight() + border);
            JimdoOrderImportInsert.this.qrCodeMessageTemplate.setSize(300, (int)JimdoOrderImportInsert.this.qrCodeMessageTemplate.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.messageStornoOk.setLocation(JimdoOrderImportInsert.this.qrCodeMessageSubject.getX() + JimdoOrderImportInsert.this.qrCodeMessageSubject.getWidth() + border, JimdoOrderImportInsert.this.qrCodeMessageSubject.getY());
            JimdoOrderImportInsert.this.messageStornoOk.setSize(300, (int)JimdoOrderImportInsert.this.messageStornoOk.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.messageStornoAlreadyPickedUp.setLocation(JimdoOrderImportInsert.this.messageStornoOk.getX(), JimdoOrderImportInsert.this.messageStornoOk.getY() + JimdoOrderImportInsert.this.messageStornoOk.getHeight() + border);
            JimdoOrderImportInsert.this.messageStornoAlreadyPickedUp.setSize(300, (int)JimdoOrderImportInsert.this.messageStornoAlreadyPickedUp.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.messageStornoNotPossibleTime.setLocation(JimdoOrderImportInsert.this.messageStornoOk.getX(), JimdoOrderImportInsert.this.messageStornoAlreadyPickedUp.getY() + JimdoOrderImportInsert.this.messageStornoAlreadyPickedUp.getHeight() + border);
            JimdoOrderImportInsert.this.messageStornoNotPossibleTime.setSize(300, (int)JimdoOrderImportInsert.this.messageStornoNotPossibleTime.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.messageStornoNotPossibleMailNumberError.setLocation(JimdoOrderImportInsert.this.messageStornoOk.getX(), JimdoOrderImportInsert.this.messageStornoNotPossibleTime.getY() + JimdoOrderImportInsert.this.messageStornoNotPossibleTime.getHeight() + border);
            JimdoOrderImportInsert.this.messageStornoNotPossibleMailNumberError.setSize(300, (int)JimdoOrderImportInsert.this.messageStornoNotPossibleMailNumberError.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.qrCodeWithInvoiceMessageSubject.setLocation(JimdoOrderImportInsert.this.useJimdoInterface.getX(), JimdoOrderImportInsert.this.qrCodeMessageTemplate.getY() + JimdoOrderImportInsert.this.qrCodeMessageTemplate.getHeight() + border * 2);
            JimdoOrderImportInsert.this.qrCodeWithInvoiceMessageSubject.setSize(300, (int)JimdoOrderImportInsert.this.qrCodeWithInvoiceMessageSubject.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.qrCodeWithInvoiceMessageTemplate.setLocation(JimdoOrderImportInsert.this.useJimdoInterface.getX(), JimdoOrderImportInsert.this.qrCodeWithInvoiceMessageSubject.getY() + JimdoOrderImportInsert.this.qrCodeWithInvoiceMessageSubject.getHeight() + border);
            JimdoOrderImportInsert.this.qrCodeWithInvoiceMessageTemplate.setSize(300, (int)JimdoOrderImportInsert.this.qrCodeWithInvoiceMessageTemplate.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.invoiceMessageSubject.setLocation(JimdoOrderImportInsert.this.useJimdoInterface.getX(), JimdoOrderImportInsert.this.qrCodeWithInvoiceMessageTemplate.getY() + JimdoOrderImportInsert.this.qrCodeWithInvoiceMessageTemplate.getHeight() + border * 2);
            JimdoOrderImportInsert.this.invoiceMessageSubject.setSize(300, (int)JimdoOrderImportInsert.this.invoiceMessageSubject.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.invoiceMessageTemplate.setLocation(JimdoOrderImportInsert.this.useJimdoInterface.getX(), JimdoOrderImportInsert.this.invoiceMessageSubject.getY() + JimdoOrderImportInsert.this.invoiceMessageSubject.getHeight() + border);
            JimdoOrderImportInsert.this.invoiceMessageTemplate.setSize(300, (int)JimdoOrderImportInsert.this.invoiceMessageTemplate.getPreferredSize().getHeight());
            JimdoOrderImportInsert.this.saveButton.setLocation(border, (int)((double)parent.getHeight() - ((double)border + JimdoOrderImportInsert.this.saveButton.getPreferredSize().getHeight())));
            JimdoOrderImportInsert.this.saveButton.setSize(JimdoOrderImportInsert.this.saveButton.getPreferredSize());
            JimdoOrderImportInsert.this.readButton.setLocation(JimdoOrderImportInsert.this.saveButton.getX() + JimdoOrderImportInsert.this.saveButton.getWidth() + border, (int)((double)parent.getHeight() - ((double)border + JimdoOrderImportInsert.this.saveButton.getPreferredSize().getHeight())));
            JimdoOrderImportInsert.this.readButton.setSize(JimdoOrderImportInsert.this.readButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            JimdoOrderImportInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (JimdoOrderImportInsert.this.animation != null) {
                JimdoOrderImportInsert.this.animation.setLocation((int)((double)parent.getWidth() - JimdoOrderImportInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - JimdoOrderImportInsert.this.animation.getPreferredSize().getHeight()) / 2);
                JimdoOrderImportInsert.this.animation.setSize(JimdoOrderImportInsert.this.animation.getPreferredSize());
            }
            if (JimdoOrderImportInsert.this.isInserted) {
                JimdoOrderImportInsert.this.configPanel.setLocation(border, border);
                JimdoOrderImportInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                JimdoOrderImportInsert.this.sendPanel.setLocation(JimdoOrderImportInsert.this.configPanel.getX() + JimdoOrderImportInsert.this.configPanel.getWidth() + border, border);
                JimdoOrderImportInsert.this.sendPanel.setSize(JimdoOrderImportInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

