/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.converter.CustomsDocumentTypeConverter;
import ch.icit.pegasus.client.converter.MigrosLastUpdateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.panels.SFTPDataExchangeSettingsPanel;
import ch.icit.pegasus.client.gui.utils.panels.TabbedItem;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.tabbed.TabButton;
import ch.icit.pegasus.client.gui.utils.tables.MigrosExchangeListTable;
import ch.icit.pegasus.client.gui.utils.tables.MigrosUnitMappingTable;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.exchange.migros.MigrosExchangeServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.DataTransferProtocolE;
import ch.icit.pegasus.server.core.dtos.dataexchange.SFTPDataExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.SFTPDataExchangeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CustomsDocumentTypeComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.DailyTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.EncryptedStringComplete;
import ch.icit.pegasus.server.core.dtos.util.TimeDurationComplete;
import ch.icit.pegasus.server.core.dtos.util.TimeUnitE;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MigrosExchangeInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private ScrollPane scrollPane;
    private MigrosUnitMappingTable mappings;
    private MigrosExchangeListTable historyTable;
    private TitledItem<CheckBox> useMigrosExchange;
    private TitledItem<CheckBox> autoTransferActive;
    private TitledItem<CheckBox> sendOrderAvisDirectly;
    private TitledItem<CheckBox> sendInvoiceDirectly;
    private TitledItem<CheckBox> sendOrderAvisAtFlightChecked;
    private TitledItem<CheckBox> sendOrderAvisManually;
    private TitledItem<CheckBox> sendInvoiceAtEvening;
    private TitledItem<CheckBox> sendInvoiceManually;
    private TitledItem<CheckBox> notifyOrder;
    private TitledItem<CheckBox> notifyInvoiceAvis;
    private TitledItem<TextField> notificationAddresses;
    private TitledItem<TextField> notificationSenderAddress;
    private TitledItem<TextField> errorNotificationAddresses;
    private TitledItem<SearchComboBox> deliverySlipSheet;
    private TitledItem<ComboBox> orderNoCustomDocuType;
    private TitledItem<TextField> companyName;
    private TitledItem<TextField> partnerNo;
    private TitledItem<TextField> kreditorNo;
    private TitledItem<TextField> companyID;
    private TitledItem<TextField> gln;
    private TitledItem<TextField> uid;
    private TitledItem<TextField> street;
    private TitledItem<TextField> city;
    private TitledItem<TextField> plz;
    private TitledItem<TextField> country;
    private TitledItem<CheckBox> testMode;
    private TitledItem<TextField> pathArticleExport;
    private TitledItem<TextField> pathOrderImport;
    private TitledItem<TextField> pathOrderAvisExport;
    private TitledItem<TextField> pathInvoiceExport;
    private TitledItem<TextField> pathInvoiceAvisImport;
    private TitledItem<TextField> pathInvoiceCreditNoteExport;
    private TabbedItem<SFTPDataExchangeSettingsPanel> ftpConfigurations;
    private TitledItem<SearchTextField2<StowingListTemplateComplete>> defaultAdHoc;
    private TitledItem<SearchTextField2<CustomerLight>> defaultCustomer;
    private TitledItem<TextField> adHocDefaultFlightCode;
    private TextLabel lastUpdates;
    private TablePanelAddSaveButton transferButton;
    private TablePanelAddSaveButton sendInvoiceButton;
    private TablePanelAddSaveButton saveButton;
    private TextButton resetLastReceiveDate;
    private final DataExchangeModule module;
    protected Node<MigrosSettingsComplete> settings;
    protected MigrosSettingsComplete rimsc;

    public MigrosExchangeInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.scrollPane = new ScrollPane();
        this.scrollPane.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
        this.scrollPane.getHorizontalScrollBar().setBackground(this.scrollPane.getBackground());
        this.scrollPane.getVerticalScrollBar().setBackground(this.scrollPane.getBackground());
        this.useMigrosExchange = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(MigrosSettingsComplete_.useMigrosInterface)), "Enable Migros Exchange", TitledItem.TitledItemOrientation.EAST);
        this.useMigrosExchange.getElement().addButtonListener(this);
        this.autoTransferActive = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(MigrosSettingsComplete_.autoTransferActive)), "Auto Transfer Active", TitledItem.TitledItemOrientation.EAST);
        this.notifyOrder = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(MigrosSettingsComplete_.notifyNewOrder)), "Notify new Order", TitledItem.TitledItemOrientation.EAST);
        this.notifyInvoiceAvis = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(MigrosSettingsComplete_.notifyNewInvoiceAvis)), "Notify new Invoice Avis", TitledItem.TitledItemOrientation.EAST);
        this.notificationAddresses = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(MigrosSettingsComplete_.notificationAddresses)), "Notification Addresses", TitledItem.TitledItemOrientation.NORTH);
        this.pathArticleExport = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(MigrosSettingsComplete_.pathArticleExport)), "Path Article Export", TitledItem.TitledItemOrientation.NORTH);
        this.pathOrderImport = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(MigrosSettingsComplete_.pathOrderImport)), "Path Order Import", TitledItem.TitledItemOrientation.NORTH);
        this.pathOrderAvisExport = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(MigrosSettingsComplete_.pathOrderAvisExport)), "Path Order Avis Export", TitledItem.TitledItemOrientation.NORTH);
        this.pathInvoiceExport = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(MigrosSettingsComplete_.pathInvoiceExport)), "Path Invoice Export", TitledItem.TitledItemOrientation.NORTH);
        this.pathInvoiceAvisImport = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(MigrosSettingsComplete_.pathInvoiceAvisImport)), "Path Invoice Avis Import", TitledItem.TitledItemOrientation.NORTH);
        this.pathInvoiceCreditNoteExport = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(MigrosSettingsComplete_.pathInvoiceCreditNoteExport)), "Path Credit Note Export", TitledItem.TitledItemOrientation.NORTH);
        this.companyName = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(MigrosSettingsComplete_.companyName)), "Company Name", TitledItem.TitledItemOrientation.NORTH);
        this.partnerNo = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(MigrosSettingsComplete_.partnerNo)), "Partner No", TitledItem.TitledItemOrientation.NORTH);
        this.kreditorNo = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(MigrosSettingsComplete_.kreditorNo)), "Kreditoren No", TitledItem.TitledItemOrientation.NORTH);
        this.companyID = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(MigrosSettingsComplete_.companyID)), "Company ID", TitledItem.TitledItemOrientation.NORTH);
        this.sendOrderAvisDirectly = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(MigrosSettingsComplete_.sendOrderAvisDirectly)), "Send Order Avis directly", TitledItem.TitledItemOrientation.EAST);
        this.sendInvoiceDirectly = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(MigrosSettingsComplete_.sendInvoiceDirectly)), "Send Invoice directly", TitledItem.TitledItemOrientation.EAST);
        this.sendOrderAvisAtFlightChecked = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(MigrosSettingsComplete_.sendOrderAvisAtFlightChecked)), "Send Order Avis at Flight Check", TitledItem.TitledItemOrientation.EAST);
        this.sendOrderAvisManually = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(MigrosSettingsComplete_.sendOrderAvisManually)), "Send Order Avis manually", TitledItem.TitledItemOrientation.EAST);
        this.sendInvoiceAtEvening = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(MigrosSettingsComplete_.sendInvoiceAtEvening)), "Send Invoice at evening", TitledItem.TitledItemOrientation.EAST);
        this.sendInvoiceManually = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(MigrosSettingsComplete_.sendInvoiceManually)), "Send Invoice manually", TitledItem.TitledItemOrientation.EAST);
        this.mappings = new MigrosUnitMappingTable();
        this.mappings.setTitleText("Unit Mapping");
        this.mappings.getModel().setNode(this.settings.getChildNamed(MigrosSettingsComplete_.unitMappings));
        this.notificationSenderAddress = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(MigrosSettingsComplete_.notificationSenderAddress)), "Notification Sender", TitledItem.TitledItemOrientation.NORTH);
        this.errorNotificationAddresses = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(MigrosSettingsComplete_.errorNotificationAddresses)), "Error Notification Addresses", TitledItem.TitledItemOrientation.NORTH);
        this.deliverySlipSheet = new TitledItem<SearchComboBox>(SearchComboBoxFactory.getDeliverySlipLayoutSearchBox(true, this.settings.getChildNamed(MigrosSettingsComplete_.deliverySlipStyleSheet)), "Delivery Slip Style Sheet", TitledItem.TitledItemOrientation.NORTH);
        this.orderNoCustomDocuType = new TitledItem<ComboBox>(new ComboBox(this.settings.getChildNamed(MigrosSettingsComplete_.customsDocumentOrderType), null, ConverterRegistry.getConverter(CustomsDocumentTypeConverter.class), true), "Order Doc Type", TitledItem.TitledItemOrientation.NORTH);
        this.orderNoCustomDocuType.getElement().refreshPossibleValues(NodeToolkit.getAffixList(CustomsDocumentTypeComplete.class));
        this.testMode = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(MigrosSettingsComplete_.testMode)), "Test Mode", TitledItem.TitledItemOrientation.EAST);
        this.gln = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(MigrosSettingsComplete_.gln)), "GLN", TitledItem.TitledItemOrientation.NORTH);
        this.uid = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(MigrosSettingsComplete_.uid)), "UID", TitledItem.TitledItemOrientation.NORTH);
        this.street = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(MigrosSettingsComplete_.street)), "Street", TitledItem.TitledItemOrientation.NORTH);
        this.city = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(MigrosSettingsComplete_.city)), "City", TitledItem.TitledItemOrientation.NORTH);
        this.plz = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(MigrosSettingsComplete_.plz)), "PLZ", TitledItem.TitledItemOrientation.NORTH);
        this.country = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(MigrosSettingsComplete_.country)), "Country", TitledItem.TitledItemOrientation.NORTH);
        this.ftpConfigurations = new TabbedItem<SFTPDataExchangeSettingsPanel>(){
            private static final long serialVersionUID = 1L;

            @Override
            public void updateFocusCycle() {
            }
        };
        int count = 1;
        Iterator it = this.settings.getChildNamed(MigrosSettingsComplete_.dataExchangeSettings).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node setting = (Node)it.next();
            SFTPDataExchangeSettingsPanel panel = new SFTPDataExchangeSettingsPanel();
            panel.setNode(setting);
            this.ftpConfigurations.addView(panel, new TabButton("Config " + count++));
        }
        this.lastUpdates = new TextLabel(this.settings, ConverterRegistry.getConverter(MigrosLastUpdateConverter.class));
        this.adHocDefaultFlightCode = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(MigrosSettingsComplete_.defaultAdHocFlightCode)), Words.DEFAULT_ADHOC_FLIGHT_CODE_PREFIX, TitledItem.TitledItemOrientation.NORTH);
        this.defaultAdHoc = new TitledItem<SearchTextField2<StowingListTemplateComplete>>(SearchTextField2Factory.getStowingTemplateSearchField(true, this.settings.getChildNamed(MigrosSettingsComplete_.defaultAdHocStowing)), Words.DEFUALT_ADHOC_STOWING, TitledItem.TitledItemOrientation.NORTH);
        this.defaultCustomer = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, this.settings.getChildNamed(MigrosSettingsComplete_.customer)), "Customer", TitledItem.TitledItemOrientation.NORTH);
        this.historyTable = new MigrosExchangeListTable();
        this.historyTable.setNode((Node)new ViewNode("TransferHistory"));
        this.resetLastReceiveDate = new TextButton("Reset last receive Date");
        this.resetLastReceiveDate.setProgress(1.0f);
        this.resetLastReceiveDate.addButtonListener(this);
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText("Actions");
        this.sendPanel.setHasBackground(true);
        this.transferButton = new TablePanelAddSaveButton();
        this.transferButton.setText(Words.RECEIVE);
        this.transferButton.addButtonListener(this);
        this.sendInvoiceButton = new TablePanelAddSaveButton();
        this.sendInvoiceButton.setText("Send Invoice");
        this.sendInvoiceButton.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.useMigrosExchange);
        this.configPanel.add(this.autoTransferActive);
        this.configPanel.add(this.defaultCustomer);
        this.configPanel.add(this.ftpConfigurations);
        this.configPanel.add(this.lastUpdates);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.resetLastReceiveDate);
        this.configPanel.add(this.defaultAdHoc);
        this.configPanel.add(this.adHocDefaultFlightCode);
        this.configPanel.add(this.notificationAddresses);
        this.configPanel.add(this.notifyOrder);
        this.configPanel.add(this.notifyInvoiceAvis);
        this.configPanel.add(this.pathArticleExport);
        this.configPanel.add(this.pathOrderImport);
        this.configPanel.add(this.pathOrderAvisExport);
        this.configPanel.add(this.pathInvoiceExport);
        this.configPanel.add(this.pathInvoiceAvisImport);
        this.configPanel.add(this.pathInvoiceCreditNoteExport);
        this.configPanel.add(this.mappings);
        this.configPanel.add(this.companyName);
        this.configPanel.add(this.partnerNo);
        this.configPanel.add(this.kreditorNo);
        this.configPanel.add(this.companyID);
        this.configPanel.add(this.notificationSenderAddress);
        this.configPanel.add(this.errorNotificationAddresses);
        this.configPanel.add(this.deliverySlipSheet);
        this.configPanel.add(this.uid);
        this.configPanel.add(this.testMode);
        this.configPanel.add(this.gln);
        this.configPanel.add(this.orderNoCustomDocuType);
        this.configPanel.add(this.sendInvoiceDirectly);
        this.configPanel.add(this.sendOrderAvisDirectly);
        this.configPanel.add(this.sendOrderAvisAtFlightChecked);
        this.configPanel.add(this.sendOrderAvisManually);
        this.configPanel.add(this.sendInvoiceAtEvening);
        this.configPanel.add(this.sendInvoiceManually);
        this.configPanel.add(this.street);
        this.configPanel.add(this.city);
        this.configPanel.add(this.plz);
        this.configPanel.add(this.country);
        this.sendPanel.add(this.historyTable);
        this.sendPanel.add(this.transferButton);
        this.sendPanel.add(this.sendInvoiceButton);
        this.scrollPane.setViewportView(this.configPanel);
        this.add(this.scrollPane);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllTimeDurations();
                try {
                    MigrosExchangeInsert.this.rimsc = (MigrosSettingsComplete)((MigrosExchangeServiceManager)ServiceManagerRegistry.getService(MigrosExchangeServiceManager.class)).getSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (MigrosExchangeInsert.this.rimsc.getDataExchangeSettings().isEmpty()) {
                    SFTPDataExchangeSettingsComplete s = new SFTPDataExchangeSettingsComplete();
                    s.setClientOId(Long.valueOf(SFTPDataExchangeSettingsComplete.getNextId()));
                    s.setLastDataTransaction(new Timestamp(0L));
                    MigrosExchangeInsert.this.rimsc.getDataExchangeSettings().add(s);
                    s = new SFTPDataExchangeSettingsComplete();
                    s.setClientOId(Long.valueOf(SFTPDataExchangeSettingsComplete.getNextId()));
                    s.setLastDataTransaction(new Timestamp(0L));
                    MigrosExchangeInsert.this.rimsc.getDataExchangeSettings().add(s);
                }
                for (SFTPDataExchangeSettingsComplete ftpList : MigrosExchangeInsert.this.rimsc.getDataExchangeSettings()) {
                    if (ftpList.getLoginPwd() != null) continue;
                    ftpList.setLoginPwd(new EncryptedStringComplete());
                }
                MigrosExchangeInsert.this.rimsc.setTimerServiceSettings(MigrosExchangeInsert.this.createTimerService());
                MigrosExchangeInsert.this.rimsc.setInvoiceTimerServiceSettings(MigrosExchangeInsert.this.createInvoiceTimerService());
                MigrosExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)MigrosExchangeInsert.this.rimsc, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CustomsDocumentTypeComplete.class);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return MigrosExchangeInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createTimerService() {
        TimerServiceSettingsComplete s = new TimerServiceSettingsComplete();
        s.setClientOId(Long.valueOf(ADTO.getNextId()));
        s.setTimerServiceConfig((TimerServiceConfigComplete)new TimeDurationComplete(TimeUnitE.MINUTE, Double.valueOf(0.0)));
        s.setIntervallRateUnit(TimeUnitE.MINUTE);
        s.setIntervallRateValue(Double.valueOf(5.0));
        return s;
    }

    private TimerServiceSettingsComplete createInvoiceTimerService() {
        TimerServiceSettingsComplete s = new TimerServiceSettingsComplete();
        s.setTimerServiceConfig((TimerServiceConfigComplete)new DailyTimeComplete(Integer.valueOf(20), Integer.valueOf(0)));
        s.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return s;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useMigrosExchange.setEnabled(isEnabled);
            boolean b = isEnabled && this.useMigrosExchange.getElement().isChecked();
            this.transferButton.setEnabled(b);
            this.sendInvoiceButton.setEnabled(b);
            this.autoTransferActive.setEnabled(b);
            this.ftpConfigurations.setEnabled(b);
            this.defaultCustomer.setEnabled(b);
            this.defaultAdHoc.setEnabled(b);
            this.adHocDefaultFlightCode.setEnabled(b);
            this.lastUpdates.setEnabled(b);
            this.saveButton.setEnabled(isEnabled);
            this.resetLastReceiveDate.setEnabled(b);
            this.notificationAddresses.setEnabled(b);
            this.notifyInvoiceAvis.setEnabled(b);
            this.notifyOrder.setEnabled(b);
            this.sendInvoiceDirectly.setEnabled(b);
            this.sendOrderAvisAtFlightChecked.setEnabled(b);
            this.sendOrderAvisManually.setEnabled(b);
            this.sendInvoiceAtEvening.setEnabled(b);
            this.sendInvoiceManually.setEnabled(b);
            this.sendOrderAvisDirectly.setEnabled(b);
            this.companyName.setEnabled(b);
            this.partnerNo.setEnabled(b);
            this.kreditorNo.setEnabled(b);
            this.companyID.setEnabled(b);
            this.pathArticleExport.setEnabled(b);
            this.pathOrderImport.setEnabled(b);
            this.pathOrderAvisExport.setEnabled(b);
            this.pathInvoiceExport.setEnabled(b);
            this.pathInvoiceAvisImport.setEnabled(b);
            this.pathInvoiceCreditNoteExport.setEnabled(b);
            this.orderNoCustomDocuType.setEnabled(b);
            this.street.setEnabled(b);
            this.city.setEnabled(b);
            this.plz.setEnabled(b);
            this.country.setEnabled(b);
            this.mappings.setEnabled(b);
            this.notificationSenderAddress.setEnabled(b);
            this.errorNotificationAddresses.setEnabled(b);
            this.deliverySlipSheet.setEnabled(b);
            this.gln.setEnabled(b);
            this.testMode.setEnabled(b);
            this.uid.setEnabled(b);
            this.historyTable.setEnabled(b);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.ftpConfigurations.kill();
            this.autoTransferActive.kill();
            this.adHocDefaultFlightCode.kill();
            this.adHocDefaultFlightCode = null;
            this.defaultCustomer.kill();
            this.defaultCustomer = null;
            this.defaultAdHoc.kill();
            this.defaultAdHoc = null;
            this.lastUpdates.kill();
            this.saveButton.kill();
            this.useMigrosExchange.kill();
            this.orderNoCustomDocuType.kill();
            this.orderNoCustomDocuType = null;
            this.sendInvoiceDirectly.kill();
            this.sendOrderAvisAtFlightChecked.kill();
            this.sendOrderAvisManually.kill();
            this.sendInvoiceAtEvening.kill();
            this.sendInvoiceManually.kill();
            this.sendOrderAvisDirectly.kill();
            this.street.kill();
            this.city.kill();
            this.plz.kill();
            this.country.kill();
            this.street = null;
            this.city = null;
            this.plz = null;
            this.country = null;
            this.resetLastReceiveDate.kill();
            this.resetLastReceiveDate = null;
            this.notifyOrder.kill();
            this.notifyOrder = null;
            this.notifyInvoiceAvis.kill();
            this.notifyInvoiceAvis = null;
            this.notificationAddresses.kill();
            this.notificationAddresses = null;
            this.companyName.kill();
            this.partnerNo.kill();
            this.kreditorNo.kill();
            this.companyID.kill();
            this.pathArticleExport.kill();
            this.pathOrderImport.kill();
            this.pathOrderAvisExport.kill();
            this.pathInvoiceExport.kill();
            this.pathInvoiceAvisImport.kill();
            this.pathInvoiceCreditNoteExport.kill();
            this.mappings.kill();
            this.mappings = null;
            this.companyName = null;
            this.partnerNo = null;
            this.kreditorNo = null;
            this.companyID = null;
            this.pathArticleExport = null;
            this.pathOrderImport = null;
            this.pathOrderAvisExport = null;
            this.pathInvoiceExport = null;
            this.pathInvoiceAvisImport = null;
            this.pathInvoiceCreditNoteExport = null;
            this.notificationSenderAddress.kill();
            this.errorNotificationAddresses.kill();
            this.deliverySlipSheet.kill();
            this.notificationSenderAddress = null;
            this.errorNotificationAddresses = null;
            this.deliverySlipSheet = null;
            this.testMode.kill();
            this.uid.kill();
            this.gln.kill();
            this.testMode = null;
            this.uid = null;
            this.gln = null;
            this.sendInvoiceDirectly = null;
            this.sendOrderAvisAtFlightChecked = null;
            this.sendOrderAvisManually = null;
            this.sendInvoiceAtEvening = null;
            this.sendInvoiceManually = null;
            this.sendOrderAvisDirectly = null;
            this.historyTable.kill();
        }
        this.historyTable = null;
        this.sendPanel = null;
        this.configPanel = null;
        this.transferButton = null;
        this.sendInvoiceButton = null;
        this.ftpConfigurations = null;
        this.autoTransferActive = null;
        this.lastUpdates = null;
        this.saveButton = null;
        this.useMigrosExchange = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return "Migros Exchange";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.transferButton || source == this.saveButton || source == this.sendInvoiceButton) {
            this.setEnabled(false);
            if (source == this.transferButton) {
                this.ensureAnimation("Exchange with Migros");
                this.processFiles();
            } else if (source == this.saveButton) {
                List<ScreenValidationObject> a = this.validateRetailinMotionConfig();
                if (!a.isEmpty()) {
                    InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
                    this.setEnabled(true);
                    return;
                }
                this.ensureAnimation(Words.SAVE_DATA);
                this.saveConfig();
            } else if (source == this.sendInvoiceButton) {
                this.ensureAnimation("Check for Invoice to send to Migros");
                this.sendInvoice();
            }
            this.module.started();
            return;
        }
        if (source != this.resetLastReceiveDate) {
            this.setEnabled(this.isEnabled());
            return;
        }
        Iterator it = this.settings.getChildNamed(MigrosSettingsComplete_.dataExchangeSettings).getFailSafeChildIterator();
        while (true) {
            if (!it.hasNext()) {
                this.settings.commit();
                this.lastUpdates.setNode((Node)this.settings);
                return;
            }
            Node n = (Node)it.next();
            n.getChildNamed(SFTPDataExchangeSettingsComplete_.lastDataTransaction).setValue((Object)new Timestamp(0L), 0L);
        }
    }

    private List<ScreenValidationObject> validateRetailinMotionConfig() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Node settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class);
        settings.commitThis(SystemSettingsComplete.class);
        return a;
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                MigrosExchangeInsert.this.settings.commit(MigrosSettingsComplete.class);
                MigrosSettingsComplete rimsc = (MigrosSettingsComplete)MigrosExchangeInsert.this.settings.getValue();
                for (SFTPDataExchangeSettingsComplete sftpDataExchangeSettingsComplete : rimsc.getDataExchangeSettings()) {
                    sftpDataExchangeSettingsComplete.setDataExchangeProtocol(DataTransferProtocolE.SFTP);
                }
                if (rimsc != null && Boolean.TRUE.equals(rimsc.getUseMigrosInterface())) {
                    rimsc.setTimerServiceSettings(MigrosExchangeInsert.this.createTimerService());
                    rimsc.setInvoiceTimerServiceSettings(MigrosExchangeInsert.this.createInvoiceTimerService());
                    MigrosSettingsComplete migroSettings = rimsc = (MigrosSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimsc).getValue();
                    TimerServiceSettingsComplete ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(migroSettings.getTimerServiceSettings()).getValue();
                    migroSettings.setTimerServiceSettings(ts);
                    migroSettings = (MigrosSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)migroSettings).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.MIGROS_EXCHANGE, migroSettings.getAutoTransferActive().booleanValue(), ts, -1L);
                    ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(migroSettings.getInvoiceTimerServiceSettings()).getValue();
                    migroSettings.setInvoiceTimerServiceSettings(ts);
                    migroSettings = (MigrosSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)migroSettings).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.MIGROS_EXCHANGE_INVOICE, Boolean.TRUE.equals(migroSettings.getSendInvoiceAtEvening()), ts, -1L);
                    Node s = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                    Node settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)rimsc, false, false);
                    MigrosExchangeInsert.this.lastUpdates.setNode(settings);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.MIGROS_EXCHANGE);
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.MIGROS_EXCHANGE_INVOICE);
                    rimsc = (MigrosSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimsc).getValue();
                    Node s = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                    Node settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)rimsc, false, false);
                    MigrosExchangeInsert.this.lastUpdates.setNode(settings);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        MigrosExchangeInsert.this.hideAnimation();
                        MigrosExchangeInsert.this.module.ended();
                        MigrosExchangeInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)MigrosExchangeInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processFiles() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n = new Node();
                ((MigrosExchangeServiceManager)ServiceManagerRegistry.getService(MigrosExchangeServiceManager.class)).readFromFTP();
                n.setValue((Object)true, 0L);
                MigrosExchangeInsert.this.rimsc = (MigrosSettingsComplete)((MigrosExchangeServiceManager)ServiceManagerRegistry.getService(MigrosExchangeServiceManager.class)).getSettings().getValue();
                MigrosExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)MigrosExchangeInsert.this.rimsc, false, false);
                MigrosExchangeInsert.this.lastUpdates.setNode((Node)MigrosExchangeInsert.this.settings);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        boolean read = (Boolean)node.getValue();
                        MigrosExchangeInsert.this.hideAnimation();
                        MigrosExchangeInsert.this.module.ended();
                        MigrosExchangeInsert.this.setEnabled(true);
                        if (read) {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_IMPORTED, MigrosExchangeInsert.this.transferButton);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, "Exchange failed", (Component)MigrosExchangeInsert.this.transferButton);
                        MigrosExchangeInsert.this.hideAnimation();
                        MigrosExchangeInsert.this.setEnabled(true);
                        MigrosExchangeInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void sendInvoice() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n = new Node();
                ((MigrosExchangeServiceManager)ServiceManagerRegistry.getService(MigrosExchangeServiceManager.class)).checkForInvoicesToSend();
                n.setValue((Object)true, 0L);
                MigrosExchangeInsert.this.rimsc = (MigrosSettingsComplete)((MigrosExchangeServiceManager)ServiceManagerRegistry.getService(MigrosExchangeServiceManager.class)).getSettings().getValue();
                MigrosExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)MigrosExchangeInsert.this.rimsc, false, false);
                MigrosExchangeInsert.this.lastUpdates.setNode((Node)MigrosExchangeInsert.this.settings);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        boolean read = (Boolean)node.getValue();
                        MigrosExchangeInsert.this.hideAnimation();
                        MigrosExchangeInsert.this.module.ended();
                        MigrosExchangeInsert.this.setEnabled(true);
                        if (read) {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_IMPORTED, MigrosExchangeInsert.this.sendInvoiceButton);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, "Exchange failed", (Component)MigrosExchangeInsert.this.sendInvoiceButton);
                        MigrosExchangeInsert.this.hideAnimation();
                        MigrosExchangeInsert.this.setEnabled(true);
                        MigrosExchangeInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            MigrosExchangeInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            MigrosExchangeInsert.this.useMigrosExchange.setLocation(border, border + MigrosExchangeInsert.this.configPanel.getTitleHeight());
            MigrosExchangeInsert.this.useMigrosExchange.setSize(MigrosExchangeInsert.this.useMigrosExchange.getPreferredSize());
            MigrosExchangeInsert.this.autoTransferActive.setLocation(border, MigrosExchangeInsert.this.useMigrosExchange.getY() + MigrosExchangeInsert.this.useMigrosExchange.getHeight());
            MigrosExchangeInsert.this.autoTransferActive.setSize(MigrosExchangeInsert.this.autoTransferActive.getPreferredSize());
            MigrosExchangeInsert.this.ftpConfigurations.setLocation(border, MigrosExchangeInsert.this.autoTransferActive.getY() + MigrosExchangeInsert.this.autoTransferActive.getHeight() + border);
            MigrosExchangeInsert.this.ftpConfigurations.setSize(parent.getWidth() - 2 * border, (int)MigrosExchangeInsert.this.ftpConfigurations.getPreferredSize().getHeight());
            MigrosExchangeInsert.this.sendInvoiceDirectly.setLocation(border, MigrosExchangeInsert.this.ftpConfigurations.getY() + MigrosExchangeInsert.this.ftpConfigurations.getHeight() + border);
            MigrosExchangeInsert.this.sendInvoiceDirectly.setSize(MigrosExchangeInsert.this.sendInvoiceDirectly.getPreferredSize());
            MigrosExchangeInsert.this.sendInvoiceAtEvening.setLocation(border, MigrosExchangeInsert.this.sendInvoiceDirectly.getY() + MigrosExchangeInsert.this.sendInvoiceDirectly.getHeight());
            MigrosExchangeInsert.this.sendInvoiceAtEvening.setSize(MigrosExchangeInsert.this.sendInvoiceAtEvening.getPreferredSize());
            MigrosExchangeInsert.this.sendInvoiceManually.setLocation(border, MigrosExchangeInsert.this.sendInvoiceAtEvening.getY() + MigrosExchangeInsert.this.sendInvoiceAtEvening.getHeight());
            MigrosExchangeInsert.this.sendInvoiceManually.setSize(MigrosExchangeInsert.this.sendInvoiceManually.getPreferredSize());
            MigrosExchangeInsert.this.sendOrderAvisDirectly.setLocation(border, MigrosExchangeInsert.this.sendInvoiceManually.getY() + MigrosExchangeInsert.this.sendInvoiceManually.getHeight());
            MigrosExchangeInsert.this.sendOrderAvisDirectly.setSize(MigrosExchangeInsert.this.sendOrderAvisDirectly.getPreferredSize());
            MigrosExchangeInsert.this.sendOrderAvisAtFlightChecked.setLocation(border, MigrosExchangeInsert.this.sendOrderAvisDirectly.getY() + MigrosExchangeInsert.this.sendOrderAvisDirectly.getHeight());
            MigrosExchangeInsert.this.sendOrderAvisAtFlightChecked.setSize(MigrosExchangeInsert.this.sendOrderAvisAtFlightChecked.getPreferredSize());
            MigrosExchangeInsert.this.sendOrderAvisManually.setLocation(border, MigrosExchangeInsert.this.sendOrderAvisAtFlightChecked.getY() + MigrosExchangeInsert.this.sendOrderAvisAtFlightChecked.getHeight());
            MigrosExchangeInsert.this.sendOrderAvisManually.setSize(MigrosExchangeInsert.this.sendOrderAvisManually.getPreferredSize());
            MigrosExchangeInsert.this.pathArticleExport.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.sendOrderAvisManually.getY() + MigrosExchangeInsert.this.sendOrderAvisManually.getHeight() + border);
            MigrosExchangeInsert.this.pathArticleExport.setSize(400, (int)MigrosExchangeInsert.this.pathArticleExport.getPreferredSize().getHeight());
            MigrosExchangeInsert.this.pathOrderImport.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.pathArticleExport.getY() + MigrosExchangeInsert.this.pathArticleExport.getHeight() + border / 2);
            MigrosExchangeInsert.this.pathOrderImport.setSize(400, (int)MigrosExchangeInsert.this.pathOrderImport.getPreferredSize().getHeight());
            MigrosExchangeInsert.this.pathOrderAvisExport.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.pathOrderImport.getY() + MigrosExchangeInsert.this.pathOrderImport.getHeight() + border / 2);
            MigrosExchangeInsert.this.pathOrderAvisExport.setSize(400, (int)MigrosExchangeInsert.this.pathOrderAvisExport.getPreferredSize().getHeight());
            MigrosExchangeInsert.this.pathInvoiceExport.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.pathOrderAvisExport.getY() + MigrosExchangeInsert.this.pathOrderAvisExport.getHeight() + border / 2);
            MigrosExchangeInsert.this.pathInvoiceExport.setSize(400, (int)MigrosExchangeInsert.this.pathInvoiceExport.getPreferredSize().getHeight());
            MigrosExchangeInsert.this.pathInvoiceAvisImport.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.pathInvoiceExport.getY() + MigrosExchangeInsert.this.pathInvoiceExport.getHeight() + border / 2);
            MigrosExchangeInsert.this.pathInvoiceAvisImport.setSize(400, (int)MigrosExchangeInsert.this.pathInvoiceAvisImport.getPreferredSize().getHeight());
            MigrosExchangeInsert.this.pathInvoiceCreditNoteExport.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.pathInvoiceAvisImport.getY() + MigrosExchangeInsert.this.pathInvoiceAvisImport.getHeight() + border / 2);
            MigrosExchangeInsert.this.pathInvoiceCreditNoteExport.setSize(400, (int)MigrosExchangeInsert.this.pathInvoiceCreditNoteExport.getPreferredSize().getHeight());
            MigrosExchangeInsert.this.defaultAdHoc.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.pathInvoiceCreditNoteExport.getY() + MigrosExchangeInsert.this.pathInvoiceCreditNoteExport.getHeight() + border);
            MigrosExchangeInsert.this.defaultAdHoc.setSize(400, (int)MigrosExchangeInsert.this.defaultAdHoc.getPreferredSize().getHeight());
            MigrosExchangeInsert.this.adHocDefaultFlightCode.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.defaultAdHoc.getY() + MigrosExchangeInsert.this.defaultAdHoc.getHeight());
            MigrosExchangeInsert.this.adHocDefaultFlightCode.setSize(400, (int)MigrosExchangeInsert.this.adHocDefaultFlightCode.getPreferredSize().getHeight());
            MigrosExchangeInsert.this.defaultCustomer.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.adHocDefaultFlightCode.getY() + MigrosExchangeInsert.this.adHocDefaultFlightCode.getHeight());
            MigrosExchangeInsert.this.defaultCustomer.setSize(400, (int)MigrosExchangeInsert.this.defaultCustomer.getPreferredSize().getHeight());
            MigrosExchangeInsert.this.deliverySlipSheet.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.defaultCustomer.getY() + MigrosExchangeInsert.this.defaultCustomer.getHeight());
            MigrosExchangeInsert.this.deliverySlipSheet.setSize(400, (int)MigrosExchangeInsert.this.deliverySlipSheet.getPreferredSize().getHeight());
            MigrosExchangeInsert.this.orderNoCustomDocuType.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.deliverySlipSheet.getY() + MigrosExchangeInsert.this.deliverySlipSheet.getHeight());
            MigrosExchangeInsert.this.orderNoCustomDocuType.setSize(400, (int)MigrosExchangeInsert.this.orderNoCustomDocuType.getPreferredSize().getHeight());
            MigrosExchangeInsert.this.notifyOrder.setLocation(border, MigrosExchangeInsert.this.orderNoCustomDocuType.getY() + MigrosExchangeInsert.this.orderNoCustomDocuType.getHeight() + border);
            MigrosExchangeInsert.this.notifyOrder.setSize(MigrosExchangeInsert.this.notifyOrder.getPreferredSize());
            MigrosExchangeInsert.this.notifyInvoiceAvis.setLocation(border, MigrosExchangeInsert.this.notifyOrder.getY() + MigrosExchangeInsert.this.notifyOrder.getHeight());
            MigrosExchangeInsert.this.notifyInvoiceAvis.setSize(MigrosExchangeInsert.this.notifyInvoiceAvis.getPreferredSize());
            MigrosExchangeInsert.this.notificationAddresses.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.notifyInvoiceAvis.getY() + MigrosExchangeInsert.this.notifyInvoiceAvis.getHeight());
            MigrosExchangeInsert.this.notificationAddresses.setSize(400, (int)MigrosExchangeInsert.this.notificationAddresses.getPreferredSize().getHeight());
            MigrosExchangeInsert.this.errorNotificationAddresses.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.notificationAddresses.getY() + MigrosExchangeInsert.this.notificationAddresses.getHeight());
            MigrosExchangeInsert.this.errorNotificationAddresses.setSize(400, (int)MigrosExchangeInsert.this.errorNotificationAddresses.getPreferredSize().getHeight());
            MigrosExchangeInsert.this.notificationSenderAddress.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.errorNotificationAddresses.getY() + MigrosExchangeInsert.this.errorNotificationAddresses.getHeight());
            MigrosExchangeInsert.this.notificationSenderAddress.setSize(400, (int)MigrosExchangeInsert.this.notificationSenderAddress.getPreferredSize().getHeight());
            MigrosExchangeInsert.this.companyName.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.notificationSenderAddress.getY() + MigrosExchangeInsert.this.notificationSenderAddress.getHeight() + border);
            MigrosExchangeInsert.this.companyName.setSize(400, (int)MigrosExchangeInsert.this.companyName.getPreferredSize().getHeight());
            MigrosExchangeInsert.this.partnerNo.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.companyName.getY() + MigrosExchangeInsert.this.companyName.getHeight());
            MigrosExchangeInsert.this.partnerNo.setSize(400, (int)MigrosExchangeInsert.this.partnerNo.getPreferredSize().getHeight());
            MigrosExchangeInsert.this.kreditorNo.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.partnerNo.getY() + MigrosExchangeInsert.this.partnerNo.getHeight());
            MigrosExchangeInsert.this.kreditorNo.setSize(400, (int)MigrosExchangeInsert.this.kreditorNo.getPreferredSize().getHeight());
            MigrosExchangeInsert.this.companyID.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.kreditorNo.getY() + MigrosExchangeInsert.this.kreditorNo.getHeight());
            MigrosExchangeInsert.this.companyID.setSize(400, (int)MigrosExchangeInsert.this.companyID.getPreferredSize().getHeight());
            MigrosExchangeInsert.this.gln.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.companyID.getY() + MigrosExchangeInsert.this.companyID.getHeight());
            MigrosExchangeInsert.this.gln.setSize(400, (int)MigrosExchangeInsert.this.gln.getPreferredSize().getHeight());
            MigrosExchangeInsert.this.uid.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.gln.getY() + MigrosExchangeInsert.this.gln.getHeight());
            MigrosExchangeInsert.this.uid.setSize(400, (int)MigrosExchangeInsert.this.uid.getPreferredSize().getHeight());
            MigrosExchangeInsert.this.street.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.uid.getY() + MigrosExchangeInsert.this.uid.getHeight());
            MigrosExchangeInsert.this.street.setSize(400, (int)MigrosExchangeInsert.this.street.getPreferredSize().getHeight());
            MigrosExchangeInsert.this.city.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.street.getY() + MigrosExchangeInsert.this.street.getHeight());
            MigrosExchangeInsert.this.city.setSize(400, (int)MigrosExchangeInsert.this.city.getPreferredSize().getHeight());
            MigrosExchangeInsert.this.plz.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.city.getY() + MigrosExchangeInsert.this.city.getHeight());
            MigrosExchangeInsert.this.plz.setSize(400, (int)MigrosExchangeInsert.this.plz.getPreferredSize().getHeight());
            MigrosExchangeInsert.this.country.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.plz.getY() + MigrosExchangeInsert.this.plz.getHeight());
            MigrosExchangeInsert.this.country.setSize(400, (int)MigrosExchangeInsert.this.country.getPreferredSize().getHeight());
            MigrosExchangeInsert.this.testMode.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.country.getY() + MigrosExchangeInsert.this.country.getHeight() + border);
            MigrosExchangeInsert.this.testMode.setSize(MigrosExchangeInsert.this.testMode.getPreferredSize());
            MigrosExchangeInsert.this.mappings.setLocation(MigrosExchangeInsert.this.ftpConfigurations.getX(), MigrosExchangeInsert.this.testMode.getY() + MigrosExchangeInsert.this.testMode.getHeight() + border);
            MigrosExchangeInsert.this.mappings.setSize(400, 150);
            MigrosExchangeInsert.this.lastUpdates.setLocation(border, MigrosExchangeInsert.this.mappings.getY() + MigrosExchangeInsert.this.mappings.getHeight() + border);
            MigrosExchangeInsert.this.lastUpdates.setSize(MigrosExchangeInsert.this.lastUpdates.getPreferredSize());
            MigrosExchangeInsert.this.resetLastReceiveDate.setLocation(MigrosExchangeInsert.this.lastUpdates.getX() + MigrosExchangeInsert.this.lastUpdates.getWidth() + border, MigrosExchangeInsert.this.lastUpdates.getY());
            MigrosExchangeInsert.this.resetLastReceiveDate.setSize(MigrosExchangeInsert.this.resetLastReceiveDate.getPreferredSize());
            MigrosExchangeInsert.this.saveButton.setLocation((int)((double)parent.getWidth() - MigrosExchangeInsert.this.saveButton.getPreferredSize().getWidth()) / 2, MigrosExchangeInsert.this.resetLastReceiveDate.getY() + MigrosExchangeInsert.this.resetLastReceiveDate.getHeight() + border);
            MigrosExchangeInsert.this.saveButton.setSize(MigrosExchangeInsert.this.saveButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = MigrosExchangeInsert.this.configPanel.getTitleHeight();
            int border = 10;
            h += border;
            h = (int)((double)h + MigrosExchangeInsert.this.useMigrosExchange.getPreferredSize().getHeight());
            h = (int)((double)h + MigrosExchangeInsert.this.autoTransferActive.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + MigrosExchangeInsert.this.ftpConfigurations.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + MigrosExchangeInsert.this.sendOrderAvisDirectly.getPreferredSize().getHeight());
            h = (int)((double)h + MigrosExchangeInsert.this.sendOrderAvisAtFlightChecked.getPreferredSize().getHeight());
            h = (int)((double)h + MigrosExchangeInsert.this.sendOrderAvisManually.getPreferredSize().getHeight());
            h = (int)((double)h + MigrosExchangeInsert.this.sendInvoiceDirectly.getPreferredSize().getHeight());
            h = (int)((double)h + MigrosExchangeInsert.this.sendInvoiceAtEvening.getPreferredSize().getHeight());
            h = (int)((double)h + MigrosExchangeInsert.this.sendInvoiceManually.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + (MigrosExchangeInsert.this.pathArticleExport.getPreferredSize().getHeight() + (double)(border / 2)));
            h = (int)((double)h + (MigrosExchangeInsert.this.pathOrderImport.getPreferredSize().getHeight() + (double)(border / 2)));
            h = (int)((double)h + (MigrosExchangeInsert.this.pathOrderAvisExport.getPreferredSize().getHeight() + (double)(border / 2)));
            h = (int)((double)h + (MigrosExchangeInsert.this.pathInvoiceExport.getPreferredSize().getHeight() + (double)(border / 2)));
            h = (int)((double)h + (MigrosExchangeInsert.this.pathInvoiceAvisImport.getPreferredSize().getHeight() + (double)(border / 2)));
            h = (int)((double)h + (MigrosExchangeInsert.this.pathInvoiceCreditNoteExport.getPreferredSize().getHeight() + (double)(border / 2)));
            h = (int)((double)h + MigrosExchangeInsert.this.defaultAdHoc.getPreferredSize().getHeight());
            h = (int)((double)h + MigrosExchangeInsert.this.adHocDefaultFlightCode.getPreferredSize().getHeight());
            h = (int)((double)h + MigrosExchangeInsert.this.defaultCustomer.getPreferredSize().getHeight());
            h = (int)((double)h + MigrosExchangeInsert.this.deliverySlipSheet.getPreferredSize().getHeight());
            h = (int)((double)h + MigrosExchangeInsert.this.orderNoCustomDocuType.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + MigrosExchangeInsert.this.notifyOrder.getPreferredSize().getHeight());
            h = (int)((double)h + MigrosExchangeInsert.this.notifyInvoiceAvis.getPreferredSize().getHeight());
            h = (int)((double)h + MigrosExchangeInsert.this.notificationAddresses.getPreferredSize().getHeight());
            h = (int)((double)h + MigrosExchangeInsert.this.errorNotificationAddresses.getPreferredSize().getHeight());
            h = (int)((double)h + MigrosExchangeInsert.this.notificationSenderAddress.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + MigrosExchangeInsert.this.companyName.getPreferredSize().getHeight());
            h = (int)((double)h + MigrosExchangeInsert.this.partnerNo.getPreferredSize().getHeight());
            h = (int)((double)h + MigrosExchangeInsert.this.kreditorNo.getPreferredSize().getHeight());
            h = (int)((double)h + MigrosExchangeInsert.this.companyID.getPreferredSize().getHeight());
            h = (int)((double)h + MigrosExchangeInsert.this.uid.getPreferredSize().getHeight());
            h = (int)((double)h + MigrosExchangeInsert.this.gln.getPreferredSize().getHeight());
            h = (int)((double)h + MigrosExchangeInsert.this.street.getPreferredSize().getHeight());
            h = (int)((double)h + MigrosExchangeInsert.this.city.getPreferredSize().getHeight());
            h = (int)((double)h + MigrosExchangeInsert.this.plz.getPreferredSize().getHeight());
            h = (int)((double)h + MigrosExchangeInsert.this.country.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + MigrosExchangeInsert.this.testMode.getPreferredSize().getHeight());
            h += border;
            h += 150;
            h += border;
            h = (int)((double)h + MigrosExchangeInsert.this.lastUpdates.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + MigrosExchangeInsert.this.saveButton.getPreferredSize().getHeight());
            return new Dimension(450, h += border);
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            MigrosExchangeInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            MigrosExchangeInsert.this.transferButton.setLocation(border, (int)((double)parent.getHeight() - (MigrosExchangeInsert.this.transferButton.getPreferredSize().getHeight() + (double)border)));
            MigrosExchangeInsert.this.transferButton.setSize(MigrosExchangeInsert.this.transferButton.getPreferredSize());
            MigrosExchangeInsert.this.sendInvoiceButton.setLocation(MigrosExchangeInsert.this.transferButton.getX() + MigrosExchangeInsert.this.transferButton.getWidth() + border, (int)((double)parent.getHeight() - (MigrosExchangeInsert.this.sendInvoiceButton.getPreferredSize().getHeight() + (double)border)));
            MigrosExchangeInsert.this.sendInvoiceButton.setSize(MigrosExchangeInsert.this.sendInvoiceButton.getPreferredSize());
            MigrosExchangeInsert.this.historyTable.setLocation(0, MigrosExchangeInsert.this.sendPanel.getTitleHeight() + border);
            MigrosExchangeInsert.this.historyTable.setSize(parent.getWidth(), parent.getHeight() - (MigrosExchangeInsert.this.historyTable.getY() + MigrosExchangeInsert.this.transferButton.getHeight() + 2 * border));
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (MigrosExchangeInsert.this.animation != null) {
                MigrosExchangeInsert.this.animation.setLocation((int)((double)parent.getWidth() - MigrosExchangeInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - MigrosExchangeInsert.this.animation.getPreferredSize().getHeight()) / 2);
                MigrosExchangeInsert.this.animation.setSize(MigrosExchangeInsert.this.animation.getPreferredSize());
            }
            if (MigrosExchangeInsert.this.isInserted) {
                MigrosExchangeInsert.this.scrollPane.setLocation(border, border);
                MigrosExchangeInsert.this.scrollPane.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                MigrosExchangeInsert.this.sendPanel.setLocation(MigrosExchangeInsert.this.scrollPane.getX() + MigrosExchangeInsert.this.scrollPane.getWidth() + border, border);
                MigrosExchangeInsert.this.sendPanel.setSize(MigrosExchangeInsert.this.scrollPane.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

