/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.NoProExchangeLastUpdateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.panels.SFTPDataExchangeSettingsPanel;
import ch.icit.pegasus.client.gui.utils.panels.TabbedItem;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.tabbed.TabButton;
import ch.icit.pegasus.client.gui.utils.tables.UserSearchTable;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.NoProExchangeServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.DataTransferProtocolE;
import ch.icit.pegasus.server.core.dtos.dataexchange.ESpecsSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.ESpecsSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.NoProExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.NoProExchangeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.SFTPDataExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.SFTPDataExchangeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.report.especs.ESpecsConfig;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.DailyTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.EncryptedStringComplete;
import ch.icit.pegasus.server.core.dtos.util.TimeDurationComplete;
import ch.icit.pegasus.server.core.dtos.util.TimeUnitE;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class NoProExchangeInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TitledItem<CheckBox> useNoProSync;
    private TitledItem<CheckBox> autoExchangeActive;
    private TitledItem<CheckBox> readMasterData;
    private TitledItem<CheckBox> readFlights;
    private TitledItem<CheckBox> readMaterialManagement;
    private TitledItem<CheckBox> writeMasterData;
    private TitledItem<CheckBox> writeFlights;
    private TitledItem<CheckBox> writeMaterialManagement;
    private TitledItem<SearchTextField2<SupplierLight>> noProAsSupplier;
    private TitledItem<SearchTextField2<CustomerLight>> noProAsCustomer;
    private TitledItem<ComboBox> noProAsDepartment;
    private TitledItem<SearchTextField2<StoreLight>> noProStore;
    private TitledItem<SearchTextField2<StoreLight>> productionStore;
    private TitledItem<SearchTextField2<StowingListTemplateComplete>> noProStowing;
    private TabbedItem<SFTPDataExchangeSettingsPanel> ftpConfigurations;
    private HorizontalSeparator sep1;
    private TextLabel lastUpdates;
    private TablePanelAddSaveButton sendButton;
    private TablePanelAddSaveButton receiveButton;
    private TablePanelAddSaveButton updateDaily;
    private TablePanelAddSaveButton saveButton;
    private TablePanelAddSaveButton exportInitialStockButton;
    private TablePanelAddSaveButton importInitialStockButton;
    private TextButton resetLastReceiveDate;
    private UserSearchTable usersToInform;
    private final DataExchangeModule module;
    private Node<NoProExchangeSettingsComplete> settings;
    private SystemSettingsComplete systemSettings;

    public NoProExchangeInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
        ESpecsConfig e = new ESpecsConfig();
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.useNoProSync = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(NoProExchangeSettingsComplete_.useNoProExchange)), "Use NoPro Exchange", TitledItem.TitledItemOrientation.EAST);
        this.useNoProSync.getElement().addButtonListener(this);
        this.autoExchangeActive = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(NoProExchangeSettingsComplete_.autoExchangeData)), "Auto Exchange", TitledItem.TitledItemOrientation.EAST);
        this.lastUpdates = new TextLabel(this.settings, ConverterRegistry.getConverter(NoProExchangeLastUpdateConverter.class));
        this.noProAsSupplier = new TitledItem<SearchTextField2<SupplierLight>>(SearchTextField2Factory.getSupplierSearchField(true, this.settings.getChildNamed(NoProExchangeSettingsComplete_.noProAsSupplier)), "NoPro as Supplier", TitledItem.TitledItemOrientation.NORTH);
        this.noProAsCustomer = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, this.settings.getChildNamed(NoProExchangeSettingsComplete_.noProAsCustomer)), "NoPro as Customer", TitledItem.TitledItemOrientation.NORTH);
        this.noProStore = new TitledItem<SearchTextField2<StoreLight>>(SearchTextField2Factory.getStoreSearchField(true, this.settings.getChildNamed(NoProExchangeSettingsComplete_.noProStore)), "NoPro Store", TitledItem.TitledItemOrientation.NORTH);
        this.productionStore = new TitledItem<SearchTextField2<StoreLight>>(SearchTextField2Factory.getStoreSearchField(true, this.settings.getChildNamed(NoProExchangeSettingsComplete_.productionStore)), "Production Store", TitledItem.TitledItemOrientation.NORTH);
        this.noProAsDepartment = new TitledItem<ComboBox>(new ComboBox(this.settings.getChildNamed(NoProExchangeSettingsComplete_.noProAsDepartment), NodeToolkit.getAffixList(InternalCostCenterComplete.class), ConverterRegistry.getConverter(CostCenterConverter.class)), "NoPro as Department", TitledItem.TitledItemOrientation.NORTH);
        this.noProStowing = new TitledItem<SearchTextField2<StowingListTemplateComplete>>(SearchTextField2Factory.getStowingTemplateSearchField(true, this.settings.getChildNamed(NoProExchangeSettingsComplete_.defaultStowingList)), "NoPro Stowing List", TitledItem.TitledItemOrientation.NORTH);
        this.readMasterData = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(NoProExchangeSettingsComplete_.readMasterData)), "Read Master Data", TitledItem.TitledItemOrientation.EAST);
        this.readFlights = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(NoProExchangeSettingsComplete_.readFlights)), "Read Flights", TitledItem.TitledItemOrientation.EAST);
        this.readMaterialManagement = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(NoProExchangeSettingsComplete_.readMaterialManagement)), "Read Material Management", TitledItem.TitledItemOrientation.EAST);
        this.writeMasterData = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(NoProExchangeSettingsComplete_.writeMasterData)), "Write Master Data", TitledItem.TitledItemOrientation.EAST);
        this.writeFlights = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(NoProExchangeSettingsComplete_.writeFlights)), "Write Flights", TitledItem.TitledItemOrientation.EAST);
        this.writeMaterialManagement = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(NoProExchangeSettingsComplete_.writeMaterialManagement)), "Write Material Management", TitledItem.TitledItemOrientation.EAST);
        this.sep1 = new HorizontalSeparator();
        this.ftpConfigurations = new TabbedItem<SFTPDataExchangeSettingsPanel>(){
            private static final long serialVersionUID = 1L;

            @Override
            public void updateFocusCycle() {
            }
        };
        Node setting = this.settings.getChildNamed(NoProExchangeSettingsComplete_.dataExchangeSettings);
        SFTPDataExchangeSettingsPanel panel = new SFTPDataExchangeSettingsPanel();
        panel.setNode(setting);
        this.ftpConfigurations.addView(panel, new TabButton("Config 1"));
        this.usersToInform = new UserSearchTable();
        this.usersToInform.getModel().setNode(this.settings.getChildNamed(ESpecsSettingsComplete_.user));
        this.resetLastReceiveDate = new TextButton("Reset last receive Date");
        this.resetLastReceiveDate.setProgress(1.0f);
        this.resetLastReceiveDate.addButtonListener(this);
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.sendButton = new TablePanelAddSaveButton();
        this.sendButton.setText(Words.SEND);
        this.sendButton.addButtonListener(this);
        this.receiveButton = new TablePanelAddSaveButton();
        this.receiveButton.setText(Words.RECEIVE);
        this.receiveButton.addButtonListener(this);
        this.updateDaily = new TablePanelAddSaveButton();
        this.updateDaily.setText("Update Daily");
        this.updateDaily.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.exportInitialStockButton = new TablePanelAddSaveButton();
        this.exportInitialStockButton.setText("Export initial Stock");
        this.exportInitialStockButton.addButtonListener(this);
        this.importInitialStockButton = new TablePanelAddSaveButton();
        this.importInitialStockButton.setText("Import initial Stock");
        this.importInitialStockButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.ftpConfigurations);
        this.configPanel.add(this.noProAsSupplier);
        this.configPanel.add(this.noProAsCustomer);
        this.configPanel.add(this.noProStowing);
        this.configPanel.add(this.useNoProSync);
        this.configPanel.add(this.autoExchangeActive);
        this.configPanel.add(this.lastUpdates);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.sep1);
        this.configPanel.add(this.resetLastReceiveDate);
        this.configPanel.add(this.usersToInform);
        this.configPanel.add(this.readMasterData);
        this.configPanel.add(this.readFlights);
        this.configPanel.add(this.readMaterialManagement);
        this.configPanel.add(this.readFlights);
        this.configPanel.add(this.writeMasterData);
        this.configPanel.add(this.writeFlights);
        this.configPanel.add(this.writeMaterialManagement);
        this.configPanel.add(this.writeFlights);
        this.configPanel.add(this.noProStore);
        this.configPanel.add(this.productionStore);
        this.configPanel.add(this.noProAsDepartment);
        this.sendPanel.add(this.sendButton);
        this.sendPanel.add(this.receiveButton);
        this.sendPanel.add(this.updateDaily);
        this.sendPanel.add(this.exportInitialStockButton);
        this.sendPanel.add(this.importInitialStockButton);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                NoProExchangeSettingsComplete s;
                StaticEnumServiceManager.getAllTimeDurations();
                NoProExchangeInsert.this.systemSettings = (SystemSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings().getValue();
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                NoProExchangeSettingsComplete esc = null;
                try {
                    esc = (NoProExchangeSettingsComplete)((NoProExchangeServiceManager)ServiceManagerRegistry.getService(NoProExchangeServiceManager.class)).getNoProSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (esc == null) {
                    s = new NoProExchangeSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    esc = s;
                }
                if (esc.getDataExchangeSettings() == null) {
                    SFTPDataExchangeSettingsComplete c = new SFTPDataExchangeSettingsComplete();
                    c.setLoginPwd(new EncryptedStringComplete());
                    c.setClientOId(Long.valueOf(ADTO.getNextId()));
                    esc.setDataExchangeSettings(c);
                } else if (esc.getDataExchangeSettings().getLoginPwd() == null) {
                    esc.getDataExchangeSettings().setLoginPwd(new EncryptedStringComplete());
                }
                if (esc.getTimerServiceSettingsDaily() == null) {
                    s = new TimerServiceSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    s.setTimerServiceConfig((TimerServiceConfigComplete)new TimeDurationComplete(TimeUnitE.MINUTE, Double.valueOf(10.0)));
                    s.setIntervallRateUnit(TimeUnitE.MINUTE);
                    s.setIntervallRateValue(Double.valueOf(10.0));
                    esc.setTimerServiceSettingsDaily((TimerServiceSettingsComplete)s);
                }
                NoProExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)esc, false, false);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return NoProExchangeInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useNoProSync.setEnabled(isEnabled);
            boolean b = isEnabled && this.useNoProSync.getElement().isChecked();
            this.sendButton.setEnabled(b);
            this.receiveButton.setEnabled(b);
            this.updateDaily.setEnabled(b);
            this.autoExchangeActive.setEnabled(b);
            this.ftpConfigurations.setEnabled(b);
            this.lastUpdates.setEnabled(b);
            this.sep1.setEnabled(b);
            this.saveButton.setEnabled(isEnabled);
            this.resetLastReceiveDate.setEnabled(b);
            this.noProAsCustomer.setEnabled(b);
            this.noProStowing.setEnabled(b);
            this.noProAsSupplier.setEnabled(b);
            this.readMasterData.setEnabled(b);
            this.readFlights.setEnabled(b);
            this.readMaterialManagement.setEnabled(b);
            this.readFlights.setEnabled(b);
            this.writeMasterData.setEnabled(b);
            this.writeFlights.setEnabled(b);
            this.writeMaterialManagement.setEnabled(b);
            this.writeFlights.setEnabled(b);
            this.noProAsDepartment.setEnabled(b);
            this.noProStore.setEnabled(b);
            this.productionStore.setEnabled(b);
            this.importInitialStockButton.setEnabled(b);
            this.exportInitialStockButton.setEnabled(b);
            this.usersToInform.setEnabled(b);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.autoExchangeActive.kill();
            this.sendButton.kill();
            this.ftpConfigurations.kill();
            this.lastUpdates.kill();
            this.saveButton.kill();
            this.sep1.kill();
            this.useNoProSync.kill();
            this.resetLastReceiveDate.kill();
            this.resetLastReceiveDate = null;
            this.usersToInform.kill();
            this.usersToInform = null;
            this.noProAsSupplier.kill();
            this.noProAsSupplier = null;
            this.noProAsCustomer.kill();
            this.noProAsCustomer = null;
            this.noProStowing.kill();
            this.noProStowing = null;
            this.readMasterData.kill();
            this.readFlights.kill();
            this.readMaterialManagement.kill();
            this.writeMasterData.kill();
            this.writeMaterialManagement.kill();
            this.writeFlights.kill();
            this.noProStore.kill();
            this.productionStore.kill();
            this.noProAsDepartment.kill();
            this.importInitialStockButton.kill();
            this.exportInitialStockButton.kill();
            this.readMasterData = null;
            this.readMaterialManagement = null;
            this.readFlights = null;
            this.writeMasterData = null;
            this.writeMaterialManagement = null;
            this.writeFlights = null;
            this.noProAsDepartment = null;
            this.noProStore = null;
            this.productionStore = null;
            this.importInitialStockButton = null;
            this.exportInitialStockButton = null;
        }
        this.sendPanel = null;
        this.configPanel = null;
        this.ftpConfigurations = null;
        this.sendButton = null;
        this.receiveButton = null;
        this.updateDaily = null;
        this.autoExchangeActive = null;
        this.lastUpdates = null;
        this.saveButton = null;
        this.sep1 = null;
        this.useNoProSync = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return Words.NOPRO_EXCHANGE;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.sendButton || source == this.receiveButton || source == this.saveButton || source == this.exportInitialStockButton || source == this.importInitialStockButton || source == this.updateDaily) {
            this.settings.commit();
            this.setEnabled(false);
            if (source == this.sendButton) {
                this.ensureAnimation(Words.EXCHANGE_DATA);
                this.processFiles(false);
            } else if (source == this.receiveButton) {
                this.ensureAnimation(Words.EXCHANGE);
                this.processFiles(true);
            } else if (source == this.saveButton) {
                List<ScreenValidationObject> a = this.validateESpecsConfig();
                if (!a.isEmpty()) {
                    InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
                    this.setEnabled(true);
                    return;
                }
                this.ensureAnimation(Words.SAVE_DATA);
                this.saveConfig();
            } else if (source == this.updateDaily) {
                this.ensureAnimation(Words.EXCHANGE_DATA);
                this.processUpdate();
            } else {
                this.ensureAnimation(Words.EXCHANGE);
                this.processInitialStock(source == this.importInitialStockButton);
            }
            this.module.started();
            return;
        }
        if (source == this.resetLastReceiveDate) {
            this.settings.getChildNamed(new DtoField[]{NoProExchangeSettingsComplete_.dataExchangeSettings, SFTPDataExchangeSettingsComplete_.lastDataTransaction}).setValue((Object)new Timestamp(0L), 0L);
            this.settings.commit();
            this.lastUpdates.setNode((Node)this.settings);
            return;
        }
        this.setEnabled(this.isEnabled());
    }

    private void processUpdate() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ((NoProExchangeServiceManager)ServiceManagerRegistry.getService(NoProExchangeServiceManager.class)).updateDaily();
                ViewNode n = new ViewNode("");
                n.setValue((Object)true, 0L);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        NoProExchangeInsert.this.hideAnimation();
                        NoProExchangeInsert.this.module.ended();
                        NoProExchangeInsert.this.setEnabled(true);
                        InnerPopupFactory.showMessageDialog(Words.SUCCESSFUL, NoProExchangeInsert.this.updateDaily);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, Words.FAILED, (Component)NoProExchangeInsert.this.updateDaily);
                        NoProExchangeInsert.this.hideAnimation();
                        NoProExchangeInsert.this.setEnabled(true);
                        NoProExchangeInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private List<ScreenValidationObject> validateESpecsConfig() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Node settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class);
        settings.commitThis(SystemSettingsComplete.class);
        return a;
    }

    private TimerServiceSettingsComplete createTimerServiceUpdate() {
        TimerServiceSettingsComplete ts = new TimerServiceSettingsComplete();
        ts.setClientOId(Long.valueOf(ADTO.getNextId()));
        if (CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()))) {
            ts.setTimerServiceConfig((TimerServiceConfigComplete)new DailyTimeComplete(Integer.valueOf(1), Integer.valueOf(30)));
        }
        ts.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return ts;
    }

    private TimerServiceSettingsComplete createTimerServiceDaily() {
        TimerServiceSettingsComplete ts = new TimerServiceSettingsComplete();
        ts.setClientOId(Long.valueOf(ADTO.getNextId()));
        if (CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()))) {
            ts.setTimerServiceConfig((TimerServiceConfigComplete)new DailyTimeComplete(Integer.valueOf(0), Integer.valueOf(30)));
        } else {
            ts.setTimerServiceConfig((TimerServiceConfigComplete)new DailyTimeComplete(Integer.valueOf(22), Integer.valueOf(5)));
        }
        ts.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return ts;
    }

    private TimerServiceSettingsComplete createTimerServiceHourly() {
        TimerServiceSettingsComplete ts = new TimerServiceSettingsComplete();
        ts.setClientOId(Long.valueOf(ADTO.getNextId()));
        ts.setTimerServiceConfig((TimerServiceConfigComplete)new TimeDurationComplete(TimeUnitE.MINUTE, Double.valueOf(20.0)));
        ts.setIntervallRateUnit(TimeUnitE.MINUTE);
        ts.setIntervallRateValue(Double.valueOf(20.0));
        return ts;
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                NoProExchangeInsert.this.settings.commit(ESpecsSettingsComplete.class);
                NoProExchangeSettingsComplete sett = (NoProExchangeSettingsComplete)NoProExchangeInsert.this.settings.getValue();
                sett.getDataExchangeSettings().setDataExchangeProtocol(DataTransferProtocolE.SFTP);
                sett.setTimerServiceSettingsDaily(NoProExchangeInsert.this.createTimerServiceDaily());
                sett.setTimerServiceSettingsHourly(NoProExchangeInsert.this.createTimerServiceHourly());
                if (Boolean.TRUE.equals(sett.getAutoExchangeData())) {
                    sett = (NoProExchangeSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)sett).getValue();
                    TimerServiceSettingsComplete daily = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(sett.getTimerServiceSettingsDaily()).getValue();
                    sett.setTimerServiceSettingsDaily(daily);
                    TimerServiceSettingsComplete hourly = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(sett.getTimerServiceSettingsHourly()).getValue();
                    sett.setTimerServiceSettingsHourly(hourly);
                    TimerServiceSettingsComplete update = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(sett.getTimerServiceSettingsUpdate()).getValue();
                    sett.setTimerServiceSettingsUpdate(update);
                    sett = (NoProExchangeSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)sett).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.NO_PRO_EXCHANGE_DAILY, sett.getAutoExchangeData().booleanValue(), daily, -1L);
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.NO_PRO_EXCHANGE_HOURLY, sett.getAutoExchangeData().booleanValue(), hourly, -1L);
                    if (CompanyUtil.isNoPro((SystemSettingsComplete)NoProExchangeInsert.this.systemSettings)) {
                        sett.setTimerServiceSettingsUpdate(NoProExchangeInsert.this.createTimerServiceUpdate());
                        ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.NO_PRO_UPDATE, sett.getAutoExchangeData().booleanValue(), update, -1L);
                    }
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.NO_PRO_EXCHANGE_HOURLY);
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.NO_PRO_EXCHANGE_DAILY);
                    if (CompanyUtil.isNoPro((SystemSettingsComplete)NoProExchangeInsert.this.systemSettings)) {
                        ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.NO_PRO_UPDATE);
                    }
                    sett = (NoProExchangeSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)sett).getValue();
                }
                NoProExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)sett, false, false);
                NoProExchangeInsert.this.lastUpdates.setNode(NoProExchangeInsert.this.settings);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        NoProExchangeInsert.this.hideAnimation();
                        NoProExchangeInsert.this.module.ended();
                        NoProExchangeInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)NoProExchangeInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processInitialStock(final boolean read) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                if (read) {
                    ((NoProExchangeServiceManager)ServiceManagerRegistry.getService(NoProExchangeServiceManager.class)).importInitialStock();
                } else {
                    ((NoProExchangeServiceManager)ServiceManagerRegistry.getService(NoProExchangeServiceManager.class)).exportInitialStock();
                }
                ViewNode n = new ViewNode("");
                n.setValue((Object)true, 0L);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        boolean read = (Boolean)node.getValue();
                        NoProExchangeInsert.this.hideAnimation();
                        NoProExchangeInsert.this.module.ended();
                        NoProExchangeInsert.this.setEnabled(true);
                        if (read) {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_IMPORTED, NoProExchangeInsert.this.receiveButton);
                        } else {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_EXPORTED, NoProExchangeInsert.this.sendButton);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, Words.UNABLE_TO_CREATE_ESPECS_EXPORT, (Component)NoProExchangeInsert.this.sendButton);
                        NoProExchangeInsert.this.hideAnimation();
                        NoProExchangeInsert.this.setEnabled(true);
                        NoProExchangeInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processFiles(final boolean read) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                if (read) {
                    if (((CheckBox)NoProExchangeInsert.this.readMasterData.getElement()).isChecked()) {
                        ((NoProExchangeServiceManager)ServiceManagerRegistry.getService(NoProExchangeServiceManager.class)).readMasterData();
                    }
                    if (((CheckBox)NoProExchangeInsert.this.readFlights.getElement()).isChecked()) {
                        ((NoProExchangeServiceManager)ServiceManagerRegistry.getService(NoProExchangeServiceManager.class)).readFlights();
                    }
                    if (((CheckBox)NoProExchangeInsert.this.readMaterialManagement.getElement()).isChecked()) {
                        ((NoProExchangeServiceManager)ServiceManagerRegistry.getService(NoProExchangeServiceManager.class)).readMaterialManagement();
                    }
                } else {
                    if (((CheckBox)NoProExchangeInsert.this.writeMasterData.getElement()).isChecked()) {
                        ((NoProExchangeServiceManager)ServiceManagerRegistry.getService(NoProExchangeServiceManager.class)).writeMasterData();
                    }
                    if (((CheckBox)NoProExchangeInsert.this.writeFlights.getElement()).isChecked()) {
                        ((NoProExchangeServiceManager)ServiceManagerRegistry.getService(NoProExchangeServiceManager.class)).writeFlights();
                    }
                    if (((CheckBox)NoProExchangeInsert.this.writeMaterialManagement.getElement()).isChecked()) {
                        ((NoProExchangeServiceManager)ServiceManagerRegistry.getService(NoProExchangeServiceManager.class)).writeMaterialManagement();
                    }
                }
                ViewNode n = new ViewNode("");
                n.setValue((Object)true, 0L);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        boolean read = (Boolean)node.getValue();
                        NoProExchangeInsert.this.hideAnimation();
                        NoProExchangeInsert.this.module.ended();
                        NoProExchangeInsert.this.setEnabled(true);
                        if (read) {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_IMPORTED, NoProExchangeInsert.this.receiveButton);
                        } else {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_EXPORTED, NoProExchangeInsert.this.sendButton);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, Words.UNABLE_TO_CREATE_ESPECS_EXPORT, (Component)NoProExchangeInsert.this.sendButton);
                        NoProExchangeInsert.this.hideAnimation();
                        NoProExchangeInsert.this.setEnabled(true);
                        NoProExchangeInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            NoProExchangeInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            NoProExchangeInsert.this.useNoProSync.setLocation(border, border + NoProExchangeInsert.this.configPanel.getTitleHeight());
            NoProExchangeInsert.this.useNoProSync.setSize(NoProExchangeInsert.this.useNoProSync.getPreferredSize());
            NoProExchangeInsert.this.autoExchangeActive.setLocation(border, NoProExchangeInsert.this.useNoProSync.getY() + NoProExchangeInsert.this.useNoProSync.getHeight());
            NoProExchangeInsert.this.autoExchangeActive.setSize(NoProExchangeInsert.this.autoExchangeActive.getPreferredSize());
            NoProExchangeInsert.this.ftpConfigurations.setLocation(border, NoProExchangeInsert.this.autoExchangeActive.getY() + NoProExchangeInsert.this.autoExchangeActive.getHeight() + border);
            NoProExchangeInsert.this.ftpConfigurations.setSize(parent.getWidth() - 2 * border, (int)NoProExchangeInsert.this.ftpConfigurations.getPreferredSize().getHeight());
            NoProExchangeInsert.this.lastUpdates.setLocation(border, NoProExchangeInsert.this.ftpConfigurations.getY() + NoProExchangeInsert.this.ftpConfigurations.getHeight());
            NoProExchangeInsert.this.lastUpdates.setSize(parent.getWidth() - 2 * border, (int)NoProExchangeInsert.this.lastUpdates.getPreferredSize().getHeight());
            NoProExchangeInsert.this.resetLastReceiveDate.setLocation(border, NoProExchangeInsert.this.lastUpdates.getY() + NoProExchangeInsert.this.lastUpdates.getHeight() + 5);
            NoProExchangeInsert.this.resetLastReceiveDate.setSize(NoProExchangeInsert.this.resetLastReceiveDate.getPreferredSize());
            NoProExchangeInsert.this.sep1.setLocation(1, NoProExchangeInsert.this.resetLastReceiveDate.getY() + NoProExchangeInsert.this.resetLastReceiveDate.getHeight() + 1);
            NoProExchangeInsert.this.sep1.setSize(parent.getWidth() - 2, (int)NoProExchangeInsert.this.sep1.getPreferredSize().getHeight());
            NoProExchangeInsert.this.readMasterData.setLocation(border, NoProExchangeInsert.this.sep1.getY() + NoProExchangeInsert.this.sep1.getHeight() + border);
            NoProExchangeInsert.this.readMasterData.setSize(NoProExchangeInsert.this.readMasterData.getPreferredSize());
            NoProExchangeInsert.this.readFlights.setLocation(NoProExchangeInsert.this.readMasterData.getX(), NoProExchangeInsert.this.readMasterData.getY() + NoProExchangeInsert.this.readMasterData.getHeight() + border / 2);
            NoProExchangeInsert.this.readFlights.setSize(NoProExchangeInsert.this.readFlights.getPreferredSize());
            NoProExchangeInsert.this.readMaterialManagement.setLocation(NoProExchangeInsert.this.readMasterData.getX(), NoProExchangeInsert.this.readFlights.getY() + NoProExchangeInsert.this.readFlights.getHeight() + border / 2);
            NoProExchangeInsert.this.readMaterialManagement.setSize(NoProExchangeInsert.this.readMaterialManagement.getPreferredSize());
            NoProExchangeInsert.this.writeMasterData.setLocation(NoProExchangeInsert.this.readMasterData.getX(), NoProExchangeInsert.this.readMaterialManagement.getY() + NoProExchangeInsert.this.readMaterialManagement.getHeight() + border / 2);
            NoProExchangeInsert.this.writeMasterData.setSize(NoProExchangeInsert.this.writeMasterData.getPreferredSize());
            NoProExchangeInsert.this.writeFlights.setLocation(NoProExchangeInsert.this.readMasterData.getX(), NoProExchangeInsert.this.writeMasterData.getY() + NoProExchangeInsert.this.writeMasterData.getHeight() + border / 2);
            NoProExchangeInsert.this.writeFlights.setSize(NoProExchangeInsert.this.writeFlights.getPreferredSize());
            NoProExchangeInsert.this.writeMaterialManagement.setLocation(NoProExchangeInsert.this.readMasterData.getX(), NoProExchangeInsert.this.writeFlights.getY() + NoProExchangeInsert.this.writeFlights.getHeight() + border / 2);
            NoProExchangeInsert.this.writeMaterialManagement.setSize(NoProExchangeInsert.this.writeMaterialManagement.getPreferredSize());
            NoProExchangeInsert.this.noProAsSupplier.setLocation(border, NoProExchangeInsert.this.writeMaterialManagement.getY() + NoProExchangeInsert.this.writeMaterialManagement.getHeight() + border);
            NoProExchangeInsert.this.noProAsSupplier.setSize(200, (int)NoProExchangeInsert.this.noProAsSupplier.getPreferredSize().getHeight());
            NoProExchangeInsert.this.noProAsCustomer.setLocation(border, NoProExchangeInsert.this.noProAsSupplier.getY() + NoProExchangeInsert.this.noProAsSupplier.getHeight() + border);
            NoProExchangeInsert.this.noProAsCustomer.setSize(200, (int)NoProExchangeInsert.this.noProAsCustomer.getPreferredSize().getHeight());
            NoProExchangeInsert.this.noProStowing.setLocation(border, NoProExchangeInsert.this.noProAsCustomer.getY() + NoProExchangeInsert.this.noProAsCustomer.getHeight() + border);
            NoProExchangeInsert.this.noProStowing.setSize(200, (int)NoProExchangeInsert.this.noProStowing.getPreferredSize().getHeight());
            NoProExchangeInsert.this.noProAsDepartment.setLocation(border, NoProExchangeInsert.this.noProStowing.getY() + NoProExchangeInsert.this.noProStowing.getHeight() + border);
            NoProExchangeInsert.this.noProAsDepartment.setSize(200, (int)NoProExchangeInsert.this.noProAsDepartment.getPreferredSize().getHeight());
            NoProExchangeInsert.this.noProStore.setLocation(border, NoProExchangeInsert.this.noProAsDepartment.getY() + NoProExchangeInsert.this.noProAsDepartment.getHeight() + border);
            NoProExchangeInsert.this.noProStore.setSize(200, (int)NoProExchangeInsert.this.noProStore.getPreferredSize().getHeight());
            NoProExchangeInsert.this.productionStore.setLocation(border, NoProExchangeInsert.this.noProStore.getY() + NoProExchangeInsert.this.noProStore.getHeight() + border);
            NoProExchangeInsert.this.productionStore.setSize(200, (int)NoProExchangeInsert.this.productionStore.getPreferredSize().getHeight());
            NoProExchangeInsert.this.saveButton.setLocation((int)((double)parent.getWidth() - NoProExchangeInsert.this.saveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ((double)border + NoProExchangeInsert.this.saveButton.getPreferredSize().getHeight())));
            NoProExchangeInsert.this.saveButton.setSize(NoProExchangeInsert.this.saveButton.getPreferredSize());
            NoProExchangeInsert.this.usersToInform.setLocation(border, NoProExchangeInsert.this.productionStore.getY() + NoProExchangeInsert.this.productionStore.getHeight() + border);
            NoProExchangeInsert.this.usersToInform.setSize(parent.getWidth() - 2 * NoProExchangeInsert.this.usersToInform.getX(), parent.getHeight() - NoProExchangeInsert.this.usersToInform.getY());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            NoProExchangeInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            NoProExchangeInsert.this.receiveButton.setLocation((int)((double)parent.getWidth() - NoProExchangeInsert.this.receiveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - (2.0 * NoProExchangeInsert.this.receiveButton.getPreferredSize().getHeight() + (double)(2 * border))));
            NoProExchangeInsert.this.receiveButton.setSize(NoProExchangeInsert.this.receiveButton.getPreferredSize());
            NoProExchangeInsert.this.sendButton.setLocation((int)((double)parent.getWidth() - NoProExchangeInsert.this.sendButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - (NoProExchangeInsert.this.sendButton.getPreferredSize().getHeight() + (double)border)));
            NoProExchangeInsert.this.sendButton.setSize(NoProExchangeInsert.this.sendButton.getPreferredSize());
            NoProExchangeInsert.this.updateDaily.setLocation(NoProExchangeInsert.this.sendButton.getX() + NoProExchangeInsert.this.sendButton.getWidth() + border, NoProExchangeInsert.this.sendButton.getY());
            NoProExchangeInsert.this.updateDaily.setSize(NoProExchangeInsert.this.updateDaily.getPreferredSize());
            NoProExchangeInsert.this.exportInitialStockButton.setLocation(NoProExchangeInsert.this.receiveButton.getX(), (int)((double)NoProExchangeInsert.this.receiveButton.getY() - (NoProExchangeInsert.this.exportInitialStockButton.getPreferredSize().getHeight() + (double)border)));
            NoProExchangeInsert.this.exportInitialStockButton.setSize(NoProExchangeInsert.this.exportInitialStockButton.getPreferredSize());
            NoProExchangeInsert.this.importInitialStockButton.setLocation(NoProExchangeInsert.this.sendButton.getX(), (int)((double)NoProExchangeInsert.this.exportInitialStockButton.getY() - (NoProExchangeInsert.this.importInitialStockButton.getPreferredSize().getHeight() + (double)border)));
            NoProExchangeInsert.this.importInitialStockButton.setSize(NoProExchangeInsert.this.importInitialStockButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (NoProExchangeInsert.this.animation != null) {
                NoProExchangeInsert.this.animation.setLocation((int)((double)parent.getWidth() - NoProExchangeInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - NoProExchangeInsert.this.animation.getPreferredSize().getHeight()) / 2);
                NoProExchangeInsert.this.animation.setSize(NoProExchangeInsert.this.animation.getPreferredSize());
            }
            if (NoProExchangeInsert.this.isInserted) {
                NoProExchangeInsert.this.configPanel.setLocation(border, border);
                NoProExchangeInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                NoProExchangeInsert.this.sendPanel.setLocation(NoProExchangeInsert.this.configPanel.getX() + NoProExchangeInsert.this.configPanel.getWidth() + border, border);
                NoProExchangeInsert.this.sendPanel.setSize(NoProExchangeInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

