/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.converter.PickNPayLastUpdateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.panels.SFTPDataExchangeSettingsPanel;
import ch.icit.pegasus.client.gui.utils.panels.TabbedItem;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.tabbed.TabButton;
import ch.icit.pegasus.client.gui.utils.tables.PickNPayTransferSheetListTable;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.PickNPayServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.DataTransferProtocolE;
import ch.icit.pegasus.server.core.dtos.dataexchange.MailTypeE;
import ch.icit.pegasus.server.core.dtos.dataexchange.PickNPaySettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.PickNPaySettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.SFTPDataExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.SFTPDataExchangeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.picknpay.PickNPayTransferComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.EncryptedStringComplete;
import ch.icit.pegasus.server.core.dtos.util.TimeDurationComplete;
import ch.icit.pegasus.server.core.dtos.util.TimeUnitE;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PickNPayExchangeInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TitledItem<CheckBox> usePickNPayInterface;
    private TitledItem<CheckBox> autoSendReceiveData;
    private TitledItem<CheckBox> useArticleImport;
    private TitledItem<CheckBox> useOrdersImport;
    private TitledItem<CheckBox> useInvoiceExport;
    private TitledItem<CheckBox> useInvoiceExceptionImport;
    private TitledItem<TextField> defaultRetailName;
    private TitledItem<CheckBox> useMinimalOrderAmount;
    private TitledItem<TextField> minimalOrderAmount;
    private TitledItem<TextField> companyGLN;
    private TitledItem<TextField> orderDirectory;
    private TitledItem<TextField> invoiceDirectory;
    private TitledItem<TextField> exceptionsDirectory;
    private TitledItem<TextField> directoryNumber;
    private TabbedItem<SFTPDataExchangeSettingsPanel> ftpConfigurations;
    private TitledItem<NumberTextField> receiveRate;
    private ComboBox receiveRateUnit;
    private Node<List<PickNPayTransferComplete>> pickNPayData;
    private TextLabel lastUpdates;
    private PickNPayTransferSheetListTable history;
    private TablePanelAddSaveButton createArticleCostUpload;
    private TablePanelAddSaveButton receiveArticleImport;
    private TablePanelAddSaveButton receiveOrdersImport;
    private TablePanelAddSaveButton sendInvoiceUpload;
    private TablePanelAddSaveButton receiveInvoiceExceptionImport;
    private TablePanelAddSaveButton saveButton;
    private TextButton resetLastReceiveDate;
    private final DataExchangeModule module;
    protected Node<PickNPaySettingsComplete> settings;
    protected PickNPaySettingsComplete edsc;

    public PickNPayExchangeInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.usePickNPayInterface = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(PickNPaySettingsComplete_.usePickNPayInterface)), Words.USE_PICK_N_PAY_INTERFACE, TitledItem.TitledItemOrientation.EAST);
        this.autoSendReceiveData = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(PickNPaySettingsComplete_.autoReceiveData)), Words.AUTO_RECEIVE, TitledItem.TitledItemOrientation.EAST);
        this.useArticleImport = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(PickNPaySettingsComplete_.useArticleImport)), Words.USE_ARTICLE_IMPORT, TitledItem.TitledItemOrientation.EAST);
        this.useOrdersImport = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(PickNPaySettingsComplete_.useOrdersImport)), Words.USE_ORDERS_IMPORT, TitledItem.TitledItemOrientation.EAST);
        this.useInvoiceExport = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(PickNPaySettingsComplete_.useInvoiceExport)), Words.USE_INVOICE_EXPORT, TitledItem.TitledItemOrientation.EAST);
        this.useInvoiceExceptionImport = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(PickNPaySettingsComplete_.useInvoiceExceptionImport)), Words.USE_INVOICE_EXCEPTION_IMPORT, TitledItem.TitledItemOrientation.EAST);
        this.defaultRetailName = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(PickNPaySettingsComplete_.defaultRetailName), TextFieldType.NORMAL), Words.DEFAULT_RETAIL_NAME, TitledItem.TitledItemOrientation.NORTH);
        this.companyGLN = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(PickNPaySettingsComplete_.companyGlobalLocationNumber), TextFieldType.NORMAL), Words.COMPANY_GLN, TitledItem.TitledItemOrientation.NORTH);
        this.orderDirectory = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(PickNPaySettingsComplete_.orderDirectory), TextFieldType.NORMAL), Words.ORDER_DIRECTORY, TitledItem.TitledItemOrientation.NORTH);
        this.invoiceDirectory = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(PickNPaySettingsComplete_.invoiceDirectory), TextFieldType.NORMAL), Words.INVOICE_DIRECTORY, TitledItem.TitledItemOrientation.NORTH);
        this.exceptionsDirectory = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(PickNPaySettingsComplete_.exceptionDirectory), TextFieldType.NORMAL), Words.EXCEPTION_DIRECTORY, TitledItem.TitledItemOrientation.NORTH);
        this.directoryNumber = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(PickNPaySettingsComplete_.directoryNumber), TextFieldType.NORMAL), Words.DIRECTORY_NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.useMinimalOrderAmount = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(PickNPaySettingsComplete_.useMinimalOrderAmountPerStore)), Words.USE_MINIMAL_ORDER_AMOUNT, TitledItem.TitledItemOrientation.EAST);
        this.minimalOrderAmount = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(PickNPaySettingsComplete_.minimalOrderAmountPerStore), TextFieldType.DOUBLE), Words.MINIMAL_ORDER_AMOUNT, TitledItem.TitledItemOrientation.NORTH);
        this.ftpConfigurations = new TabbedItem<SFTPDataExchangeSettingsPanel>(){
            private static final long serialVersionUID = 1L;

            @Override
            public void updateFocusCycle() {
            }
        };
        int count = 1;
        Iterator it = this.settings.getChildNamed(PickNPaySettingsComplete_.receiveDataExchangeSettingsList).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node setting = (Node)it.next();
            SFTPDataExchangeSettingsPanel panel = new SFTPDataExchangeSettingsPanel();
            panel.setNode(setting);
            this.ftpConfigurations.addView(panel, new TabButton("Config " + count++));
        }
        this.receiveRate = new TitledItem<NumberTextField>(new NumberTextField(this.settings.getChildNamed(new DtoField[]{PickNPaySettingsComplete_.timerServiceSettings, TimerServiceSettingsComplete_.intervallRateValue}), TextFieldType.DOUBLE), Words.RECEIVE_RATE, TitledItem.TitledItemOrientation.NORTH);
        this.receiveRateUnit = ComboBoxFactory.getTimeDurationComboBoxWithoutSeconds((Node<TimeUnitE>)this.settings.getChildNamed(new DtoField[]{PickNPaySettingsComplete_.timerServiceSettings, TimerServiceSettingsComplete_.intervallRateUnit}), false);
        if (this.settings.getChildNamed(new DtoField[]{PickNPaySettingsComplete_.timerServiceSettings, TimerServiceSettingsComplete_.intervallRateUnit}) != null) {
            this.receiveRateUnit.setSelectedItem(this.settings.getChildNamed(new DtoField[]{PickNPaySettingsComplete_.timerServiceSettings, TimerServiceSettingsComplete_.intervallRateUnit}).getValue());
        }
        this.lastUpdates = new TextLabel(this.settings, ConverterRegistry.getConverter(PickNPayLastUpdateConverter.class));
        this.history = new PickNPayTransferSheetListTable();
        this.history.setNode(this.pickNPayData);
        this.resetLastReceiveDate = new TextButton("Reset last receive Date");
        this.resetLastReceiveDate.setProgress(1.0f);
        this.resetLastReceiveDate.addButtonListener(this);
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.createArticleCostUpload = new TablePanelAddSaveButton();
        this.createArticleCostUpload.setText(Words.CREATE_PRICE_UPLOAD);
        this.createArticleCostUpload.addButtonListener(this);
        this.receiveArticleImport = new TablePanelAddSaveButton();
        this.receiveArticleImport.setText(Words.RECEIVE_ARTICLE_DATA);
        this.receiveArticleImport.addButtonListener(this);
        this.receiveOrdersImport = new TablePanelAddSaveButton();
        this.receiveOrdersImport.setText(Words.RECEIVE_ORDER_DATA);
        this.receiveOrdersImport.addButtonListener(this);
        this.sendInvoiceUpload = new TablePanelAddSaveButton();
        this.sendInvoiceUpload.setText(Words.SEND_INVOICE_DATA);
        this.sendInvoiceUpload.addButtonListener(this);
        this.receiveInvoiceExceptionImport = new TablePanelAddSaveButton();
        this.receiveInvoiceExceptionImport.setText(Words.RECEIVE_INVOICE_EXCEPTION_DATA);
        this.receiveInvoiceExceptionImport.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.usePickNPayInterface.getElement().addButtonListener(this);
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.usePickNPayInterface);
        this.configPanel.add(this.autoSendReceiveData);
        this.configPanel.add(this.useArticleImport);
        this.configPanel.add(this.useOrdersImport);
        this.configPanel.add(this.useInvoiceExport);
        this.configPanel.add(this.useInvoiceExceptionImport);
        this.configPanel.add(this.defaultRetailName);
        this.configPanel.add(this.companyGLN);
        this.configPanel.add(this.orderDirectory);
        this.configPanel.add(this.invoiceDirectory);
        this.configPanel.add(this.exceptionsDirectory);
        this.configPanel.add(this.directoryNumber);
        this.configPanel.add(this.ftpConfigurations);
        this.configPanel.add(this.receiveRate);
        this.configPanel.add(this.receiveRateUnit);
        this.configPanel.add(this.lastUpdates);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.resetLastReceiveDate);
        this.sendPanel.add(this.history);
        this.sendPanel.add(this.createArticleCostUpload);
        this.sendPanel.add(this.receiveArticleImport);
        this.sendPanel.add(this.receiveOrdersImport);
        this.sendPanel.add(this.sendInvoiceUpload);
        this.sendPanel.add(this.receiveInvoiceExceptionImport);
        this.configPanel.add(this.minimalOrderAmount);
        this.configPanel.add(this.useMinimalOrderAmount);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Object s;
                StaticEnumServiceManager.getAllTimeDurations();
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CabinClassComplete.class, false);
                try {
                    PickNPayExchangeInsert.this.edsc = (PickNPaySettingsComplete)((PickNPayServiceManager)ServiceManagerRegistry.getService(PickNPayServiceManager.class)).getSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (PickNPayExchangeInsert.this.edsc == null) {
                    s = new PickNPaySettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    PickNPayExchangeInsert.this.edsc = s;
                }
                if (PickNPayExchangeInsert.this.edsc.getReceiveDataExchangeSettingsList().isEmpty()) {
                    s = new SFTPDataExchangeSettingsComplete();
                    s.setClientOId(Long.valueOf(SFTPDataExchangeSettingsComplete.getNextId()));
                    s.setLastDataTransaction(new Timestamp(0L));
                    s.setMaxRetry(Integer.valueOf(0));
                    s.setTimeWait(Long.valueOf(60000L));
                    PickNPayExchangeInsert.this.edsc.getReceiveDataExchangeSettingsList().add(s);
                    s = new SFTPDataExchangeSettingsComplete();
                    s.setClientOId(Long.valueOf(SFTPDataExchangeSettingsComplete.getNextId()));
                    s.setLastDataTransaction(new Timestamp(0L));
                    s.setMaxRetry(Integer.valueOf(0));
                    s.setTimeWait(Long.valueOf(60000L));
                    PickNPayExchangeInsert.this.edsc.getReceiveDataExchangeSettingsList().add(s);
                }
                for (SFTPDataExchangeSettingsComplete ftpList : PickNPayExchangeInsert.this.edsc.getReceiveDataExchangeSettingsList()) {
                    if (ftpList.getLoginPwd() != null) continue;
                    ftpList.setLoginPwd(new EncryptedStringComplete());
                }
                if (PickNPayExchangeInsert.this.edsc.getTimerServiceSettings() == null) {
                    s = new TimerServiceSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    s.setTimerServiceConfig((TimerServiceConfigComplete)new TimeDurationComplete(TimeUnitE.MINUTE, Double.valueOf(20.0)));
                    s.setIntervallRateUnit(TimeUnitE.MINUTE);
                    s.setIntervallRateValue(Double.valueOf(20.0));
                    PickNPayExchangeInsert.this.edsc.setTimerServiceSettings((TimerServiceSettingsComplete)s);
                }
                PickNPayExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)PickNPayExchangeInsert.this.edsc, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                PickNPayExchangeInsert.this.pickNPayData = (Node)new ViewNode("data");
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PickNPayExchangeInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.usePickNPayInterface.setEnabled(isEnabled);
            boolean b = isEnabled && this.usePickNPayInterface.getElement().isChecked();
            this.autoSendReceiveData.setEnabled(b);
            this.useArticleImport.setEnabled(b);
            this.useInvoiceExceptionImport.setEnabled(b);
            this.useInvoiceExport.setEnabled(b);
            this.useOrdersImport.setEnabled(b);
            this.minimalOrderAmount.setEnabled(b);
            this.useMinimalOrderAmount.setEnabled(b);
            this.createArticleCostUpload.setEnabled(b);
            this.receiveArticleImport.setEnabled(b);
            this.receiveOrdersImport.setEnabled(b);
            this.sendInvoiceUpload.setEnabled(b);
            this.receiveInvoiceExceptionImport.setEnabled(b);
            this.defaultRetailName.setEnabled(b);
            this.companyGLN.setEnabled(b);
            this.orderDirectory.setEnabled(b);
            this.invoiceDirectory.setEnabled(b);
            this.exceptionsDirectory.setEnabled(b);
            this.directoryNumber.setEnabled(b);
            this.ftpConfigurations.setEnabled(b);
            this.receiveRate.setEnabled(b);
            this.receiveRateUnit.setEnabled(b);
            this.lastUpdates.setEnabled(b);
            this.history.setEnabled(isEnabled);
            this.saveButton.setEnabled(isEnabled);
            this.resetLastReceiveDate.setEnabled(b);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.ftpConfigurations.kill();
            this.usePickNPayInterface.kill();
            this.autoSendReceiveData.kill();
            this.useArticleImport.kill();
            this.useInvoiceExceptionImport.kill();
            this.useInvoiceExport.kill();
            this.useOrdersImport.kill();
            this.defaultRetailName.kill();
            this.minimalOrderAmount.kill();
            this.useMinimalOrderAmount.kill();
            this.companyGLN.kill();
            this.orderDirectory.kill();
            this.invoiceDirectory.kill();
            this.exceptionsDirectory.kill();
            this.directoryNumber.kill();
            this.createArticleCostUpload.kill();
            this.receiveArticleImport.kill();
            this.receiveOrdersImport.kill();
            this.sendInvoiceUpload.kill();
            this.receiveInvoiceExceptionImport.kill();
            this.history.kill();
            this.receiveRate.kill();
            this.receiveRateUnit.kill();
            this.lastUpdates.kill();
            this.saveButton.kill();
            this.resetLastReceiveDate.kill();
            this.resetLastReceiveDate = null;
            this.usePickNPayInterface = null;
            this.autoSendReceiveData = null;
            this.useArticleImport = null;
            this.useInvoiceExceptionImport = null;
            this.useInvoiceExport = null;
            this.useOrdersImport = null;
            this.createArticleCostUpload = null;
            this.receiveArticleImport = null;
            this.receiveOrdersImport = null;
            this.sendInvoiceUpload = null;
            this.defaultRetailName = null;
            this.minimalOrderAmount = null;
            this.useMinimalOrderAmount = null;
            this.companyGLN = null;
            this.orderDirectory = null;
            this.invoiceDirectory = null;
            this.exceptionsDirectory = null;
            this.directoryNumber = null;
            this.receiveInvoiceExceptionImport = null;
        }
        this.sendPanel = null;
        this.configPanel = null;
        this.ftpConfigurations = null;
        this.history = null;
        this.receiveRate = null;
        this.receiveRateUnit = null;
        this.lastUpdates = null;
        this.saveButton = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return Words.PICK_N_PAY;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.createArticleCostUpload) {
            this.setEnabled(false);
            this.ensureAnimation(Words.EXCHANGE_DATA_WITH_PICK_N_PAY);
            this.processUpload();
            this.module.started();
            return;
        }
        if (source == this.saveButton) {
            List<ScreenValidationObject> a = this.validateConfig();
            if (a.isEmpty()) {
                this.ensureAnimation(Words.SAVE_DATA);
                this.saveConfig();
                return;
            }
            InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
            this.setEnabled(true);
            return;
        }
        if (source != this.resetLastReceiveDate) {
            this.setEnabled(this.isEnabled());
            return;
        }
        Iterator it = this.settings.getChildNamed(PickNPaySettingsComplete_.receiveDataExchangeSettingsList).getFailSafeChildIterator();
        while (true) {
            if (!it.hasNext()) {
                this.settings.commit();
                this.lastUpdates.setNode((Node)this.settings);
                return;
            }
            Node n = (Node)it.next();
            n.getChildNamed(SFTPDataExchangeSettingsComplete_.lastDataTransaction).setValue((Object)new Timestamp(0L), 0L);
        }
    }

    private List<ScreenValidationObject> validateConfig() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Node settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class);
        settings.commitThis(SystemSettingsComplete.class);
        return a;
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                PickNPayExchangeInsert.this.settings.commit(PickNPaySettingsComplete.class);
                PickNPaySettingsComplete pnpsc = (PickNPaySettingsComplete)PickNPayExchangeInsert.this.settings.getValue();
                for (SFTPDataExchangeSettingsComplete sftpDataExchangeSettingsComplete : pnpsc.getReceiveDataExchangeSettingsList()) {
                    sftpDataExchangeSettingsComplete.setDataExchangeProtocol(DataTransferProtocolE.SFTP);
                    sftpDataExchangeSettingsComplete.setMaxRetry(Integer.valueOf(0));
                    sftpDataExchangeSettingsComplete.setTimeWait(Long.valueOf(60000L));
                }
                if ((pnpsc = PickNPayExchangeInsert.this.setDefaultValues(pnpsc)) != null && Boolean.TRUE.equals(pnpsc.getUsePickNPayInterface())) {
                    TimeUnitE unit = (TimeUnitE)PickNPayExchangeInsert.this.receiveRateUnit.getSelectedItem();
                    Double rate = (Double)((NumberTextField)PickNPayExchangeInsert.this.receiveRate.getElement()).getNode().getValue();
                    TimeDurationComplete tdc = null;
                    if (pnpsc.getTimerServiceSettings() == null) {
                        TimerServiceSettingsComplete tss = new TimerServiceSettingsComplete();
                        pnpsc.setTimerServiceSettings(tss);
                    }
                    tdc = new TimeDurationComplete(unit, rate);
                    pnpsc.getTimerServiceSettings().setTimerServiceConfig((TimerServiceConfigComplete)tdc);
                    pnpsc.getTimerServiceSettings().setIntervallRateUnit(unit);
                    pnpsc.getTimerServiceSettings().setIntervallRateValue(rate);
                    PickNPaySettingsComplete pickNPaySettingsComplete = pnpsc = (PickNPaySettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)pnpsc).getValue();
                    pickNPaySettingsComplete.setMailType(MailTypeE.SendMail);
                    pickNPaySettingsComplete.getTimerServiceSettings().setTimerServiceConfig((TimerServiceConfigComplete)tdc);
                    TimerServiceSettingsComplete ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(pickNPaySettingsComplete.getTimerServiceSettings()).getValue();
                    pickNPaySettingsComplete.setTimerServiceSettings(ts);
                    pickNPaySettingsComplete = (PickNPaySettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)pickNPaySettingsComplete).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.PICK_N_PAY_INTERFACE, pickNPaySettingsComplete.getAutoReceiveData().booleanValue(), ts, -1L);
                    PickNPayExchangeInsert.this.pickNPayData = (Node)new ViewNode("data");
                    Node settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)pnpsc, false, false);
                    PickNPayExchangeInsert.this.lastUpdates.setNode(settings);
                    PickNPayExchangeInsert.this.history.setNode(PickNPayExchangeInsert.this.pickNPayData);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.PICK_N_PAY_INTERFACE);
                    pnpsc = (PickNPaySettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)pnpsc).getValue();
                    PickNPayExchangeInsert.this.pickNPayData = (Node)new ViewNode("data");
                    Node settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)pnpsc, false, false);
                    PickNPayExchangeInsert.this.lastUpdates.setNode(settings);
                    PickNPayExchangeInsert.this.history.setNode(PickNPayExchangeInsert.this.pickNPayData);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        PickNPayExchangeInsert.this.hideAnimation();
                        PickNPayExchangeInsert.this.module.ended();
                        PickNPayExchangeInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)PickNPayExchangeInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processUpload() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n = new Node();
                ((PickNPayServiceManager)ServiceManagerRegistry.getService(PickNPayServiceManager.class)).checkForArticleMasterDataUpdate();
                n.setValue((Object)true, 0L);
                PickNPayExchangeInsert.this.edsc = (PickNPaySettingsComplete)((PickNPayServiceManager)ServiceManagerRegistry.getService(PickNPayServiceManager.class)).getSettings().getValue();
                PickNPayExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)PickNPayExchangeInsert.this.edsc, false, false);
                PickNPayExchangeInsert.this.lastUpdates.setNode((Node)PickNPayExchangeInsert.this.settings);
                PickNPayExchangeInsert.this.history.setNode(PickNPayExchangeInsert.this.pickNPayData);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        boolean read = (Boolean)node.getValue();
                        PickNPayExchangeInsert.this.hideAnimation();
                        PickNPayExchangeInsert.this.module.ended();
                        PickNPayExchangeInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        PickNPayExchangeInsert.this.hideAnimation();
                        PickNPayExchangeInsert.this.setEnabled(true);
                        PickNPayExchangeInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private PickNPaySettingsComplete setDefaultValues(PickNPaySettingsComplete pnpsc) {
        if (pnpsc.getDirectoryNumber() == null) {
            pnpsc.setDirectoryNumber(new PickNPaySettingsComplete().getDirectoryNumber());
        }
        if (pnpsc.getOrderDirectory() == null) {
            pnpsc.setOrderDirectory(new PickNPaySettingsComplete().getOrderDirectory());
        }
        if (pnpsc.getInvoiceDirectory() == null) {
            pnpsc.setInvoiceDirectory(new PickNPaySettingsComplete().getInvoiceDirectory());
        }
        if (pnpsc.getExceptionDirectory() == null) {
            pnpsc.setExceptionDirectory(new PickNPaySettingsComplete().getExceptionDirectory());
        }
        return pnpsc;
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            PickNPayExchangeInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            PickNPayExchangeInsert.this.usePickNPayInterface.setLocation(border, border + PickNPayExchangeInsert.this.configPanel.getTitleHeight());
            PickNPayExchangeInsert.this.usePickNPayInterface.setSize(PickNPayExchangeInsert.this.usePickNPayInterface.getPreferredSize());
            PickNPayExchangeInsert.this.autoSendReceiveData.setLocation(border, PickNPayExchangeInsert.this.usePickNPayInterface.getY() + PickNPayExchangeInsert.this.usePickNPayInterface.getHeight());
            PickNPayExchangeInsert.this.autoSendReceiveData.setSize(PickNPayExchangeInsert.this.autoSendReceiveData.getPreferredSize());
            PickNPayExchangeInsert.this.ftpConfigurations.setLocation(border, PickNPayExchangeInsert.this.autoSendReceiveData.getY() + PickNPayExchangeInsert.this.autoSendReceiveData.getHeight() + border);
            PickNPayExchangeInsert.this.ftpConfigurations.setSize(parent.getWidth() - 2 * border, (int)PickNPayExchangeInsert.this.ftpConfigurations.getPreferredSize().getHeight());
            PickNPayExchangeInsert.this.useArticleImport.setLocation(border, PickNPayExchangeInsert.this.ftpConfigurations.getY() + PickNPayExchangeInsert.this.ftpConfigurations.getHeight() + border);
            PickNPayExchangeInsert.this.useArticleImport.setSize(PickNPayExchangeInsert.this.useArticleImport.getPreferredSize());
            PickNPayExchangeInsert.this.useOrdersImport.setLocation(border, PickNPayExchangeInsert.this.useArticleImport.getY() + PickNPayExchangeInsert.this.useArticleImport.getHeight());
            PickNPayExchangeInsert.this.useOrdersImport.setSize(PickNPayExchangeInsert.this.useOrdersImport.getPreferredSize());
            PickNPayExchangeInsert.this.useInvoiceExport.setLocation(border, PickNPayExchangeInsert.this.useOrdersImport.getY() + PickNPayExchangeInsert.this.useOrdersImport.getHeight());
            PickNPayExchangeInsert.this.useInvoiceExport.setSize(PickNPayExchangeInsert.this.useInvoiceExport.getPreferredSize());
            PickNPayExchangeInsert.this.useInvoiceExceptionImport.setLocation(border, PickNPayExchangeInsert.this.useInvoiceExport.getY() + PickNPayExchangeInsert.this.useInvoiceExport.getHeight());
            PickNPayExchangeInsert.this.useInvoiceExceptionImport.setSize(PickNPayExchangeInsert.this.useInvoiceExceptionImport.getPreferredSize());
            PickNPayExchangeInsert.this.defaultRetailName.setLocation(PickNPayExchangeInsert.this.useInvoiceExceptionImport.getX(), PickNPayExchangeInsert.this.useInvoiceExceptionImport.getY() + PickNPayExchangeInsert.this.useInvoiceExceptionImport.getHeight());
            PickNPayExchangeInsert.this.defaultRetailName.setSize(200, (int)PickNPayExchangeInsert.this.defaultRetailName.getPreferredSize().getHeight());
            PickNPayExchangeInsert.this.orderDirectory.setLocation(PickNPayExchangeInsert.this.useInvoiceExceptionImport.getX(), PickNPayExchangeInsert.this.defaultRetailName.getY() + PickNPayExchangeInsert.this.defaultRetailName.getHeight());
            PickNPayExchangeInsert.this.orderDirectory.setSize(200, (int)PickNPayExchangeInsert.this.orderDirectory.getPreferredSize().getHeight());
            PickNPayExchangeInsert.this.invoiceDirectory.setLocation(PickNPayExchangeInsert.this.orderDirectory.getX() + PickNPayExchangeInsert.this.orderDirectory.getWidth() + border, PickNPayExchangeInsert.this.orderDirectory.getY());
            PickNPayExchangeInsert.this.invoiceDirectory.setSize(200, (int)PickNPayExchangeInsert.this.invoiceDirectory.getPreferredSize().getHeight());
            PickNPayExchangeInsert.this.exceptionsDirectory.setLocation(PickNPayExchangeInsert.this.useInvoiceExceptionImport.getX(), PickNPayExchangeInsert.this.invoiceDirectory.getY() + PickNPayExchangeInsert.this.invoiceDirectory.getHeight());
            PickNPayExchangeInsert.this.exceptionsDirectory.setSize(200, (int)PickNPayExchangeInsert.this.exceptionsDirectory.getPreferredSize().getHeight());
            PickNPayExchangeInsert.this.directoryNumber.setLocation(PickNPayExchangeInsert.this.useInvoiceExceptionImport.getX(), PickNPayExchangeInsert.this.exceptionsDirectory.getY() + PickNPayExchangeInsert.this.exceptionsDirectory.getHeight());
            PickNPayExchangeInsert.this.directoryNumber.setSize(200, (int)PickNPayExchangeInsert.this.directoryNumber.getPreferredSize().getHeight());
            PickNPayExchangeInsert.this.companyGLN.setLocation(PickNPayExchangeInsert.this.directoryNumber.getX() + PickNPayExchangeInsert.this.directoryNumber.getWidth() + border, PickNPayExchangeInsert.this.directoryNumber.getY());
            PickNPayExchangeInsert.this.companyGLN.setSize(200, (int)PickNPayExchangeInsert.this.companyGLN.getPreferredSize().getHeight());
            PickNPayExchangeInsert.this.useMinimalOrderAmount.setLocation(PickNPayExchangeInsert.this.directoryNumber.getX(), PickNPayExchangeInsert.this.directoryNumber.getY() + PickNPayExchangeInsert.this.directoryNumber.getHeight() + border);
            PickNPayExchangeInsert.this.useMinimalOrderAmount.setSize(PickNPayExchangeInsert.this.useMinimalOrderAmount.getPreferredSize());
            PickNPayExchangeInsert.this.minimalOrderAmount.setLocation(PickNPayExchangeInsert.this.directoryNumber.getX(), PickNPayExchangeInsert.this.useMinimalOrderAmount.getY() + PickNPayExchangeInsert.this.useMinimalOrderAmount.getHeight());
            PickNPayExchangeInsert.this.minimalOrderAmount.setSize(200, (int)PickNPayExchangeInsert.this.minimalOrderAmount.getPreferredSize().getHeight());
            PickNPayExchangeInsert.this.receiveRate.setLocation(PickNPayExchangeInsert.this.useInvoiceExceptionImport.getX(), PickNPayExchangeInsert.this.minimalOrderAmount.getY() + PickNPayExchangeInsert.this.minimalOrderAmount.getHeight() + border);
            PickNPayExchangeInsert.this.receiveRate.setSize(100, (int)PickNPayExchangeInsert.this.receiveRate.getPreferredSize().getHeight());
            PickNPayExchangeInsert.this.receiveRateUnit.setLocation(PickNPayExchangeInsert.this.receiveRate.getX() + PickNPayExchangeInsert.this.receiveRate.getWidth() + 5, (int)((double)(PickNPayExchangeInsert.this.receiveRate.getY() + PickNPayExchangeInsert.this.receiveRate.getHeight()) - PickNPayExchangeInsert.this.receiveRateUnit.getPreferredSize().getHeight()));
            PickNPayExchangeInsert.this.receiveRateUnit.setSize(75, (int)PickNPayExchangeInsert.this.receiveRateUnit.getPreferredSize().getHeight());
            PickNPayExchangeInsert.this.lastUpdates.setLocation(border, PickNPayExchangeInsert.this.receiveRateUnit.getY() + PickNPayExchangeInsert.this.receiveRateUnit.getHeight());
            PickNPayExchangeInsert.this.lastUpdates.setSize(PickNPayExchangeInsert.this.lastUpdates.getPreferredSize());
            PickNPayExchangeInsert.this.resetLastReceiveDate.setLocation(PickNPayExchangeInsert.this.lastUpdates.getX() + PickNPayExchangeInsert.this.lastUpdates.getWidth() + border, PickNPayExchangeInsert.this.lastUpdates.getY());
            PickNPayExchangeInsert.this.resetLastReceiveDate.setSize(PickNPayExchangeInsert.this.resetLastReceiveDate.getPreferredSize());
            PickNPayExchangeInsert.this.saveButton.setLocation((int)((double)parent.getWidth() - PickNPayExchangeInsert.this.saveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ((double)border + PickNPayExchangeInsert.this.saveButton.getPreferredSize().getHeight())));
            PickNPayExchangeInsert.this.saveButton.setSize(PickNPayExchangeInsert.this.saveButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            PickNPayExchangeInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            PickNPayExchangeInsert.this.history.setLocation(0, PickNPayExchangeInsert.this.sendPanel.getTitleHeight());
            PickNPayExchangeInsert.this.history.setSize(parent.getWidth(), PickNPayExchangeInsert.this.sendPanel.getHeight() - (border + PickNPayExchangeInsert.this.sendPanel.getTitleHeight() + 100));
            PickNPayExchangeInsert.this.createArticleCostUpload.setLocation(border, (int)((double)parent.getHeight() - (PickNPayExchangeInsert.this.createArticleCostUpload.getPreferredSize().getHeight() + (double)border)));
            PickNPayExchangeInsert.this.createArticleCostUpload.setSize(PickNPayExchangeInsert.this.createArticleCostUpload.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (PickNPayExchangeInsert.this.animation != null) {
                PickNPayExchangeInsert.this.animation.setLocation((int)((double)parent.getWidth() - PickNPayExchangeInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - PickNPayExchangeInsert.this.animation.getPreferredSize().getHeight()) / 2);
                PickNPayExchangeInsert.this.animation.setSize(PickNPayExchangeInsert.this.animation.getPreferredSize());
            }
            if (PickNPayExchangeInsert.this.isInserted) {
                PickNPayExchangeInsert.this.configPanel.setLocation(border, border);
                PickNPayExchangeInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                PickNPayExchangeInsert.this.sendPanel.setLocation(PickNPayExchangeInsert.this.configPanel.getX() + PickNPayExchangeInsert.this.configPanel.getWidth() + border, border);
                PickNPayExchangeInsert.this.sendPanel.setSize(PickNPayExchangeInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

