/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.tables.PurchaseApprovalEntryTable;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.RetailInMotionServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.PurchaseApprovalSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.PurchaseApprovalSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.TimeDurationComplete;
import ch.icit.pegasus.server.core.dtos.util.TimeUnitE;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class PurchaseApprovalDataExchangeInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TitledItem<CheckBox> usePurchaseApproval;
    private TitledItem<PurchaseApprovalEntryTable> approvalPrice;
    private TitledItem<TextField> defaultOverDueTime;
    private TitledItem<TextField> defaultRemindMinutes;
    private TitledItem<CheckBox> sendNotifications;
    private TitledItem<TextField> nightlyWindowStart;
    private TitledItem<TextField> nightlyWindowStop;
    private TitledItem<CheckBox> autoSendPurchaseOrderToSupplier;
    private TitledItem<CheckBox> autoCloseOrderWhenRejected;
    private TitledItem<TextField> styleSheetName;
    private TablePanelAddSaveButton checkButton;
    private TablePanelAddSaveButton saveButton;
    private final DataExchangeModule module;
    protected Node<PurchaseApprovalSettingsComplete> settingsNode;
    protected PurchaseApprovalSettingsComplete purchaseSettings;

    public PurchaseApprovalDataExchangeInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.usePurchaseApproval = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settingsNode.getChildNamed(PurchaseApprovalSettingsComplete_.usePurchaseApproval)), "Use Purchase Release Process", TitledItem.TitledItemOrientation.EAST);
        this.usePurchaseApproval.getElement().addButtonListener(this);
        this.approvalPrice = new TitledItem<PurchaseApprovalEntryTable>(new PurchaseApprovalEntryTable(), "Approval Price Steps", TitledItem.TitledItemOrientation.NORTH);
        this.approvalPrice.setIgnorePrefHeight(true);
        this.approvalPrice.getElement().setNode(this.settingsNode.getChildNamed(PurchaseApprovalSettingsComplete_.steps));
        this.defaultOverDueTime = new TitledItem<TextField>(new TextField(this.settingsNode.getChildNamed(PurchaseApprovalSettingsComplete_.defaultOverdueTime), TextFieldType.DAYTIME), "Default Overdue Time (at order date)", TitledItem.TitledItemOrientation.NORTH);
        this.defaultRemindMinutes = new TitledItem<TextField>(new TextField(this.settingsNode.getChildNamed(PurchaseApprovalSettingsComplete_.defaultRemindMinutes), TextFieldType.INT), "Default reminder minutes (from order date and overdue time)", TitledItem.TitledItemOrientation.NORTH);
        this.sendNotifications = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settingsNode.getChildNamed(PurchaseApprovalSettingsComplete_.sendNotifications)), "Send Notification", TitledItem.TitledItemOrientation.EAST);
        this.nightlyWindowStart = new TitledItem<TextField>(new TextField(this.settingsNode.getChildNamed(PurchaseApprovalSettingsComplete_.nightlyWindowStart), TextFieldType.DAYTIME), "Nightly Window Start", TitledItem.TitledItemOrientation.NORTH);
        this.nightlyWindowStop = new TitledItem<TextField>(new TextField(this.settingsNode.getChildNamed(PurchaseApprovalSettingsComplete_.nightlyWindowStop), TextFieldType.DAYTIME), "Nightly Window End", TitledItem.TitledItemOrientation.NORTH);
        this.autoSendPurchaseOrderToSupplier = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settingsNode.getChildNamed(PurchaseApprovalSettingsComplete_.autoSendPurchaseOrderToSupplier)), "Auto Send Purchase Order to Supplier after Approval", TitledItem.TitledItemOrientation.EAST);
        this.autoCloseOrderWhenRejected = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settingsNode.getChildNamed(PurchaseApprovalSettingsComplete_.autoCloseOrderWhenRejected)), "Auto close order when rejected", TitledItem.TitledItemOrientation.EAST);
        this.styleSheetName = new TitledItem<TextField>(new TextField(this.settingsNode.getChildNamed(PurchaseApprovalSettingsComplete_.styleSheetName)), "Order Style Sheet Name", TitledItem.TitledItemOrientation.NORTH);
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.checkButton = new TablePanelAddSaveButton();
        this.checkButton.setText(Words.RECEIVE);
        this.checkButton.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.usePurchaseApproval);
        this.configPanel.add(this.approvalPrice);
        this.configPanel.add(this.defaultOverDueTime);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.defaultRemindMinutes);
        this.configPanel.add(this.sendNotifications);
        this.configPanel.add(this.nightlyWindowStart);
        this.configPanel.add(this.nightlyWindowStop);
        this.configPanel.add(this.autoSendPurchaseOrderToSupplier);
        this.configPanel.add(this.autoCloseOrderWhenRejected);
        this.configPanel.add(this.styleSheetName);
        this.sendPanel.add(this.checkButton);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllTimeDurations();
                try {
                    PurchaseApprovalDataExchangeInsert.this.purchaseSettings = (PurchaseApprovalSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getPurchaseReleaseSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (PurchaseApprovalDataExchangeInsert.this.purchaseSettings == null) {
                    PurchaseApprovalSettingsComplete s = new PurchaseApprovalSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    PurchaseApprovalDataExchangeInsert.this.purchaseSettings = s;
                }
                if (PurchaseApprovalDataExchangeInsert.this.purchaseSettings.getNightlyWindowStart() == null) {
                    PurchaseApprovalDataExchangeInsert.this.purchaseSettings.setNightlyWindowStart(DateUtil.getSQLTime((int)20, (int)0, (int)0));
                }
                if (PurchaseApprovalDataExchangeInsert.this.purchaseSettings.getNightlyWindowStop() == null) {
                    PurchaseApprovalDataExchangeInsert.this.purchaseSettings.setNightlyWindowStop(DateUtil.getSQLTime((int)5, (int)0, (int)0));
                }
                if (PurchaseApprovalDataExchangeInsert.this.purchaseSettings.getDefaultOverdueTime() == null) {
                    PurchaseApprovalDataExchangeInsert.this.purchaseSettings.setDefaultOverdueTime(DateUtil.getSQLTime((int)16, (int)0, (int)0));
                }
                if (PurchaseApprovalDataExchangeInsert.this.purchaseSettings.getDefaultRemindMinutes() == null) {
                    PurchaseApprovalDataExchangeInsert.this.purchaseSettings.setDefaultRemindMinutes(Integer.valueOf(120));
                }
                PurchaseApprovalDataExchangeInsert.this.purchaseSettings.setTimerServiceSettings(PurchaseApprovalDataExchangeInsert.this.createTimerService());
                PurchaseApprovalDataExchangeInsert.this.settingsNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)PurchaseApprovalDataExchangeInsert.this.purchaseSettings, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PurchaseApprovalDataExchangeInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createTimerService() {
        TimerServiceSettingsComplete s = new TimerServiceSettingsComplete();
        s.setClientOId(Long.valueOf(ADTO.getNextId()));
        s.setTimerServiceConfig((TimerServiceConfigComplete)new TimeDurationComplete(TimeUnitE.MINUTE, Double.valueOf(10.0)));
        s.setIntervallRateUnit(TimeUnitE.MINUTE);
        s.setIntervallRateValue(Double.valueOf(10.0));
        return s;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.usePurchaseApproval.setEnabled(isEnabled);
            boolean b = isEnabled && this.usePurchaseApproval.getElement().isChecked();
            this.approvalPrice.setEnabled(b);
            this.defaultOverDueTime.setEnabled(b);
            this.defaultRemindMinutes.setEnabled(b);
            this.sendNotifications.setEnabled(b);
            this.nightlyWindowStart.setEnabled(b);
            this.nightlyWindowStop.setEnabled(b);
            this.autoSendPurchaseOrderToSupplier.setEnabled(b);
            this.autoCloseOrderWhenRejected.setEnabled(b);
            this.styleSheetName.setEnabled(b);
            this.checkButton.setEnabled(b);
            this.saveButton.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.approvalPrice.kill();
            this.defaultOverDueTime.kill();
            this.defaultRemindMinutes.kill();
            this.sendNotifications.kill();
            this.nightlyWindowStart.kill();
            this.nightlyWindowStop.kill();
            this.autoSendPurchaseOrderToSupplier.kill();
            this.autoCloseOrderWhenRejected.kill();
            this.styleSheetName.kill();
            this.saveButton.kill();
            this.usePurchaseApproval.kill();
        }
        this.sendPanel = null;
        this.configPanel = null;
        this.checkButton = null;
        this.approvalPrice = null;
        this.defaultOverDueTime = null;
        this.defaultRemindMinutes = null;
        this.sendNotifications = null;
        this.nightlyWindowStart = null;
        this.nightlyWindowStop = null;
        this.saveButton = null;
        this.usePurchaseApproval = null;
        this.autoSendPurchaseOrderToSupplier = null;
        this.autoCloseOrderWhenRejected = null;
        this.styleSheetName = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return "Purchase Approval Process";
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.checkButton || source == this.saveButton) {
            this.setEnabled(false);
            if (source == this.checkButton) {
                this.ensureAnimation(Words.EXCHANGE_DATA_WITH_RETAIL_IN_MOTION);
                this.processFiles();
            } else if (source == this.saveButton) {
                List<ScreenValidationObject> a = this.validatePurchaseRelease();
                if (a.isEmpty()) {
                    this.ensureAnimation(Words.SAVE_DATA);
                    this.saveConfig();
                } else {
                    InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
                    this.setEnabled(true);
                    return;
                }
            }
            this.module.started();
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private List<ScreenValidationObject> validatePurchaseRelease() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Node settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class);
        settings.commitThis(SystemSettingsComplete.class);
        return a;
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                PurchaseApprovalDataExchangeInsert.this.settingsNode.commit(PurchaseApprovalSettingsComplete.class);
                PurchaseApprovalSettingsComplete prc = (PurchaseApprovalSettingsComplete)PurchaseApprovalDataExchangeInsert.this.settingsNode.getValue();
                if (prc != null && Boolean.TRUE.equals(prc.getUsePurchaseApproval())) {
                    prc.setTimerServiceSettings(PurchaseApprovalDataExchangeInsert.this.createTimerService());
                    PurchaseApprovalSettingsComplete purchaseRelease = prc = (PurchaseApprovalSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)prc).getValue();
                    TimerServiceSettingsComplete ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(purchaseRelease.getTimerServiceSettings()).getValue();
                    purchaseRelease.setTimerServiceSettings(ts);
                    purchaseRelease = (PurchaseApprovalSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)purchaseRelease).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.PURCHASE_APPROVAL_REMINDER, purchaseRelease.getUsePurchaseApproval().booleanValue(), ts, -1L);
                    Node node = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.PURCHASE_APPROVAL_REMINDER);
                    prc = (PurchaseApprovalSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)prc).getValue();
                    Node node = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        PurchaseApprovalDataExchangeInsert.this.hideAnimation();
                        PurchaseApprovalDataExchangeInsert.this.module.ended();
                        PurchaseApprovalDataExchangeInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)PurchaseApprovalDataExchangeInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processFiles() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n = new Node();
                ((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).readRetailInMotionData();
                n.setValue((Object)true, 0L);
                ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).notifyPurchaseReleaseOverdue();
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        boolean read = (Boolean)node.getValue();
                        PurchaseApprovalDataExchangeInsert.this.hideAnimation();
                        PurchaseApprovalDataExchangeInsert.this.module.ended();
                        PurchaseApprovalDataExchangeInsert.this.setEnabled(true);
                        if (read) {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_PROCESSED, PurchaseApprovalDataExchangeInsert.this.checkButton);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, Words.UNABLE_TO_PROCESS, (Component)PurchaseApprovalDataExchangeInsert.this.checkButton);
                        PurchaseApprovalDataExchangeInsert.this.hideAnimation();
                        PurchaseApprovalDataExchangeInsert.this.setEnabled(true);
                        PurchaseApprovalDataExchangeInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            PurchaseApprovalDataExchangeInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            PurchaseApprovalDataExchangeInsert.this.usePurchaseApproval.setLocation(border, border + PurchaseApprovalDataExchangeInsert.this.configPanel.getTitleHeight());
            PurchaseApprovalDataExchangeInsert.this.usePurchaseApproval.setSize(PurchaseApprovalDataExchangeInsert.this.usePurchaseApproval.getPreferredSize());
            PurchaseApprovalDataExchangeInsert.this.approvalPrice.setLocation(border, PurchaseApprovalDataExchangeInsert.this.usePurchaseApproval.getY() + PurchaseApprovalDataExchangeInsert.this.usePurchaseApproval.getHeight());
            PurchaseApprovalDataExchangeInsert.this.approvalPrice.setSize(500, 300);
            PurchaseApprovalDataExchangeInsert.this.defaultOverDueTime.setLocation(border, PurchaseApprovalDataExchangeInsert.this.approvalPrice.getY() + PurchaseApprovalDataExchangeInsert.this.approvalPrice.getHeight() + border);
            PurchaseApprovalDataExchangeInsert.this.defaultOverDueTime.setSize(PurchaseApprovalDataExchangeInsert.this.defaultOverDueTime.getPreferredSize());
            PurchaseApprovalDataExchangeInsert.this.defaultRemindMinutes.setLocation(border, PurchaseApprovalDataExchangeInsert.this.defaultOverDueTime.getY() + PurchaseApprovalDataExchangeInsert.this.defaultOverDueTime.getHeight() + border);
            PurchaseApprovalDataExchangeInsert.this.defaultRemindMinutes.setSize(PurchaseApprovalDataExchangeInsert.this.defaultRemindMinutes.getPreferredSize());
            PurchaseApprovalDataExchangeInsert.this.sendNotifications.setLocation(border, PurchaseApprovalDataExchangeInsert.this.defaultRemindMinutes.getY() + PurchaseApprovalDataExchangeInsert.this.defaultRemindMinutes.getHeight() + border * 2);
            PurchaseApprovalDataExchangeInsert.this.sendNotifications.setSize(PurchaseApprovalDataExchangeInsert.this.sendNotifications.getPreferredSize());
            PurchaseApprovalDataExchangeInsert.this.nightlyWindowStart.setLocation(border, PurchaseApprovalDataExchangeInsert.this.sendNotifications.getY() + PurchaseApprovalDataExchangeInsert.this.sendNotifications.getHeight());
            PurchaseApprovalDataExchangeInsert.this.nightlyWindowStart.setSize(PurchaseApprovalDataExchangeInsert.this.nightlyWindowStart.getPreferredSize());
            PurchaseApprovalDataExchangeInsert.this.nightlyWindowStop.setLocation(border, PurchaseApprovalDataExchangeInsert.this.nightlyWindowStart.getY() + PurchaseApprovalDataExchangeInsert.this.nightlyWindowStart.getHeight());
            PurchaseApprovalDataExchangeInsert.this.nightlyWindowStop.setSize(PurchaseApprovalDataExchangeInsert.this.nightlyWindowStop.getPreferredSize());
            PurchaseApprovalDataExchangeInsert.this.autoSendPurchaseOrderToSupplier.setLocation(border, PurchaseApprovalDataExchangeInsert.this.nightlyWindowStop.getY() + PurchaseApprovalDataExchangeInsert.this.nightlyWindowStop.getHeight() + border);
            PurchaseApprovalDataExchangeInsert.this.autoSendPurchaseOrderToSupplier.setSize(PurchaseApprovalDataExchangeInsert.this.autoSendPurchaseOrderToSupplier.getPreferredSize());
            PurchaseApprovalDataExchangeInsert.this.autoCloseOrderWhenRejected.setLocation(border, PurchaseApprovalDataExchangeInsert.this.autoSendPurchaseOrderToSupplier.getY() + PurchaseApprovalDataExchangeInsert.this.autoSendPurchaseOrderToSupplier.getHeight() + border);
            PurchaseApprovalDataExchangeInsert.this.autoCloseOrderWhenRejected.setSize(PurchaseApprovalDataExchangeInsert.this.autoCloseOrderWhenRejected.getPreferredSize());
            PurchaseApprovalDataExchangeInsert.this.styleSheetName.setLocation(border, PurchaseApprovalDataExchangeInsert.this.autoCloseOrderWhenRejected.getY() + PurchaseApprovalDataExchangeInsert.this.autoCloseOrderWhenRejected.getHeight() + border);
            PurchaseApprovalDataExchangeInsert.this.styleSheetName.setSize(300, (int)PurchaseApprovalDataExchangeInsert.this.styleSheetName.getPreferredSize().getHeight());
            PurchaseApprovalDataExchangeInsert.this.saveButton.setLocation((int)((double)parent.getWidth() - PurchaseApprovalDataExchangeInsert.this.saveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ((double)border + PurchaseApprovalDataExchangeInsert.this.saveButton.getPreferredSize().getHeight())));
            PurchaseApprovalDataExchangeInsert.this.saveButton.setSize(PurchaseApprovalDataExchangeInsert.this.saveButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            PurchaseApprovalDataExchangeInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            PurchaseApprovalDataExchangeInsert.this.checkButton.setLocation((int)((double)parent.getWidth() - PurchaseApprovalDataExchangeInsert.this.checkButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - (PurchaseApprovalDataExchangeInsert.this.checkButton.getPreferredSize().getHeight() + (double)border)));
            PurchaseApprovalDataExchangeInsert.this.checkButton.setSize(PurchaseApprovalDataExchangeInsert.this.checkButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (PurchaseApprovalDataExchangeInsert.this.animation != null) {
                PurchaseApprovalDataExchangeInsert.this.animation.setLocation((int)((double)parent.getWidth() - PurchaseApprovalDataExchangeInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - PurchaseApprovalDataExchangeInsert.this.animation.getPreferredSize().getHeight()) / 2);
                PurchaseApprovalDataExchangeInsert.this.animation.setSize(PurchaseApprovalDataExchangeInsert.this.animation.getPreferredSize());
            }
            if (PurchaseApprovalDataExchangeInsert.this.isInserted) {
                PurchaseApprovalDataExchangeInsert.this.configPanel.setLocation(border, border);
                PurchaseApprovalDataExchangeInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                PurchaseApprovalDataExchangeInsert.this.sendPanel.setLocation(PurchaseApprovalDataExchangeInsert.this.configPanel.getX() + PurchaseApprovalDataExchangeInsert.this.configPanel.getWidth() + border, border);
                PurchaseApprovalDataExchangeInsert.this.sendPanel.setSize(PurchaseApprovalDataExchangeInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

