/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.converter.RetailInMotionStockImageLastUpdateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.panels.SFTPDataExchangeSettingsPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.tables.RetailInMotionStockImageExportListTable;
import ch.icit.pegasus.client.gui.utils.tables.RetailInMotionUnitMappingEditTable;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.RetailInMotionServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.DataTransferProtocolE;
import ch.icit.pegasus.server.core.dtos.dataexchange.RetailInMotionStockImageSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.RetailInMotionStockImageSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.SFTPDataExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.SFTPDataExchangeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.retailinmotion.RetailInMotionStockImageExportLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.DailyTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.EncryptedStringComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class RetailInMotionStockImageInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TitledItem<CheckBox> useRetailInMotionStockSync;
    private TitledItem<CheckBox> autoSendActive;
    private TitledItem<TextField> companyID;
    private TitledItem<TextField> senderIdentifier;
    private TitledItem<TextField> receiverIdentifier;
    private TitledItem<TextField> clientNumber;
    private SFTPDataExchangeSettingsPanel ftpPanel;
    private RetailInMotionUnitMappingEditTable unitMapping;
    private Node<List<RetailInMotionStockImageExportLight>> retailInMotionData;
    private TextLabel lastUpdates;
    private RetailInMotionStockImageExportListTable history;
    private TablePanelAddSaveButton sendButton;
    private TablePanelAddSaveButton saveButton;
    private TextButton resetLastSendDate;
    private final DataExchangeModule module;
    protected Node<RetailInMotionStockImageSettingsComplete> settings;
    protected RetailInMotionStockImageSettingsComplete rimsisc;

    public RetailInMotionStockImageInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.useRetailInMotionStockSync = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(RetailInMotionStockImageSettingsComplete_.useRetailInMotionInterface)), Words.ENABLE_RETAIL_IN_MOTION_STOCK, TitledItem.TitledItemOrientation.EAST);
        this.useRetailInMotionStockSync.getElement().addButtonListener(this);
        this.autoSendActive = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(RetailInMotionStockImageSettingsComplete_.autoSendData)), Words.AUTO_SEND, TitledItem.TitledItemOrientation.EAST);
        this.ftpPanel = new SFTPDataExchangeSettingsPanel();
        this.ftpPanel.setNode(this.settings.getChildNamed(RetailInMotionStockImageSettingsComplete_.sendDataExchangeSettings));
        this.companyID = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(RetailInMotionStockImageSettingsComplete_.companyID)), Words.RETAIL_IN_MOTION_COMPANY_ID, TitledItem.TitledItemOrientation.NORTH);
        this.senderIdentifier = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(RetailInMotionStockImageSettingsComplete_.senderIdentification)), Words.RETAIL_IN_MOTION_SENDER_ID, TitledItem.TitledItemOrientation.NORTH);
        this.receiverIdentifier = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(RetailInMotionStockImageSettingsComplete_.receiverIdentification)), Words.RETAIL_IN_MOTION_RECEIVE_ID, TitledItem.TitledItemOrientation.NORTH);
        this.clientNumber = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(RetailInMotionStockImageSettingsComplete_.clientNumber)), Words.RETAIL_IN_MOTION_CLIENT_NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.lastUpdates = new TextLabel(this.settings, ConverterRegistry.getConverter(RetailInMotionStockImageLastUpdateConverter.class));
        this.history = new RetailInMotionStockImageExportListTable();
        this.history.setNode(this.retailInMotionData);
        this.resetLastSendDate = new TextButton("Reset last send date");
        this.resetLastSendDate.setProgress(1.0f);
        this.resetLastSendDate.addButtonListener(this);
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.sendButton = new TablePanelAddSaveButton();
        this.sendButton.setText(Words.SEND);
        this.sendButton.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.unitMapping = new RetailInMotionUnitMappingEditTable();
        this.unitMapping.getModel().setNode(this.settings.getChildNamed(RetailInMotionStockImageSettingsComplete_.unitMapping));
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.useRetailInMotionStockSync);
        this.configPanel.add(this.autoSendActive);
        this.configPanel.add(this.companyID);
        this.configPanel.add(this.ftpPanel);
        this.configPanel.add(this.senderIdentifier);
        this.configPanel.add(this.receiverIdentifier);
        this.configPanel.add(this.clientNumber);
        this.configPanel.add(this.lastUpdates);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.resetLastSendDate);
        this.configPanel.add(this.unitMapping);
        this.sendPanel.add(this.history);
        this.sendPanel.add(this.sendButton);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllTimeDurations();
                UnitToolkit.loadUnits();
                try {
                    RetailInMotionStockImageInsert.this.rimsisc = (RetailInMotionStockImageSettingsComplete)((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).getRetailInMotionStockImageSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (RetailInMotionStockImageInsert.this.rimsisc == null) {
                    RetailInMotionStockImageSettingsComplete s = new RetailInMotionStockImageSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    RetailInMotionStockImageInsert.this.rimsisc = s;
                }
                RetailInMotionStockImageInsert.this.rimsisc.setTimerServiceSettings(RetailInMotionStockImageInsert.this.createDailyTimerService());
                if (RetailInMotionStockImageInsert.this.rimsisc.getSendDataExchangeSettings() == null) {
                    RetailInMotionStockImageInsert.this.rimsisc.setSendDataExchangeSettings(new SFTPDataExchangeSettingsComplete());
                }
                if (RetailInMotionStockImageInsert.this.rimsisc.getSendDataExchangeSettings().getLoginPwd() == null) {
                    RetailInMotionStockImageInsert.this.rimsisc.getSendDataExchangeSettings().setLoginPwd(new EncryptedStringComplete());
                }
                RetailInMotionStockImageInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)RetailInMotionStockImageInsert.this.rimsisc, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                RetailInMotionStockImageInsert.this.retailInMotionData = (Node)new ViewNode("data");
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return RetailInMotionStockImageInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createDailyTimerService() {
        TimerServiceSettingsComplete ts = new TimerServiceSettingsComplete();
        ts.setClientOId(Long.valueOf(ADTO.getNextId()));
        ts.setTimerServiceConfig((TimerServiceConfigComplete)new DailyTimeComplete(Integer.valueOf(21), Integer.valueOf(0)));
        ts.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return ts;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useRetailInMotionStockSync.setEnabled(isEnabled);
            boolean b = isEnabled && this.useRetailInMotionStockSync.getElement().isChecked();
            this.sendButton.setEnabled(b);
            this.autoSendActive.setEnabled(b);
            this.companyID.setEnabled(b);
            this.senderIdentifier.setEnabled(b);
            this.receiverIdentifier.setEnabled(b);
            this.clientNumber.setEnabled(b);
            this.ftpPanel.setEnabled(b);
            this.lastUpdates.setEnabled(b);
            this.history.setEnabled(isEnabled);
            this.saveButton.setEnabled(isEnabled);
            this.resetLastSendDate.setEnabled(b);
            this.unitMapping.setEnabled(b);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.autoSendActive.kill();
            this.history.kill();
            this.ftpPanel.kill();
            this.companyID.kill();
            this.senderIdentifier.kill();
            this.receiverIdentifier.kill();
            this.clientNumber.kill();
            this.lastUpdates.kill();
            this.saveButton.kill();
            this.useRetailInMotionStockSync.kill();
            this.resetLastSendDate.kill();
            this.resetLastSendDate = null;
            this.unitMapping.kill();
            this.unitMapping = null;
        }
        this.sendPanel = null;
        this.configPanel = null;
        this.sendButton = null;
        this.ftpPanel = null;
        this.history = null;
        this.autoSendActive = null;
        this.lastUpdates = null;
        this.companyID = null;
        this.senderIdentifier = null;
        this.receiverIdentifier = null;
        this.clientNumber = null;
        this.saveButton = null;
        this.useRetailInMotionStockSync = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return Words.RETAIL_INMOTION;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.sendButton || source == this.saveButton) {
            this.setEnabled(false);
            if (source == this.sendButton) {
                this.ensureAnimation(Words.SEND_RETAIL_INMOTION_STOCKIMAGE);
                this.processFiles();
            } else if (source == this.saveButton) {
                List<ScreenValidationObject> a = this.validateRetailinMotionConfig();
                if (a.isEmpty()) {
                    this.ensureAnimation(Words.SAVE_DATA);
                    this.saveConfig();
                } else {
                    InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
                    this.setEnabled(true);
                    return;
                }
            }
            this.module.started();
        } else if (source == this.resetLastSendDate) {
            this.settings.getChildNamed(new DtoField[]{RetailInMotionStockImageSettingsComplete_.sendDataExchangeSettings, SFTPDataExchangeSettingsComplete_.lastDataTransaction}).setValue((Object)new Timestamp(0L), 0L);
            this.settings.commit();
            this.lastUpdates.setNode((Node)this.settings);
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private List<ScreenValidationObject> validateRetailinMotionConfig() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Node settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class);
        settings.commitThis(SystemSettingsComplete.class);
        return a;
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                RetailInMotionStockImageInsert.this.settings.commit(RetailInMotionStockImageSettingsComplete.class);
                RetailInMotionStockImageSettingsComplete rimsisc = (RetailInMotionStockImageSettingsComplete)RetailInMotionStockImageInsert.this.settings.getValue();
                rimsisc.getSendDataExchangeSettings().setDataExchangeProtocol(DataTransferProtocolE.SFTP);
                if (Boolean.TRUE.equals(rimsisc.getUseRetailInMotionInterface())) {
                    rimsisc.setTimerServiceSettings(RetailInMotionStockImageInsert.this.createDailyTimerService());
                    TimerServiceSettingsComplete ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(rimsisc.getTimerServiceSettings()).getValue();
                    rimsisc.setTimerServiceSettings(ts);
                    rimsisc = (RetailInMotionStockImageSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimsisc).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.RETAIL_INMOTION_SEND_STOCK_IMAGE, rimsisc.getAutoSendData().booleanValue(), ts, -1L);
                    Node s = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                    Node settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)rimsisc, false, false);
                    RetailInMotionStockImageInsert.this.lastUpdates.setNode(settings);
                    RetailInMotionStockImageInsert.this.history.setNode(RetailInMotionStockImageInsert.this.retailInMotionData);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.RETAIL_INMOTION_SEND_STOCK_IMAGE);
                    rimsisc = (RetailInMotionStockImageSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimsisc).getValue();
                    Node s = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                    Node settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)rimsisc, false, false);
                    RetailInMotionStockImageInsert.this.lastUpdates.setNode(settings);
                    RetailInMotionStockImageInsert.this.history.setNode(RetailInMotionStockImageInsert.this.retailInMotionData);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        RetailInMotionStockImageInsert.this.hideAnimation();
                        RetailInMotionStockImageInsert.this.module.ended();
                        RetailInMotionStockImageInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)RetailInMotionStockImageInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processFiles() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n = new Node();
                ((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).sendRetailInMotionStockImage();
                n.setValue((Object)true, 0L);
                RetailInMotionStockImageInsert.this.rimsisc = (RetailInMotionStockImageSettingsComplete)((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).getRetailInMotionStockImageSettings().getValue();
                RetailInMotionStockImageInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)RetailInMotionStockImageInsert.this.rimsisc, false, false);
                RetailInMotionStockImageInsert.this.lastUpdates.setNode((Node)RetailInMotionStockImageInsert.this.settings);
                RetailInMotionStockImageInsert.this.history.setNode(RetailInMotionStockImageInsert.this.retailInMotionData);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        boolean read = (Boolean)node.getValue();
                        RetailInMotionStockImageInsert.this.hideAnimation();
                        RetailInMotionStockImageInsert.this.module.ended();
                        RetailInMotionStockImageInsert.this.setEnabled(true);
                        if (read) {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_IMPORTED, RetailInMotionStockImageInsert.this.sendButton);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, Words.UNABLE_TO_CREATE_RETAIL_INMOTION_EXPORT, (Component)RetailInMotionStockImageInsert.this.sendButton);
                        RetailInMotionStockImageInsert.this.hideAnimation();
                        RetailInMotionStockImageInsert.this.setEnabled(true);
                        RetailInMotionStockImageInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            RetailInMotionStockImageInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            RetailInMotionStockImageInsert.this.useRetailInMotionStockSync.setLocation(border, border + RetailInMotionStockImageInsert.this.configPanel.getTitleHeight());
            RetailInMotionStockImageInsert.this.useRetailInMotionStockSync.setSize(RetailInMotionStockImageInsert.this.useRetailInMotionStockSync.getPreferredSize());
            RetailInMotionStockImageInsert.this.autoSendActive.setLocation(border, RetailInMotionStockImageInsert.this.useRetailInMotionStockSync.getY() + RetailInMotionStockImageInsert.this.useRetailInMotionStockSync.getHeight());
            RetailInMotionStockImageInsert.this.autoSendActive.setSize(RetailInMotionStockImageInsert.this.autoSendActive.getPreferredSize());
            RetailInMotionStockImageInsert.this.companyID.setLocation(border, RetailInMotionStockImageInsert.this.autoSendActive.getY() + RetailInMotionStockImageInsert.this.autoSendActive.getHeight() + border);
            RetailInMotionStockImageInsert.this.companyID.setSize(220, (int)RetailInMotionStockImageInsert.this.companyID.getPreferredSize().getHeight());
            RetailInMotionStockImageInsert.this.clientNumber.setLocation(RetailInMotionStockImageInsert.this.companyID.getX() + RetailInMotionStockImageInsert.this.companyID.getWidth() + border, RetailInMotionStockImageInsert.this.companyID.getY());
            RetailInMotionStockImageInsert.this.clientNumber.setSize(220, (int)RetailInMotionStockImageInsert.this.clientNumber.getPreferredSize().getHeight());
            RetailInMotionStockImageInsert.this.senderIdentifier.setLocation(border, RetailInMotionStockImageInsert.this.companyID.getY() + RetailInMotionStockImageInsert.this.companyID.getHeight());
            RetailInMotionStockImageInsert.this.senderIdentifier.setSize(220, (int)RetailInMotionStockImageInsert.this.senderIdentifier.getPreferredSize().getHeight());
            RetailInMotionStockImageInsert.this.receiverIdentifier.setLocation(RetailInMotionStockImageInsert.this.senderIdentifier.getX() + RetailInMotionStockImageInsert.this.senderIdentifier.getWidth() + border, RetailInMotionStockImageInsert.this.senderIdentifier.getY());
            RetailInMotionStockImageInsert.this.receiverIdentifier.setSize(220, (int)RetailInMotionStockImageInsert.this.receiverIdentifier.getPreferredSize().getHeight());
            RetailInMotionStockImageInsert.this.ftpPanel.setLocation(border, RetailInMotionStockImageInsert.this.receiverIdentifier.getY() + RetailInMotionStockImageInsert.this.receiverIdentifier.getHeight() + border);
            RetailInMotionStockImageInsert.this.ftpPanel.setSize(450, (int)RetailInMotionStockImageInsert.this.ftpPanel.getPreferredSize().getHeight());
            RetailInMotionStockImageInsert.this.lastUpdates.setLocation(border, RetailInMotionStockImageInsert.this.ftpPanel.getY() + RetailInMotionStockImageInsert.this.ftpPanel.getHeight());
            RetailInMotionStockImageInsert.this.lastUpdates.setSize(RetailInMotionStockImageInsert.this.lastUpdates.getPreferredSize());
            RetailInMotionStockImageInsert.this.resetLastSendDate.setLocation(RetailInMotionStockImageInsert.this.lastUpdates.getX() + RetailInMotionStockImageInsert.this.lastUpdates.getWidth() + border, RetailInMotionStockImageInsert.this.lastUpdates.getY());
            RetailInMotionStockImageInsert.this.resetLastSendDate.setSize(RetailInMotionStockImageInsert.this.resetLastSendDate.getPreferredSize());
            RetailInMotionStockImageInsert.this.unitMapping.setLocation(border, RetailInMotionStockImageInsert.this.resetLastSendDate.getY() + RetailInMotionStockImageInsert.this.resetLastSendDate.getHeight() + border);
            RetailInMotionStockImageInsert.this.unitMapping.setSize(parent.getWidth() - 2 * border, (int)((double)parent.getHeight() - ((double)RetailInMotionStockImageInsert.this.unitMapping.getY() + (RetailInMotionStockImageInsert.this.saveButton.getPreferredSize().getHeight() + (double)(2 * border)))));
            RetailInMotionStockImageInsert.this.saveButton.setLocation((int)((double)parent.getWidth() - RetailInMotionStockImageInsert.this.saveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ((double)border + RetailInMotionStockImageInsert.this.saveButton.getPreferredSize().getHeight())));
            RetailInMotionStockImageInsert.this.saveButton.setSize(RetailInMotionStockImageInsert.this.saveButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            RetailInMotionStockImageInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            RetailInMotionStockImageInsert.this.history.setLocation(0, RetailInMotionStockImageInsert.this.sendPanel.getTitleHeight());
            RetailInMotionStockImageInsert.this.history.setSize(parent.getWidth(), RetailInMotionStockImageInsert.this.sendPanel.getHeight() - (border + RetailInMotionStockImageInsert.this.sendPanel.getTitleHeight() + 100));
            RetailInMotionStockImageInsert.this.sendButton.setLocation((int)((double)parent.getWidth() - RetailInMotionStockImageInsert.this.sendButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - (RetailInMotionStockImageInsert.this.sendButton.getPreferredSize().getHeight() + (double)border)));
            RetailInMotionStockImageInsert.this.sendButton.setSize(RetailInMotionStockImageInsert.this.sendButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (RetailInMotionStockImageInsert.this.animation != null) {
                RetailInMotionStockImageInsert.this.animation.setLocation((int)((double)parent.getWidth() - RetailInMotionStockImageInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - RetailInMotionStockImageInsert.this.animation.getPreferredSize().getHeight()) / 2);
                RetailInMotionStockImageInsert.this.animation.setSize(RetailInMotionStockImageInsert.this.animation.getPreferredSize());
            }
            if (RetailInMotionStockImageInsert.this.isInserted) {
                RetailInMotionStockImageInsert.this.configPanel.setLocation(border, border);
                RetailInMotionStockImageInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                RetailInMotionStockImageInsert.this.sendPanel.setLocation(RetailInMotionStockImageInsert.this.configPanel.getX() + RetailInMotionStockImageInsert.this.configPanel.getWidth() + border, border);
                RetailInMotionStockImageInsert.this.sendPanel.setSize(RetailInMotionStockImageInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

