/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts.edelweiss;

import ch.icit.pegasus.client.converter.EdelweissStockLevelExchangeLastUpdateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.FTPDataExchangeSettingsPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.tables.EdelweissStockLevelExportSheetListTable;
import ch.icit.pegasus.client.gui.utils.tables.StoreSearchTable;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.EdelweissStockLevelExchangeServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.DataTransferProtocolE;
import ch.icit.pegasus.server.core.dtos.dataexchange.SFTPDataExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.edelweiss.EdelweissStockLevelExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.edelweiss.EdelweissStockLevelExchangeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.edelweiss.stocklevel.EdelweissStockLevelExportComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.util.DayOfMonthE;
import ch.icit.pegasus.server.core.dtos.util.DayOfMonthTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.DayOfWeekE;
import ch.icit.pegasus.server.core.dtos.util.DayOfWeekTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.EncryptedStringComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class EdelweissStockLevelExchangeInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TitledItem<CheckBox> active;
    private FTPDataExchangeSettingsPanel ftpPanel;
    private StoreSearchTable excludedStores;
    private TextLabel lastUpdates;
    private TitledItem<SearchTextField2<CustomerLight>> customer;
    private TitledItem<CheckBox> appendData;
    private TitledItem<TextField> notificationAddress;
    private Node<List<EdelweissStockLevelExportComplete>> stockLevelData;
    private EdelweissStockLevelExportSheetListTable history;
    private TablePanelAddSaveButton sendButton;
    private TablePanelAddSaveButton saveButton;
    private final DataExchangeModule module;
    private Node<EdelweissStockLevelExchangeSettingsComplete> settings;

    public EdelweissStockLevelExchangeInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.active = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(EdelweissStockLevelExchangeSettingsComplete_.active)), Words.ACTIVE, TitledItem.TitledItemOrientation.EAST);
        this.active.getElement().addButtonListener(this);
        this.ftpPanel = new FTPDataExchangeSettingsPanel();
        this.ftpPanel.setNode(this.settings.getChildNamed(EdelweissStockLevelExchangeSettingsComplete_.sendDataExchangeSettings));
        this.lastUpdates = new TextLabel(this.settings, ConverterRegistry.getConverter(EdelweissStockLevelExchangeLastUpdateConverter.class));
        this.excludedStores = new StoreSearchTable(true, true, "Excluded Main Stores");
        this.excludedStores.setNode((Node<List<StoreLight>>)this.settings.getChildNamed(EdelweissStockLevelExchangeSettingsComplete_.excludeStores));
        this.customer = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, this.settings.getChildNamed(EdelweissStockLevelExchangeSettingsComplete_.customer)), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.appendData = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(EdelweissStockLevelExchangeSettingsComplete_.appendData)), "Append Data", TitledItem.TitledItemOrientation.EAST);
        this.notificationAddress = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(EdelweissStockLevelExchangeSettingsComplete_.notificationMailAddress)), "Notification Address", TitledItem.TitledItemOrientation.EAST);
        this.history = new EdelweissStockLevelExportSheetListTable();
        this.history.setNode(this.stockLevelData);
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.sendButton = new TablePanelAddSaveButton();
        this.sendButton.setText(Words.SEND);
        this.sendButton.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.ftpPanel);
        this.configPanel.add(this.active);
        this.configPanel.add(this.lastUpdates);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.customer);
        this.configPanel.add(this.appendData);
        this.configPanel.add(this.notificationAddress);
        this.configPanel.add(this.excludedStores);
        this.sendPanel.add(this.history);
        this.sendPanel.add(this.sendButton);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SFTPDataExchangeSettingsComplete c;
                StaticEnumServiceManager.getAllTimeDurations();
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                EdelweissStockLevelExchangeSettingsComplete esc = null;
                try {
                    esc = (EdelweissStockLevelExchangeSettingsComplete)((EdelweissStockLevelExchangeServiceManager)ServiceManagerRegistry.getService(EdelweissStockLevelExchangeServiceManager.class)).getSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (esc == null) {
                    EdelweissStockLevelExchangeSettingsComplete s = new EdelweissStockLevelExchangeSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    esc = s;
                }
                if (esc.getSendDataExchangeSettings() == null) {
                    c = new SFTPDataExchangeSettingsComplete();
                    c.setClientOId(Long.valueOf(ADTO.getNextId()));
                    esc.setSendDataExchangeSettings(c);
                }
                if (esc.getSendDataExchangeSettings().getLoginPwd() == null) {
                    esc.getSendDataExchangeSettings().setLoginPwd(new EncryptedStringComplete());
                }
                if (esc.getSendDataExchangeSettings26th() == null) {
                    c = new SFTPDataExchangeSettingsComplete();
                    c.setClientOId(Long.valueOf(ADTO.getNextId()));
                    esc.setSendDataExchangeSettings26th(c);
                }
                if (esc.getSendDataExchangeSettings26th().getLoginPwd() == null) {
                    esc.getSendDataExchangeSettings26th().setLoginPwd(new EncryptedStringComplete());
                }
                esc.setSendTimerServiceSettings(EdelweissStockLevelExchangeInsert.this.createWeeklyTimerService());
                esc.setSendTimerServiceSettings26th(EdelweissStockLevelExchangeInsert.this.createMonthlyTimerService());
                EdelweissStockLevelExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)esc, false, false);
                EdelweissStockLevelExchangeInsert.this.stockLevelData = (Node)new ViewNode("data");
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return EdelweissStockLevelExchangeInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createWeeklyTimerService() {
        TimerServiceSettingsComplete s = new TimerServiceSettingsComplete();
        s.setClientOId(Long.valueOf(ADTO.getNextId()));
        s.setTimerServiceConfig((TimerServiceConfigComplete)new DayOfWeekTimeComplete(DayOfWeekE.WEDNESDAY, Integer.valueOf(23), Integer.valueOf(40), Integer.valueOf(0)));
        s.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return s;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.active.setEnabled(isEnabled);
            boolean b = isEnabled && this.active.getElement().isChecked();
            this.sendButton.setEnabled(b);
            this.ftpPanel.setEnabled(b);
            this.appendData.setEnabled(b);
            this.notificationAddress.setEnabled(b);
            this.customer.setEnabled(b);
            this.lastUpdates.setEnabled(b);
            this.history.setEnabled(isEnabled);
            this.saveButton.setEnabled(isEnabled);
            this.excludedStores.setEditable(b);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.sendButton.kill();
            this.ftpPanel.kill();
            this.history.kill();
            this.lastUpdates.kill();
            this.saveButton.kill();
            this.active.kill();
            this.customer.kill();
            this.appendData.kill();
            this.notificationAddress.kill();
            this.excludedStores.kill();
        }
        this.sendPanel = null;
        this.configPanel = null;
        this.ftpPanel = null;
        this.sendButton = null;
        this.history = null;
        this.lastUpdates = null;
        this.saveButton = null;
        this.active = null;
        this.customer = null;
        this.appendData = null;
        this.notificationAddress = null;
        this.excludedStores = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return "EDW Stock Level Exchange";
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.sendButton || source == this.saveButton) {
            this.settings.commit();
            this.setEnabled(false);
            if (source == this.sendButton) {
                this.ensureAnimation(Words.EXCHANGE_DATA_WITH_EDELWEISS);
                this.processFiles(false);
            } else if (source == this.saveButton) {
                List<ScreenValidationObject> a = this.validateESpecsConfig();
                if (a.isEmpty()) {
                    this.ensureAnimation(Words.SAVE_DATA);
                    this.saveConfig();
                } else {
                    InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
                    this.setEnabled(true);
                    return;
                }
            }
            this.module.started();
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private List<ScreenValidationObject> validateESpecsConfig() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        return a;
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                EdelweissStockLevelExchangeInsert.this.settings.commit(EdelweissStockLevelExchangeSettingsComplete.class);
                EdelweissStockLevelExchangeSettingsComplete value = (EdelweissStockLevelExchangeSettingsComplete)EdelweissStockLevelExchangeInsert.this.settings.getValue();
                value.getSendDataExchangeSettings().setDataExchangeProtocol(DataTransferProtocolE.SFTP);
                value.setSendTimerServiceSettings(EdelweissStockLevelExchangeInsert.this.createWeeklyTimerService());
                TimerServiceSettingsComplete sendTS = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(value.getSendTimerServiceSettings()).getValue();
                value.setSendTimerServiceSettings(sendTS);
                value = (EdelweissStockLevelExchangeSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)value).getValue();
                ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.EDW_STOCK_LEVEL_EXCHANGE_WEEKLY, value.getActive().booleanValue(), sendTS, -1L);
                value.getSendDataExchangeSettings26th().setDataExchangeProtocol(DataTransferProtocolE.SFTP);
                value.setSendTimerServiceSettings26th(EdelweissStockLevelExchangeInsert.this.createMonthlyTimerService());
                sendTS = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(value.getSendTimerServiceSettings26th()).getValue();
                value.setSendTimerServiceSettings26th(sendTS);
                value = (EdelweissStockLevelExchangeSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)value).getValue();
                ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.EDW_STOCK_LEVEL_EXCHANGE_26TH, value.getActive().booleanValue(), sendTS, -1L);
                EdelweissStockLevelExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)value, false, false);
                EdelweissStockLevelExchangeInsert.this.lastUpdates.setNode(EdelweissStockLevelExchangeInsert.this.settings);
                EdelweissStockLevelExchangeInsert.this.history.setNode(EdelweissStockLevelExchangeInsert.this.stockLevelData);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        EdelweissStockLevelExchangeInsert.this.hideAnimation();
                        EdelweissStockLevelExchangeInsert.this.module.ended();
                        EdelweissStockLevelExchangeInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)EdelweissStockLevelExchangeInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createMonthlyTimerService() {
        TimerServiceSettingsComplete s = new TimerServiceSettingsComplete();
        s.setClientOId(Long.valueOf(ADTO.getNextId()));
        s.setTimerServiceConfig((TimerServiceConfigComplete)new DayOfMonthTimeComplete(DayOfMonthE.DAY_26, Integer.valueOf(1), Integer.valueOf(30), Integer.valueOf(0)));
        s.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return s;
    }

    private void processFiles(boolean read) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ((EdelweissStockLevelExchangeServiceManager)ServiceManagerRegistry.getService(EdelweissStockLevelExchangeServiceManager.class)).sendStockLevel();
                EdelweissStockLevelExchangeInsert.this.lastUpdates.setNode(EdelweissStockLevelExchangeInsert.this.settings);
                return EdelweissStockLevelExchangeInsert.this.stockLevelData;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_EXPORTED, EdelweissStockLevelExchangeInsert.this.sendButton);
                        EdelweissStockLevelExchangeInsert.this.hideAnimation();
                        EdelweissStockLevelExchangeInsert.this.setEnabled(true);
                        EdelweissStockLevelExchangeInsert.this.module.ended();
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, "Export failed", (Component)EdelweissStockLevelExchangeInsert.this.sendButton);
                        EdelweissStockLevelExchangeInsert.this.hideAnimation();
                        EdelweissStockLevelExchangeInsert.this.setEnabled(true);
                        EdelweissStockLevelExchangeInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            EdelweissStockLevelExchangeInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            EdelweissStockLevelExchangeInsert.this.active.setLocation(border, border + EdelweissStockLevelExchangeInsert.this.configPanel.getTitleHeight());
            EdelweissStockLevelExchangeInsert.this.active.setSize(EdelweissStockLevelExchangeInsert.this.active.getPreferredSize());
            EdelweissStockLevelExchangeInsert.this.ftpPanel.setLocation(border, EdelweissStockLevelExchangeInsert.this.active.getY() + EdelweissStockLevelExchangeInsert.this.active.getHeight() + border);
            EdelweissStockLevelExchangeInsert.this.ftpPanel.setSize(450, (int)EdelweissStockLevelExchangeInsert.this.ftpPanel.getPreferredSize().getHeight());
            EdelweissStockLevelExchangeInsert.this.lastUpdates.setLocation(border, EdelweissStockLevelExchangeInsert.this.ftpPanel.getY() + EdelweissStockLevelExchangeInsert.this.ftpPanel.getHeight());
            EdelweissStockLevelExchangeInsert.this.lastUpdates.setSize(parent.getWidth() - 2 * border, (int)EdelweissStockLevelExchangeInsert.this.lastUpdates.getPreferredSize().getHeight());
            EdelweissStockLevelExchangeInsert.this.customer.setLocation(border, EdelweissStockLevelExchangeInsert.this.lastUpdates.getY() + EdelweissStockLevelExchangeInsert.this.lastUpdates.getHeight() + 5);
            EdelweissStockLevelExchangeInsert.this.customer.setSize(parent.getWidth() - 2 * border, (int)EdelweissStockLevelExchangeInsert.this.customer.getPreferredSize().getHeight());
            EdelweissStockLevelExchangeInsert.this.appendData.setLocation(border, EdelweissStockLevelExchangeInsert.this.customer.getY() + EdelweissStockLevelExchangeInsert.this.customer.getHeight() + 5);
            EdelweissStockLevelExchangeInsert.this.appendData.setSize(EdelweissStockLevelExchangeInsert.this.appendData.getPreferredSize());
            EdelweissStockLevelExchangeInsert.this.notificationAddress.setLocation(border, EdelweissStockLevelExchangeInsert.this.appendData.getY() + EdelweissStockLevelExchangeInsert.this.appendData.getHeight() + 5);
            EdelweissStockLevelExchangeInsert.this.notificationAddress.setSize(EdelweissStockLevelExchangeInsert.this.notificationAddress.getPreferredSize());
            EdelweissStockLevelExchangeInsert.this.excludedStores.setLocation(border, EdelweissStockLevelExchangeInsert.this.notificationAddress.getY() + EdelweissStockLevelExchangeInsert.this.notificationAddress.getHeight() + 10);
            EdelweissStockLevelExchangeInsert.this.excludedStores.setSize(300, 300);
            EdelweissStockLevelExchangeInsert.this.saveButton.setLocation((int)((double)parent.getWidth() - EdelweissStockLevelExchangeInsert.this.saveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ((double)border + EdelweissStockLevelExchangeInsert.this.saveButton.getPreferredSize().getHeight())));
            EdelweissStockLevelExchangeInsert.this.saveButton.setSize(EdelweissStockLevelExchangeInsert.this.saveButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            EdelweissStockLevelExchangeInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            EdelweissStockLevelExchangeInsert.this.history.setLocation(0, EdelweissStockLevelExchangeInsert.this.sendPanel.getTitleHeight());
            EdelweissStockLevelExchangeInsert.this.history.setSize(parent.getWidth(), EdelweissStockLevelExchangeInsert.this.sendPanel.getHeight() - (border + EdelweissStockLevelExchangeInsert.this.sendPanel.getTitleHeight() + 100));
            EdelweissStockLevelExchangeInsert.this.sendButton.setLocation((int)((double)parent.getWidth() - EdelweissStockLevelExchangeInsert.this.sendButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - (EdelweissStockLevelExchangeInsert.this.sendButton.getPreferredSize().getHeight() + (double)border)));
            EdelweissStockLevelExchangeInsert.this.sendButton.setSize(EdelweissStockLevelExchangeInsert.this.sendButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (EdelweissStockLevelExchangeInsert.this.animation != null) {
                EdelweissStockLevelExchangeInsert.this.animation.setLocation((int)((double)parent.getWidth() - EdelweissStockLevelExchangeInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - EdelweissStockLevelExchangeInsert.this.animation.getPreferredSize().getHeight()) / 2);
                EdelweissStockLevelExchangeInsert.this.animation.setSize(EdelweissStockLevelExchangeInsert.this.animation.getPreferredSize());
            }
            if (EdelweissStockLevelExchangeInsert.this.isInserted) {
                EdelweissStockLevelExchangeInsert.this.configPanel.setLocation(border, border);
                EdelweissStockLevelExchangeInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                EdelweissStockLevelExchangeInsert.this.sendPanel.setLocation(EdelweissStockLevelExchangeInsert.this.configPanel.getX() + EdelweissStockLevelExchangeInsert.this.configPanel.getWidth() + border, border);
                EdelweissStockLevelExchangeInsert.this.sendPanel.setSize(EdelweissStockLevelExchangeInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

