/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts.spotcheck;

import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.tracking.KnifeTrackingServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.knife.KnifeSpotCheckSettingsComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.knife.KnifeSpotCheckSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.util.DailyTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class KnifeSpotCheckExchangeInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<CheckBox> useSpotCheck;
    private TitledItem<CheckBox> autoGenerate;
    private TitledItem<CheckBox> runSpotCheckSameDay;
    private TitledItem<CheckBox> notification;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TablePanelAddSaveButton sendButton;
    private TablePanelAddSaveButton saveButton;
    private final DataExchangeModule module;
    protected Node<KnifeSpotCheckSettingsComplete> settings;
    protected KnifeSpotCheckSettingsComplete rimtesc;

    public KnifeSpotCheckExchangeInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.useSpotCheck = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(KnifeSpotCheckSettingsComplete_.useSpotCheck)), "Enable Spot Check", TitledItem.TitledItemOrientation.EAST);
        this.useSpotCheck.getElement().addButtonListener(this);
        this.autoGenerate = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(KnifeSpotCheckSettingsComplete_.autoGenerate)), "Auto Generate Spot Checks", TitledItem.TitledItemOrientation.EAST);
        this.runSpotCheckSameDay = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(KnifeSpotCheckSettingsComplete_.runSpotCheckSameDay)), "Run Spot Check same day", TitledItem.TitledItemOrientation.EAST);
        this.notification = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(KnifeSpotCheckSettingsComplete_.notification)), "Notification", TitledItem.TitledItemOrientation.EAST);
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.sendButton = new TablePanelAddSaveButton();
        this.sendButton.setText(Words.SEND);
        this.sendButton.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.useSpotCheck);
        this.configPanel.add(this.autoGenerate);
        this.configPanel.add(this.runSpotCheckSameDay);
        this.configPanel.add(this.notification);
        this.configPanel.add(this.saveButton);
        this.sendPanel.add(this.sendButton);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                try {
                    KnifeSpotCheckExchangeInsert.this.rimtesc = (KnifeSpotCheckSettingsComplete)((KnifeTrackingServiceManager)ServiceManagerRegistry.getService(KnifeTrackingServiceManager.class)).getSpotCheckSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (KnifeSpotCheckExchangeInsert.this.rimtesc == null) {
                    KnifeSpotCheckSettingsComplete s = new KnifeSpotCheckSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    KnifeSpotCheckExchangeInsert.this.rimtesc = s;
                }
                KnifeSpotCheckExchangeInsert.this.rimtesc.setTimerServiceSettings(KnifeSpotCheckExchangeInsert.this.createDailyTimerService());
                KnifeSpotCheckExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)KnifeSpotCheckExchangeInsert.this.rimtesc, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return KnifeSpotCheckExchangeInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createDailyTimerService() {
        TimerServiceSettingsComplete s = new TimerServiceSettingsComplete();
        s.setTimerServiceConfig((TimerServiceConfigComplete)new DailyTimeComplete(Integer.valueOf(22), Integer.valueOf(10)));
        s.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return s;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useSpotCheck.setEnabled(isEnabled);
            boolean b = isEnabled && this.useSpotCheck.getElement().isChecked();
            this.sendButton.setEnabled(b);
            this.autoGenerate.setEnabled(b);
            this.runSpotCheckSameDay.setEnabled(b);
            this.notification.setEnabled(b);
            this.saveButton.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.autoGenerate.kill();
            this.runSpotCheckSameDay.kill();
            this.notification.kill();
            this.saveButton.kill();
            this.useSpotCheck.kill();
        }
        this.sendPanel = null;
        this.configPanel = null;
        this.sendButton = null;
        this.autoGenerate = null;
        this.runSpotCheckSameDay = null;
        this.notification = null;
        this.saveButton = null;
        this.useSpotCheck = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return Words.RETAIL_INMOTION;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.sendButton || source == this.saveButton) {
            this.setEnabled(false);
            if (source == this.sendButton) {
                this.ensureAnimation("Generate Spot Check");
                this.processFiles();
            } else if (source == this.saveButton) {
                this.ensureAnimation(Words.SAVE_DATA);
                this.saveConfig();
            }
            this.module.started();
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                KnifeSpotCheckExchangeInsert.this.settings.commit(KnifeSpotCheckSettingsComplete.class);
                KnifeSpotCheckSettingsComplete rimtesc = (KnifeSpotCheckSettingsComplete)KnifeSpotCheckExchangeInsert.this.settings.getValue();
                if (Boolean.TRUE.equals(rimtesc.getUseSpotCheck())) {
                    rimtesc.setTimerServiceSettings(KnifeSpotCheckExchangeInsert.this.createDailyTimerService());
                    TimerServiceSettingsComplete ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(rimtesc.getTimerServiceSettings()).getValue();
                    rimtesc.setTimerServiceSettings(ts);
                    rimtesc = (KnifeSpotCheckSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimtesc).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.KNIFE_SPOT_CHECK, rimtesc.getAutoGenerate().booleanValue(), ts, -1L);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.KNIFE_SPOT_CHECK);
                    rimtesc = (KnifeSpotCheckSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimtesc).getValue();
                    KnifeSpotCheckExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)rimtesc, false, false);
                    ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        KnifeSpotCheckExchangeInsert.this.hideAnimation();
                        KnifeSpotCheckExchangeInsert.this.module.ended();
                        KnifeSpotCheckExchangeInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)KnifeSpotCheckExchangeInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processFiles() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n = new Node();
                ((KnifeTrackingServiceManager)ServiceManagerRegistry.getService(KnifeTrackingServiceManager.class)).generateSpotCheck();
                n.setValue((Object)true, 0L);
                KnifeSpotCheckExchangeInsert.this.rimtesc = (KnifeSpotCheckSettingsComplete)((KnifeTrackingServiceManager)ServiceManagerRegistry.getService(KnifeTrackingServiceManager.class)).getSpotCheckSettings().getValue();
                KnifeSpotCheckExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)KnifeSpotCheckExchangeInsert.this.rimtesc, false, false);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        boolean read = (Boolean)node.getValue();
                        KnifeSpotCheckExchangeInsert.this.hideAnimation();
                        KnifeSpotCheckExchangeInsert.this.module.ended();
                        KnifeSpotCheckExchangeInsert.this.setEnabled(true);
                        if (read) {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_IMPORTED, KnifeSpotCheckExchangeInsert.this.sendButton);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, "Unable to generate Spot Check", (Component)KnifeSpotCheckExchangeInsert.this.sendButton);
                        KnifeSpotCheckExchangeInsert.this.hideAnimation();
                        KnifeSpotCheckExchangeInsert.this.setEnabled(true);
                        KnifeSpotCheckExchangeInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            KnifeSpotCheckExchangeInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            KnifeSpotCheckExchangeInsert.this.useSpotCheck.setLocation(border, border + KnifeSpotCheckExchangeInsert.this.configPanel.getTitleHeight());
            KnifeSpotCheckExchangeInsert.this.useSpotCheck.setSize(KnifeSpotCheckExchangeInsert.this.useSpotCheck.getPreferredSize());
            KnifeSpotCheckExchangeInsert.this.autoGenerate.setLocation(border, KnifeSpotCheckExchangeInsert.this.useSpotCheck.getY() + KnifeSpotCheckExchangeInsert.this.useSpotCheck.getHeight());
            KnifeSpotCheckExchangeInsert.this.autoGenerate.setSize(KnifeSpotCheckExchangeInsert.this.autoGenerate.getPreferredSize());
            KnifeSpotCheckExchangeInsert.this.runSpotCheckSameDay.setLocation(border, KnifeSpotCheckExchangeInsert.this.autoGenerate.getY() + KnifeSpotCheckExchangeInsert.this.autoGenerate.getHeight());
            KnifeSpotCheckExchangeInsert.this.runSpotCheckSameDay.setSize(KnifeSpotCheckExchangeInsert.this.runSpotCheckSameDay.getPreferredSize());
            KnifeSpotCheckExchangeInsert.this.notification.setLocation(border, KnifeSpotCheckExchangeInsert.this.runSpotCheckSameDay.getY() + KnifeSpotCheckExchangeInsert.this.runSpotCheckSameDay.getHeight());
            KnifeSpotCheckExchangeInsert.this.notification.setSize(KnifeSpotCheckExchangeInsert.this.notification.getPreferredSize());
            KnifeSpotCheckExchangeInsert.this.saveButton.setLocation((int)((double)parent.getWidth() - KnifeSpotCheckExchangeInsert.this.saveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ((double)border + KnifeSpotCheckExchangeInsert.this.saveButton.getPreferredSize().getHeight())));
            KnifeSpotCheckExchangeInsert.this.saveButton.setSize(KnifeSpotCheckExchangeInsert.this.saveButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            KnifeSpotCheckExchangeInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            KnifeSpotCheckExchangeInsert.this.sendButton.setLocation((int)((double)parent.getWidth() - KnifeSpotCheckExchangeInsert.this.sendButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - (KnifeSpotCheckExchangeInsert.this.sendButton.getPreferredSize().getHeight() + (double)border)));
            KnifeSpotCheckExchangeInsert.this.sendButton.setSize(KnifeSpotCheckExchangeInsert.this.sendButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (KnifeSpotCheckExchangeInsert.this.animation != null) {
                KnifeSpotCheckExchangeInsert.this.animation.setLocation((int)((double)parent.getWidth() - KnifeSpotCheckExchangeInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - KnifeSpotCheckExchangeInsert.this.animation.getPreferredSize().getHeight()) / 2);
                KnifeSpotCheckExchangeInsert.this.animation.setSize(KnifeSpotCheckExchangeInsert.this.animation.getPreferredSize());
            }
            if (KnifeSpotCheckExchangeInsert.this.isInserted) {
                KnifeSpotCheckExchangeInsert.this.configPanel.setLocation(border, border);
                KnifeSpotCheckExchangeInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                KnifeSpotCheckExchangeInsert.this.sendPanel.setLocation(KnifeSpotCheckExchangeInsert.this.configPanel.getX() + KnifeSpotCheckExchangeInsert.this.configPanel.getWidth() + border, border);
                KnifeSpotCheckExchangeInsert.this.sendPanel.setSize(KnifeSpotCheckExchangeInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

