/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts.spotcheck;

import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.tables.MailTable;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SpotCheckServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.DataTransferProtocolE;
import ch.icit.pegasus.server.core.dtos.dataexchange.EMailDataExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.EMailDataExchangeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.EMailReceiptComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.documentscan.DocumentScanSpotCheckSettingsComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.documentscan.DocumentScanSpotCheckSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.util.DailyTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class PurchaseDocumentScanSpotCheckExchangeInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<CheckBox> useSpotCheck;
    private TitledItem<CheckBox> autoGenerate;
    private TitledItem<TextField> headerTemplate;
    private TitledItem<TextField> defaultMailSender;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TablePanelAddSaveButton sendButton;
    private TablePanelAddSaveButton saveButton;
    private MailTable usersToInform;
    private final DataExchangeModule module;
    protected Node<DocumentScanSpotCheckSettingsComplete> settings;
    protected DocumentScanSpotCheckSettingsComplete rimtesc;

    public PurchaseDocumentScanSpotCheckExchangeInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.useSpotCheck = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(DocumentScanSpotCheckSettingsComplete_.useSpotCheck)), "Enable Spot Check", TitledItem.TitledItemOrientation.EAST);
        this.useSpotCheck.getElement().addButtonListener(this);
        this.autoGenerate = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(DocumentScanSpotCheckSettingsComplete_.autoGenerate)), "Auto Generate Spot Checks", TitledItem.TitledItemOrientation.EAST);
        this.headerTemplate = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(new DtoField[]{DocumentScanSpotCheckSettingsComplete_.mailDataExchangeSettings, EMailDataExchangeSettingsComplete_.mailHeaderTemplate})), Words.HEADER_TEMPLATE, TitledItem.TitledItemOrientation.NORTH);
        this.defaultMailSender = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(new DtoField[]{DocumentScanSpotCheckSettingsComplete_.mailDataExchangeSettings, EMailDataExchangeSettingsComplete_.defaultMailSender})), Words.MAIL_SENDER, TitledItem.TitledItemOrientation.NORTH);
        this.usersToInform = new MailTable(){

            @Override
            public Node createNewNode() {
                EMailReceiptComplete receipt = new EMailReceiptComplete();
                receipt.setClientOId(Long.valueOf(ADTO.getNextId()));
                receipt.setMailAddress("");
                return INodeCreator.getDefaultImpl().getNode4DTO((Object)receipt, true, false);
            }
        };
        this.usersToInform.getModel().setNode(this.settings.getChildNamed(new DtoField[]{DocumentScanSpotCheckSettingsComplete_.mailDataExchangeSettings, EMailDataExchangeSettingsComplete_.mailReceipts}));
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.sendButton = new TablePanelAddSaveButton();
        this.sendButton.setText(Words.SEND);
        this.sendButton.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.useSpotCheck);
        this.configPanel.add(this.autoGenerate);
        this.configPanel.add(this.headerTemplate);
        this.configPanel.add(this.defaultMailSender);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.usersToInform);
        this.sendPanel.add(this.sendButton);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                try {
                    PurchaseDocumentScanSpotCheckExchangeInsert.this.rimtesc = (DocumentScanSpotCheckSettingsComplete)((SpotCheckServiceManager)ServiceManagerRegistry.getService(SpotCheckServiceManager.class)).getDocumentScanSpotCheckSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (PurchaseDocumentScanSpotCheckExchangeInsert.this.rimtesc == null) {
                    DocumentScanSpotCheckSettingsComplete s = new DocumentScanSpotCheckSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    PurchaseDocumentScanSpotCheckExchangeInsert.this.rimtesc = s;
                }
                PurchaseDocumentScanSpotCheckExchangeInsert.this.rimtesc.setTimerServiceSettings(PurchaseDocumentScanSpotCheckExchangeInsert.this.createDailyTimerService());
                if (PurchaseDocumentScanSpotCheckExchangeInsert.this.rimtesc.getMailDataExchangeSettings() == null) {
                    EMailDataExchangeSettingsComplete mailSetting = new EMailDataExchangeSettingsComplete();
                    mailSetting.setClientOId(Long.valueOf(ADTO.getNextId()));
                    PurchaseDocumentScanSpotCheckExchangeInsert.this.rimtesc.setMailDataExchangeSettings(mailSetting);
                }
                PurchaseDocumentScanSpotCheckExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)PurchaseDocumentScanSpotCheckExchangeInsert.this.rimtesc, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PurchaseDocumentScanSpotCheckExchangeInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createDailyTimerService() {
        TimerServiceSettingsComplete s = new TimerServiceSettingsComplete();
        s.setTimerServiceConfig((TimerServiceConfigComplete)new DailyTimeComplete(Integer.valueOf(21), Integer.valueOf(0)));
        s.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return s;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useSpotCheck.setEnabled(isEnabled);
            boolean b = isEnabled && this.useSpotCheck.getElement().isChecked();
            this.sendButton.setEnabled(b);
            this.autoGenerate.setEnabled(b);
            this.headerTemplate.setEnabled(b);
            this.defaultMailSender.setEnabled(isEnabled);
            this.saveButton.setEnabled(isEnabled);
            this.usersToInform.setEnabled(b);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.autoGenerate.kill();
            this.headerTemplate.kill();
            this.defaultMailSender.kill();
            this.saveButton.kill();
            this.useSpotCheck.kill();
            this.usersToInform.kill();
            this.usersToInform = null;
        }
        this.sendPanel = null;
        this.configPanel = null;
        this.sendButton = null;
        this.autoGenerate = null;
        this.defaultMailSender = null;
        this.headerTemplate = null;
        this.saveButton = null;
        this.useSpotCheck = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return Words.RETAIL_INMOTION;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.sendButton || source == this.saveButton) {
            this.setEnabled(false);
            if (source == this.sendButton) {
                this.ensureAnimation("Generate Spot Check");
                this.processFiles();
            } else if (source == this.saveButton) {
                this.ensureAnimation(Words.SAVE_DATA);
                this.saveConfig();
            }
            this.module.started();
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                PurchaseDocumentScanSpotCheckExchangeInsert.this.settings.commit(DocumentScanSpotCheckSettingsComplete.class);
                DocumentScanSpotCheckSettingsComplete rimtesc = (DocumentScanSpotCheckSettingsComplete)PurchaseDocumentScanSpotCheckExchangeInsert.this.settings.getValue();
                rimtesc.getMailDataExchangeSettings().setDataExchangeProtocol(DataTransferProtocolE.EMAIL);
                List<Table2RowPanel> uTIFList = PurchaseDocumentScanSpotCheckExchangeInsert.this.usersToInform.getRows();
                rimtesc.getMailDataExchangeSettings().setMailReceipts(new ArrayList());
                for (Table2RowPanel utif : uTIFList) {
                    EMailReceiptComplete l = (EMailReceiptComplete)utif.getModel().getNode().getValue();
                    if (rimtesc.getMailDataExchangeSettings().getMailReceipts().contains(l)) continue;
                    rimtesc.getMailDataExchangeSettings().getMailReceipts().add(l);
                }
                if (Boolean.TRUE.equals(rimtesc.getUseSpotCheck())) {
                    rimtesc.setTimerServiceSettings(PurchaseDocumentScanSpotCheckExchangeInsert.this.createDailyTimerService());
                    TimerServiceSettingsComplete ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(rimtesc.getTimerServiceSettings()).getValue();
                    rimtesc.setTimerServiceSettings(ts);
                    rimtesc = (DocumentScanSpotCheckSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimtesc).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.DOCUMENT_SCAN_SPOT_CHECK, rimtesc.getAutoGenerate().booleanValue(), ts, -1L);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.DOCUMENT_SCAN_SPOT_CHECK);
                    rimtesc = (DocumentScanSpotCheckSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimtesc).getValue();
                    PurchaseDocumentScanSpotCheckExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)rimtesc, false, false);
                    ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        PurchaseDocumentScanSpotCheckExchangeInsert.this.hideAnimation();
                        PurchaseDocumentScanSpotCheckExchangeInsert.this.module.ended();
                        PurchaseDocumentScanSpotCheckExchangeInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)PurchaseDocumentScanSpotCheckExchangeInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processFiles() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n = new Node();
                ((SpotCheckServiceManager)ServiceManagerRegistry.getService(SpotCheckServiceManager.class)).generateDocumentScanSpotCheck();
                n.setValue((Object)true, 0L);
                PurchaseDocumentScanSpotCheckExchangeInsert.this.rimtesc = (DocumentScanSpotCheckSettingsComplete)((SpotCheckServiceManager)ServiceManagerRegistry.getService(SpotCheckServiceManager.class)).getDocumentScanSpotCheckSettings().getValue();
                PurchaseDocumentScanSpotCheckExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)PurchaseDocumentScanSpotCheckExchangeInsert.this.rimtesc, false, false);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        boolean read = (Boolean)node.getValue();
                        PurchaseDocumentScanSpotCheckExchangeInsert.this.hideAnimation();
                        PurchaseDocumentScanSpotCheckExchangeInsert.this.module.ended();
                        PurchaseDocumentScanSpotCheckExchangeInsert.this.setEnabled(true);
                        if (read) {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_IMPORTED, PurchaseDocumentScanSpotCheckExchangeInsert.this.sendButton);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, "Unable to generate Spot Check", (Component)PurchaseDocumentScanSpotCheckExchangeInsert.this.sendButton);
                        PurchaseDocumentScanSpotCheckExchangeInsert.this.hideAnimation();
                        PurchaseDocumentScanSpotCheckExchangeInsert.this.setEnabled(true);
                        PurchaseDocumentScanSpotCheckExchangeInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            PurchaseDocumentScanSpotCheckExchangeInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            PurchaseDocumentScanSpotCheckExchangeInsert.this.useSpotCheck.setLocation(border, border + PurchaseDocumentScanSpotCheckExchangeInsert.this.configPanel.getTitleHeight());
            PurchaseDocumentScanSpotCheckExchangeInsert.this.useSpotCheck.setSize(PurchaseDocumentScanSpotCheckExchangeInsert.this.useSpotCheck.getPreferredSize());
            PurchaseDocumentScanSpotCheckExchangeInsert.this.autoGenerate.setLocation(border, PurchaseDocumentScanSpotCheckExchangeInsert.this.useSpotCheck.getY() + PurchaseDocumentScanSpotCheckExchangeInsert.this.useSpotCheck.getHeight());
            PurchaseDocumentScanSpotCheckExchangeInsert.this.autoGenerate.setSize(PurchaseDocumentScanSpotCheckExchangeInsert.this.autoGenerate.getPreferredSize());
            PurchaseDocumentScanSpotCheckExchangeInsert.this.headerTemplate.setLocation(border, PurchaseDocumentScanSpotCheckExchangeInsert.this.autoGenerate.getY() + PurchaseDocumentScanSpotCheckExchangeInsert.this.autoGenerate.getHeight() + border);
            PurchaseDocumentScanSpotCheckExchangeInsert.this.headerTemplate.setSize(220, (int)PurchaseDocumentScanSpotCheckExchangeInsert.this.headerTemplate.getPreferredSize().getHeight());
            PurchaseDocumentScanSpotCheckExchangeInsert.this.defaultMailSender.setLocation(PurchaseDocumentScanSpotCheckExchangeInsert.this.headerTemplate.getX() + PurchaseDocumentScanSpotCheckExchangeInsert.this.headerTemplate.getWidth() + border, PurchaseDocumentScanSpotCheckExchangeInsert.this.headerTemplate.getY());
            PurchaseDocumentScanSpotCheckExchangeInsert.this.defaultMailSender.setSize(220, (int)PurchaseDocumentScanSpotCheckExchangeInsert.this.defaultMailSender.getPreferredSize().getHeight());
            PurchaseDocumentScanSpotCheckExchangeInsert.this.saveButton.setLocation((int)((double)parent.getWidth() - PurchaseDocumentScanSpotCheckExchangeInsert.this.saveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ((double)border + PurchaseDocumentScanSpotCheckExchangeInsert.this.saveButton.getPreferredSize().getHeight())));
            PurchaseDocumentScanSpotCheckExchangeInsert.this.saveButton.setSize(PurchaseDocumentScanSpotCheckExchangeInsert.this.saveButton.getPreferredSize());
            PurchaseDocumentScanSpotCheckExchangeInsert.this.usersToInform.setLocation(border, PurchaseDocumentScanSpotCheckExchangeInsert.this.defaultMailSender.getY() + PurchaseDocumentScanSpotCheckExchangeInsert.this.defaultMailSender.getHeight() + border);
            PurchaseDocumentScanSpotCheckExchangeInsert.this.usersToInform.setSize(parent.getWidth() - 2 * PurchaseDocumentScanSpotCheckExchangeInsert.this.usersToInform.getX(), 150);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            PurchaseDocumentScanSpotCheckExchangeInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            PurchaseDocumentScanSpotCheckExchangeInsert.this.sendButton.setLocation((int)((double)parent.getWidth() - PurchaseDocumentScanSpotCheckExchangeInsert.this.sendButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - (PurchaseDocumentScanSpotCheckExchangeInsert.this.sendButton.getPreferredSize().getHeight() + (double)border)));
            PurchaseDocumentScanSpotCheckExchangeInsert.this.sendButton.setSize(PurchaseDocumentScanSpotCheckExchangeInsert.this.sendButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (PurchaseDocumentScanSpotCheckExchangeInsert.this.animation != null) {
                PurchaseDocumentScanSpotCheckExchangeInsert.this.animation.setLocation((int)((double)parent.getWidth() - PurchaseDocumentScanSpotCheckExchangeInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - PurchaseDocumentScanSpotCheckExchangeInsert.this.animation.getPreferredSize().getHeight()) / 2);
                PurchaseDocumentScanSpotCheckExchangeInsert.this.animation.setSize(PurchaseDocumentScanSpotCheckExchangeInsert.this.animation.getPreferredSize());
            }
            if (PurchaseDocumentScanSpotCheckExchangeInsert.this.isInserted) {
                PurchaseDocumentScanSpotCheckExchangeInsert.this.configPanel.setLocation(border, border);
                PurchaseDocumentScanSpotCheckExchangeInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                PurchaseDocumentScanSpotCheckExchangeInsert.this.sendPanel.setLocation(PurchaseDocumentScanSpotCheckExchangeInsert.this.configPanel.getX() + PurchaseDocumentScanSpotCheckExchangeInsert.this.configPanel.getWidth() + border, border);
                PurchaseDocumentScanSpotCheckExchangeInsert.this.sendPanel.setSize(PurchaseDocumentScanSpotCheckExchangeInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

