/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.driver.details;

import ch.icit.pegasus.client.gui.modules.driver.details.ContactDetailsPanel;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiDepartmentComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight_;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class BasicDetailsPanel
extends DefaultDetailsPanel<UserLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<Component> userName;
    private TitledItem<RDMultiDepartmentComboBox> departments;
    private ContactDetailsPanel contactPanel;

    public BasicDetailsPanel(RowEditor<UserLight> editor, RDProvider provider, ContactDetailsPanel contactDetailsPanel) {
        super(editor, provider);
        this.contactPanel = contactDetailsPanel;
        this.setTitleText(Words.BASIC_DATA);
        this.userName = new TitledItem<TextField>(new TextField(), Words.USERNAME, TitledItem.TitledItemOrientation.NORTH);
        this.departments = new TitledItem<RDMultiDepartmentComboBox>(new RDMultiDepartmentComboBox(provider), "Departments", TitledItem.TitledItemOrientation.NORTH);
        this.departments.getElement().setOverrideName(UserComplete_.departments);
        this.setCustomLayouter(new Layout());
        this.addToView(this.userName);
        this.addToView(this.departments);
    }

    @Override
    public boolean isRemoteValidation() {
        return this.editor.getModel().isAddRow();
    }

    @Override
    public void validateRemote(List<ScreenValidationObject> callBack) throws ClientServerCallException {
        boolean a;
        if (this.editor.getModel().isAddRow() && (a = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).isUsernameAssigned(((TextField)this.userName.getElement()).getText()))) {
            callBack.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.USERNAME_IS_ALREADY_IN_USE, (Object[])new Object[]{((TextField)this.userName.getElement()).getText()})));
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.userName);
        CheckedListAdder.addToList(focusList, this.departments);
        return focusList;
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.editor.getModel().isAddRow()) {
            this.userName.requestFocusInWindowNow();
        } else {
            this.departments.requestFocusInWindowNow();
        }
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean b = true;
        this.contactPanel.setEnabled(isEnabled && b);
        this.userName.setEnabled(isEnabled);
        this.departments.setEnabled(isEnabled && b);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.userName.kill();
        this.departments.kill();
        this.userName = null;
        this.departments = null;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (this.userName.getElement() instanceof TextField) {
            ((TextField)this.userName.getElement()).setNode(node.getChildNamed(UserLight_.userName));
        } else if (this.userName.getElement() instanceof TextLabel) {
            ((TextLabel)this.userName.getElement()).setNode(node.getChildNamed(UserLight_.userName));
        }
        this.departments.getElement().setNode(node.getChildNamed(UserComplete_.departments));
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.editor.getModel().isAddRow() && ((TextField)this.userName.getElement()).getText().isEmpty()) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ROLE_IS_SET));
            ((TextField)this.userName.getElement()).setInvalid();
        }
        return validationObjects;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = BasicDetailsPanel.this.verticalBorder;
            h = (int)((double)h + BasicDetailsPanel.this.userName.getPreferredSize().getHeight());
            h += BasicDetailsPanel.this.verticalBorder;
            h = (int)((double)h + BasicDetailsPanel.this.departments.getPreferredSize().getHeight());
            return new Dimension(0, h += BasicDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            BasicDetailsPanel.this.userName.setLocation(BasicDetailsPanel.this.horizontalBorder, BasicDetailsPanel.this.verticalBorder);
            BasicDetailsPanel.this.userName.setSize(parent.getWidth() - 2 * BasicDetailsPanel.this.horizontalBorder, (int)BasicDetailsPanel.this.userName.getPreferredSize().getHeight());
            BasicDetailsPanel.this.departments.setLocation(BasicDetailsPanel.this.horizontalBorder, BasicDetailsPanel.this.userName.getY() + BasicDetailsPanel.this.userName.getHeight() + BasicDetailsPanel.this.verticalBorder);
            BasicDetailsPanel.this.departments.setSize(parent.getWidth() - 2 * BasicDetailsPanel.this.horizontalBorder, (int)BasicDetailsPanel.this.departments.getPreferredSize().getHeight());
        }
    }
}

