/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flight.details;

import ch.icit.pegasus.client.converter.FlightTypeEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.flight.details.AdHocStwDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.utils.FlightProviderRule;
import ch.icit.pegasus.client.gui.modules.flightschedule.details.utils.LegTable;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.datechooser.DateTimeChooser;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.textfield.DateTimeTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.StowingListServiceManager;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class AdHocFlightDataDetailsPanel
extends DefaultDetailsPanel<FlightLight>
implements SearchTextField2Listener,
NodeListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<SearchTextField2> flightSchedule;
    private TitledItem<SearchTextField2> customer;
    private HorizontalSeparator horizontalSeparator;
    private TitledItem<ComboBox> flightType;
    private TitledItem<TextField> outbound;
    private TitledItem<TextField> inbound;
    private TitledItem<DateChooser> plannedDeparture;
    private TitledItem<DateChooser> plannedArrival;
    private TitledItem<DateTimeTextField> plannedDepartureTime;
    private TitledItem<DateTimeTextField> plannedArrivalTime;
    private TitledItem<TextField> shortCode;
    private TitledItem<DateTimeChooser> kitchenReadyTime;
    private StowingListTemplateVariantLight currentStowingList;
    private AdHocStwDetailsPanel stwDetailsPanel;
    private LegTable referencedLegTable;

    public AdHocFlightDataDetailsPanel(RowEditor<FlightLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.FLIGHT_DATA);
        this.flightSchedule = new TitledItem<SearchTextField2<FlightScheduleLight>>(SearchTextField2Factory.getFlightScheduleSearchField(true, new DTOProxyNode()), Words.FLIGHT_SCHEDULE, TitledItem.TitledItemOrientation.NORTH);
        this.flightSchedule.getElement().addSearchTextFieldListener(this);
        this.customer = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, null), WordsToolkit.toCapitalLetter((String)Words.CUSTOMER), TitledItem.TitledItemOrientation.NORTH);
        this.horizontalSeparator = new HorizontalSeparator();
        this.kitchenReadyTime = new TitledItem<DateTimeChooser>(new DateTimeChooser(null), Words.KITCHEN_READY_TIME, TitledItem.TitledItemOrientation.NORTH);
        this.flightType = new TitledItem<ComboBox>(new ComboBox(null, null, ConverterRegistry.getConverter(FlightTypeEConverter.class)), Words.TYPE, TitledItem.TitledItemOrientation.NORTH);
        this.plannedDepartureTime = new TitledItem<DateTimeTextField>(new DateTimeTextField(TextFieldType.DAYTIME), Words.DEPARTURE_TIME, TitledItem.TitledItemOrientation.NORTH);
        this.plannedArrivalTime = new TitledItem<DateTimeTextField>(new DateTimeTextField(TextFieldType.DAYTIME), Words.ARRIVAL_TIME, TitledItem.TitledItemOrientation.NORTH);
        this.outbound = new TitledItem<TextField>(new TextField(), Words.OUTBOUND, TitledItem.TitledItemOrientation.NORTH);
        this.inbound = new TitledItem<TextField>(new TextField(), Words.INBOUND, TitledItem.TitledItemOrientation.NORTH);
        Node n = new Node();
        n.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        this.plannedDeparture = new TitledItem<DateChooser>(new DateChooser(null, true), Words.DEPARTURE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.plannedDeparture.getElement().setNode(n);
        this.plannedDeparture.getElement().setIsTimestamp(true);
        Node n2 = new Node();
        n2.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        this.plannedArrival = new TitledItem<DateChooser>(new DateChooser(null, true), Words.ARRIVAL_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.plannedArrival.getElement().setNode(n2);
        this.plannedArrival.getElement().setIsTimestamp(true);
        this.shortCode = new TitledItem<TextField>(new TextField(), Words.SHORT_CODE, TitledItem.TitledItemOrientation.NORTH);
        this.setCustomLayouter(new Layout());
        this.addToView(this.flightSchedule);
        this.addToView(this.kitchenReadyTime);
        this.addToView(this.horizontalSeparator);
        this.addToView(this.customer);
        this.addToView(this.flightType);
        this.addToView(this.plannedDeparture);
        this.addToView(this.plannedArrival);
        this.addToView(this.plannedArrivalTime);
        this.addToView(this.plannedDepartureTime);
        this.addToView(this.inbound);
        this.addToView(this.outbound);
        this.addToView(this.shortCode);
    }

    public void setReferencedLegTable(LegTable referencedLegTable) {
        this.referencedLegTable = referencedLegTable;
    }

    public void setStwDetailsPanel(AdHocStwDetailsPanel stwDetailsPanel) {
        this.stwDetailsPanel = stwDetailsPanel;
    }

    @Override
    public void setNode(Node<?> node) {
        Node krtNode;
        Timestamp krt;
        Node fsNode;
        super.setNode(node);
        if (this.editor.getModel().isAddRow()) {
            FlightComplete dto = (FlightComplete)node.getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        if (this.provider.getAdditionalRule() == null) {
            this.provider.setAdditionalRule(new FlightProviderRule((FlightComplete)node.getValue(FlightComplete.class)));
        }
        if ((fsNode = node.getChildNamed(DtoFieldConstants.NEW_FS)) == null) {
            fsNode = new DTOProxyNode();
            fsNode.setName(DtoFieldConstants.NEW_FS);
            node.addChild(fsNode, 0L);
        }
        this.outbound.getElement().setNode(node.getChildNamed(FlightLight_.outboundCode));
        this.inbound.getElement().setNode(node.getChildNamed(FlightLight_.inboundCode));
        node.getChildNamed(FlightLight_.outboundCode).addNodeListener((NodeListener)this);
        node.getChildNamed(FlightLight_.inboundCode).addNodeListener((NodeListener)this);
        Node staN = node.getChildNamed(FlightLight_.sta);
        Node stdN = node.getChildNamed(FlightLight_.std);
        Timestamp sta = (Timestamp)staN.getValue();
        Timestamp std = (Timestamp)stdN.getValue();
        if (sta == null) {
            staN.setValue((Object)new Timestamp(System.currentTimeMillis()), 0L);
        }
        if (std == null) {
            stdN.setValue((Object)new Timestamp(System.currentTimeMillis()), 0L);
        }
        if ((krt = (Timestamp)(krtNode = node.getChildNamed(FlightLight_.kitchenReadyTime)).getValue()) == null) {
            krt = new Timestamp(System.currentTimeMillis());
            krtNode.setValue((Object)krt, 0L);
        }
        this.kitchenReadyTime.getElement().setNode(krtNode);
        node.getChildNamed(FlightLight_.sta).addNodeListener((NodeListener)this);
        node.getChildNamed(FlightLight_.std).addNodeListener((NodeListener)this);
        this.plannedArrival.getElement().setNode(staN);
        this.plannedArrivalTime.getElement().setNode(staN);
        this.plannedDeparture.getElement().setNode(stdN);
        this.plannedDepartureTime.getElement().setNode(stdN);
        this.customer.getElement().setNode(node.getChildNamed(FlightLight_.customer));
        this.flightType.getElement().refreshPossibleValues(NodeToolkit.getAffixList(FlightTypeE.class));
        this.flightType.getElement().setNode(node.getChildNamed(FlightLight_.flightType));
        this.shortCode.getElement().setNode(node.getChildNamed(FlightLight_.shortFlightCode));
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.flightSchedule.setEnabled(isEnabled);
        this.customer.setEnabled(isEnabled);
        this.horizontalSeparator.setEnabled(isEnabled);
        this.outbound.setEnabled(isEnabled);
        this.inbound.setEnabled(isEnabled);
        this.plannedArrival.setEnabled(isEnabled);
        this.plannedDeparture.setEnabled(isEnabled);
        this.plannedArrivalTime.setEnabled(isEnabled);
        this.plannedDepartureTime.setEnabled(isEnabled);
        this.flightType.setEnabled(isEnabled);
        this.shortCode.setEnabled(isEnabled);
        this.kitchenReadyTime.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.editor.getModel().getNode() != null) {
            Node currentNode = this.editor.getModel().getNode().getChildNamed(FlightLight_.outboundCode);
            if (currentNode != null) {
                currentNode.removeNodeListener((NodeListener)this);
            }
            if ((currentNode = this.editor.getModel().getNode().getChildNamed(FlightLight_.inboundCode)) != null) {
                currentNode.removeNodeListener((NodeListener)this);
            }
            if ((currentNode = this.editor.getModel().getNode().getChildNamed(FlightLight_.sta)) != null) {
                currentNode.removeNodeListener((NodeListener)this);
            }
            if ((currentNode = this.editor.getModel().getNode().getChildNamed(FlightLight_.std)) != null) {
                currentNode.removeNodeListener((NodeListener)this);
            }
        }
        this.flightSchedule.kill();
        this.customer.kill();
        this.horizontalSeparator.kill();
        this.inbound.kill();
        this.outbound.kill();
        this.plannedArrival.kill();
        this.plannedDeparture.kill();
        this.kitchenReadyTime.kill();
        this.plannedArrivalTime.kill();
        this.plannedDepartureTime.kill();
        this.flightType.kill();
        this.shortCode.kill();
        this.plannedArrivalTime = null;
        this.plannedDepartureTime = null;
        this.flightSchedule = null;
        this.customer = null;
        this.horizontalSeparator = null;
        this.kitchenReadyTime = null;
        this.inbound = null;
        this.outbound = null;
        this.plannedArrival = null;
        this.plannedDeparture = null;
        this.flightType = null;
        this.shortCode = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.flightSchedule);
        CheckedListAdder.addToList(focusList, this.customer);
        CheckedListAdder.addToList(focusList, this.flightType);
        CheckedListAdder.addToList(focusList, this.outbound);
        CheckedListAdder.addToList(focusList, this.inbound);
        CheckedListAdder.addToList(focusList, this.plannedDeparture);
        CheckedListAdder.addToList(focusList, this.plannedArrival);
        CheckedListAdder.addToList(focusList, this.plannedDepartureTime);
        CheckedListAdder.addToList(focusList, this.plannedArrivalTime);
        CheckedListAdder.addToList(focusList, this.kitchenReadyTime);
        CheckedListAdder.addToList(focusList, this.shortCode);
        return focusList;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.outbound.requestFocusInWindowNow();
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.editor.getModel().getNode().getChildNamed(FlightComplete_.customer).getValue() == null) {
            this.customer.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_CUSTOMER));
        }
        if (this.editor.getModel().getNode().getChildNamed(FlightComplete_.std).getValue() == null) {
            this.plannedDeparture.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_STD));
        }
        if (this.editor.getModel().getNode().getChildNamed(FlightComplete_.sta).getValue() == null) {
            this.plannedArrival.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_STA));
        }
        if (this.editor.getModel().getNode().getChildNamed(FlightComplete_.inboundCode).getValue() == null) {
            this.inbound.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_INBOUND_CODE));
        } else if (this.editor.getModel().getNode().getChildNamed(FlightComplete_.inboundCode).getValue().equals("")) {
            this.inbound.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_INBOUND_CODE));
        }
        if (this.editor.getModel().getNode().getChildNamed(FlightComplete_.outboundCode).getValue() == null) {
            this.outbound.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_OUTBOUND_CODE));
        } else if (this.editor.getModel().getNode().getChildNamed(FlightComplete_.outboundCode).getValue().equals("")) {
            this.outbound.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_OUTBOUND_CODE));
        }
        return validationObjects;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    public void setStwVariant(StowingListTemplateVariantLight currentStowingList) {
        this.currentStowingList = currentStowingList;
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        Timestamp stdD = CalendarUtil.getTimestamp((Node)this.plannedDeparture.getElement().getNode());
        Timestamp staD = CalendarUtil.getTimestamp((Node)this.plannedArrival.getElement().getNode());
        Timestamp stdT = CalendarUtil.getTimestamp((Node)this.plannedDepartureTime.getElement().getNode());
        Timestamp staT = CalendarUtil.getTimestamp((Node)this.plannedArrivalTime.getElement().getNode());
        Timestamp tsA = CalendarUtil.mergeTimestamps((Timestamp)staD, (Timestamp)staT);
        Timestamp tsD = CalendarUtil.mergeTimestamps((Timestamp)stdD, (Timestamp)stdT);
        this.editor.getModel().getNode().getChildNamed(FlightComplete_.sta).setValue((Object)tsA, 0L);
        this.editor.getModel().getNode().getChildNamed(FlightComplete_.std).setValue((Object)tsD, 0L);
        ((FlightComplete)this.editor.getModel().getNode().getValue(FlightComplete.class)).setStd(tsD);
        ((FlightComplete)this.editor.getModel().getNode().getValue(FlightComplete.class)).setSta(tsA);
        return super.commitParagraph();
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) {
        final FlightScheduleLight flightScheduleLight = (FlightScheduleLight)n.getValue();
        if (flightScheduleLight == null) {
            return;
        }
        this.editor.setEnabled(false);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                FlightScheduleComplete flightScheduleComplete = (FlightScheduleComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlightSchedule(new FlightScheduleReference(flightScheduleLight.getId())).getValue();
                Timestamp stdTime = new Timestamp(flightScheduleLight.getStd().getTime());
                Timestamp toDay = new Timestamp(System.currentTimeMillis());
                Timestamp stdTimeDate = CalendarUtil.mergeTimestamps((Timestamp)toDay, (Timestamp)stdTime);
                StowingListTemplateComplete stowingList = flightScheduleComplete.getDefaultStowingList().getStowingList();
                AdHocFlightDataDetailsPanel.this.currentStowingList = (StowingListTemplateVariantLight)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).resolveVariant(new StowingListTemplateReference(stowingList.getId()), new TimestampWrapper(stdTimeDate)).getValue();
                AdHocFlightDataDetailsPanel.this.stwDetailsPanel.setStwVariant(AdHocFlightDataDetailsPanel.this.currentStowingList);
                AdHocFlightDataDetailsPanel.this.referencedLegTable.setCurrentStowingList(AdHocFlightDataDetailsPanel.this.currentStowingList);
                return INodeCreator.getDefaultImpl().getNode4DTO((Object)flightScheduleComplete, false, false);
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        FlightScheduleComplete flightScheduleComplete = (FlightScheduleComplete)node.getValue(FlightScheduleComplete.class);
                        AdHocFlightDataDetailsPanel.this.editor.getModel().getNode().getChildNamed(FlightLight_.customer).setValue((Object)flightScheduleLight.getCustomer(), 0L);
                        AdHocFlightDataDetailsPanel.this.editor.getModel().getNode().getChildNamed(FlightLight_.outboundCode).setValue((Object)flightScheduleLight.getOutboundCode(), 0L);
                        AdHocFlightDataDetailsPanel.this.editor.getModel().getNode().getChildNamed(FlightLight_.inboundCode).setValue((Object)flightScheduleLight.getInboundCode(), 0L);
                        AdHocFlightDataDetailsPanel.this.editor.getModel().getNode().getChildNamed(FlightLight_.shortFlightCode).setValue((Object)flightScheduleLight.getShortFlightCode(), 0L);
                        AdHocFlightDataDetailsPanel.this.editor.getModel().getNode().getChildNamed(FlightLight_.autoCheckout).setValue((Object)flightScheduleComplete.getAutoCheckout(), 0L);
                        AdHocFlightDataDetailsPanel.this.editor.getModel().getNode().getChildNamed(FlightComplete_.ignoreCustomerLabelConfig).setValue((Object)flightScheduleComplete.getIgnoreCustomerLabelConfig(), 0L);
                        Timestamp stdTime = new Timestamp(flightScheduleLight.getStd().getTime());
                        Timestamp staTime = new Timestamp(flightScheduleLight.getSta().getTime());
                        Timestamp toDay = new Timestamp(System.currentTimeMillis());
                        Timestamp stdTimeDate = CalendarUtil.mergeTimestamps((Timestamp)toDay, (Timestamp)stdTime);
                        Timestamp staTimeDate = CalendarUtil.mergeTimestamps((Timestamp)toDay, (Timestamp)staTime);
                        ((DateTimeTextField)AdHocFlightDataDetailsPanel.this.plannedDepartureTime.getElement()).getNode().setValue((Object)stdTimeDate, 0L);
                        ((DateTimeTextField)AdHocFlightDataDetailsPanel.this.plannedArrivalTime.getElement()).getNode().setValue((Object)staTimeDate, 0L);
                        ((DateTimeChooser)AdHocFlightDataDetailsPanel.this.kitchenReadyTime.getElement()).getNode().setValue((Object)stdTimeDate, 0L);
                        AdHocFlightDataDetailsPanel.this.editor.getModel().getNode().getChildNamed(FlightLight_.flightType).setValue((Object)flightScheduleLight.getFlightType(), 0L);
                        AdHocFlightDataDetailsPanel.this.editor.getModel().getNode().getChildNamed(DtoFieldConstants.NEW_FS).setValue((Object)flightScheduleComplete, 0L);
                        AdHocFlightDataDetailsPanel.this.updateStowingList(flightScheduleComplete, flightScheduleComplete.getDefaultStowingList().getStowingList());
                        AdHocFlightDataDetailsPanel.this.editor.getModel().getNode().getChildNamed(FlightLight_.deliveryAirport).setValue((Object)flightScheduleComplete.getDeliveryAirport(), 0L);
                        AdHocFlightDataDetailsPanel.this.editor.getModel().getNode().getChildNamed(FlightComplete_.labelLayout).setValue((Object)flightScheduleComplete.getLabelLayout(), 0L);
                        AdHocFlightDataDetailsPanel.this.editor.getModel().getNode().getChildNamed(FlightComplete_.deliverySlipSheet).setValue((Object)flightScheduleComplete.getDeliverySlipSheet(), 0L);
                        AdHocFlightDataDetailsPanel.this.editor.getModel().getNode().getChildNamed(FlightComplete_.sealLabelLayout).setValue((Object)flightScheduleComplete.getSealLabelLayout(), 0L);
                        if (AdHocFlightDataDetailsPanel.this.editor.getModel().isAddRow()) {
                            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                            Node ac = AdHocFlightDataDetailsPanel.this.editor.getModel().getNode().getChildNamed(FlightComplete_.autoCheckout);
                            ac.setValue((Object)settings.getAutoCheckout(), 0L);
                        }
                        AdHocFlightDataDetailsPanel.this.editor.getModel().getNode().getChildNamed(FlightComplete_.flightOrderReceived).setValue((Object)(!Boolean.TRUE.equals(flightScheduleComplete.getCustomer().getNotifyFlightOrderReceived()) ? 1 : 0), 0L);
                        AdHocFlightDataDetailsPanel.this.editor.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)AdHocFlightDataDetailsPanel.this);
                        AdHocFlightDataDetailsPanel.this.editor.setEnabled(true);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void updateStowingList(FlightScheduleComplete flightScheduleComplete, StowingListTemplateComplete defaultStowingList) {
        HashMap legMapping = new HashMap();
        HashMap<FlightScheduleLegComplete, FlightLegComplete> old2newMapping = new HashMap<FlightScheduleLegComplete, FlightLegComplete>();
        this.editor.getModel().getNode().getChildNamed(DtoFieldConstants.NEW_LEGS).removeExistingValues();
        this.editor.getModel().getNode().getChildNamed(DtoFieldConstants.NEW_LEGS).removeAllChilds();
        this.editor.getModel().getNode().getChildNamed(DtoFieldConstants.NEW_STW).setValue(defaultStowingList != null ? defaultStowingList : null, 0L);
        for (FlightScheduleLegComplete leg : flightScheduleComplete.getLegs()) {
            FlightLegComplete nLeg = new FlightLegComplete();
            nLeg.setClientOId(Long.valueOf(ADTO.getNextId()));
            nLeg.setArrivalAirport(leg.getArrivalAirport());
            nLeg.setDepartureAirport(leg.getDepartureAirport());
            nLeg.setFlightTime(leg.getFlightTime());
            nLeg.setFlightNo(leg.getFlightNo());
            nLeg.setLegType(leg.getLegType());
            nLeg.setNumber(leg.getNumber());
            nLeg.setCateringLeg(leg.getCateringLeg());
            nLeg.setShowLegOnDailyOps(leg.getShowLegOnDailyOps());
            Node legNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)nLeg, false, false);
            this.editor.getModel().getNode().getChildNamed(DtoFieldConstants.NEW_LEGS).addChild(legNode, 0L);
            old2newMapping.put(leg, nLeg);
        }
        if (defaultStowingList != null) {
            for (FlightScheduleLegComplete leg : defaultStowingList.getLegs()) {
                legMapping.put(leg, old2newMapping.get(flightScheduleComplete.getDefaultStowingList().getLegMapping().get(leg)));
            }
            this.editor.getModel().getNode().getChildNamed(DtoFieldConstants.LEG_MAPPING).setValue(legMapping, 0L);
        }
        if (this.currentStowingList != null) {
            this.editor.getModel().getNode().getChildNamed(DtoFieldConstants.NEW_AIR).setValue((Object)this.currentStowingList.getAircraft(), 0L);
        }
    }

    public void valueChanged(Node<?> node) {
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = AdHocFlightDataDetailsPanel.this.verticalBorder;
            h = (int)((double)h + AdHocFlightDataDetailsPanel.this.flightSchedule.getPreferredSize().getHeight());
            h += AdHocFlightDataDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + AdHocFlightDataDetailsPanel.this.customer.getPreferredSize().getHeight());
            h += AdHocFlightDataDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + AdHocFlightDataDetailsPanel.this.flightType.getPreferredSize().getHeight());
            h += AdHocFlightDataDetailsPanel.this.verticalBorder;
            h = (int)((double)h + AdHocFlightDataDetailsPanel.this.horizontalSeparator.getPreferredSize().getHeight());
            h += AdHocFlightDataDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + AdHocFlightDataDetailsPanel.this.outbound.getPreferredSize().getHeight());
            h += AdHocFlightDataDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + AdHocFlightDataDetailsPanel.this.plannedArrival.getPreferredSize().getHeight());
            h += AdHocFlightDataDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + AdHocFlightDataDetailsPanel.this.plannedArrivalTime.getPreferredSize().getHeight());
            h += AdHocFlightDataDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + AdHocFlightDataDetailsPanel.this.kitchenReadyTime.getPreferredSize().getHeight());
            h += AdHocFlightDataDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + AdHocFlightDataDetailsPanel.this.shortCode.getPreferredSize().getHeight());
            return new Dimension(0, h += AdHocFlightDataDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            int ww = (parent.getWidth() - (2 * AdHocFlightDataDetailsPanel.this.horizontalBorder + AdHocFlightDataDetailsPanel.this.inner_horizontalBorder)) / 2;
            AdHocFlightDataDetailsPanel.this.flightSchedule.setLocation(AdHocFlightDataDetailsPanel.this.horizontalBorder, AdHocFlightDataDetailsPanel.this.verticalBorder);
            AdHocFlightDataDetailsPanel.this.flightSchedule.setSize(parent.getWidth() - 2 * AdHocFlightDataDetailsPanel.this.horizontalBorder, (int)AdHocFlightDataDetailsPanel.this.flightSchedule.getPreferredSize().getHeight());
            AdHocFlightDataDetailsPanel.this.customer.setLocation(AdHocFlightDataDetailsPanel.this.horizontalBorder, AdHocFlightDataDetailsPanel.this.flightSchedule.getY() + AdHocFlightDataDetailsPanel.this.flightSchedule.getHeight() + AdHocFlightDataDetailsPanel.this.inner_verticalBorder);
            AdHocFlightDataDetailsPanel.this.customer.setSize(parent.getWidth() - 2 * AdHocFlightDataDetailsPanel.this.horizontalBorder, (int)AdHocFlightDataDetailsPanel.this.customer.getPreferredSize().getHeight());
            AdHocFlightDataDetailsPanel.this.horizontalSeparator.setLocation(0, AdHocFlightDataDetailsPanel.this.customer.getY() + AdHocFlightDataDetailsPanel.this.customer.getHeight() + AdHocFlightDataDetailsPanel.this.verticalBorder);
            AdHocFlightDataDetailsPanel.this.horizontalSeparator.setSize(parent.getWidth(), (int)AdHocFlightDataDetailsPanel.this.horizontalSeparator.getPreferredSize().getHeight());
            AdHocFlightDataDetailsPanel.this.flightType.setLocation(AdHocFlightDataDetailsPanel.this.horizontalBorder, AdHocFlightDataDetailsPanel.this.horizontalSeparator.getY() + AdHocFlightDataDetailsPanel.this.horizontalSeparator.getHeight() + AdHocFlightDataDetailsPanel.this.inner_verticalBorder);
            AdHocFlightDataDetailsPanel.this.flightType.setSize(parent.getWidth() - 2 * AdHocFlightDataDetailsPanel.this.horizontalBorder, (int)AdHocFlightDataDetailsPanel.this.flightType.getPreferredSize().getHeight());
            AdHocFlightDataDetailsPanel.this.outbound.setLocation(AdHocFlightDataDetailsPanel.this.horizontalBorder, AdHocFlightDataDetailsPanel.this.flightType.getY() + AdHocFlightDataDetailsPanel.this.flightType.getHeight() + AdHocFlightDataDetailsPanel.this.inner_verticalBorder);
            AdHocFlightDataDetailsPanel.this.outbound.setSize(ww, (int)AdHocFlightDataDetailsPanel.this.outbound.getPreferredSize().getHeight());
            AdHocFlightDataDetailsPanel.this.inbound.setLocation(AdHocFlightDataDetailsPanel.this.horizontalBorder + AdHocFlightDataDetailsPanel.this.inner_horizontalBorder + ww, AdHocFlightDataDetailsPanel.this.outbound.getY());
            AdHocFlightDataDetailsPanel.this.inbound.setSize(ww, (int)AdHocFlightDataDetailsPanel.this.inbound.getPreferredSize().getHeight());
            AdHocFlightDataDetailsPanel.this.plannedDeparture.setLocation(AdHocFlightDataDetailsPanel.this.horizontalBorder, AdHocFlightDataDetailsPanel.this.inbound.getY() + AdHocFlightDataDetailsPanel.this.inbound.getHeight() + AdHocFlightDataDetailsPanel.this.inner_verticalBorder);
            AdHocFlightDataDetailsPanel.this.plannedDeparture.setSize(ww, (int)AdHocFlightDataDetailsPanel.this.plannedDeparture.getPreferredSize().getHeight());
            AdHocFlightDataDetailsPanel.this.plannedArrival.setLocation(AdHocFlightDataDetailsPanel.this.inbound.getX(), AdHocFlightDataDetailsPanel.this.plannedDeparture.getY());
            AdHocFlightDataDetailsPanel.this.plannedArrival.setSize(ww, (int)AdHocFlightDataDetailsPanel.this.plannedArrival.getPreferredSize().getHeight());
            AdHocFlightDataDetailsPanel.this.plannedDepartureTime.setLocation(AdHocFlightDataDetailsPanel.this.horizontalBorder, AdHocFlightDataDetailsPanel.this.plannedDeparture.getY() + AdHocFlightDataDetailsPanel.this.plannedDeparture.getHeight() + AdHocFlightDataDetailsPanel.this.inner_verticalBorder);
            AdHocFlightDataDetailsPanel.this.plannedDepartureTime.setSize(ww, (int)AdHocFlightDataDetailsPanel.this.plannedDepartureTime.getPreferredSize().getHeight());
            AdHocFlightDataDetailsPanel.this.plannedArrivalTime.setLocation(AdHocFlightDataDetailsPanel.this.horizontalBorder + ww + AdHocFlightDataDetailsPanel.this.inner_horizontalBorder, AdHocFlightDataDetailsPanel.this.plannedDepartureTime.getY());
            AdHocFlightDataDetailsPanel.this.plannedArrivalTime.setSize(ww, (int)AdHocFlightDataDetailsPanel.this.plannedArrivalTime.getPreferredSize().getHeight());
            AdHocFlightDataDetailsPanel.this.kitchenReadyTime.setLocation(AdHocFlightDataDetailsPanel.this.horizontalBorder, AdHocFlightDataDetailsPanel.this.plannedArrivalTime.getY() + AdHocFlightDataDetailsPanel.this.plannedArrivalTime.getHeight() + AdHocFlightDataDetailsPanel.this.inner_verticalBorder);
            AdHocFlightDataDetailsPanel.this.kitchenReadyTime.setSize(ww, (int)AdHocFlightDataDetailsPanel.this.kitchenReadyTime.getPreferredSize().getHeight());
            AdHocFlightDataDetailsPanel.this.shortCode.setLocation(AdHocFlightDataDetailsPanel.this.horizontalBorder, AdHocFlightDataDetailsPanel.this.kitchenReadyTime.getY() + AdHocFlightDataDetailsPanel.this.kitchenReadyTime.getHeight() + AdHocFlightDataDetailsPanel.this.inner_verticalBorder);
            AdHocFlightDataDetailsPanel.this.shortCode.setSize(ww, (int)AdHocFlightDataDetailsPanel.this.shortCode.getPreferredSize().getHeight());
        }
    }
}

